10!!!TEKDEM.BAS		VERSION 6A	EDIT 1		6-APR-76

20!!!DESCRIPTION--DEMONSTRATION PROGRAM FOR THE TEKTRONIX 4010-1 TERMINAL
	USING THE PLOTTING FUNCTIONS CONTAINED IN $PLOT10.BAS.  PROGRAM
	PERFORMS LINEAR LEAST SQUARES FIT OF USER SUPPLIED DATA.
21!	IT THEN PLOTS THE DATA POINTS AND FITTED CURVE.  USING THE GRAPHIC
	INPUT FUNCTION OF THE TERMINAL IT THEN ALLOWS THE USER TO 
	SELECTIVELY REMOVE CERTAIN DATA VALUES AND HAVE A NEW REGRESSION
22!	LINE PLOTTED.

30!!!DIRECTIONS--USER MUST APPEND $PLOT10 BEFORE RUNNING.  SAMPLE DATA IS
	CONTAINED IN LINES 1000-1999.  THE USER MAY SUPPLY HIS OWN IF HE
	WISHES.  THE FORMAT FOR DATA ENTRY IS:
31!		N - # OF PAIRS OF DATA
		X1,Y1,X2,Y2,X3,Y3,...,XN,YN
	WHERE Y IS THE DEPENDENT VARIABLES.  PROGRAM WILL HANDLE AS MANY AS
32!	100 PAIRS OF OBSERVATIONS.

40!!!ADDITONAL NOTES--THIS PROGRAM IS PRIMARILY INTENDED FOR DEMONSTRATION
	PURPOSES. AS SUCH, THE BASIC USED IS QUITE SIMPLE AND STRAIGHT-
	FORWARD.  AN APPLICATION PROGRAM BASED UPON THIS TECHNIQUE COULD
41!	EASILY BE MADE MORE EFFICIENT BY USING SOME OF THE ADVANCED FEATURES
	OF BASIC-PLUS.

99!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

100 DIM X(100),Y(100)
110 P=FNT0%(0.,0.,1%)
120 P=FNT6%(0.,4.,0.,.25,'$PLOT10 DEMONSTRATION PROGRAM')
130 P=FNT6%(3.6,2.,X,.12,'  $TEKDEM') FOR X=0 TO 315 STEP 45
140 P=FNT6%(0.,0.,0.,.12,'TYPE <CR> TO CONTINUE')
150 INPUT X
160 P=FNT0%(0.,0.,0%)
	!CLEAR THE SCREEN AFTER PRINTING HEADER AND GIVE INSTRUCTIONS
170 PRINT'BASED UPON THE MIN AND MAX FOR X AND Y WHICH WILL BE PRINTED,'
180 PRINT'SELECT VALUES FOR XMIN,XMAX,YMIN,YMAX FOR DATA PRESENTATION.'
190 PRINT'FOR SMAPLE DATA SUPPLIED, THE VALUES -400,200,-2,8 ARE GOOD.'
200 PRINT'THE DATA WILL BE PLOTTED AND A REGRESSION LINE THRU THE DATA'
210 PRINT 'WILL BE DRAWN.  WHEN THE CROSSHAIR COMES ON, MOVE IT TO ONE'
220 PRINT'OR MORE OF THE DATA SYMBOLS AND PRESS ANY KEY EXCEPT "0".'
230 PRINT'AN "X" WILL BE DRAWN THRU THAT POINT. CONTINUE IN THIS WAY'
240 PRINT 'UNTIL AS MANY POINTS AS YOU WISH HAVE BEEN ELIMINATED.'
250 PRINT 'TYPE A "0" (ZERO) TO STOP THE PROCESS, AND A NEW REGRESSION'
260 PRINT 'LINE WILL BE DRAWN.'
270 READ N
280 X1,Y1=0
290 U1,V1=1E38
300 U2,V2=-1E38
310 FOR I=1 TO N
320 READ X(I),Y(I)
330 X1=X1+X(I)
340 Y1=Y1+Y(I)
350 IF X(I) < U1 THEN U1=X(I)
		ELSE IF X(I)>U2 THEN U2=X(I)
360 IF Y(I) < V1 THEN V1=Y(I)
		ELSE IF Y(I)>V2 THEN V2=Y(I)
	!THESE TWO LINES ARE USED TO FIND THE RANGE OF THE DATA--
	 (U1,U2) FOR X AND (V1,V2) FOR Y
370 NEXT I
380 X1=X1/N
390 Y1=Y1/N
	!THE PRECEDING LINES READ IN THE DATA PAIRS AND COMPUTE THE MEAN
	 OF BOTH X (IND. VAR.) AND Y (DEP. VAR.)
400 S1,S2=0
410 FOR I=1 TO N
420 S1=S1+(Y(I)-Y1)*(X(I)-X1)
430 S2=S2+(X(I)-X1)^2
440 NEXT I
450 B=S1/S2
460 A=Y1-B*X1
	!THESE LINES HAVE COMPUTED THE COEFFICIENTS A & B IN THE LEAST SQUARES
	 FIT.  THE FITTED CURVE IS Y=A + B*X
470 PRINT 'XMIN='U1;TAB(20);'XMAX=';U2
480 PRINT 'YMIN='V1;TAB(20);'YMAX=';V2
490 INPUT 'XMIN,XMAX,YMIN,YMAX FOR PLOT';A1,A2,B1,B2
	!BEGINNING PLOTTING PORTION OF PROGRAM.  USER MUST ENTER LIMITS ON
	 DATA TO BE USED FOR PLOTTING; PROGRAM DETERMINES OTHER VALUES.
500 P=FNT0%(.5,.5,2%)
	!RE-INITIALIZE AND CLEAR SCREEN; ORIGIN OFFSET ENOUGH TO ALLOW FOR 
	 ANNOTATION ALONG AXIS.
510 P=FNT1%(A1,B1,(A2-A1)/6,(B2-B1)/5)
	!DATA SCALED SO THAT X DIMENSION WILL BE 6 INCHES, Y DIMENSION 
	 5 INCHES. 
520 FOR I=1 TO N
530 P=FNT2%(X(I),Y(I),1%,1%)
540 NEXT I
	!EACH OF THE DATA POINTS IS PLOTTED SEPARATELY USING THE TRIANGLE
	 SYMBOL.
550 P=FNT2%(A1,A+B*A1,1%,0%)+FNT2%(A2,A+B*A2,-2%,0%)
	!THE LEAST SQUARES LINE IS DRAWN FROM X=A1 TO X=A2; THE TERMINAL
	 IS RETURNED TO ALPHA MODE AFTER THE LINE.
560 P=FNT4%(0.,0.,0.,-6.,'IND. VAR.')+FNT4%(0.,0.,90.,5.,'DEP. VAR.')
	!THE X AND Y AXES ARE NOW DRAWN; NOTE THAT HERE AND IN THE PREVIOUS
	 LINE, TWO FUNCTIONS ARE INVOKED AT THE SAME TIME.  THIS CAN BE DONE
	 TO GROUP RELATED OPERATIONS
570 IF B2-B1>A2-A1 THEN T=(B2-B1)/250 ELSE T=(A2-A1)/250
	!TOLERENCE FOR CROSSHAIR INPUT; CALL A HIT IF CROSSHAIR IS
	 WITHIN SYMBOL.
580 P=FNT3%(0%)
590 IF P=48 THEN 680
600 X=O1\ Y=O2
	!GET POINT(S) TO DELETE FROM CROSSHAIR LOCATION; TYPING A ZERO (0)
	 STOP THE PROCESS-- ASCII CODE FOR '0' IS 48.
610 FOR I=1 TO N
620 IF ABS(X(I)-X)<T AND ABS(Y(I)-Y)<T THEN 650
630 NEXT I
640 GOTO 580
	!CROSSHAIR FINDS VALUES APPROXIMATELY -- TOLERANCE IS T.  IF
	 NO POINT MEETS CRITERION, ASSUME USER ERROR AND TRY AGAIN.
650 X(I),Y(I)=-1E38
660 P=FNT2%(X,Y,-1%,7%)
	!PUT AN 'X' THRU DATA POINT THAT WILL DELETED FROM
	 NEXT FIT OF DATA.
670 GOTO 580
	!FLAG VALUE TO OMIT AND CONTINUE UNTIL USER INPUTS A '0' TO STOP
680 X1,Y1,S1,S2,N1=0
690 FOR I=1 TO N
700 IF X(I)=-1E38 AND Y(I)=-1E38 THEN 740
710 X1=X1+X(I)
720 Y1=Y1+Y(I)
730 N1=N1+1
740 NEXT I
750 X1=X1/N1
760 Y1=Y1/N1
	!COMPUTE NEW MEAN FROM REMAINING POINTS
770 FOR I=1 TO N
780 IF X(I)=-1E38 AND Y(I)=-1E38 THEN 810
790 S1=S1+(Y(I)-Y1)*(X(I)-X1)
800 S2=S2+(X(I)-X1)^2
810 NEXT I
820 B=S1/S2
830 A=Y1-B*X1
	!COMPUTE REVISED COEFFICIENTS.
840 P=FNT2%(A1,A+B*A1,1%,0%)+FNT2%(A2,A+B*A2,-2%,0%)
	!DRAW NEW LEAST SQUARES FIT LINE
850 P=FNT7%(0.,-.2,0%)
	!MOVE CURSOR BELOW FIGURE AND STOP
860 STOP
1000 DATA 21
1010 DATA -300,-.295, -260, .433, -220, 1.30,-200,1.28
1020 DATA -180, 1.44, -160, 1.298, -120, 1.978, -100, 2.18
1030 DATA -60, 2.70, -40, 3.015,-20, 2.686, -10,2.448,-5,2.55
1040 DATA 20,3.07, 40,4.16,60,4.55,80,4.319,100,5.347,120,4.97
1050 DATA 110, 2.63, 90,3.077
2000END
