1!		SYSMAN		EDIT 03		FEB. 10,1977
	Peter Mullen

20!	SYSMAN is a program that will watch a given set of terminals
	and check if any terminal has been left unattended.

21!	A terminal is considered unattended if the following criterion
	exist for a given number of cycles of the program;
	a) The job number has not changed,
	b) The terminal is in keyboard wait state,
22!	c) The KCTs of the job have not changed,
	d) There has been no input from the terminal.

23!	The terminal that is unattended will have the following steps taken;
	a) Two Ctrl/C s are forced,
	b) SAVE XXXXXX.YYY is forced if the program in core is not NONAME
		(XXXXXX is keyed on the time)
		(YYY is keyed on the day)
24!	c) The user is logged out using the Double 'P' option of LOGOUT
		(If the user has exceded his quota then logout will
		put a default message in the GRIPE file, otherwise
		it is the same as the Y option)

25!	SYSMAN will also keep track of the total time it finds each
	terminal attached to a job. It times terminals 0-20.
	This information is stored in core in the array K().
26!	When SYSMAN receives a message from IMUNIZ or SHUTUP it will
	open the file (1,2)SYSMAN.DAT and add the new times to the
	ones that already exist.

30!	OPERATING INSTRUCTIONS:
	The first question the program askes is for a time interval in minutes
		( an interval of 5 minutes will send a terminal the first
		message after 45 minutes and log the terminal out after
31!		another 15 minutes.)
	The second question askes for the terminals to be watched.
		(Enter the terminal numbers separated by comas.
		11 terminals is the limit.)

40!	HOW IT WORKS:
	k%(,) holds the DDB pointer for every terminal on the system.
	T%(,) is used only for terminals that are being watched.
41!	For each terminal being watched the following are checked
	in the following order, if one element changes then the rest
	are not checked.
42!	a) Change in job
		The program checks to see if the second word in
		the terminal's DDB has changed.
43!	b) Keyboard wait state
		If the entry in the JBWAIT table for this job is 
		equal to 2 then the job is in keyboard wait.
44!	c) Change in KCTs
		The KCTs are obtained from the 11'th word in the 
		JDB for this job.
45!	d) Change in SBC
		The 5-9'th words in the DDB are the Small Buffer Chain.
		These 5 words are assumed to change whenever a 
		character is typed at the terminal.

50!	To immunize a keyboard that is being watched. The highest bit
	of the T%(X,1%) must be set. When this is done the keyboard
	only becomes unimmunized when it's job changes.

400 DIM	I%(30%),	K%(20%,2%),	T%(15%,8%),	A$(7%),   K(20%)
	! DIMENSION IN CORE ARRAYS
401	!
	! I%()-	USED TO GET INFORMATION FROM SYS CALL
	!	ALSO USED TO GET WHICH TERMINALS SHOULD BE WATCHED
	!
402	!
	! K%(,)- INFORMATION ABOUT EACH TERMINAL
	!	K%(,0%)- BASE OF DDB FOR EACH TERMINAL
	!	K%(,1%)- POINTER TO THIS TERMINALS SPACE IN T%(,)
	!	K%(,2%)- IF THIS TERMINAL SHOULD BE WATCHED
	!		-1 YES, 0 NO
	!
403	!
	! T%(,)- INFORMATION ABOUT TERMINALS BEING WATCHED
	!	T%(,1%)- JOB USING TERMINAL
	!		(HIGH ORDER: TERMINAL NUMBER, NEVER CHANGES)
	!	T%(,2%)- KCTS USED BY THIS JOB
	!	T%(,3%)- INDICATOR OF HOW MANY TIMES THIS TERMINAL
404	!		HAS BEEN CHECKED AND NO CHANGE
	!	T%(,4%)-T%(,8%)= COPY OF THE (SBC) FOR THIS TERMINAL
	!		IF NOTHING ELSE HAS CHANGED
	!
405	!
	! A$()- THE MESSAGES TO SEND TO THE USER WHEN HE HAS NOT DONE ANYTHING
	!
406	!
	! K()- THE ACCUMULATED TIME FOR EACH TERMINAL
	!	( IN MINUTES )
	!
410 DIM #1%,	K1(20%)
	! TERMINAL DATA FILE
	!
	! K1()- TOTAL MINUTES SINCE LAST RESET FOR EACH TERMINAL
	!



1000 ON ERROR GOTO 19000
	! SET ERROR TRAP

1010 CHANGE SYS(CHR$(6%)+CHR$(-3%)) TO I%
	\ J0%=I%(11%)+SWAP%(I%(12%))
	\ S0%=I%(13%)+SWAP%(I%(14%))
	\ W0%=I%(15%)+SWAP%(I%(16%))
	\ N0%=I%(23%)+SWAP%(I%(24%))
	! GET MONITOR TABLES
	  (JOBTBL)
	  (JBWAIT)
	  (TBLNAM)

1020 D0%=I%(7%)+SWAP%(I%(8%))
	\ T0%=PEEK(D0%+ASCII(RIGHT(SYS(CHR$(6%)+CHR$(-12%)),9%)))
	! GET (DEVPTR)
	  OFFSET BY 12 TO GET (TTYDEV) TABLE
	  THESE CONSECUTIVE WORDS POINT TO KEYBOARB DDB'S

1030 INPUT 'HOW MANY MINUTES BETWEEN KEYBOARD CHECKS';S
	\ S%=S*60%
	\ PRINT 'WHICH KEYBOARDS SHOULD BE WATCHED'
	\ MAT INPUT I%
	\ N%=NUM-1%
	\ N%=15% IF N%>15%
	! 11 IS LIMIT, REDIMENSION ARRAY IF MORE NEEDED

1040 K%(I%,0%)=PEEK(T0%+I%*2%) FOR I%=0% TO 20%
	\ T%=0%
	! GET BASE OF ALL TERMINAL  DDB

1045 FOR I%=0% TO N%
	\ K%(I%(I%+1%),1%)=T%
	\ K%(I%(I%+1%),2%)=-1%
	\ T%=T%+1%
	! SAVE WHICH TERMINALS TO WATCH

1050 NEXT I%
	\ B0%=2%^15%

1060 READ Z9%
	\ READ A$(I%) FOR I%=1% TO Z9%
	! Z9%- NUMBER OF MESSAGES TO BE SENT
	  A$()- MESSAGES TO BE SENT

1070 T1=TIME(0%)
	\ T=0.
	\ A1$=CHR$(6%)+CHR$(18%)+CHR$(1%)+CHR$(3%)+
	MID(SYS(CHR$(6%)+CHR$(-10%)+'SYSMAN'),7%,4%)
	! SET RECEIVE STRING

1090 PRINT 'DETACHING... .'
	\ PRINT FOR I%=1% TO 3%
	\ I$=SYS(CHR$(6%)+CHR$(7%))
	! DETACH 

1100 I%=0%
	\ I$=FNM9$('SYSMAN MESSAGE: PUT ON LINE AT '+TIME$(0%))
	! SEND MESSAGE TO CONSOLE

2010 DATA 5,
	'ARE YOU STILL THERE?',
	'TYPE SOMETHING PLEASE.',
	'FIRST WARNING TO USER (DO SOMETHING).',
	'SECOND WARNING, 1 MINUTE TO LOGOUT',
	'YOUR TIME IS UP, GOOD BYE'



3000 FOR I%=0% TO 20%
	\ GOSUB 10000
	\ IF L% THEN GOSUB 10100
	\ IF L% THEN GOSUB 10200
	\ IF L% THEN GOSUB 10300
	! CHECK JOB CHANGE
	  CHECK CHANGE KCTS
	  CHECK CHANGE (SBC)
	  SEND NOTICES OR KILL JOB

3010 NEXT I%
	\ S1%=S%
	! LOOP THROUGH ALL KEYBOARDS

3020 SLEEP S%
	\ GOSUB 11100
	\ T=(TIME(0%)-T1)/60
	\ T=T+1440 IF T<0
	\ T1=TIME(0%)
	\ GOTO 3000 UNLESS F%
	\ ON ASCII(RIGHT(I$,9%)) GOTO 4000,4100,4200

3030	! 1- DUMP TERMINAL DATA
	! 2- DUMP TERMINAL DATA AND KILL YOURSELF
	! 3- IMUNIZE KEYBOARD



4000 GOSUB 11200
	\ GOTO 3000
	! DUMP TERMINAL TIME DATA

4100 GOSUB 11200
	\ GOTO 32700
	! DUMP TERMINAL TIME DATA, THEN KILL

4200 T%=ASCII(RIGHT(I$,10%))/2%
	\ GOTO 3000 UNLESS K%(T%,2%)
	\ T%(K%(T%,1%),1%)=T%(K%(T%,1%),1%) OR B0%
	\ GOTO 3000
	! IMUNIZE KEYBOARD THEN CHECK ALL KEYBOARDS



10000	! CHECK FOR CHANGE IN JOB

10010 L%=0%
	\ T%=PEEK(K%(I%,0%)+2%) 
	\ GOSUB 11000
	\ RETURN UNLESS K%(I%,2%)
	\ L%=-1%
	\ IF T%<>(T%(K%(I%,1%),1%)  AND NOT B0%) THEN T%(K%(I%,1%),1%)=T%
			\ T%(K%(I%,1%),3%),L%=0%
	! CHANGE OF JOB

10020 L%=0% IF (T%(K%(I%,1%),1%) AND -32513%) <=0% OR K%(I%,2%)=0%
	\ RETURN
	! IMUNIZED OR NO JOB



10100	! CHECK CHANGE IN KCTS
	  W0%- (JBWAIT)
	  J0%- (JOBTBL)

10110 D%=T%(K%(I%,1%),1%) AND 255%
	\ IF PEEK(W0%+D%) <>2% THEN T%(K%(I%,1%),3%),L%=0%
			\ RETURN

10120 T%=PEEK(PEEK(PEEK(J0%+D%)+8%)+6%)
	\ IF T%<>T%(K%(I%,1%),2%) THEN T%(K%(I%,1%),2%)=T%
		\ T%(K%(I%,1%),3%),L%=0%
	! T%- KCTS USED BY THIS JOB

10130 RETURN



10200	! CHECK CHANGE IN (SBC)

10220 FOR J%=0% TO 4%
	\ IF T%(K%(I%,1%),4%+J%)<>PEEK(K%(I%,0%)+10%+J%*2%) THEN 
			T%(K%(I%,1%),3%),L%=0%
		\ T%(K%(I%,1%),4%+J%)=PEEK(K%(I%,0%)+10%+J%*2%)
	! RESET COUNTER IF CHANGE IN (SBC)

10230 NEXT J%
	\ RETURN



10300 I$=FNM9$(A$(T%(K%(I%,1%),3%)))
	\ GOSUB 10400 IF T%(K%(I%,1%),3%)=Z9%
	\ T%(K%(I%,1%),3%)=T%(K%(I%,1%),3%)+1%
	\ RETURN
	! SEND MESSAGES TO USER WARNING HIM OF APPROACHING DISASTER



10400 I$=FNM9$('BEGINNING REMOVAL SEQUENCE')\ SLEEP 5%
	\ T%=PEEK(PEEK(J0%+D%)+8%)+12%
	\ I1$=RAD$(PEEK(T%))+RAD$(PEEK(T%+2%))
	\ I$=FNM8$(STRING$(40%,32%)+CHR$(3%)+STRING$(150%,0%)+CHR$(3%))
	! GET NAME OF PROGRAM

10410 IF I1$<>'NONAME' THEN 
	I1$=LEFT(TIME$(0%),2%)+RIGHT(TIME$(0%),4%)+'.'+
	LEFT(DATE$(0%),2%)+MID(DATE$(0%),4%,1%)
	\ I1$=CVT$$(I1$,-1%)
	\ I$=FNM8$('SAVE '+I1$)
	! SAVE USERS PROGRAM

10420 I$=FNM8$('BYEP'+CHR$(8%)+'P')
	\ T%(K%(I%,1%),3%)=-1%
	\ RETURN
	! LOG USER OFF, LOGOUT WILL RECORD MESSAGE TO GRIPE



10500 DEF FNM9$(A$)
	\ IF LEN(A$) THEN I$=SYS(CHR$(6%)+CHR$(-5%)+CHR$(I%)+
		A$+CHR$(13%)+CHR$(10%))

10510 FNEND
	! SEND MESSAGE TO KEYBOARDS



10600 DEF FNM8$(A$)
	\ I$=SYS(CHR$(6%)+CHR$(-4%)+CHR$(I%)+
		A$+CHR$(13%))

10610 FNEND
	! FORCE INPUT TO A TERMINAL



11000 RETURN UNLESS T% AND 255%
	\ K(I%)=K(I%)+T
	\ RETURN
	! UPDATE TERMINAL USE INFORMATION



11100 I$=SYS(A1$)
	\ F%=-1%
	\ RETURN
	! GET MESSAGE, F%- TRUE IF MESSAGE PENDING

11110 F%=0%
	\ RETURN
	! F%- FALSE IF NO MESSAGE



11200 OPEN '[1,2]SYSMAN.DAT' AS FILE 1%
	\ K1(I%)=K(I%)+K1(I%) FOR I%=0% TO 20%
	\ CLOSE 1%
	\ K(I%)=0. FOR I%=0% TO 20%
	\ RETURN
	! DUMP TERMINAL DATA


19000 IF ERR=5% THEN RESUME 11110
	ELSE ON ERROR GOTO 0
	! ONLY ERROR IS TRAP FOR NO MESSAGE



32700 GOTO 3000 UNLESS ASCII(RIGHT(I$,8%))=1%
	\ I%=0%
	\ I$=FNM9$('SYSMAN MESSAGE:  SHUTING DOWN')
	! ONLY PRIVALIDGED USER CAN SHUT DOWN PROGRAM

32710 I$=SYS(CHR$(6%)+CHR$(8%)+CHR$(PEEK(518%)/2%)+STRING$(23%,0%)
	+CHR$(0%)+CHR$(255%))
	! KILL YOUR SELF



32767 END
