1	!
	! RSTS/E SYSTEM PERFORMANCE MEASUREMENT	V5B-24	
	! WRITTEN BY:	I.F. (BUD) DAWSON
			MACMILLAN BLOEDEL LTD.
			1075 W. GEORGIA ST
			VANCOUVER, B.C.  
			CANADA	      V6E3R9
2!
	RELATED PROGRAMS:
		PRTIME - PRINTS FILES CREATED BY 'LOGTIM', IN TAB FORM.
		GRAPH  - PRINTS FILES CREATED BY 'LOGTIM', IN GRAPH FORM.
		SUMGPH - SUMMARIZES AND PRINTS FILES CREATED BY 'LOGTIM',
			 IN GRAPH FORM


3!	 DATE WRITTEN : MARCH, 1975


6	!
	! PROGRAM 'LOGTIM' RUNS DETACHED UNDER PPN [10,2]. EACH HOUR IT
	  SAMPLES DATA ACCUMULATED BY MONITOR STATISTICS-GATHERING ROUTINE.
	  THIS ROUTINE MUST HAVE BEEN INCLUDED AT SYSGEN TIME BY ANSWERING
7!	  'STATS' TO THE QUESTION 'LONG' OR 'SHORT ANSWERS' AT THE START 
	  OF SYSGEN.
	  DATA FOR EACH HOUR IS STORED IN A VIRTUAL ARRAY, NAMED FOR MONTH
	  AND DAY (IE. APR09.). EACH SLOT IN VIRTUAL ARRAY REPRESENT DATA
	  FOR THE PREVIOUS HOUR.
8!	  WHEN THE SYSTEM IS IPL'D, THE DAY'S FILE IS CREATED IF IT DOES
	  NOT ALREADY EXIST, OR IT IS UPDATED IF IT DOES EXIST. THE JOB
	  THEN SLEEPS FOR ONE HOUR AND ONE MINUTE, THEN AGAIN STORES THE
	  STATISTICS FROM THE MONITOR TABLES.
9!	  IF THIS PROGRAM RUNS UNDER A NON-PRIVILEGED NUMBER (IE. [10,2])
	  IT MUST HAVE THE PRIVILEGED BIT (<128>) SET ON AFTER 'COMPILE'.


20	DIM #1%, T$(32%) = 128%		! ONE LINE FOR EACH OF 24 HOURS,
					  PLUS 7 HDG LINES AND 1 SPARE
90	DIM T(100), M%(30%), N%(30%)
100	P%=PEEK(PEEK(156%)+2%)
	: IF P%=0% THEN
		PRINT "NO STATISTICS CONFIGURED IN THIS SYSTEM"
		: GOTO 32767
110	T(I%)=0. FOR I%=0% TO 100%
115	O% = 12%			! TEMP DISK FILE ON CHANNEL 12
120	I9% = 0%
130	&'LOGTIM DETACHING....' :
	O1$ = SYS(CHR$(6%)+CHR$(7%))	! DETACH MYSELF
140	GOSUB 11000			! GET CURR # USERS FOR FIRST REPORT
					  OF THE CYCLE, INSTEAD OF AVERAGE
210	GOSUB 15000			! OPEN A FILE TO STORE REPORT
500	GOSUB 1000 :
	GOSUB 10000			! GET STATS, DO ONE LINE ON REPORT
512	U5% = 0%			! ZERO TOTAL # OF USERS
515	FOR U3% = 1% TO 61% :
	SLEEP 60% :
	GOSUB 11000 :
	NEXT U3%			! WAIT 1 MINUTE, THEN GET # OF USER
					  NOW, THEN GET AVERAGE OVER 61 MIN
					  FOR NEXT HOURLY CYCLE

520	U5% = U5%/61%				! GET AVG # USERS FOR HOUR
530	GOTO 210			! SEE IF NEW DAY YET, THEN DO REPORT


998	!
	! GATHER ALL STATS FOR THIS CYCLE, IN LINES
	! 1000 TO 9999, THEN RETURN TO MAINLINE
	!
1000	T%=PEEK(P%)		! TICKS PER SECOND
1010	U=FNX(2%)		! UPTIME (TICKS)
1020	B%=PEEK(P%+6%)		! SMALLEST FREE COUNT
1030	S=FNX(8%)		! LEVEL 3 ACCOUNTED (TICKS)
1040	L=FNX(12%)		! LOST (TICKS)
1050	O=FNX(16%)		! LEVEL 3 UNACCOUNTED (TICKS)
1060	N=FNX(20%)		! NULL (TICKS)
2000	F0=FNX(24%)		! FIP DESIRED
2010	F1=FNX(28%)		! FIP NOT RUNNING
2020	F2=FNX(32%)		! FIP WAITING
2030	F3=FNX(36%)		!	FOR CODE
2040	F4=FNX(40%)		!	FOR DISK
2050	F5=FNX(44%)		!	FOR SAT
2060	F6=FNX(48%)		!	FOR OTHER
3000	L0=FNX(52%)		! PR0
3010	L1=FNX(56%)		! PR1
3020	L2=FNX(60%)		! PR2
3030	L3=FNX(64%)		! PR3
3040	L4=FNX(68%)		! PR4
3050	L5=FNX(72%)		! PR5
3060	K9%=PEEK(P%+76%)	! KW11P OVERRUNS
9999	RETURN

				!!SKIP
10000	!
	! PRINT ONE LINE ON THE REPORT, REPRESENTING ONE SET OF
	! STATISTICS FOR ONE CYCLE, BETWEEN SLEEPS OF S%
	!
10010	OPEN 'LOGTIM.TMP' FOR OUTPUT AS FILE O%	! TEMP DISK FILE
10030	PRINT #O%, MID(NUM$(U5%),2%,2%);	! PRINT AVG # USER FOR HOUR
10100	PRINT #O%, LEFT(TIME$(0%),5%);'   ';	! TIME OF THIS SAMPLES
10105	PRINT #O%, FNP$(U-S-L-O-N);'   ';	!"USER RUN-TIME
10110	PRINT #O%, FNP$(S);' ';			!" EXEC CHARGED SERVICE"
10120	PRINT #O%, FNP$(O);'  ';  		!" EXEC UNCHARGED TIME"
10130	PRINT #O%, FNP$(L);' ';			!" LOST TIME"
10140	PRINT #O%, FNP$(N);'  ';		!" NULL TIME"
10142	PRINT #O%, USING '###.##%', 100.;	!" TOTAL PERCENT = 100.00"
10143	PRINT #O%, '  ';
10145	PRINT #O%, USING '###', B%;	! "LOWEST SMALL BUFFER COUNT"
10146	PRINT #O%, '    ';
10310	PRINT #O%, FNP$(F0)+'  =';		!" FIP QUEUE NON-EMPTY"
10320	PRINT #O%, FNP$(U-F1);' +';		!" FIP ACTUALLY RUNNING"
10330	PRINT #O%, FNP$(F2);' =->';		!" FIP WAITING TO RUN"
10340	PRINT #O%, FNP$(F3);			!" WAITING FOR CODE"
10350	PRINT #O%, FNP$(F4);			!" WAITING FOR DISK DATA"
10360	PRINT #O%, FNP$(F5);			!" WAITING FOR SAT"
10370	PRINT #O%, FNP$(F6)			!" WAITING FOR OTHER"
10400	CLOSE O%			! ONE PRINT LINE IS NOW ON DISK
					  IN FORMATTED ASCII
10500	OPEN 'LOGTIM.TMP' FOR INPUT AS FILE O%
10510	INPUT LINE #O%, I0$		! GET THAT LAST LINE
10520	T$(I5%) = I0$			! STICK IT IN THE VIRTUAL ARRAY
10530	CLOSE O%			! DONE WITH TEMP DISK FILE
10540	CLOSE 1%			! CLOSE OUR VIRTUAL ARRAY
10999	RETURN

				!!SKIP
11000	!
	! GET NUMBER OF USERS FOR THIS TIME PERIOD
	!
11005	DIM U4%(2%)				! TEMPORARY ARRAY
11010	CHANGE SYS(CHR$(6%)+CHR$(-12%)) TO M%		! GET # OF USERS
11020	U6% = M%(13%)+SWAP%(M%(14%))		! ADDR OF USER COUNT
11030	CHANGE CVT%$(PEEK(U6%)) TO U4%		! GET # USERS IN ARRAY
11040	U5% = U5% + U4%(2%)			! ADD TO TOTAL USER FOR THIS
						  HOUR, TO GET AN AVERAGE
11099	RETURN


12000	!
	! REPORT PAGE HEADING
	!
12005	OPEN 'LOGTIM.TMP' FOR OUTPUT AS FILE O%	! TEMP DISK FILE
12120	P9% = P9% + 1%
12130	& #O%, TAB(37%);
	'RUNNING SYSTEM STATISTICS OF RSTS/E V5B - 24 ON ';
12140	& #O%, DATE$(0%);
12150	& #O%, TAB(120%); 'PAGE'; P9%
12160	& #O% : & #O%
12170	& #O%, TAB(8%);
12180	& #O%, 
	'-'; FOR Z9% = 1% TO 13%
12190	& #O%,
	' ALLOCATION OF CPU TIME ';
12200	& #O%,
	'-'; FOR Z9% = 1% TO 14%
12205	PRINT #O%, ' LOWEST';
12210	& #O%,
	TAB(72%);
12220	& #O%,
	'-'; FOR Z9% = 1% TO 15%
12230	& #O%,
	' FILE PROCESSING (FIP) STATS ';
12240	& #O%,
	'-'; FOR Z9% = 1% TO 15%
12250	& #O%
12260	& #O%,
	' TIME     USER    --EXEC SERVICE--';
12270	& #O%,
	'   LOST    NULL    TOTAL   SMALL   FIP QUEUE';
12280	& #O%,
	'  ANY FIP  WAITING     READY TO RUN, WAITING FOR:'
12290	& #O%,
	'OF DAY  RUN TIME  CHARGED UNCHRGED';
12300	& #O%,
	'   TIME    TIME  PER CENT  BUFFS   NON-EMPTY';
12310	& #O%,
	'  RUNNING  TO RUN      CODE   DATA    SAT   OTHER'
12320	& #O%
12330	CLOSE O%			! CLOSE TEMP DISK FILE
12500	!
	! READ FORMATTED ASCII DISK FILE CONTAINING PAGE HEADING,
	! AND TRANSFER IT TO PERMANENT VIRTUAL ARRAY FILE (1%)
	!
12510	OPEN 'LOGTIM.TMP' FOR INPUT AS FILE O%	! READ TEMP FILE BACK IN
12515	ON ERROR GO TO 12700		! FOR END-OF-FILE
12520	FOR I5% = 1% TO 7%		! SEVEN LINES IN PAGE HEADING
12530	INPUT LINE #12%, I0$		! GET A LINE OF PAGE HEADING
12540	I0$ = LEFT(I0$,LEN(I0$)-2%)	! DROP CR/LF
12550	T$(I5%) = I0$			! STORE IN VIRTUAL ARRAY
12560	NEXT I5%			! DO ALL PAGE HEADING LINES
12570	CLOSE O% :
	RETURN


12700	&'ERR';ERR;'AT LINE';ERL : CLOSE 1%,12% : STOP
12999	RETURN



15000	!
	! CHECK IF TODAY'S FILE EXISTS. IF SO, RETURN. 
	! IF NOT, INITIALIZE ONE AND RETURN
	!
15060 ON ERROR GO TO 15270
15070	F$ = MID(DATE$(0%),4%,3%) + LEFT(DATE$(0%),2%)	! USE TODAY'S DATE 
						AS THE FILE NAME
15080 OPEN F$ FOR INPUT AS FILE 1%		! IS THERE A FILE ?
15090 ON ERROR GO TO 0				! TURN OFF ERROR TRAP
15100	!
	! IF CONTROL REACHES HERE, THE FILE ALREADY EXISTS,
	! SO WE HAVE JUST IPL'ED, AND THE FILE IS TO BE UPDATED
	!
15250	T1$ = TIME$(0%) :
	T1$ = LEFT(T1$,INSTR(1%,T1$,':')-1%)	! GET HOUR OF DAY
15255	I5% = VAL(T1$) + 1% :
	I5% = I5% + 7%			! USE HOUR OF DAY + 1, AS INDEX
					  INTO VIRTUAL ARRAY, PLUS 7 TO
					  ALLOW FOR PAGE HEADING LINES
15259	RETURN


15260	!
	! FILE DOES NOT EXIST - MUST BE INITIALIZED
	!
15270 IF ERR = 5% AND ERL = 15080 THEN 
	RESUME 15280 ELSE
	ON ERROR GO TO 0			! TRAP 'NO FILE FOUND'
						  AND CREATE IT
15280 OPEN F$ FOR OUTPUT AS FILE 1%		! CREATE LOGTIME FILE
15300	GOSUB 12000				! DO A PAGE HEADING ON FILE
15310	FOR X2% = 8% TO 32% :
	T$(X2%) = '*****' :
	NEXT X2%			! INIT VIRT ARRAY WITH 'NO DATA' IND

15320	GOTO 15250			! SET UP VIRTUAL ARRAY INDEX
			  VALUE, BASED ON CURR HOUR OF DAY
30000	DEF FNP(Q%)
	: Q=PEEK(Q%+P%)
	: IF Q<0. THEN Q=Q+65536.
30010	FNP=Q+65536.*PEEK(Q%+P%+2%)
	: FNEND
30100	DEF FNX(Q%)
	: Q=FNP(Q%)
	: T(Q%)=0. IF I9%
	: FNX=Q-T(Q%)
	: T(Q%)=Q
	: FNEND		! DIFF IN TICKS SINCE PREV SAMPLE AFTER FIRST TIME
30200	DEF FNP$(Q)
	: IF U=0. THEN
		PRINT #O%, USING "###.##%",0.; ELSE
		PRINT #O%, USING "###.##%",Q*100./U;
30210	FNP$=""
	: FNEND
30299	!!SKIP
32767 END
