10 PRINT              'NORTON V02.2'
20 REM		DECIPHERS INPUT STRING AND
30 REM		  LOCATES OUTPUT PROGRAM
35 REM  PART OF PACKAGE INCLUDING MNEPCH.BAS, EPHEM1.BAS AND NORTON.HLP
40 PRINT
45 REM  SEND COMMENTS, CHANGES, BUG REPORTS TO PROGRAM AUTHOR 
46 REM 		WARREN LEACH
		OREGON MUSEUM OF SCIENCE AND INDUSTRY
		COMMUNITY RESEARCH CENTER
		4015 SW CANYON ROAD
		PORTLAND, OREGON 97221
		(503) 248-5923
50 A$='[6,1]'	!PROGRAM IS RESIDENT HERE
60 ON ERROR GOTO 1240: RANDOM
80 J$="JD 2,4#,####.## UT"
120 OPEN "SAM.DAT" AS FILE 2		!COMMON FILE
130 DIM #2,D$(1)=128,E(15,6),D(13),M$(12)=3,Y%(13),P%(15),
	P$(15)=7,F%(15),N$(9)=15,C0$(20%)=25%,C0(20%,8%)
140 N$(0%)=A$	!STUFF PPN INTO FILE
142 L0=E(0%,3%)	!RETRIEVE LONGITUDE FROM SAM
145 IF Y%(13%)<>365% THEN PRINT "Just a Minute"
	:Y=VAL(RIGHT(DATE$(0%),8%))
	:D(1%)=Y*365+FIX(Y/4)
	:N$(9%)=A$+'NORTON'
	:C1$='MNEPCH'
	:GOTO 1230	!SAM.DAT IS DEFECTIVE

150 PRINT
160 PRINT: PRINT
165 PRINT "."+CHR$(7%);
170 OPEN "KB: " FOR INPUT AS FILE 3:
	INPUT LINE #3, D1$		!START
190 D$=CVT$$(D1$,32%+16%+4%+1%): IF D$='' THEN 165
200 IF INSTR(1%,D$,"HELP")>0% THEN D(3%)=3%: GOTO 850
220 D1$=D$: D(3%),N%=0%: D(13%)=1%	!SEE DESCRIPTION OF MATRIX D BELOW

230 IF INSTR(1%,D$,"SAME PLANET")>0% THEN 300 ELSE
	P9%=D(12%)
	:D(6%)=0%	!<< FIND PLANET NAMES >>
240	FOR P0%=0% TO P9%
	:IF INSTR(1%,D$,CVT$$(P$(P0%),32%))=0% THEN P%(P0%)=0% ELSE
		N%=N%+1%: P%(P0%)=1%	!SET PLANET FLAG
245	NEXT P0%
250 IF INSTR(1%,D$,'COMET')=0% THEN 265	!DID SOMEONE SAY 'COMET'?
251 IF INSTR(1%,D$,' ALL C')>0% THEN MAT P%=CON: GOTO 265
255	FOR P0%=1% TO C0(0%,0%)
	:IF INSTR(1%,D$,C0$(P0%))=0% THEN P%(P0%)=0% ELSE
		N%=N%+1%: P%(P0%)=1%	!SET COMET FLAG
260	NEXT P0%
265 DEF FNA(A%,B%): FNA=N%+B%-A%+1%: P%(G%)=1% FOR G%=A% TO B%: FNEND
268 IF INSTR(1%,D$,"INNER")>0 THEN N%=FNA(1%,4%)
270 IF INSTR(1%,D$,"OUTER")>0% THEN N%=FNA(5%,9%)
280 IF INSTR(1%,D$,"ASTER")>0% THEN N%=FNA(10%,P9%)
290 IF INSTR(1%,D$,"ALL P")>0% OR N%=0% THEN N%=FNA(1%,9%)
295 IF INSTR(1%,D$,'MOON')>0% OR INSTR(1%,D$,'LUNAR')>0% THEN
	PRINT 'Lunar Calculator is out to lunch': GOTO 150

300 IF INSTR(1%,D$,"SAME DATE")>0% THEN S=D(9%): GOTO 685  !<< LOOK FOR DATE >>
310 T=0%: D(6%),F1%=INSTR(1%,D$," TO ")
	:IF F1%>0% THEN D$=LEFT(D$,F1%)		! F1% POINTS TO 'TO' OR IS 0
320 FOR M%=1% TO 12%: P3%=1%
330 P%=INSTR(P3%,D$,M$(M%))
340 IF P%>0% AND INSTR(P3%,D$,"MARS")=P% THEN P3%=P%+4%: GOTO 330 !SEPARATE
350 IF P%>0% AND INSTR(P3%,D$,"JULI")=P% THEN P3%=P%+4%: GOTO 330 !'MARS'
360 IF P%>0% AND INSTR(P3%,D$,"JUNO")=P% THEN P3%=P%+4%: GOTO 330 ! FROM
370 IF P%>0% AND INSTR(P3%,D$,"DECL")=P% THEN P3%=P%+4%: GOTO 330 !'MARCH'
380 IF P%>0% THEN 430
400 NEXT M%
410 Z$=DATE$(0%)
	:D=VAL(MID(Z$,1%,2%))
	:M%=INSTR(1%,'JanFebMarAprMayJunJulAugSepOctNovDec',MID(Z$,4%,3%))/3%+1%
	:Y=VAL(RIGHT(Z$,8%))+1900%
413 IF INSTR(1%,D$,"YESTER")>0% THEN D=D-1%
418 IF INSTR(1%,D$,"TOMMO")>0% OR INSTR(1%,D$,"TOMO")>0% THEN D=D+1%
420	GOTO 470

430 P1%=INSTR(P%,D$,",")
	:IF P1%=P% THEN
		PRINT "Bad Date -- 'MONTH DD,YYYY'"
		:PRINT: GOTO 160
450 P2%=5%: D=VAL(MID(D$,P1%-2%,2%))	!PARSE DATE IN SENTENCE
460 Y=VAL(MID(D$,P1%+1%,P2%))	!THIS LINE USES ERROR TRAP BELOW
470 D1=D-.5+Y%(M%)+(Y-1900%)*365+FIX((Y-1900%)/4%)
	-(M%<3)*(Y/4=INT(Y/4) AND Y<>1900)		!EPOCH 0 JAN 1900
480 IF T=0% THEN T=D1/36525

550 P1%=3%: S=1%: P%=INSTR(1%,D$,"EVERY"): IF P%=0% THEN 570
560 S=VAL(MID(D$,P%+5%,P1%))	!THIS LINE USES AN ERROR TRAP BELOW

570 IF D(6%)>0% AND F1%=0% THEN 790	!DON'T FIGURE TIME TWICE
580 D(11%)=1%
	:U1%=(INSTR(1%,D$," UT")=0%)
	:U1=U1%*D(8%)	!U1 IS TIME DIFF BETWEEN INPUT AND UT
600 IF INSTR(1%,D$,"NOON")>0% THEN H=12%: GOTO 665
610 IF INSTR(1%,D$,"MIDN")>0% THEN H=24%: GOTO 665
620 P%=INSTR(1%,D$,':')
	:IF P%=0% THEN H=TIME(0%)/60/60
	:GOTO 665	!READ RSTS TIME
650 H=VAL(MID(D$,P%-2%,2%))+VAL(MID(D$,P%+1%,2%))/60%
660 IF INSTR(1%,MID(D$,P%+3%,8%)," PM")>0% THEN H=H+12%
665 H=H-U1		!ALL INTERNAL TIME IS UT
670 IF H<0% THEN H=H+24%: D1=D1-1%: GOTO 670
680 IF H>24% THEN H=H-24%: D1=D1+1%: GOTO 680

685 IF INSTR(1%,D$,"JULIA")>0% THEN
	 F2%=1%
	:D(3%)=4%
	:PRINT: PRINT USING J$,D1+H/24%+15020%

690 T1=D1/36525: H1=H-D(8%)		!<< SIDERIAL TIME >>
700 H9=6.6460655+(.0929*T1/3600+2400.05126167)*T1  !MEAN GREENWICH SIDERIAL 0:00 
710 H0=H9-INT(H9/24%)*24%+L0/PI/2*.655556E-1+H1+H1/24*.655556E-1
	:H0=H0-INT(H0/24)*24 !LOCAL SIDERIAL IS FUNCTION OF LONGITUDE
720 IF INSTR(1%,D$,"SIDER")=0% THEN 780 ELSE F2%=1%: D(3%)=4%
730 PRINT: PRINT USING "   Local Mean Time  **:##",INT(H1),(H1-INT(H1))*60%
740 PRINT USING "   Universal Time   **:##",INT(H),(H-INT(H))*60%
760 PRINT USING "   Siderial Time    **:##",INT(H0),(H0-INT(H0))*60%;
770 PRINT '  at Longitude';L0*180/PI

780 IF F1%>0% THEN D$=RIGHT(D1$,F1%)
	:D2=D1
	:F1%=0%
	:GOTO 320	!F1% INDICATED SECOND DATE IN SENTENCE
790 D7=D1: IF D(6%)=0% THEN D2=D1
800 IF D7<D2 THEN PRINT "Join us as we go back in Time...": S=-ABS(S)
810 D$=D1$: D(10)=T: D(9%)=S: D(4%)=H: D(5%)=H0: D(7%)=D7: D(1%)=D2: D$(1%)=D1$
	!D(X%) IS IN 'SAM.DAT':
	!  0=Home Planet Number	         7=Ending Date
	!  1=Starting Date               8=LST-GMT
820	!  2=Epoch of SAM.DAT            9=Increment in days
	!  3=Printout flag              10=D(2) as fraction of century
825	!  4=Time requested in UT       11=LST flag
	!  5=Siderial time (local)      12=Number of planets on file
	!  6=Two date flag              13=SAM Status

830 IF INSTR(1%,D$,"OBLI")>0% THEN D(3%)=2%	!OBLIQUITY
840 IF INSTR(1%,D$,"ELEM")>0% THEN D(3%)=1%	!ORBITAL ELEMENTS
850 F$="KB: ": IF INSTR(1%,D$,"INEPR")>0% THEN F$="LP: "
860 IF D(3%)>0% THEN OPEN F$ FOR OUTPUT AS FILE 1
870 ON D(3%)+1% GOTO 1020,930,1010,880,1020	!ZAP,ELEMENTS,OBLIQUITY,HELP,ZILCH

880 OPEN A$+"NORTON.HLP" FOR INPUT AS FILE 4
890 PRINT #1: PRINT #1: IF INSTR(1%,D$,"SOME")=0% THEN 910
900 INPUT LINE #4,L$: IF LEFT(L$,4%)<>"STOP" THEN 900
910 INPUT LINE #4,L$: IF LEFT(L$,4%)="STOP" THEN PRINT #1: CLOSE 4: GOTO 1020
920 PRINT #1,L$;: GOTO 910

930 FOR P%=0% TO P9%
	:IF P%(P%)=0% THEN 990		!LIST ORBITAL ELEMENTS FROM SAM
940 PRINT #1: PRINT #1,P$(P%);TAB(20);
	:PRINT #1,USING J$,E(P%,0%)+15020%: PRINT #1
950	PRINT #1,N$(1%);TAB(24%);E(P%,1%)
	:PRINT #1,N$(2%);TAB(24%);: PRINT #1 USING '.######',E(P%,2%)
955	PRINT #1,N$(J%);TAB(24);E(P%,J%)*180/PI  FOR J%=3% TO 6%
985 IF P%>0% THEN A=E(P%,1%)
	:PRINT #1,"Period";TAB(24);365.257*A^(3/2)
			!365.257=2*PI/.017202 (GAUSS GRAVITATION CONSTANT)
988 IF P%=1% THEN PRINT #1
	:PRINT #1,"Mean Obliquity of Ecliptic to Earth's Equator is";
	 E(0%,1%)*180/PI;"Degrees"
990 NEXT P%

1020 ! LOOK FOR SOMETHING TO DO
1025 IF INSTR(1%,D$,"DATA")>0 THEN MAT F%=CON: F1%=14%: GOTO 1080
1030 F1%=0%: RESTORE
	:FOR F%=1% TO 14%
	:READ F$
	:IF INSTR(1%,D$,F$)=0% THEN F%(F%)=0%
		ELSE F1%=F1%+1%: F%(F%)=1%	!SET F% FLAGS
1050	DATA "VELO","AL LONG","LAR DIST","ELONG","CONST","RIC DIST"
1060	DATA "RIS","SET","CULMIN","IC X","ASCEN","UR AN","DECL","ALT"
1070	NEXT F%:
     IF INSTR(1%,D$,"WHERE")>0% THEN F%(5%),F%(11%),F%(13%)=1%: F1%=F1%+3%
1080 F%(0%)=F1%: F2%=D(3%)
1090 IF INSTR(1%,D$,"PLOT")>0% OR INSTR(1%,D$,"LIST")>0% THEN 1140
1110 IF F1%=0% THEN
 	  IF F2%>0% THEN 60 ELSE
		 PRINT "Type 'HELP' for Help": GOTO 60

1140 C1$="EPHEM1"
1150 IF INSTR(1%,D$,"COMET")>0% THEN C1$="EPHEM2"
1160 IF INSTR(1%,D$,'PLOT')=0% THEN 1220
1170 K%=ASCII(MID(SYS(CHR$(6%)+CHR$(9%)),2%,1%))/2%	!THIS KB: NUMBER
1180 IF INSTR(1%,' 1 15 20 ',NUM$(K%))=0% THEN
	PRINT "Sensors indicate that this is not a graphics terminal": 
	INPUT 'Do you want the Plot anyway';Q$: 
	IF ASCII(Q$)<>ASCII('Y') THEN 60
1200 C1$="SKYPLT"
1210 IF INSTR(1%,D$,"R SYS")>0% OR INSTR(1%,D$,"ORBIT")>0% 
		THEN C1$="SLRSYS"
1220 N$(9%)=A$+C1$
	:IF ABS(D(1%)-D(2%))>365% THEN C1$="MNEPCH"
		!IF SAM EPOCH FURTHER THAN A YEAR, GO TO 'MNEPCH' TO FIX
1230 CLOSE 1,2,3: CHAIN A$+C1$ 50

1240 REM  ERROR HANDLER
1250 IF ERR=52% AND ERL=560% THEN P1%=P1%-1%: IF P1%>0% THEN RESUME 560
				ELSE PRINT "Bad 'Every'": RESUME 60
1260 IF ERR=52% AND ERL=460% THEN P2%=P2%-1%: IF P2%=4% THEN RESUME 460
				ELSE PRINT "Bad Year": RESUME 160
1280 IF ERR=11% AND ERL=170% THEN KILL "SAM.DAT": GOTO 1340
1285 PRINT: PRINT 'NORTON - ';
1290 IF ERR=5% AND ERL=1230% THEN
	PRINT C1$+".BAS is Missing": RESUME 60
1300 E$=SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)): P%=INSTR(3%,E$,CHR$(0%))
1310 PRINT MID(E$,3%,P%-2%);
1320 IF ERR=14% THEN PRINT " -- Lineprinter": PRINT: F$="KB: ": RESUME 860
1330 PRINT " in line";ERL: PRINT "TRY AGAIN": RESUME 60
1340 END
