001  REM ------------ LAWRENCE UNIVERSITY ------------
002  REM ------------ COMPUTER CENTER     ------------
003  REM ------------ APPLETON, WISCONSIN 54911 ------
004  REM ------------ (414) 739-3681      ------------
005  !---------------
006  REM -- PROGRAM NAME, VERSION AND DATE --
007  REM --     PUNCH VERSION 1A   14-JUNE-74
008  !---------------
009  REM -- PROGRAM AUTHORSHIP --
010  REM --     PUNCH WAS WRITTEN BY S. HOLMGREN, LAWRENCE UNIVERSITY
011  REM --     COMPUTER CENTER.
012  !---------------
013  REM -- PURPOSE OF PROGRAM --
014  REM --     PUNCH PUNCHES PAPER TAPES ON ASR 33 TELETYPES.
015  REM --     INCLUDED ON THE PAPER TAPE ARE A LEADER OF NULLS, AN
016  REM --     ARROW SHOWING TAPE MOTION DIRECTION, THE NAME OF THE
017  REM --     FILE IN READABLE FORMAT AND A SERIES OF RUBOUTS TO
018  REM --     INDICATE BEGINNING OF MACHINE READABLE INFORMATION.
019  REM --     PUNCH ALSO EDITS OUT LINE FEEDS THAT
020  REM --     NORMALLY FOLLOW CARRIAGE RETURNS SO THAT THE PAPER
021  REM --     TAPES CAN BE READ BY RSTS-11 IN EITHER TAPE OR NORMAL
022  REM --     ECHOING MODE.
023  !---------------
024  REM -- LANGUAGE AND OPERATING SYSTEM --
025  REM --     PUNCH IS WRITTEN IN BASIC-PLUS FOR OPERATION UNDER
026  REM --     RSTS-11 VERSION 4A ON A PDP11/20 OR PDP11/35.  IT
027  REM --     MAKES USE OF CERTAIN SYS FUNCTIONS PRESENT IN V4A OF
028  REM --     RSTS.  (FOR DETAILS, SEE RSTS-11 SYSTEM MANAGER'S GUIDE
029  REM --     [DEC-11-ORSMA-B-D].)
030  !---------------
031  REM -- AVAILABILITY --
032  REM --     PUNCH IS A NON-PROPRIETARY PROGRAM PRODUCT OF LAWRENCE
033  REM --     UNIVERSITY.  IT IS DISTRIBUTED AT COST FOR EDUCATIONAL
034  REM --     USE ON THE CONDITION THAT IT NOT BE SOLD, RENTED, OR
035  REM --     LEASED FOR PROFIT.
036  !---------------
037  REM -- LIMITATIONS --
038  REM --     PUNCH MUST HAVE THE FILE 'PUNCH.CHR' AVAILABLE IN THE
039  REM --     SYSTEM LIBRARY.  PUNCH MUST BE PROTECTION CODED 168.
040  !---------------
041  REM -- FURTHER DOCUMENTATION --
042  REM --     NONE.
043  !---------------
044  REM -- DISCLAIMER --
045  REM --     NEITHER LAWRENCE UNIVERSITY NOR THE AUTHORS OF THIS
046  REM --     PROGRAM ASSUME ANY LIABILITY, EXPRESSED OR
047  REM --     IMPLIED, WITH RESPECT TO THE CORRECTNESS OR PERFORMANCE
048  REM --     OF THIS PROGRAM.
049  !---------------
120 DIM M%(30)
        ! DEFINE ARRAY FOR SYS FUNCTIONS
130 CHANGE SYS(CHR$(6%)+CHR$(9%)) TO M%  :  K9%=M%(2%)/2%
        ! GET THE USER'S KB#
140 IF K9%<=8% THEN 150 ELSE PRINT "PUNCH CAN ONLY BE USED ON ";
    "TELETYPE MODEL 33 TERMINALS!" : GOTO 720
        ! ALLOW USE ONLY ON ASR33'S.
150 M$=SYS(CHR$(6%)+CHR$(-7)) : ON ERROR GOTO 300 
        !  ENABLE CNTRL/C TRAP
160 LET P$="$PUNCH.CHR"
        ! SET UP THE NAME OF THE CHARACTER TRANSLATION FILE
180 READ M%(I%) FOR I%=0% TO 14%
        ! SET UP M% TO EXPAND LINE WIDTH TO 255%
190 DATA 14,6,3,1,0,255,-1,128,-1,-1,128,128,128,1,1
200 M%(4%)=K9%
210 CHANGE M% TO M$ : M$=SYS(M$)
        ! DO THE SYS FUNCTION TO EXPAND LINE WIDTH
220 LET D$=DATE$(0%) : CHANGE D$ TO D% : D%(5%)=D%(5%)-32% :
    D%(6%)=D%(6%)-32%
230 D$=LEFT(D$,4%)+CHR$(D%(5%))+CHR$(D%(6%))+RIGHT(D$,7%)
        ! CHANGE LOWER CASE CHAR. IN DATE TO UPPER CASE
240 B$=CHR$(0%) : B$=B$+B$+B$ : L$=B$+B$+B$+B$+B$+B$
        ! SET UP THE CODE FOR LEADER ON TAPE
250 R$=CHR$(255%)+CHR$(255%)+CHR$(255%)+CHR$(255%)+CHR$(255%) :
    R$=R$+R$+R$+R$
        ! SET UP CODE FOR LEADER AND RUBOUTS
260 R$=B$+B$+R$+B$+B$
270 B1$=B$+CHR$(0%)+CHR$(0%)
280 A2$=CHR$(8%)+CHR$(16%)+CHR$(36%)+CHR$(66%)+CHR$(36%)+CHR$(36%)+
    CHR$(36%)+CHR$(36%)+CHR$(36%)+CHR$(60%)
        ! CODE FOR ARROW ON LEADER
290 OPEN P$ AS FILE 1%  : GOTO 320
        ! OPEN THE TRANSLATION FILE
300 IF ERR<>5% THEN GOTO 600 ELSE PRINT"CAN'T FIND '"X1$"'"
310 RESUME 450 
320 DIM#1,V$(48)=8%,K%(1) ! ACCESS VIRT. CORE MATRIX
330 IF V$(0%)<>"\TESTER/" GOTO 690
        ! SEE IF THE VIRTUAL CORE ARRAY IS OKAY
335 PRINT "PUNCH V1A -- PAPER TAPE PUNCHING PROGRAM -- LAWRENCE"
340 INPUT "INSTRUCTIONS--(Y OR N)";Y$
350 IF Y$="N" THEN 450 
360 &"THIS IS A ROUTINE TO PUNCH A USER'S PROGRAM OUT ON PAPER TAPE"
370 &"   AND TO LABEL THE LEADER WITH THE PROGRAM NAME AND DATE."
380 &"WAIT FOR THE 'FILE NAME ?' REQUEST, THEN TYPE IN THE NAME OF"
390 &"   THE FILE. IF NO EXTENSION IS ENTERED, '.BAS' IS ASSUMED."
400 & "TURN THE PAPER TAPE PUNCH ON WHEN THE PROGRAM REMINDS YOU, "
410 & "   THEN HIT 'RETURN'.  TURN OFF THE PUNCH AFTER IT PUNCHES "
420 &"   THE FINAL LEADER."
430 &"MULTIPLE-LINE STATEMENTS WILL LOOK FUNNY ON THE KEYBOARD, BUT"
440 &"   HAVE FAITH THAT THEY WILL APPEAR CORRECTLY ON THE TAPE." : &
450 INPUT "FILE NAME";X$ : X1$=X$ : X$=X$+" "+D$
460 IF INSTR(1%,X1$,".")=0% THEN X1$=X1$+".BAS"
470 OPEN X1$ FOR INPUT AS FILE 2%
480 INPUT "IS THE PUNCH ON";Y$
        ! GIVE TIME TO TURN ON THE PUNCH
490 N%=LEN(X$) : A$=CHR$(0%)
500 FOR I%=1% TO N% : X%=ASCII(MID(X$,I%,1%))
510 IF X%<48% OR X%>90% THEN A$=A$+B$+B1$
           ELSE A$=A$+B$+V$(X%-47%)
520 NEXT I% : A$=L$+A$+R$  !  ATTACH LEADERS TO STRING
530 A$=L$+A2$+A$ ! ATTACH ARROW
540 PRINT A$; : K%(1%)=K%(1%)+1%  ! INCREMENT USE COUNTER
550 PRINT CHR$(13%);CHR$(10%);CHR$(10%);CHR$(10%);
560 INPUT LINE #2,Z$
570 L%=INSTR(1%,Z$,CHR$(10%))
        ! SEE IF THIS LINE CONTAINS LINE FEED
580 IF MID(Z$,L%-1%,1%)=CHR$(13%) THEN 590 
    ELSE Z$=LEFT(Z$,L%)
        ! CHOP OFF EXTRA LINE FEEDS
590 PRINT Z$;  : GOTO 560 
600 IF ERR<>11% THEN 670 
610 CLOSE 2 : RESUME 620 
620 PRINT L$+L$+A2$+R$
630 INPUT"DO YOU WISH TO PUNCH ANOTHER FILE (Y OR N)";Y$
640 IF Y$="Y" THEN 450 
650 IF Y$="USE" THEN 660 ELSE 670 
660 PRINT K%(1%);" FILES PUNCHED SINCE ";V$(46%);V$(47%);V$(48%)
670 CLOSE 1 : M%(5%)=73% : CHANGE M%TO M$ : M$=SYS(M$)
680 ON ERROR GOTO 0 : GOTO 720 
     ! IN CASE OF ERROR (OR CTRL/C) RESTORE THE TTY FIRST,THEN
       HANDLE THE ERROR
690 PRINT "VIRTUAL CORE MATRIX IN ERROR FOR PROGRAM 'PUNCH'"
700 PRINT "NOTIFY CENTER PERSONNEL BY PHONE(EXT 564)"
710 PRINT"OR BY RUNNING THE PROGRAM '$GRIPE'"
        ! COMPLAIN IF 'PUNCH.CHR' IS SCREWED UP
720 END
