


                    
Ready


100 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  : !                                                          !
  : !                       SADSM                              !
110 !                                                          !
  : !     SADSM IS AN INSTRUCTIONAL MACHINE LANGUAGE ADOPTED   !
  : ! ORIGIONALLY FROM THE IBM 1130 AT U-W-PLATTEVILLE.  THE   !
120 ! LANGUAGE 'SADSM' IS A VERY EASY LANGUAGE TO BE 'EMULATED'!
  : ! ON ANY COMPUTER.  THERE ARE ONLY 14 INSTRUCTIONS IN ITS  !
  : ! INSTRUCTION SET, SO NO COMPLEX SEARCHES NEED BE ADOPTED  !
130 ! WHILE EXECUTING THE 'SADSM' PROGRAM.                     !
  : !                                                          !
  : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
140 !                                                          !
150 !     THIS SECTION INITIALIZES THE 1000 CORE MEMBERS GIVEN !
  : ! TO THE SADSM USER.  THE RANDOMIZE OPERATION IS USED TO   !
  : ! PLACE 'GARBAGE' IN THE SADSM MEMORY.  THIS IS DONE TO    !
160 ! PREVENT THE FOLLOWING FROM HAPPENING:                    !
  : !                                                          !
170 !          SUPPOSE A USER INADVERTENTLY FORGETS TO USE A   !
  : !     'HALT' INSTRUCTION IN HIS PROGRAM.  THE SADSM        !
180 !     EMULATOR WILL THEREFORE CONTINUE PICKING UP INSTRUC- !
  : !     TIONS AND EXECUTING THEM.  SINCE THE BASIC-PLUS      !
  : !     LANGUAGE ZERO FILLS ALL VARIABLES BEFORE EXECUTION,  !
190 !     IT WOULD PICK UP A LOCATION WITH ZERO IN IT AND      !
  : !     INTERPRET IT AS AN INPUT INTO LOCATION ZERO.  THE    !
  : !     RANDOMIZE ROUTINE THEREFORE PUTS LARGE AND SMALL NUM-!
200 !     BERS INTO SADSM MEMORY THAT MAY OR MAY NOT BE FOUND  !
  : !     TO BE AN EXECUTABLE INSTRUCTION.                     !
210 !                                                          !
  : ! ONCE SADSM'S MEMORY IS 'GARBAGE' FILLED, THE 'SADSM      !
220 ! EDITOR' ASKES THE USER FOR HIS NAME AND ID (THIS IS FOR  !
  : ! LISTING PURPOSES).                                       !
  : !     THE VARIABLES USED IN THIS SECTION ARE AS FOLLOWS:   !
230 !       M%  -  MACHINE LANGUAGE MEMORY                     !
  : !       M1% -  BACK-UP FOR MACHINE LANGUAGE MEMORY         !
  : !       X$  -  STRING CONTAINING USER NAME AND ID          !
240 !       U%  -  INDEX                                       !
  : !                                                          !
  : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
250 S1$=SYS(CHR$(6%)+CHR$(-7%))
260 ON ERROR GO TO 1780
270 RANDOMIZE
280 INPUT "DO YOU WANT INSTRUCTIONS";X1$
  : IF X1$="YES" THEN GO TO 290
           ELSE IF X1$<>"NO" THEN GO TO 280
                   ELSE GO TO 350
290 PRINT "    AFTER THE SADSM EDITOR ASKS FOR YOUR NAME, IT ASKS"
  : PRINT "FOR YOUR PROGRAM.  FOLLOWING THE QUESTION MARK, TYPE THE"
  : PRINT "INSTRUCTION THEN HIT THE RETURN KEY.  THE FIRST"
300 PRINT "INSTRUCTION MUST BE A 'LOAD' PROGRAM INSTRUCTION.  TYPE"
  : PRINT "IN THE NUMBER OF INSTRUCTIONS INDICATED BY YOUR LOAD"
  : PRINT "INSTRUCTION.  YOU MAY THEN CHANGE, LIST OR RUN YOUR PROGRAM"
310 PRINT "WHEN THE EDITOR ASKS WHAT YOU WISH.  HITTING CONTROL C"
  : PRINT "(CTRL BUTTON AND C BUTTON SIMULTANEOUSLY) BRINGS"
  : PRINT "CONTROL BACK TO THE SADSM EDITOR WHERE AGAIN YOU MAY"

320 PRINT "CHANGE, LIST OR RUN YOUR PROGRAM.  WHEN YOU WISH TO"
  : PRINT "TERMINATE YOUR PROGRAM, AFTER THE QUESTION MARK FOLLOWING"
  : PRINT "'RUN OR LIST' TYPE STOP."
330 PRINT "YOU ARE NOW READY TO PROCEED."
340 DIM M%(1000%),M1%(1000%),Z5%(7%)
350 M%(U%)=INT(RND(0)*100)*100% FOR U%=0% TO 1000%
360 PRINT
  : INPUT "PLEASE TYPE YOUR NAME AND ID "X$
370 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  : !                                                          !
  : !     THIS SECTION ASKS THE USER FOR HIS INITIAL PROGRAM.  !
380 ! THE FIRST INSTRUCTION IS TESTED TO SEE IF IT IS A 'LOAD  !
  : ! PROGRAM INSTRUCTION, THE VARIABLE 'Y1%' IS SET TO        !
  : ! INDICATE THE NUMBER OF INSTRUCTIONS TO BE LOADED INTO    !
390 ! SADSM MEMORY.  A LOOP IS THEN SET UP WITH Y1% AS ITS     !
  : ! INDEX, AND ALL THE SADSM INSTRUCTIONS ARE INPUTTED.      !
  : !     THE VARIABLES USED IN THIS SECTION ARE AS FOLLOWS:   !
400 !       B%  -  INSTRUCTION COUNT                           !
  : !       A%  -  INSTRUCTION INPUTTED                        !
  : !       O1% -  OPCODE OF INSTRUCTION                       !
410 !       Y1% -  NUMBER OF INSTRUCTIONS TO BE 'LOADED'       !
  : !       M%  -  MACHINE LANGUAGE MEMORY                     !
  : !       J%  -  INDEX                                       !
420 !                                                          !
  : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
430 PRINT
  : PRINT "PLEASE TYPE IN YOUR PROGRAM"
440 !
  : !     READ IN LOAD PROGRAM INSTRUCTION
  : !
450 B%=0%
470 GOSUB 1650
  : O1%=A%/1000%
  : IF O1%=20% THEN GO TO 480
       ELSE PRINT "OPCODE MUST BE A LOAD PROGRAM INSTRUCTION"
       : GO TO 470
480 Y1%=A%-(O1%*1000%)
  : M%(0%)=A%
490 !
  : !     FILL MEMORY UNITS 1 THROUGH Y1%
  : !
500 FOR J%=1% TO Y1%
510 B%=B%+1%
  : GO SUB 1650
  : M%(J%)=A%
520 NEXT J%
530 PRINT
  : PRINT "THANK YOU FOR YOUR PROGRAM"
540 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  : !                                                          !
  : !     THIS SECTION ASKS THE USER IF THERE ARE ANY CHANGES  !
550 ! IN HIS PROGRAM.  IF SO A MESSAGE IS PRINTED TO THE USER  !
  : ! SPECIFYING THAT EACH CHANGE MUST BE IN THE FORM ...      !
  : ! LOCATION, INSTRUCTION.                                   !
560 !     A SUBROUTINE IS USED TO INPUT THE NEW INSTRUCTION.   !
  : ! IF THE LOCATION IS GREATER THAN THE LAST INITIAL INSTRUC-!
  : ! TION. AN ERROR MESSAGE IS PRINTED OTHERWISE THE INSTRUC- !
570 ! TION INPUTTED REPLACES THE INSTRUCTION SPECIFIED.  IF THE!
  : ! INSTRUCTION HAPPENS TO BE A LOAD PROGRAM INSTRUCTION, THE!
  : ! SUBROUTINE TRANSFERS TO THE SECTION FOLLOWING THIS ONE.  !
580 !     THE VARIABLES USED IN THIS SECTION ARE AS FOLLOWS:   !
  : !       X1$ - ANSWER TO QUESTION (YES OR NO)               !
  : !       P2% - NUMBER OF INSTRUCTION TO BE ADDED (NOT       !
590 !             SPECIFICALLY USED IN THIS SECTION)           !
  : !       L%  - LOCATION OF INSTRUCTION TO BE REPLACED       !
  : !       B%  - NUMBER OF PRESENT SADSM INSTRUCTIONS         !
600 !       A%  - INSTRUCTION INPUTTED                         !
  : !       M%  - MACHINE LANGUAGE MEMORY                      !
  : !                                                          !
610 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
620 S1$=SYS(CHR$(6%)+CHR$(-7%))
630 ON ERROR GO TO 1780
640 INPUT "ARE THERE ANY CHANGES";X1$
650 IF X1$<>"YES" THEN GO TO 1050
660 PRINT "ALL CHANGES MUST BE IN THE FORM:"
  : PRINT "LOCATION, INSTRUCTION OR CONSTANT"
  : PRINT "(-1, -1 INDICATES END OF CHANGES)"
  : PRINT
670 P2%=0%
680 GO SUB 1710
690 IF L%<=B% THEN GO TO 700
       ELSE PRINT "PROGRAM TOO LARGE FOR LOAD PROGRAM INSTRUCTION"
          : PRINT "READY"
          : PRINT
          : GO TO 680
700 M%(L%)=A%
  : GO TO 680
710 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  : !                                                          !
  : !     THIS SECTION HANDLES THE SUBSTITUTION OF A 'LOAD     !
720 ! PROGRAM' INSTRUCTION.  P% IS SET TO INDICATE THE NUMBER  !
  : ! OF INSTRUCTIONS TO BE LOADED (FROM THE NEW 'LOAD'        !
  : ! INSTRUCTION).  IF P%>Y1% (THE ORIGINAL NUMBER OF INSTRUC-!
730 ! TIONS) THEN P2% IS SET TO INDICATE THE DIFFERENCE BETWEEN!
  : ! Y1% AND P%.  A LOOP IS THEN SET UP TO INPUT P2% NEW      !
  : ! INSTRUCTIONS.  IF ONE OF THE INSTRUCTIONS IS NOT IN      !
740 ! SEQUENCIAL ORDER, THEN AN ERROR IS PRINTED (UNLESS THE   !
  : ! INSTRUCTION IS A SUBSTITUTION).                          !
  : !     IF P%=Y1% THEN THE PROGRAM IGNORES THE NEW INSTRUC-  !
750 ! TION.  HOWEVER IF P%<Y1%  ALL MEMORY LOCATIONS BETWEEN   !
  : ! P% AND Y1% ARE GARBAGE FILLED.                           !
  : !     IN ALL CASES Y1%, B%, AND P2% ARE UPDATED TO COINCIDE!
760 ! WITH THE NEW PROGRAM.                                    !
  : !     THE VARIABLES USED IN THIS SECTION ARE AS FOLLOWS:   !
  : !       P%  -  NUMBER OF INSTRUCTIONS TO BE LOADED INTO    !
770 !              SADSM MEMORY BY THE NEW LOAD PROGRAM INST.  !
  : !       Y1% -  NUMBER OF ORIGINAL SADSM INSTRUCTIONS       !
  : !       P2% -  DIFFERENCE BETWEEN Y1% AND P%, ALSO COUNTER !
780 !              OF NEW INSTRUCTIONS TO BE ADDED             !
  : !       L%  -  LOCATION OF INSTRUCTION                     !
  : !       B%  -  NUMBER OF INSTRUCTIONS (INITIALLY)          !
790 !       M%  -  MACHINE LANGUAGE MEMORY                     !
  : !       A%  -  INSTRUCTION                                 !
  : !       J%  -  INDEX                                       !
800 !       E%  -  INDEX                                       !
  : !                                                          !
  : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
810 P%=A%-(O1%*1000%)
820 IF P%<=Y1% THEN GO TO 910
830 P2%=P2%+(P%-Y1%)
   : Y1%=P%
840 FOR J%=1% TO P2%
850 GO SUB 1710
860 IF L%<=B% THEN GO TO 880
       ELSE IF L%=B%+1% THEN GO TO 870
            ELSE PRINT "INSTRUCTION NOT IN SEQUENCIAL ORDER"
                 : GO TO 850
870 B%=B%+1%
  : M%(L%)=A%
  : GO TO 890
880 M%(L%)=A%
   : GO TO 850
890 NEXT J%
900 GO TO 680
910 IF P%=Y1% THEN GO TO 850
920 FOR E%=P%+1% TO Y1%
930 M%(E%)=INT(RND(0)*100)*100%
940 NEXT E%
950 Y1%,B%=P%
  : GO TO 680
960 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  : !                                                          !
  : !     THIS SECTION TESTS IF THE REPLY TO THE QUESTION:     !
970 ! "ARE THERE ANY CHANGES", IS NO.  IF NOT, IT BRANCHES     !
  : ! TO ASK THE QUESTION AGAIN.                               !
  : !     THIS SECTION THEN ASKS IF THE USER WISHES TO LIST OR !
980 ! RUN HIS PROGRAM.  A USER MAY TERMINATE HIS PROGRAM BY    !
  : ! TYPING STOP.  IF THE REPLY IS 'LIST', A PROGRAM LISTING  !
  : ! IS PRESENTED TO THE USER WITH HIS NAME AND ID AS A       !
990 ! HEADER.  IF THE REPLY IS 'RUN' A SMALL ROUTINE IS FIRST  !
  : ! UTILIZED TO SAVE THE INSTRUCTION SET.  THIS IS DONE TO   !
  : ! PREVENT THE USER FROM DESTROYING HIS INITIAL SET OF      !
1000! INSTRUCTIONS (IN CASE THE PROGRAM MAY HAVE 'BUGS' IN IT).!
  : !     THE VARIABLES IN THIS SECTION ARE AS FOLLOWS:        !
  : !       X1$ -  REPLY OF 'YES' OR NO'                       !
1010!              'RUN', 'LIST', OR 'STOP'                    !
  : !       X$  -  NAME AND ID OF USER (FOR LISTING)           !
  : !       B%  -  NUMBER OF INSTRUCTIONS                      !
1020!       J%  -  INDEX AND LOCATION OF INSTRUCTION           !
  : !       M%  -  MACHINE LANGUAGE MEMORY                     !
  : !       U%  -  INDEX                                       !
1030!       I%  -  MENORY LOCATION                             !
  : !                                                          !
  : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
1050 IF X1$<>"NO" THEN GO TO 620
       ELSE PRINT "READY"
          : PRINT
          : INPUT "RUN OR LIST";X1$
1060 IF X1$<>"LIST" THEN GO TO 1190
1070 !
1080 !    THIS SECTION LISTS A SADSM PROGRAM
1090 !
1100 PRINT
   : PRINT
   : PRINT X$
   : PRINT
1110 FOR J%=0% TO Y1%
1120 Z1$=NUM$(J%)
   : Z2$=NUM$(M%(J%))
   : Z1%=LEN(Z1$)
   : Z2%=LEN(Z2$)
   : A1%=7%-Z1%
   : A2%=7%-Z2%
   : Z1$=SPACE$(A1%)+Z1$
   : Z2$=SPACE$(A2%)+Z2$
1130 CHANGE Z2$ TO Z5%
1140 FOR U%=2% TO 7%
1150 IF Z5%(U%)<>32% THEN GO TO 1160
        ELSE Z5%(U%)=48%
           : NEXT U%
1160 IF Z5%(U%)<>45% THEN Z3$="+"
     ELSE Z5%(U%)=48%: Z3$="-"
1165 CHANGE Z5% TO Z2$
   : Z2$=Z3$+Z2$
   : PRINT Z1$,Z2$
1170 NEXT J%
1180 GO TO 620
1190 IF X1$="RUN" THEN GO TO 1210
     ELSE IF X1$<>"STOP" THEN GO TO 620
            ELSE PRINT
               : PRINT "PROGRAM TERMINATION"
               : PRINT FOR U%=1% TO 8%
               : GO TO 1830
1200 !
   : !     THIS SECTION BEGINS EXECUTION OF A SADSM PROGRAM
   : !
1210 M1%(U%)=M%(U%) FOR U%=0% TO Y1%
1220 I%=1%
1230 GO SUB 1250
  : GO SUB 1270
  : GO TO 1230
1240 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  :  !                                                           !
  :  !     THIS SUBROUTINE FETCHES AND DECODES ONE INSTRUCTION   !
1245 !                                                           !
  :  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
1250 C%=INT(M%(I%)/1000%)
   : V%=M%(I%)-(1000%*C%)
   : I%=I%+1%
   : RETURN
1260 !
   : !     THIS SUBROUTINE EXECUTES ONE SADSM INSTRUCTION
   : !
1270 IF C%=0% THEN GO TO 1330
      ELSE IF C%=1% THEN GO TO 1400
         ELSE IF C%=9% THEN GO TO 1420
            ELSE IF C%=10% THEN GO TO 1440
1280 IF C%=11% THEN GO TO 1460
      ELSE IF C%=12% THEN GO TO 1480
         ELSE IF C%=13% THEN GO TO 1500
            ELSE IF C%=14% THEN GO TO 1530
1290 IF C%=15% THEN GO TO 1550
      ELSE IF C%=16% THEN GO TO 1570
         ELSE IF C%=17% THEN GO TO 1590
            ELSE IF C%=18% THEN GO TO 1610
               ELSE IF C%=19% THEN GO TO 1630
1300 !
   : !     IF NO INSTRUCTION HAS BEEN DISCOVERED
   : !
1310 PRINT "OPCODE ERROR AT LOCATION";I%-1%
   : GO TO 1500
1320 !
   : !     OPCODE IS TO INPUT ONE VALUE INTO LOCATION V%
   : !
1330 ON ERROR GO TO 1350
1340 INPUT "INPUT ONE VALUE";M%(V%)
   : RETURN
1350 S1$=SYS(CHR$(0%))
1360 IF ERR<>28 THEN S1$=SYS(CHR$(6%)+CHR$(-7%))
        : PRINT "ILLEGAL NUMBER"
        : PRINT "READY"
        : PRINT
        : RESUME 1330
1370 S1$=SYS(CHR$(6%)+CHR$(-7%))
   : RESUME 620
1390 !
   : !     OPCODE IS TO STORE CONTENTS OF ACC IN ADDRESS V%
   : !
1400 M%(V%)=A%
   : RETURN
1410 !
   : !     OPCODE IS UNCONDITIONAL TRANSFER TO INSTR. AT ADDRESS V%
   : !
1420 I%=V%
   : RETURN
1430 !
   : !     OPCODE IS CONDITIONAL TRANSFER IF ACC IS NEGATIVE
   : !
1440 IF A%<0% THEN GO TO 1420
               ELSE RETURN
1450 !
   : !     OPCODE IS CONDITIONAL TRANSFER IF ACC IS ZERO
   : !
1460 IF A%=0% THEN GO TO 1420
               ELSE RETURN
1470 !
   : !     OPCODE IS CONDITIONAL TRANSFER IF ACC IS POSITIVE
   : !
1480 IF A%>0% THEN GO TO 1420
               ELSE RETURN
1490 !
   : !     OPCODE IS HALT
   : !
1500 M%(U%)=M1%(U%) FOR U%=0% TO Y1%
1510 PRINT
   : PRINT "READY"
   : PRINT
   : GO TO 620
1520 !
   : !     OPCODE IS PRINT CONTENTS OF MEMORY UNIT ADDRESS V%
   : !
1530 PRINT M%(V%)
   : RETURN
1540 !
   : !     OPCODE IS TO PLACE CONTENTS OF ADDRESS V% INTO ACC
   : !
1550 A%=M%(V%)
   : RETURN
1560 !
   : !     OPCODE IS TO ADD V% TO ACC
   : !
1570 A%=A%+M%(V%)
   : RETURN
1580 !
   : !     OPCODE IS TO SUBTRACT V% FROM ACC
   : !
1590 A%=A%-M%(V%)
   : RETURN
1600 !
   : !     OPCODE IS TO MULTIPLY ACC BY V%
   : !
1610 A%=A%*M%(V%)
   : RETURN
1620 !
   : !     OPCODE IS TO DIVIDE ACC BY V%
   : !
1630 A%=A%/M%(V%)
   : RETURN
1640 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  :  !                                                           !
  :  !     THIS SUBROUTINE READS ONE SADSM INSTRUCTION           !
1645 !                                                           !
  :  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
1650 ON ERROR GO TO 1680
1660 INPUT A%
1670 RETURN
1680 S1$=SYS(CHR$(0%))
   : IF ERR=28 THEN RESUME 620
        ELSE PRINT "SYNTAX ERROR": PRINT "READY": PRINT: RESUME 1650
1690 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  :  !                                                           !
  :  !     THIS SUBROUTINE READS ONE NEW SADSM INSTRUCTION AND   !
1695 ! TESTS IT IF IT IS A 'LOAD PROGRAM' INSTRUCTION.  IF SO    !
  :  ! IT TRANSFERS TO THAT PART OF THE MAIN-LINE THAT HANDLES   !
  :  ! IT.                                                       !
1697 !                                                           !
  :  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
1710 ON ERROR GO TO 1780
1715 S1$=SYS(CHR$(6%)+CHR$(-7%))
1720 INPUT L%,A%
1730 O1%=A%/1000%
1740 IF L%<>0% AND O1%<>20% THEN GO TO 1770
1750 IF L%=0% AND O1%<>20% THEN GO TO 1760
        ELSE M%(0%)=A%
           : GO TO 810
1760 PRINT "LOCATION MUST BE 0 FOR LOAD PROGRAM INSTRUCTION"
   : GO TO 1720
1770 IF L%=-1% AND A%=-1% THEN GO TO 620
      ELSE IF L%>0% THEN RETURN
1780 S1$=SYS(CHR$(0%))
   : IF ERR=28 THEN RESUME 620
1790 PRINT "SYNTAX ERROR"
   : PRINT "READY"
   : PRINT
   : RESUME 1710
1830 END

Ready

