3 REM      GSTKVL: STOCK VALUATION
8 REM D. NIEBUHR, OCT. L969
9 REM -- SPONSOR: PROF. MCDONALD
10 REM THIS PROGRAM COMPUTES A MATRIX OF PRESENT VALUES OF
12 REM DIVIDENDS AND A TERMINAL STOCK PRICE GIVEN CURRENT EPS,
14 REM PROJECTED GROWTH RATES FOR EPS, PROJECTED PAYOUT RATIOS,
16 REM AND A RANGE OF TERMINAL P/E RATIOS.
40 REM D(I)=DIVIDEND IN PERIOD I
41 REM N =NUMBER OF GROWTH SEGMENTS
43 REM B(I)=BEGINNING PERIOD OF SEGMENT I
45 REM E(I)=EPS
46 REM Q=INDICATOR FOR RERUN OPTIONS (SEE LINE 310)
47 REM X(I)=PAYOUT RATIO IN SEG, I
50 DIM D(100),X(100),E(100)
51 MAT D=ZER
55 DIM L(20),B(20),G(20)
60 Q=0
80 IF Q=1 THEN 110
84 REM LINES 85-170 ARE DATA INPUT
85 PRINT
90 PRINT'CURRENT EARNINGS/SHARE';
100 INPUT E1
105 IF Q=2 THEN 195
107 PRINT
110 INPUT 'ENTER THE NUMBER OF TIME SEGMENTS';N
111 PRINT'ENTER, THE GROWTH RATE IN DIVIDENDS PER SHARE'
112 PRINT'THEN THE PAYOUT RATIO FOLLOWED BY THE FINAL PERIOD OF THE SEGMENT'
113 PRINT'ALL ARE SEPARATED BY COMMAS, FOR EACH PERIOD.'
114 FOR I=1 TO N
115 PRINT'PERIOD';I
116 INPUT G(I),X(I),L(I)
117 NEXT I
119 PRINT
120 PRINT'GROWTH RATES --'
140 FOR I=1 TO N
160 PRINT '    PERIOD';I;G(I)
170 NEXT I
175 PRINT
176 PRINT
180 E(1)=E1*(1+G(1))
195 B(1)=1
200 FOR I=1 TO N
210 FOR J=B(I) TO L(I)
220 E(J+1)=E(J)*(1+G(I))
225 D(J+1)=X(I)*E(J+1)
230 NEXT J
235 B(I+1)=L(I)+1
250 NEXT I
260 GOSUB 500
300 PRINT'CODES FOR NEXT TASK:'
301 PRINT'	0: ALL NEW DATA'
302 PRINT'	1: SAME CURRENT EPS, NEW PROJECTIONS'
303 PRINT'	2: NEW EPS, SAME PROGECTIONS'
304 PRINT'	3: STOP'
305 PRINT'NEXT TASK';
335 INPUT Q
340 PRINT
350 IF Q=3 THEN 9999
360 GOTO 80
499 REM STMTS. 500-730 COMPUTE MATRIX OF PVS
500 PRINT'RANGE OF TERMINAL P/E RATIOS --'
501 PRINT '  LOW';
502 INPUT R1
503 PRINT'  HIGH';
504 INPUT R2
520 R3=(R2-R1)/3
530 PRINT'RANGE OF RETURNS DESIRED (DECIMAL) --'
531 PRINT'  LOW';
532 INPUT D1
533 PRINT'  HIGH';
534 INPUT D2
545 PRINT
547 PRINT ' ',' ---------- P/E RATIO ----------------------------'
550 PRINT '  RETURN',R1,R1+R3,R1+2*R3,R1+3*R3
560 FOR I1=D1 TO D2 STEP (D2-D1)/4
570 PRINT I1,
580 P3=0
590 F1=1
600 FOR I=1 TO L(N)
610 F1=F1/(1+I1)
620 P3=P3+F1*D(I)
630 NEXT I
640 FOR I2=R1 TO R2 STEP R3
650 P2=I2*E(L(N))
670 P=P3+(P2+D(L(N)+1))*F1
671 PRINT P,
680 NEXT I2
700 NEXT I1
710 PRINT
730 RETURN
900 PRINT
902 PRINT'EACH CASE REQUIRES THE FOLLOWING DAT --'
904 PRINT'   THE NUMBER OF SEGMENTS'
906 PRINT'   THEN, FOR EACH SEGMENT --'
908 PRINT'        THE GROWTH RATE IN DIVIDENDS PER SHARE'
910 PRINT'        PAYOUT RATIO'
912 PRINT'        FINAL PERIOD OF THE SEGMENT'
914 PRINT
916 PRINT'ENTER DATA STATEMENTS BEGINNING AT LINE 1000'
918 PRINT'FOR MULTIPLE RUNS, SIMPLY PROVIDE ADDITIONAL SETS OF DATA'
920 PRINT'AFTER DATA STATEMENTS HAVE BEEN ENTERED, RE-RUN THE PROGRAM.'
9999 END
