3 REM      GSSS:  SMALL SYSTEMS SIMULATOR
5 REM	CONVERTED FOR BASIC-PLUS BY DSAA
9 RANDOMIZE
10 OPEN'DATA.DAT'AS FILE 1%:DIM#1%,B(50,6),F(50,6),E(100,3)
12 REM -- B IS BLOCK TABLE
13 REM -- F IS FACILITY TABLES
14 REM --E IS EVENT TALBE
15 REM -- I9 IS THE TOTAL NUMBER OF EVENTS TO BE DESTROYED
16 REM -- T9 IS THE CLOCK
17 REM -- E9 IS THE NUMBER OF ROWS IS THE EVENT TABLE
18 E9=100
20 REM -----------------------------------------------------
30 REM -- PROGRAM NAME:  SSS (SMALL SYSTEMS SIMULATOR)
31 REM -- SPONSOR:  PROF. SHARPE
32 REM -- PROGRAMMER: W.F. SHARPE (FEB., 1971)
34 REM -- FILES:  NONE
40 REM -----------------------------------------------------
100 REM -- MAIN ROUTINE
110 REM -- INITIALIZE TABLES
111 GOSUB 400
120 REM -- READ INPUTS FROM DATA STATEMENTS
121 GOSUB 500
140 REM -- CHAIN TO SIMULATION ROUTINE
141 GOTO 1000
400 REM ---------------------------------------------------
405 REM -- SUBROUTINE TO INITIALIZE BLOCK, FACILITY AND EVENT TBLS
410 REM -- INITIALIZE BLOCK TABLE
415 MAT B=ZER
416 MAT E=ZER
430 REM -- INITIALIZE FACITLITY TABLE
432 FOR I=1 TO 50
434 F(I,1)=1
436 FOR J=2 TO 6
438 F(I,J)=0
440 NEXT J
442 NEXT I
450 REM -- PUT ALL EVENTS ON THE FREE LIST
452 FOR I=1 TO E9-1
454 E(I,2)=I+1
456 NEXT I
458 E(E9,2)=0
460 E1=1
462 REM -- SET TIME-SEQUENCE LIST TO EMPTY
463 E2=0
470 REM -- SET TIME CLOCK TO ZERO
472 T9=0
475 REM -- SET DEFAULT NUMBER OF ITEMS
476 I9=1000
495 REM -- INITIALIZATION COMPLETE
496 RETURN
500 REM ----------------------------------------------------------
505 REM -- SUBROUTINE TO READ INPUTS
510 REM -- FORMAT IS ANY OF THE FOLLOWING
511 REM BLK#,'CREATE',MEAN,SPREAD,NEXT BLOCK
512 REM BLK #,'DESTROY'
513 REM BLK#,'BRANCH',PPOB,NEXT BLK (P),NEXT BLK (1-P)
514 REM BLK#,'ENTER',FACILITY,MAX WAIT,NEXT BLOCK,ALT BLOCK
515 REM BLK#,'LEAVE',FACILITY,NEXT BLOCK
516 REM BLK#,'ADVANCE',MEAN,SPREAD,NEXT BLOCK
517 REM FACILITY #,'FACILITY',CAPACITY
518 REM NUMBER OF ITEMS, 'ITEMS'
519 REM 100, 'NO MORE'
532 PRINT'SYSTEM DESCRIPTION'
533 PRINT'------ -----------'
534 PRINT
540 READ I,A$
541 IF MID(A$,1,1)='N' THEN 680
542 PRINT I;A$;TAB(15);
550 IF MID(A$,1,1)='A' THEN 600
551 IF MID(A$,1,1)='B' THEN 610
552 IF MID(A$,1,1)='C' THEN 620
553 IF MID(A$,1,1)='D' THEN 630
554 IF MID(A$,1,1)='E' THEN 640
555 IF MID(A$,1,1)='F' THEN 650
556 IF MID(A$,1,1)='I' THEN 660
557 IF MID(A$,1,1)='L' THEN 670 
559 PRINT' ** IGMORE -- ILLEGAL BLOCK TYPE'
560 GOTO 540
600 REM -- ADVANCE
601 READ B(I,2),B(I,3),B(I,4)
602 PRINT B(I,2);B(I,3);B(I,4)
603 B(I,1)=6
604 GOTO 540
610 REM -- BRANCH
611 READ B(I,2),B(I,4),X9
612 PRINT B(I,2);'  ';B(I,4);X9
613 B(I,4)=B(I,4)+(X9/100)
614 B(I,1)=3
615 GOTO 540
620 REM -- CREATE
621 READ B(I,2),B(I,3),B(I,4)
622 PRINT B(I,2);B(I,3);B(I,4)
623 B(I,1)=1
624 GOTO 540
630 REM -- DESTROY
631 PRINT
633 B(I,1)=2
634 GOTO 540
640 REM -- ENTER
641 READ B(I,2),B(I,3),B(I,4),X9
642 PRINT B(I,2);B(I,3);B(I,4);X9
643 B(I,4)=B(I,4)+(X9/100)
644 B(I,1)=4
645 GOTO 540
650 REM -- FACILITY
651 READ X9
652 PRINT X9
653 F(I,1)=X9
654 GOTO 540
660 REM -- ITEMS
661 I9=I
662 PRINT
664 GOTO 540
670 REM -- NO MORE
671 READ B(I,2),B(I,4)
672 PRINT B(I,2);B(I,4)
673 B(I,1)=5
674 GOTO 540
680 REM -- NO MORE --
681 PRINT
682 PRINT'-------------------------'
683 PRINT
684 RETURN
1000 REM -- DO SIMULATION
1005 REM
1010 REM -- PROGRAM: SSS1
1015 REM -- CHAINED FROM SSS
1020 REM
1025 REM -- MAIN ROUTINE
1030 REM -- SCHEDULE INITIAL CREATIOONS
1035 GOSUB 1185
1040 REM -- GET NEXT EVENT FROM EVENT LIST
1045 GOSUB 1225
1050 REM -- PROCESS DEPARTURE
1055 GOSUB 1385
1060 REM -- PROCESS UNTIL A DELAY OR DESTROY IS REACHED
1065 GOSUB 1590
1070 REM -- CHECK FOR COPLETION
1075 IF I9>0 THEN 1090
1080 REM -- DONE
1085 GOTO 3000
1090 REM -- CHECK FACILITIES
1095 FOR F9=1 TO 50
1100 IF (F(F9,2)<F(F9,1)) AND (F(F9,5)<>0) THEN 1120
1105 NEXT F9
1110 REM -- NOTHING CAN ENTER A FACILTY
1115 GOTO 1040
1120 REM -- FACILITY F9 IS FREE, GET EVENT
1125 E5=F(F9,5)
1130 IF E2<>E5 THEN 1145
1135 GOSUB 1260
1140 GOTO 1050
1145 E3=E2
1150 IF E(E3,2)=E5 THEN 1165
1155 E3=E(E3,2)
1160 GOTO 1150
1165 E(E3,2)=E(E5,2)
1170 GOSUB 1265
1175 GOTO 1050
1180 REM
1185 REM
1190 REM -- SUBROUTINE TO SCHEDULE INITIAL CREATIONS
1195 FOR B9=1 TO 50
1200 IF B(B9,1)<>1 THEN 1215
1205 GOSUB 1805
1210 GOSUB 1865
1215 NEXT B9
1220 RETURN
1225 REM
1230 REM -- SOUBOUTINE TO GET NEXT EVENT FROM TIMED LIST
1235 IF E2<>0 THEN 1250
1240 PRINT'NO MORE SCHEDULED EVENTS'
1245 GOTO 3000
1250 E5=E2
1255 T9=E(E5,1)
1260 E2=E(E5,2)
1265 B9=100*(E(E5,3)-INT(E(E5,3))+.001)
1270 B9=INT(B9)
1275 E(E5,2)=E1
1280 E1=E5
1285 IF B(B9,1)=4 THEN 1295
1290 RETURN
1295 REM -- RESTORE FACILITY LIST
1300 F9=B(B9,2)
1305 IF F(F9,5)<>E5 THEN 1330
1310 F(F9,5)=INT(E(E5,3))
1315 IF F(F9,6)<>E5 THEN 1325
1320 F(F9,6)=F(F9,5)
1325 RETURN
1330 E3=F(F9,5)
1335 E4=INT(E(E3,3))
1340 IF E4<>E5 THEN 1375
1345 REM -- EVENT FOUND
1350 E(E3,3)=(E(E3,3)-INT(E(E3,3)))+INT(E(E4,3))
1355 IF INT(E(E3,3))=0 THEN 1365
1360 RETURN
1365 F(F9,6)=E3
1370 RETURN
1375 E3=E4
1380 GOTO 1335
1385 REM
1390 REM -- SUBROUTINE TO HANDLE DEPARTURE FROM BLOCK B9
1395 B(B9,6)=B(B9,6)+1
1400 ON B(B9,1) GOTO 1405,1430,1440,1475,1540,1575
1405 REM -- CREATE
1410 GOSUB 1805
1415 GOSUB 1865
1420 B9=B(B9,4)
1425 RETURN
1430 REM -- DESTROY  (NOT USED)
1435 RETURN
1440 REM -- BRANCH
1445 IF RND(1)>B(B9,2) THEN 1460
1450 B9=INT(B(B9,4))
1455 RETURN
1460 B9=100*(B(B9,4)-INT(B(B9,4))+.001)
1465 B9=INT(B9)
1470 RETURN
1475 REM -- ENTER
1480 IF E(E5,1)=T9 THEN 1520
1485 REM -- ENTERING FACILITY
1490 F9=B(B9,2)
1495 F(F9,4)=F(F9,4)+((T9-F(F9,3))*F(F9,2))
1500 F(F9,2)=F(F9,2)+1
1505 F(F9,3)=T9
1510 B9=INT(B(B9,4))
1515 RETURN
1520 REM -- GOING OUT ALTERNATE ROUTE
1525 B9=100*(B(B9,4)-INT(B(B9,4))+.001)
1530 B9=INT(B9)
1535 RETURN
1540 REM -- LEAVE
1545 F9=B(B9,2)
1550 F(F9,4)=F(F9,4)+((T9-F(F9,3))*F(F9,2))
1555 F(F9,2)=F(F9,2)-1
1560 B9=B(B9,4)
1565 F(F9,3)=T9
1570 RETURN
1575 REM -- ADVANCE
1580 B9=B(B9,4)
1585 RETURN
1590 REM
1595 REM -- SUBROUTINE TO HANDLE ENTRIES UP TO A DELAY OR DESTROY
1600 B(B9,5)=B(B9,5)+1
1603 IF B(B9,1)=0 THEN 1800
1605 ON B(B9,1) GOTO 1610,1620,1635,1650,1770,1785
1610 REM -- CREATE (NOT LEGAL HERE)
1615 RETURN
1620 REM -- DESTROY
1625 I9=I9-1
1630 RETURN
1635 REM -- BRANCH
1640 GOSUB 1385
1645 GOTO 1600
1650 REM -- ENTER
1655 F9=B(B9,2)
1660 IF F(F9,2)<F(F9,1) THEN 1735
1665 REM -- FACILITY FULL
1670 T1=T9+B(B9,3)
1675 GOSUB 1865
1680 REM -- LINK IN FACILITY LIST
1685 IF F(F9,5)=0 THEN 1715
1690 REM -- ADD TO END OF LIST
1695 E4=F(F9,6)
1700 E(E4,3)=(E(E4,3)-INT(E(E4,3)))+E5
1705 F(F9,6)=E5
1710 RETURN
1715 REM -- ADD TO TOP OF EMPTY LIST
1720 F(F9,5)=E5
1725 F(F9,6)=E5
1730 RETURN
1735 REM -- FACILITY NOT FULL, ENTER IT
1740 F(F9,4)=F(F9,4)+((T9-F(F9,3))*F(F9,2))
1745 F(F9,2)=F(F9,2)+1
1750 F(F9,3)=T9
1755 B(B9,6)=B(B9,6)+1
1760 B9=INT(B(B9,4))
1765 GOTO 1600
1770 REM -- LEAVE
1775 GOSUB 1385
1780 GOTO 1600
1785 REM -- ADVANCE
1790 GOSUB 1805
1795 GOSUB 1865
1800 RETURN
1805 REM
1810 REM -- SUBROUTINE TO CALCULATE EXIT TIME
1815 IF B(B9,2)<0 THEN 1845
1820 T1=T9+(B(B9,2)-B(B9,3))+(2*B(B9,3)*RND(1))
1825 IF T1<T9 THEN 1835
1830 RETURN
1835 T1=T9
1840 RETURN
1845 X9=RND(1)
1850 X9=SQR(-LOG(RND(1)))*(COS(6.28318*X9)+SIN(6.28315*X9))
1855 T1=T9+ABS(B(B9,2))+(X9*B(B9,3))
1860 GOTO 1825
1865 REM
1870 REM -- SUBROUTINE TO SCHEDULE AN EVENT FOR BLOCK
1875 REM    B9 AT TIME T1
1880 IF E1<>0 THEN 1900
1885 PRINT'SIMULATION STOPPED -- TOO MANY ITEMS IN SYSTEM'
1890 PRINT
1895 GOTO 3000
1900 E5=E1
1905 REM -- RESET FREE LIST
1910 E1=E(E1,2)
1915 REM -- INSET TIME AND BLOCK NUMBER
1920 E(E5,1)=T1
1925 E(E5,3)=B9/100
1930 REM -- LINK  IN TIME-SEQUENCE LIST
1935 IF E2=0 THEN 1950
1940 IF E(E2,1)>T1 THEN 1950
1945 GOTO 1970
1950 REM -- INSET FIRST IN  LIST
1955 E(E5,2)=E2
1960 E2=E5
1965 RETURN
1970 REM -- INSET LATER IN LIST
1975 E3=E2
1980 E4=E(E3,2)
1985 IF E4=0 THEN 2010
1990  IF E(E4,1)>T1 THEN 2010
1995 REM -- KEEP GGOIN
2000 E3=E4
2005 GOTO 1980
2010 REM -- INSET AFTER E3
2015 E(E5,2)=E4
2020 E(E3,2)=E5
2025 RETURN
3000 PRINT
3005 PRINT'SIMULATION RESULTS'
3010 PRINT '--------------------------------'
3015 PRINT
3020 PRINT'BLOCK #','# ENTERED','# LEFT','# REMAINING'
3025  PRINT'-------','---------','------','-----------'
3030 FOR I=1 TO 50
3035 IF B(I,1)=0 THEN 3085
3040 IF B(I,1)=1 THEN 3060
3045 IF B(I,1)=2 THEN 3075
3050 PRINTI,B(I,5),B(I,6),B(I,5)-B(I,6)
3055 GOTO 3085
3060 REM -- CREATE
3065 PRINT I,' ',B(I,6)
3070 GOTO 3085
3075 REM -- DESTROY
3080 PRINT I,B(I,5)
3085 NEXT I
3090 PRINT
3095 PRINT ' ',' ','CURRENT # OF','AVERAGE # OF'
3100 PRINT'FACILITY #','CAPACITY','OCCUPANTS','OCCUPANTS'
3105 PRINT'----------','--------','---------','---------'
3110 FOR I=1 TO 50
3115 IF F(I,3)=0 THEN 3135
3120 REM -- UPDATE TOTAL
3125 F(I,4)=F(I,4)+(F(I,2)*(T9-F(I,3)))
3130 PRINT I,F(I,1),F(I,2),F(I,4)/T9
3135 NEXT I
3140 PRINT
3145 PRINT'SIMULATED TIME = ';T9
3150 PRINT '-----------------------------------'
3155 PRINT
3160 GOTO 9999
9000 DATA 1,'CREATE',5,2,2
9001 DATA 2,'BRANCH',.3,3,4
9002 DATA 3,'ADVANCE',6,3,5
9003 DATA 4,'ADVANCE',15,5,6
9004 DATA 5,'ENTER',1,10,7,13
9005 DATA 6,'ENTER',1,15,8,14
9006 DATA 7,'ADVANCE',3,1,9
9007 DATA 8,'ADVANCE',7,2,10
9008 DATA 9,'LEAVE',1,11
9009 DATA 10,'LEAVE',1,12
9010 DATA 12,'DESTROY'
9011 DATA 12,'DESTROY'
9012 DATA 13,'DESTROY'
9013 DATA 14,'DESTROY'
9014 DATA 1,'FACILITY',2
9015 DATA 50,'ITEMS'
9998 DATA 100,'NO MORE'
9999 CLOSE 1%:KILL'DATA.DAT':END
