9000 REM ***** LESSEE ***** BUSINESS PROGRAM
9002 REM LESSEE *********** VERSION #1 (7/31/69)******LEASE/PURCHASE ANALYSIS
9004 REM THIS PROGRAM COMPARES A LEASE WITH PURCHASE OF EQUIPMENT, USING
9006 REM THE BOWER-WILLAIMSON METHOD OF ANALYSIS.  THE EQUIPMENT IS DE-
9008 REM PRECIATED WITH SUM-OF-THE-YEARS-DIGITS, AND THE APPROPRIATE IN-
9010 REM VESTMENT TAX CREDIT IS TAKEN, FOR THE PURCHASE ALTERNATIVE.
9012 REM
9014 REM VALUES ARE REQUIRED FOR THE FOLOWING VARIABLES:
9016 REM
9018 REM 1.  P   = THE PURCHASE PRICE OF THE EQUIPMENT
9020 REM 2.  T   = THE LESSEE'S INCOME TAX RATE
9022 REM 3.  R1  = THE INTEREST RATE ON A LOAN, COMPOUNDED SEMI-ANNUALLY
9024 REM 4.  R2  = THE OPPORTUNITY RATE THAT CAN BE EARNED, AFTER TAXES, ON
9026 REM           NEW INVESTMENTS, COMPOUNDED SEMI-ANNUALLY
9028 REM 5.  M   = THE MONTHLY RENT, PAYABLE IN ADVANCE
9030 REM 6.  L   = THE DEPRECIABLE LIFE IN YEARS
9032 REM 7.  S1  = THE SALVAGE VALUE FOR TAX PURPOSES
9034 REM 8.  S2  = EXPECTED ACTUAL SALVAGE VALUE, MUST BE LESS THAN P
9036 REM 9.  E1  = EXPENSES OF MAKING THE LEASE AGREEMENT
9038 REM 10. E2  = ANNUAL SAVING IN EXPENSES DUE TO THE LEASE
9040 REM 11. Y   = THE LENGTH OF THE LEASE IN YEARS
9042 REM 12. J   = THE LENGTH OF THE BASIC RENTAL PERIOD
9044 REM 13. Z   = 0 IF NO INVESTMENT TAX CREDIT IS TAKEN, OTHERWISE 1
9046 REM 14. X   = THE NUMBER OF THE VARIABLE FOR WHICH A SENSITIVITY ANALYSIS
9048 REM           IS TO BE DONE; 0 IF NO ANALYSIS; 1 IF ON PURCHASE PRICE,
9050 REM           2 IF ON INCOME TAX RATE, ETC.
9052 REM 15. X1  = THE LOWEST VALUE FOR THE VARIABLE SPECIFIED IN14.
9054 REM 16. X2  = THE HIGHEST VALUE OF THE VARIABLE SPECIFIED IN 14.
9056 REM
9058 REM
9060 PRINT '*  LEASE/PURCHASE ANALYSIS  *'
9062 PRINT
9064 PRINT 'HAS YOUR DATA ALREADY BEEN ENTERED';
9066 INPUT N$
9068 IF N$='YES' THEN 9082
9071 PRINT
9072 PRINT 'THEN DO SO NOW BEGINNING IN LINE 9900. DATA SPECIFICATIONS CAN BE'
9074 PRINT 'LISTED BY TYPING "LIST-9014".'
9076 PRINT 'VALUES FOR P,T1,R1,R2,M,L,S1,S2,E1,E2,Y,J,Z,X,X1,X2 MUST BE ENTERED,'
9078 PRINT 'AND IN THAT ORDER.'
9080 GOTO 9999
9082 READ P,T,R1,R2,M,L,S1,S2,E1,E2,Y,J,Z
9084 READ X,X1,X2
9088 F9=0
9090 PRINT
9092 IF X=0 THEN 9102
9094 PRINT 'DO YOU WANT THE SENSITIVITY ANALYSIS ONLY';
9096 INPUT N$
9098 PRINT
9100 IF N$='YES' THEN 9128
9102 GOSUB 9158
9104 PRINT
9106 PRINT 'DO YOU WANT TO SEE THE FLOWS';
9108 INPUT N$
9110 PRINT
9112 IF N$='YES' THEN 9118
9114 F9=-1
9116 GOTO 9120
9118 GOSUB 9224
9120 GOSUB 9238
9122 PRINT
9124 GOSUB 9441
9126 IF X=0 THEN 9999
9128 PRINT '         SENSITIVITY ANALYSIS ON ';
9130 GOSUB 9354
9132 PRINT
9134 GOSUB 9354
9136 PRINT TAB(30)'NET ADVANTAGE OF LEASE'
9138 FOR F8=0 TO 10
9140 F9=-1
9142 RESTORE
9144 READ P,T,R1,R2,M,L,S1,S2,E1,E2,Y,J,Z,X,X1,X2
9146 GOSUB 9366
9148 GOSUB 9200
9150 GOSUB 9238
9152 PRINT TAB(30);A1+V2
9153 NEXT F8
9154 PRINT
9155 PRINT '************************************************************'
9156 GOTO 9999
9158 PRINT
9160 PRINT '************************************************************'
9162 PRINT
9164 PRINT '        *COMPARISON OF LEASE WITH PURCHASE*'
9166 PRINT
9168 PRINT 'PURCHASE PRICE $';P
9170 PRINT 'TAX RATE';T
9172 PRINT 'INTEREST RATE';R1
9174 PRINT 'OPPORTUNITY RATE';R2
9176 PRINT 'MONTHLY RENT $';M
9178 PRINT 'DEPRECIABLE LIFE';L;'YEARS'
9180 PRINT 'SALVAGE FOR TAX $';S1
9182 PRINT 'EXPECTED SALVAGE $';S2
9184 PRINT 'EXPENSE OF ARRANGING LEASE $';E1
9186 PRINT 'ANNUAL EXPENSE SAVING DUE TO LEASE $';E2
9188 PRINT 'LEASE LENGTH';Y;'YEARS'
9190 PRINT 'BASIC RENTAL PERIOD';J;'YEARS'
9192 IF X=0 THEN 9200
9194 PRINT 'SENSITIVITY ANALYSIS ON ';
9196 GOSUB 9354
9198 PRINT ' WITH A RANGE OF';X1;'TO';X2
9200 IF Z=0 THEN 9214
9202 C1=.07*P
9204 IF L>7 THEN 9216
9206 C1=(2/3)*C1
9208 IF L>5 THEN 9216
9210 C1=(1/3)*C1
9212 IF L>3 THEN 9216
9214 C1=0
9216 IF F9=-1 THEN 9222
9218 PRINT 'INVESTMENT TAX CREDIT TO BE TAKEN $';C1
9220 PRINT
9222 RETURN
9224 PRINT
9226 PRINT TAB(50)'BASIC'
9228 PRINT TAB(40)"OP'G FLO"TAB(50)'CASH FLO'TAB(60)'BASIC'
9230 PRINT TAB(40)"DIFF'CE"TAB(50)'SAVING'TAB(60)'CASH FLOW'
9231 PRINT 'YEAR';TAB(9);'PAYMENT';TAB(20);'DEPR';
9232 PRINT TAB(30)'LOAN'TAB(40)'WITH'TAB(50)'WITH'TAB(60)'DISC.AT'
9234 PRINT
9236 RETURN
9238 R4=(1+R1/2)^(1/6)-1
9240 P1=(M/R4)*(1+R4-(1/(1+R4)^(12*J-1)))
9242 A1=P-P1
9244 IF J=0 THEN 9248
9246 B2=M*P/P1
9248 P2=P
9250 D1=0
9252 V2=0
9254 M1=12*M
9256 I1,I2,I3,I4,I5,I6=0
9258 FOR K=1 TO Y
9260 D=(P2-S1)*2*(L-K+1)/(L*(L+1))
9262 IF D<=P2-S1-D1 THEN 9266
9264 D=P2-S1-D1
9266 IF D>=0 THEN 9270
9268 D=0
9270 D1=D1+D
9272 B3=0
9274 IF K>J THEN 9288
9276 FOR I=1 TO 12
9278 B1=R4*(P-B2)
9280 B3=B3+B1
9282 B4=B2-B1
9284 P=P-B4
9286 NEXT I
9288 F=E2
9290 S3=-E2
9292 IF K>1 THEN 9300
9294 F=E2-E1
9296 S3=-F
9298 GOTO 9308
9300 IF K<Y THEN 9306
9302 F=E2-S2
9304 S3=S2-(P2-D1)-D2
9306 C1=0
9308 C=(M1+S3-D-B3)*T+F-C1
9310 IF K<=J THEN 9314
9312 C=C-M1
9314 V1=C/(1+R2/2)^(2*K-1)
9316 V2=V2+V1
9318 U1=INT(M1+.5)
9320 U2=INT(D+.5)
9322 U3=INT(B3+.5)
9324 U4=INT(F+.5)
9326 U5=INT(C+.5)
9328 U6=INT(V1+.5)
9330 IF F9=-1 THEN 9346
9332 PRINT K;TAB(10);U1;TAB(20);U2;TAB(30);U3;TAB(40);U4;TAB(50);U5;TAB(60);U6
9334 I1=I1+U1
9336 I2=I2+U2
9338 I3=I3+U3
9340 I4=I4+U4
9342 I5=I5+U5
9344 I6=I6+U6
9346 NEXT K
9348 IF F9=-1 THEN 9352
9350 PRINT 'TOTAL'TAB(10);I1;TAB(20);I2;TAB(30);I3;TAB(40);I4;TAB(50);I5;TAB(60);I6
9351 PRINT
9352 RETURN
9354 FOR H=1 TO X
9356 READ M$
9358 NEXT H
9360 PRINT M$;
9361 RESTORE
9362READ Q$ FOR Q6=1 TO 16
9364 RETURN
9366 W=X1+(F8/10)*(X2-X1)
9368 ON X GOTO 9370,9376,9382,9388,9394,9400,9406,9412,9418,9424,9430,9436
9370 P=W
9372 PRINT P;
9373 STOP
9374 RETURN
9376 T=W
9378 PRINT T;
9380 RETURN
9382 R1=W
9384 PRINT R1;
9386 RETURN
9388 R2=W
9390 PRINT R2;
9392 RETURN
9394  M=W
9396 PRINT M;
9398 RETURN
9400 L=W
9402 PRINT L;
9404 RETURN
9406 S1=W
9408 PRINT S1;
9410 RETURN
9412 S2=W
9414 PRINT S2;
9416 RETURN
9418 E1=S
9420 PRINT E1;
9422 RETURN
9424 E2=W
9426 PRINT E2;
9428 RETURN
9430 Y=W
9432 PRINT Y;
9434 RETURN
9436 J=W
9438 PRINT J;
9440 RETURN
9441 PRINT '=========='
9442 PRINT
9444 PRINT 'FINANCIAL ADVANTAGE OF LEASE:  $';A1
9446 PRINT
9448 PRINT 'OPERATING ADVANTAGE OF LEASE:  $';V2
9450 PRINT
9452 PRINT '      NET ADVANTAGE OF LEASE:  $';A1+V2
9453 PRINT
9454 PRINT '-----------------------------------------------------------
9455 PRINT
9456 RETURN
9900 DATA 20000,.5,.055,.15,500,10,1000,2000,500,4000,10,10,1
9901 DATA 3,.12,.045
9940 DATA 'LEASE EXPENSE','ANNUAL SAVING','LIFE OF LEASE','BASIC RENTAL PERIOD'
9990 DATA 'PURCHASE PRICE','TAX RATE','INTEREST RATE','OPPORTUNITY RATE'
9991 DATA 'MONTHLY RENT','DEPRECIABLE LIFE','TAX SALVAGE','ACTUAL SALVAGE'
9994 DATA 'LEASE EXPENSE','ANNUAL SAVING',7LIFE OF LEASE','BASIC RENTAL PERIOD'
9999 END
