9000 REM ***** DYNPRO ***** BUSINESS PROGRAM
9002 REM DYNPRO *********** VERSION #1 (7/31/69)****DYNAMIC PROGRAMMING MODEL
9004 REM MAIN PROGRAM BEGINS AT LINE 9392.
9006 PRINT "* DYNAMIC PROGRAMMING MODEL *"
9010 GOTO 9392
9012 REM THIS IS A SOMEWHAT GENERAL-PURPOSE DYNAMIC PROGRAMMING MODEL.
9014 REM IT IS LIMITED TO ONE STATE VARIABLE.  THE SOLUTION IS IMBEDDED
9016 REM IN THE INLET STATE.  THE USER MUST SUPPLY THE FOLLOWING
9018 REM FUNCTION RELATIONS:
9020 REM    1. LINES 9120-9130.  TRANSFORMATION FUNCTION.  IN THE
9022 REM       PRESENT EXAMPLE IT RELATES THE ALLOCATION VARIABLE TO THE
9024 REM       INLET AND OUTLET STATES.  USUALLY IT WOULD RELATE EITHER
9026 REM       THE INLET OR THEOUTLET STATE TO THE ALLOCATION VARIABLE
9028 REM       AND THE OTHER STATE VARIABLE.  IT IS CALLED A9.
9030 REM    2. LINES 9132-9148.  RETURN FUNCTION. IT RELATES THE RETURN
9032 REM       ON THE CURRENT STAGE THE MOST CONVENIENT OF THE FOLLOWING
9034 REM       THREE VARIABLES:  INLET STATE, OUTLET STATE, ALLOCATION
9036 REM       VARIABLE.
9038 REM    3. LINES 9150-9156.  THE VALUES OF THE INLET STATE VARIABLE
9040 REM       IN WHICH THE SOLUTION IS TO BE IMBEDDED.
9042 REM    4. LINES 9158-9172.  INDICATES THE MAXIMUM RETURN FROM THE
9044 REM       SUBSEQUENT AS A FUNCTION OF THE OUTLET STATE OF THE CRRENT
9046 REM       STAGE.  AS IT NOW STANDS, IT USES LINEAR INTERPOLATION.
9048 REM    5.  LINES 9172-9386.  EVALUATES THE MAXIMUM RETURN ON THE
9050 REM       CURRENT AND SUBSEQUENT STAGES, AND OPTIMAL ALLOCATION TO
9052 REM       THE CURRENT STAGE VARIABLE BEING TREATED AS THE INDEPEN-
9054 REM       DENT VARIABLE IN THE SEARCH, TO THE UPPER LIMIT OF THE
9056 REM       SAME, AND TO THE MINIMUM ALLOWED SEPARATION AND MAXIMUM
9058 REM       SIZE OF THE FINAL INTERVAL.  A FIBONACCI SEARCH IS USED.
9060 REM    6. LINES 9112-9118.  SPECIAL FUNCTION NEEDED IN THIS EXAMPLE
9062 REM       ONLY.  IT RELATES THE SOLUTE CONCENTRATION IN THE RAFFINATE
9064 REM       TO THE SOLVENT SOLUTE CONCENTRATION IN THE EXTRACT.
9070 REM *****NOMENCLATURE*****
9074 REM F(I,J) = MATRIX RELATING OPT CONTROL (J=2), TOTAL MAX RETURN
9076 REM    (J=3), OPT OUTLET STATE (J=4), TO THE VARIOUS VALUES (I=1 TO N)
9078 REM     OF THE INLET STATE (J=1).
9080 REM G(I,J) = F(I,J) FOR THE FOLLOWING STAGES:
9082 REM A9 = TRANSFORMATION FUNCTION
9084 REM B9 = RETURN FUNCTION
9086 REM C9 = MAXIMUM RETURN FROM SUBSEQUENT STAGES
9088 REM E9 = MAXIMUM RETURN ON CURRENT AND SUBSEQUENT STAGES
9090 REM H9 = VALUE OF INLET STATE
9092 REM I9 = (EXAMPLE HERE ONLY) SOLUTE CONCENTRATION IN EXTRACT AS A
9094 REM    FUNCTION ON CONCENTRATION IN RAFFINATE
9096 REM A1 = SALES PRICE OF EXTRACT
9098 REM B1 = COST OF SOLVENT
9100 REM Q  = FLOW RATE OF FEE
9102 REM K1 = NUMBER OF STAGES
9104 REM I1 = NUMBER OF VALUES OF THE STATE VARIABLE
9112 REM FUNCTION DEFINITION: I9 CAN BE ASSOCIATED WITH A FUNCTION
9114 REM                      OF THE PARAMETER Q1.
9116 I9=-.00152+2.78*Q1-3.385*(Q1^2)-107.7*(Q1^3)+404*(Q1^4)
9118 RETURN
9120 REM FUNCTION DEFINITION: I9 CAN BE ASSOCIATED WITH A FUNCTION
9122 REM
9124 Q1=R2
9126 GOSUB 9112
9128 A9=(R1-R2)*Q/I9
9130 RETURN
9132 REM FUNCTION DEFINITION: B9 CAN BE ASSOCIATED WITH A FUNCTION
9134 REM                      OF THE PARAMETER P1 AND P2.
9136 Q1=P2
9138 GOSUB 9112
9140 R1=P1
9142 R2=P2
9144 GOSUB 9120
9146 B9=(A1*I9-B1)*A9
9148 RETURN
9150 REM FUNCTION DEFINITION: H9 CAN BE ASSOCIATED WITH A FUNCTION
9152 REM                      OF THE PARAMETERS T1 AND T2.
9154 H9=T2*.2-.01*(T1-1)
9156 RETURN
9158 REM FUNCTION DEFINITION: C9 CAN BE ASSOCIATED WITH A FUNCTION
9160 REM                    OF THE PARAMETER U1.
9162 IF K<K1 THEN 9165
9163 C9=0
9164 GOTO 9172
9165 L=INT((.2-U1)/.01+1)
9166 IF L <= I1 AND L>0 THEN 9169
9167 GOTO 9163
9169 IF G(L+1,1)*(G(L+1,3)-G(L,1))=0 THEN 9171
9170 C9=G(L,3)+((U1-G(L,1))/(G(L+1,1)))*(G(L+1,3)-G(L,1))
9171 C9=0
9172 RETURN
9174 REM FUNCTION DEFINITION: E9 CAN BE ASSOCIATED WITH A FUNCTION
9176 REM                      OF THE PARAMETERS X1,A,B,E, AND H.
9184 REM  A = LOWER LIMIT OF INITIAL INTERVAL
9186 REM  B = UPPERLIMIT OF INITIAL INTERVAL
9188 REM  C = WIDTH OF INITIAL INTERVAL
9190 REM  E = MINIMUM ALLOWED SEPARATION OF EVALUATION
9192 REM  F = CURRENT VALUE OF FUNCTION
9194 REM F1 = EVALUATION #1 FOR CURRENT INTERVAL
9196 REM F2 = EVALUATION #2 FOR CURRENT INTERVAL
9198 REM G1,G2,G3 = FIBONACCI NUMBERS IN CURRENT USE
9200 REM  H = MAXIMUM ALLOWABLE FINALLINTERVAL SIZE
9202 REM H1 = COMPUTER WIDTH OF FINAL INTERVAL
9204 REM I2 = COUNTER IN THE 'L2 COMPUTATION' SUBROUTINE
9206 REM  J = COMPUTED TOTAL NUMBER OF EXPERIMETNS REQUIRED
9210 REM L1,L2 = INTERVAL FRACTION POSITION INDICES
9212 REM  N = COUNTER IN MAIN SEARCH ROUTINE
9214 REM  X = CURRENT VALUE OF INDEPENDENT VARIABLE
9216 REM S1,S2 = LOCATION OF F1 AND F2
9218 REM Z = INTERMEDIATE VARIABLE IN AMIN SEARCH ROUTINE
9222 REM COMPUTATION PROCEDURE:
9226 REM F1 AND F2 ARE PLACED AT X1 > X2.  F1 AND F2 ARE COMPARED
9228 REM AND THE INTERVAL (A,B) IS DIMINISHED BY REDIFINING A OR B
9230 REM ACCORDING TO THE FOLLOWING SCHEME:
9232 REM   IF F1<F2 THEN             IF F1>F2 THEN
9234 REM           B=S1                      A=S2
9236 REM           S1=S2                     S2=S1
9238 REM           F1=F2                     F2=F1
9240 REM           S2=B-L2*C                 S1=A+L2*C
9244 REM     THE ENTIRE CYCLE IS PREPEATED J TIMES.
9250 REM *******MAIN ROUTINE*******
9254 C=B-A
9256 GOSUB 9358
9258 L1=1
9260 X=A+L2*C
9262 S2=X
9264 GOSUB 9338
9266 F1=F
9270 REM ***MAIN SEARCH ROUTINE***
9272 FOR N=2 TO J
9274 IF A<S2 THEN 9288
9276 X=A+L2*C
9278 S2=S1
9280 S1=X
9282 GOSUB 9338
9284 F1=F
9286 GO TO 9300
9288 X=B-L2*C
9290 S1=S2
9292 S2=X
9294 GOSUB 9338
9296 F2=F
9300 IF F1<F2 THEN 9308
9302 A=S2
9304 F2=F1
9306 GOTO 9314
9308 F1=F2
9310 B=S1
9312 REM RECURSIVELY COMPUTE L2
9314 Z=L2
9316 L2=L1-L2
9318 L1=Z
9320 NEXT N
9322 REM
9324 REM ******FINAL OUTPUT******
9326 X=(A+B)/2
9328 GOSUB 9338
9330 LET E9=F
9332 GO TO 9386
9336 REM
9338 REM ***DEFINE YOUR FUNCTION HERE***
9340 P1=X1
9342 P2=X
9344 GOSUB 9132
9346 U1=X
9348 GOSUB 9158
9350 F=B9+C9
9356 RETURN
9358 REM ***SUBROUTINE TO COMPUTE L2***
9360 G1=1
9362 G2=1
9364 I2=2
9366 G3=G2+G1
9368 H1=(C+G1*E)/G3
9370 IF H1<H THEN 9382
9372 I2=I2+1
9374 G1=G2
9376 G2=G3
9378 IF I2 > 50 THEN 9382
9380 GOTO 9366
9382 L2=G2/G3+((-1)^I)*E/(G3*C)
9384 J=I2
9386 RETURN
9392 REM
9394 REM ***********MAIN PROGRAM*********:
9396 REM
9397 GOSUB 9468
9398 DIM F(21,4),G(21,4)
9399 FOR I=1 TO I1+1
9400 FOR J=1 TO 4
9401 F(I,J),G(I,J)=0
9402 NEXT J
9403 NEXT I
9405 PRINT "*********************************************************************"
9406 PRINT "INLET STATE";TAB(19);"OPT ALLOCATION";TAB(40);"MAX RETURN";TAB(57);"OPT OUTLET"
9408 PRINT "-----------";TAB(19);"--------------";TAB(40);"----------";TAB(57);"----------"
9410 PRINT
9412 FOR K=K1 TO 1 STEP -1
9414 FOR I=1 TO I1
9416 T1=I
9418 T2=K
9420 GOSUB 9150
9422 F(I,1)=H9
9424 X1=F(I,1)
9426 A=.000001
9428 B=X1
9430 E=.0001
9432 H=.001
9434 GOSUB 9174
9436 F(I,3)=E9
9438 F(I,4)=X
9440 R1=F(I,1)
9442 R2=F(I,4)
9444 GOSUB 9120
9446 F(I,2)=A9
9448 NEXT I
9450 MAT G=F
9452 PRINT "STAGE NUMBER:";K
9454 PRINT
9455 FOR I=1 TO I1
9456 PRINT F(I,1);TAB(19);F(I,2);TAB(40);F(I,3);TAB(57);F(I,4)
9457 PRINT
9458 NEXT I
9460 NEXT K
9462 PRINT "**********************************************************************"
9464 PRINT
9466 GOTO 9999
9468 REM ****INPUT DATA ROUTINE****
9469 PRINT
9470 PRINT
9472 PRINT "HOW MANY VALUES ARE THERE IN THE STATE VARIABLE";
9473 REM  NOTE: PROGRAM ON LIBRARY HAS DIM-STATEMENT SET FOR I1=20.
9474 INPUT I1
9475 PRINT " IF DIM-STATEMENT HAS NOT BEEN ADJUSTED TO F(LAST INPUT+1,4). ETC.,"
9476 PRINT "THEN STOP PROGRAM AND DO SO NOW."
9477 PRINT
9478 PRINT "HOW MANY STAGES ARE THERE";
9480 INPUT K1
9482 PRINT
9484 PRINT "WHAT IS THE SALES PRICE";
9486 INPUT A1
9488 PRINT
9490 PRINT "AND WHAT IS THE COST";
9492 INPUT B1
9494 PRINT "AND THE FLOW RATE OF FEED";
9495 INPUT Q
9496 PRINT
9497 RETURN
9999 END
