       PROGRAM NDTEDT                                                   ********
C*******************************************************************************
C                                                                       ********
C      PROGRAM STATEMENT ABOVE ADDED AT EKU                             ********
C                                                                       ********
C*******************************************************************************
C     COPYRIGHT (C) 1978 - UNIVERSITY OF NOTRE DAME - V2R1I1            00000010
C                                                                       00000020
C          * * * * *    N  D  T  R  A  N    * * * * *                   00000030
C                                                                       00000040
C     NDTRAN IS A SYSTEM DYNAMICS CONTINUOUS SIMULATION LANGUAGE        00000050
C     DEVELOPED AT THE UNIVERSITY OF NOTRE DAME, FINANCED BY A          00000060
C     GRANT FROM THE MAX D. FLEISCHMANN FOUNDATION, UNDER THE           00000070
C     DIRECTION OF DR. WILLIAM I. DAVISSON AND DR. JOHN J. UHRAN, JR.   00000080
C     THIS INTERPRETER WHICH COMPUTERIZES THE NDTRAN LANGUAGE WAS       00000090
C     WRITTEN BY DANIEL A. POYDENCE, THOMAS L. EVERMAN, JR.,            00000100
C     GARY L. PELKEY, AND TIMOTHY J. MALLOY AS UNDERGRADUATES           00000110
C     OF THE UNIVERSITY.                                                00000120
C                                                                       00000130
C                                                                       00000140
      REAL RMIN,RMAX,LITBL(1024)                                        00000150
      INTEGER PTRS(45),TITLE(120),CRSET(39),OPER(9),SYM(15),            00000160
     1SUBSC(6),TYPCT(20),EQCHN(80),TOKEN(80),CARD1(80),CARD2(80),       00000170
     2ERROR(80),OBJCD(160),DEF(80),XREF(80),TMAP(80),FCTN(5,22),        00000180
     3SYMTB(5,512)                                                      00000190
      INTEGER INIT0(5772),INIT1(48),INIT2(48),I,READR,PRNTR,            00000200
     1DISK,LINPP,EXPMX,INTYP,PSSWT,SYMND,LITND,VALCT,STPGM,             00000210
     2DSKND,VARND,OBJND,PGMCT,CBIT,EOF,ASC1,RRBST,RRBPT,OPTNS           00000220
      COMMON RMIN,RMAX,PTRS,TITLE,CRSET,OPER,SYM,SUBSC,TYPCT,           00000230
     1EQCHN,TOKEN,CARD1,CARD2,ERROR,OBJCD,DEF,XREF,TMAP,FCTN,           00000240
     2SYMTB,LITBL                                                       00000250
      EQUIVALENCE (INIT0(1),PTRS(1)),(INIT1(1),CRSET(1)),               00000260
     1(READR,PTRS(1)),(PRNTR,PTRS(2)),(DISK,PTRS(3)),(LINPP,PTRS(6)),   00000270
     2(EXPMX,PTRS(9)),(INTYP,PTRS(8)),(PSSWT,PTRS(10)),(SYMND,PTRS(17)),00000280
     3(LITND,PTRS(19)),(VALCT,PTRS(20)),(STPGM,PTRS(21)),(DSKND,PTRS(25)00000290
     4),(VARND,PTRS(26)),(OBJND,PTRS(27)),(PGMCT,PTRS(22)),             00000300
     5(CBIT,TOKEN(2)),(RRBST,PTRS(36)),(RRBPT,PTRS(37)),(OPTNS,PTRS(7)) 00000310
      DATA INIT2 /' ','$','#','A','B','C','D','E','F','G','H','I',      00000320
     1'J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X',      00000330
     2'Y','Z','0','1','2','3','4','5','6','7','8','9','.','+','-',      00000340
     3'*','/','=','(',')',','/                                          00000350
C*******************************************************************************
C                                                                       ********
C     ALL REFERENCES TO THE FORTRAN LOG FUNCTION HAVE BEEN CHANGED      ********
C     TO "ALOG" AT EKU.  OTHER CHANGES MADE AT EKU HAVE COMMENTS        ********
C     AND HAVE BEEN FLAGGED BY *'S IN COLS 72 THRU 80.                  ********
C                                                                       ********
C*******************************************************************************
C                                                                       00000360
C                                                                       00000370
C     DEFINE THE CHARACTERISTICS FOR THE DIRECT ACCESS FILE.            00000380
C     5,000  RECORDS OF 80 INTEGER WORDS ARE REQUIRED.  THE             00000390
C     RECORDS ARE UNFORMATTED AND 'ASC1' IS THE ASSOCIATED              00000400
C     VARIABLE.  NDTRAN DOES NOT USE THE ASSOCIATED VARIABLE.           00000410
C     ANY UNIT NUMBER MAY BE ASSIGNED FOR THE FILE.                     00000420
C                                                                       00000430
C                                                                       00000440
      DEFINE FILE 1(5000,80,U,ASC1)                                     00000450
C                                                                       00000460
C                                                                       00000470
C     ALL COMMON STORAGE LOCATIONS MUST BE INITIALIZED FOR              00000480
C     THOSE SYSTEMS WHICH PREVENT A REFERENCE TO A STORAGE              00000490
C     LOCATION WHICH HAS NOT BEEN ASSIGNED A VALUE.                     00000500
C                                                                       00000510
C                                                                       00000520
      DO 10 I=1,5772                                                    00000530
   10 INIT0(I)=0                                                        00000540
C                                                                       00000550
C                                                                       00000560
C     THE FOLLOWING ASSIGNMENTS ESTABLISH INSTALLATION DEPENDENT        00000570
C     PARAMETERS.  READR IS THE INPUT DEVICE NUMBER (THE CARD READER    00000580
C     OR ANY SEQUENTIAL INPUT FILE), PRNTR IS THE OUTPUT DEVICE         00000590
C     NUMBER (LINE PRINTER OR ANY SEQUENTIAL OUTPUT FILE), AND          00000600
C     DISK IS THE DIRECT ACCESS FILE NUMBER.  LINPP IS THE NUMBER       00000610
C     OF LINES PER PAGE OF PRINTED OUTPUT.  EXPMX IS THE MAXIMUM        00000620
C     EXPONENT PERMITTED DURING EXECUTION AND SHOULD BE SET TO          00000630
C     ONE LESS THAN THE SMALLEST OF THE THE ABSOLUTE VALUE OF THE       00000640
C     CHARACTERISTICS OF THE FLOATING POINT MINIMUM AND THE MAXIMUM.    00000650
C                                                                       00000660
C     AS AN EXAMPLE, THE IBM 370 FLOATING POINT MINIMUM AND MAXIMUM     00000670
C     VALUES ARE APPROXIMATELY 1E-78 AND 1E75 SO EXPMX IS 74 ON         00000680
C     THAT SYSTEM. NDTRAN WILL PERMIT NUMBERS BETWEEN AND INCLUDING     00000690
C     1E-74 AND 1E74 DURING EXECUTION.                                  00000700
C                                                                       00000710
C                                                                       00000720
C*******************************************************************************
C                                                                       ********
C      PROGRAM STATEMENTS BELOW ADDED AT EKU                            ********
C                                                                       ********
C*******************************************************************************
       READR=2                                                          ********
        TYPE 11                                                         ********
   11 FORMAT('0Enter filename of NDTRAN model  ' $)                     ********
        CALL ASSIGN(2,,-1,'OLD')                                        ********
C                                                                       ********
C       THE ABOVE ASSIGN STATEMENT CAUSES EXECUTION TO STOP AFTER       ********
C       AN ASTERISK '*' PROMPT FOR THE USER TO ENTER THE NAME OF THE    ********
C       FILE CONTAINING THE NDTRAN MODEL.                               ********
C                                                                       ********
C*******************************************************************************
C                                                                       ********
C      READR=5                                                          00000730
C                                                                       ********
C*******************************************************************************
C                                                                       ********
C      PRNTR=6                                                          00000740
C                                                                       ********
C                                                                       ********
C     STATEMENTS BELOW ADDED AT EKU                                     ********
C                                                                       ********
C                                                                       ********
       PRNTR=3                                                          ********
       TYPE 12                                                          ********
   12 FORMAT('0Enter filename for output  '$)                           ********
        CALL ASSIGN (3,,-1,'NEW','CC')                                  ********
C                                                                       ********
C     --- ASTERISK PROMPT FOR OUTPUT FILE ALSO ---                      ********
C                                                                       ********
C*******************************************************************************
C                                                                       ********
      DISK=1                                                            00000750
C      LINPP=60                                                         00000760
C                                                                       ********
C        STATMENTS BELOW ADDED AT EKU                                   ********
C                                                                       ********
         LINPP=45                                                       ********
C                                                                       ********
C*******************************************************************************
C                                                                       ********
C      EXPMX=74                                                         00000770
C                                                                       00000780
C                                                                       00000790
C       STATEMENT BELOW ADDED AT EKU                                    ********
C                                                                       ********
        EXPMX=36                                                        ********
C                                                                       ********
C*******************************************************************************
C                                                                       ********
C     INTYP IS INITIALIZED TO THE DESIRED DEFAULT INTEGRATION           00000800
C     TECHNIQUE TO BE USED DURING EXECUTION.  INTYP MAY HAVE            00000810
C     THE FOLLOWING VALUES:                                             00000820
C                                                                       00000830
C          1 - EULER LOWER SUM                                          00000840
C          2 - FOURTH ORDER RUNGE-KUTTA                                 00000850
C          3 - ADAMS-BASHFORTH PREDICTOR                                00000860
C                                                                       00000870
C                                                                       00000880
      INTYP=3                                                           00000890
C                                                                       00000900
C                                                                       00000910
C     THE FOLLOWING ASSIGNMENTS ESTABLISH THE LIMITS ON SIZE AND        00000920
C     REQUIREMENTS FOR NDTRAN PROGRAMS.  SYMND LIMITS THE SYMBOL        00000930
C     TABLE SIZE, LITND LIMITS THE NUMBER OF NUMERIC LITERALS,          00000940
C     AND DSKND LIMITS THE NUMBER OF RECORDS THAT MAY BE WRITTEN        00000950
C     TO AND READ FROM THE DISK FILE.  VARND AND OBJND LIMIT THE        00000960
C     REAL AND INTEGER STORAGE AVAILABLE DURING EXECUTION.              00000970
C                                                                       00000980
C                                                                       00000990
      SYMND=512                                                         00001000
      LITND=1024                                                        00001010
      DSKND=5000                                                        00001020
      VARND=5000                                                        00001030
      OBJND=5154                                                        00001040
C                                                                       00001050
C                                                                       00001060
C     THE FLOATING POINT MINIMUM AND MAXIMUM VALUES ARE COMPUTED        00001070
C     AND THE NDTRAN CHARACTER SET IS INITIALIZED.                      00001080
C                                                                       00001090
C                                                                       00001100
      RMAX=10.**EXPMX                                                   00001110
      RMIN=10.**(-EXPMX)                                                00001120
      DO 20 I=1,48                                                      00001130
   20 INIT1(I)=INIT2(I)                                                 00001140
C                                                                       00001150
C                                                                       00001160
C     NDT03 INITIALIZES THE SYMBOL AND FUNCTION TABLES AND PUTS         00001170
C     BUILTIN MACRO RECORDS ON DISK.                                    00001180
C                                                                       00001190
C                                                                       00001200
      CALL NDT03                                                        00001210
C                                                                       00001220
C                                                                       00001230
C     THE REQUIRED INITIALIZATIONS ARE COMPLETED.  STPGM IS             00001240
C     THE FIRST RECORD AVAILABLE FOR SOURCE PROGRAM INFORMATION         00001250
C     STORAGE.  PGMCT POINTS TO THE LAST RECORD USED FOR THAT           00001260
C     PURPOSE.  ASC1 IS SET TO 1 FOR SYSTEMS THAT REQUIRE THE           00001270
C     ASSOCIATED VARIABLE TO BE VALID WHETHER IT IS USED OR NOT.        00001280
C     PSSWT, THE PROGRAM STATUS SWITCH IS SET TO BEGIN LOOKING          00001290
C     FOR A TITLE CARD DURING INPUT.  VALCT, THE VARIABLE               00001300
C     ALLOCATION COUNTER, IS SET TO THE LAST STORAGE LOCATION           00001310
C     ALLOCATED FOR USE DURING EXECUTION.  EOF IS AN END OF FILE        00001320
C     FLAG (1 = END OF FILE HAS OCCURRED).  CBIT, THE CONTINUATION      00001330
C     BIT, INDICATES THAT THE PREVIOUS CARD WAS CONTINUED WITH          00001340
C     A VALUE OF 1.  IT IS SET TO 1 TO CAUSE 2 CARDS TO BE INPUT        00001350
C     INITIALLY.  RRBST IS THE FIRST RECORD AVAILABLE FOR RERUN         00001360
C     BUFFERS.  RRBPT POINTS TO THE LAST RECORD USED FOR THAT PURPOSE.  00001370
C     RRBPT IS INITIALIZED TO ALLOW THE RERUN CARD PROCESSOR TO         00001380
C     DISTINGUISH THE FIRST RERUN CARD FROM THE OTHERS.                 00001390
C                                                                       00001400
C                                                                       00001410
      STPGM=150                                                         00001420
      PGMCT=STPGM-1                                                     00001430
      ASC1=1                                                            00001440
      PSSWT=1                                                           00001450
      VALCT=21                                                          00001460
      EOF=0                                                             00001470
      CBIT=1                                                            00001480
      RRBST=53                                                          00001490
      RRBPT=-1                                                          00001500
C                                                                       00001510
C                                                                       00001520
C     IF CBIT IS 1 THEN THE PREVIOUS CARD WAS CONTINUED AND             00001530
C     BOTH CARDS HAVE BEEN PROCESSED.  IN THIS CASE TWO MORE            00001540
C     CARDS ARE READ.  IF CBIT IS 0 THEN CARD1 WAS PROCESSED.           00001550
C     CARD2 MUST BE MOVED TO CARD1 AND ONE CARD MUST BE READ.           00001560
C     THIS SCHEME ALLOWS INPUT TO BE PROCESSED FROM CARD1 WITH          00001570
C     AN OPTIONAL CONTINUATION IN CARD2.                                00001580
C                                                                       00001590
C                                                                       00001600
  400 IF(CBIT.EQ.1) GO TO 600                                           00001610
      DO 500 I=1,80                                                     00001620
  500 CARD1(I)=CARD2(I)                                                 00001630
      READ(READR,700,END=800) CARD2                                     00001640
      GO TO 900                                                         00001650
  600 READ(READR,700,END=1400) CARD1                                    00001660
      READ(READR,700,END=800) CARD2                                     00001670
      GO TO 900                                                         00001680
  700 FORMAT(80A1)                                                      00001690
C                                                                       00001700
C                                                                       00001710
C     END OF FILE HAS OCCURRED BUT THE LAST CARD NEEDS TO BE            00001720
C     PROCESSED SO EOF IS SET. THE CARD CANNOT BE CONTINUED             00001730
C     SO THE KEY FIELD OF CARD2 MUST NOT INDICATE A CONTINUATION.       00001740
C                                                                       00001750
C                                                                       00001760
  800 EOF=1                                                             00001770
      CARD2(1)=0                                                        00001780
C                                                                       00001790
C                                                                       00001800
C     NDT01 PROCESSES THE INPUT SOURCE CARDS AND UPDATES PSSWT          00001810
C     TO INDICATE THE MODE OF INPUT.  IF PSSWT IS 6 THEN THE            00001820
C     SOURCE CARD REQUESTED A MACRO EXPANSION WHICH IS HANDLED          00001830
C     BY NDT02.                                                         00001840
C                                                                       00001850
C                                                                       00001860
  900 CALL NDT01                                                        00001870
      IF(PSSWT.EQ.6) CALL NDT02                                         00001880
      IF(EOF.EQ.0) GO TO 400                                            00001890
C                                                                       00001900
C                                                                       00001910
C     ALL SOURCE STATEMENTS HAVE BEEN INPUT AND PROCESSED.              00001920
C     THE CONTEXT ANALYSIS BEGINS AT THIS POINT.                        00001930
C                                                                       00001940
C                                                                       00001950
 1400 CALL NDT04                                                        00001960
C                                                                       00001970
C                                                                       00001980
C     THE TABLES REQUESTED BY CONTROL CARDS ARE PRODUCED NEXT.          00001990
C                                                                       00002000
C                                                                       00002010
      CALL NDT61                                                        00002020
C                                                                       00002030
C                                                                       00002040
C     THE EQUATION ORDERING ROUTINE IS CALLED TO RECONSTRUCT THE        00002050
C     EQUATION CHAIN TO BE USED BY THE LOADER.                          00002060
C                                                                       00002070
C                                                                       00002080
      CALL NDT62                                                        00002090
C*******************************************************************************
C                                                                       ********
C      THE FOLLOWING STATEMENTS ADDED AT EKU TO STOP EXECUTION AND      ********
C      CLOSE INPUT AND WORK FILES.                                      ********
C                                                                       ********
C*******************************************************************************
       CLOSE(UNIT=1,DISP='DELETE')                                      ********
       CLOSE(UNIT=3,DISP='SAVE')                                        ********
       STOP                                                             ********
       END                                                              ********
