1	!


	!		Z E R O 



2!		Program:	ZERO
3!		Version:	V02A
4!		Edit:		03
7!		Edit Date:	19-May-80
9!		Author:		Brant Cheikes/Terry F. O'Dwyer


15	EXTEND
	!  Set up BASIC-PLUS EXTEND mode processing

20	! &
	&
	&
	!	M o d i f i c a t i o n   H i s t o r y &
	&
	&
	!	Version/Edit	Edit Date	Reason &

21!		V02A-01		10-May-80	New release &
  !		V02A-02		12-May-80	Add functionality &
  !						and documentation &
  !		V02A-03		19-May-80	Fix reattach/kill self &
  !						query bug &

50	! &
	&
	&
	!	P r o g r a m   D e s c r i p t i o n &
	&
	&

60	!  ZERO is used to erase unused areas on any file structured disk. &
	!  The purpose of this is to prevent RSTS/E users from doing "disk &
	!  dumps" and obtaining unauthorized information. &
	! &
	!  A disk dump is performed by opening a large file on disk using &
	!  the BASIC-PLUS FILESIZE option.  A large file can be created &
	!  and closed without writing into it in this way.  When the file &
	!  is listed (for example, by using the TYPE.TEC program), data &
	!  unerased from the disk can be obtained.  ZERO erases all unused &
	!  areas on the system disk (or any other disk specified) in order &
	!  to eliminate this security problem. &
	! &
	!  ZERO creates a file of the user's choice (usually ZERO00.TMP), &
	!  marks it for deletion, and writes blocks of zeros (nulls) to it &
	!  always extending the file until a "?No room for user on device" &
	!  is returned to the program when the system runs out of disk &
	!  space. &
	! &
	!  ZERO runs detached while performing this processing.  The user has &
	!  the option of having ZERO reattach to the keyboard from which it &
	!  detached (to print totals and statistics) or having it KILL itself &
	!  when done. &
	! &
	!  ZERO should generally be run when the system is lightly loaded. &
	!  It has a tendency to noticeably slow down a RSTS/E system by tying &
	!  up the Monitor's File Processor. &
	! &
	!  This program was originally written by Dr. Terry F. O'Dwyer, Dean &
	!  of Instruction for Learning Resources of Nassau Community College. &
	!  The current version was written and expanded by Brant Cheikes (of &
	!  no particular fame). &
	! &

700	! &
	&
	&
	!	D a t a   S t a t e m e n t s &
	&
	&

710	DATA 4,8,16,32,64,128,256 &

720!	Data for determining correct file clustersize value &

900	! &
	&
	&
	!	D i m e n s i o n   S t a t e m e n t s &
	&
	&

910	DIM CLU.SIZE%(6%) &
	\  READ CLU.SIZE%(N%) FOR N% = 0% TO 6% &
	!  This matrix holds various possible file clustersizes &

920	DIM M%(30%) &
	!  SYS calls are returned here &

1000	! &
	&
	&
	!	M a i n   P r o g r a m   C o d i n g &
	&
	&

1010	V$ = "V02A-03" &
	!  Set up version/edit level &

1020	ON ERROR GOTO 30000 &
	\  PRINT &
	\  PRINT "ZERO   "+V$+"   "+ &
	   CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%) &
	\  PRINT "Zeros Unallocated Blocks" &
	\  PRINT &
	!  Output the system header &

1030	INPUT "Disk?  <SY:>  ";DISK$ &
	\  DISK$ = "SY:" UNLESS LEN(DISK$) &
	\  DISK$ = DISK$ + ":" UNLESS INSTR(1%,DISK$,":") &
	!  Get the disk to zero; the public structure (SY:) is the default &
	!  Add a colon if necessary &

1040	PRINT "Filename?  <ZERO00.TMP>  "; &
	\  INPUT LINE FILNAM$ &
	\  FILNAM$ = CVT$$(FILNAM$,4%) &
	\  FILNAM$ = "ZERO00.TMP" UNLESS LEN(FILNAM$) &
	!  Get the filename the user prefers; ZERO00.TMP is the default &

1050	NAM$ = DISK$ + FILNAM$ &
	\  NAM$ = CVT$$(NAM$,2%+4%+32%) &
	\  SYSCAL$ = SYS(CHR$(6%)+CHR$(-10%)+NAM$) &
	\  CHANGE SYSCAL$ TO M% &
	\  NAM$ = RAD$(M%(7%)+SWAP%(M%(8%)))+RAD$(M%(9%)+SWAP%(M%(10%)))+ &
		  '.'+RAD$(M%(11%)+SWAP%(M%(12%))) &
	\  DEV$ = CHR$(M%(23%))+CHR$(M%(24%)) &
	\  DEV$ = DEV$ + NUM1$(M%(25%)) IF M%(26%) = 255% &
	\  DEV$ = DEV$ + ":" &
	\  PPN$ = "[" + NUM1$(M%(6%)) + ',' + NUM1$(M%(5%)) + "]" &
	\  DEV$ = DEV$ + PPN$ UNLESS PPN$ = "[0,0]" &
	\  NAM$ = DEV$ + NAM$ + "<60>" &
	!  Format the final name and push it through a filename scan to &
	!  make sure it is valid; an error will knock us out of here &

1060	PRINT "Clustersize for ";NAM$;"?  <4>  "; &
	\  INPUT CLU% &
	\  CLU% = 4% UNLESS CLU% &
	\  IF CLU% < 1% OR CLU% > 256% THEN PRINT "?Illegal clustersize" &
	\  PRINT &
	\  GOTO 1060 &
	!  Get the clustersize and check it for validity &

1070	PRINT "Should ZERO reattach (R) or kill itself (K) when done?  <K>  "; &
	\  INPUT A$ &
	\  KILL.% = 0% &
	\  A$ = LEFT(CVT$$(A$,2%+32%), 1%) &
	\  KILL.% = -1% IF A$ = "K" OR LEN(A$) = 0% &
	\  GOTO 1070 UNLESS KILL.% OR (A$ = "R") &
	!  Find out what to do when finished &

1080	FOR LOOP% = 1% TO 6% &
	\  CLU% = CLU.SIZE%(LOOP%-1%) IF (CLU%>CLU.SIZE%(LOOP%-1%)) AND &
					 (CLU%<CLU.SIZE%(LOOP%)) &
	\  NEXT LOOP% &
	!  Get the next lowest clustersize if the specified clustersize is &
	!  not a multiple of 4 &

1090	FILESIZ% = 32767% &
	\  BUFFERSIZ% = 16% * 512% &
	\  BUFFERSIZ% = CLU% * 512% IF CLU% < 32% &
	\  ADD% = BUFFERSIZ%/512% &
	\  PRINT "Clustersize: ";CLU%;"blocks" &
	\  PRINT "Buffer size: ";BUFFERSIZ%;"bytes" &
	!  Set up the initial filesize, clustersize, buffersize, and disk &
	!  zero block increment factor; print values &

2000	OPEN NAM$ FOR OUTPUT AS FILE 1%, RECORDSIZE BUFFERSIZ%, &
					 CLUSTERSIZE CLU%, &
					 FILESIZE FILESIZ% &
	\  KILL NAM$ &
	!  Open the file and mark it for deletion &

2010	FIELD #1%, BUFSIZ(1%) AS BUFFER$ &
	\  LSET BUFFER$ = STRING$(BUFSIZ(1%), 0%) &
	\  PRINT "Initial filesize is";FILESIZ%;"blocks" &
	\  JOB% = (PEEK(518%) AND 255%)/2% &
	\  KB% = ASCII(MID(SYS(CHR$(6%)+CHR$(26%)),4%,1%)) &
	\  PRINT "Detaching..." &
	\  PRINT CHR$(12%) &
	\  SYSCAL$ = SYS(CHR$(6%)+CHR$(7%)) &
	!  Field the buffer; fill it with zeros; tell user the filesize and &
	!  detach &

2020	! &
	&
	&
	!	B e g i n   Z e r o i n g   O p e r a t i o n &
	&
	&

2030	REC% = 1% &
	\  TIME0 = TIME(0%) &
	\  CPU = TIME(1%) &
	!  Initial RECORD value &
	!  Get seconds since midnight and current CPU time in tenths of secs &

2040	PUT #1%, RECORD REC% &
	\  REC% = REC% + ADD% &
	\  GOTO 2040 &
	!  Start writing zeros to the file and loop until done &

2100	CLOSE #1% &
	!  Close the file, deleting it since it was marked for such &

3000	! &
	&
	&
	!	E n d   P r o c e s s i n g &
	&
	&

3010	GOTO 3100 UNLESS KILL.% &
	!  Skip out if we are reattaching &

3020	SYSCAL$ = SYS(CHR$(6%)+CHR$(8%)+CHR$(JOB%)+STRING$(24%,0%)+CHR$(255%)) &
	!  Kill our job &

3100	SYSCAL$ = SYS(CHR$(6%)+CHR$(6%)+CHR$(JOB%)+CHR$(KB%)) &
	\  PRINT "ZERO reattaching..." &
	\  PRINT &
	\  REC = REC%-1% &
	\  REC = 32767.+(32767.-(ABS(REC))) IF REC < 0. &
	\  PRINT "Ultimate filesize was";REC;"blocks." &
	!  Reattach and tell user; display final filesize &

3110	ELAPSED = TIME(0%) - TIME0 &
	\  CPU = TIME(1%) - CPU &
	\  HOURS% = ELAPSED/3600% &
	\  ELAPSED = ELAPSED - (HOURS% * 3600%) &
	\  MINUTES% = ELAPSED/60% &
	\  ELAPSED = ELAPSED - (MINUTES% * 60%) &
	!  Get elapsed time and elapsed CPU time; get hours, minutes and &
	!  seconds of elapsed time &

3120	PRINT "Elapsed time: "; &
	\  PRINT HOURS%;"hour";FNS$(HOURS%);","; IF HOURS% &
	\  PRINT MINUTES%;"minute";FNS$(MINUTES%);","; IF MINUTES% &
	\  PRINT ELAPSED;"second";FNS$(ELAPSED) IF ELAPSED <> 0 &
	!  Print the elapsed time &

3130	CPU = CPU / 10% &
	\  MINUTES% = CPU/60% &
	\  CPU = CPU - (MINUTES% * 60%) &
	\  PRINT "CPU time: "; &
	!  Get minutes and seconds of CPU time &

3140	PRINT MINUTES%;"minute";FNS$(MINUTES%);","; IF MINUTES% &
	\  PRINT CPU;"second";FNS$(CPU) &
	!  Print the totals &

3300	GOTO 32000 &
	!  Exit out &

10000	! &
	&
	&
	!	S u b r o u t i n e s &
	&
	&

10010	CLOSE #1% &
	\  FILESIZ% = FILESIZ%/2% &
	\  IF FILESIZ% > 3% THEN 2000 ELSE PRINT &
	   "?File cannot be opened due to insufficient space on disk" &
	\  GOTO 32000 &
	!  Close the file; cut down the filesize; if too small to be useful, &
	!  tell user and abort &

20000	! &
	&
	&
	!	F u n c t i o n s &
	&
	&

20010	DEF* FNS$(D%) &

20020	IF D% <> 1% THEN FNS$ = "s" ELSE FNS$ = "" &
	!  If D% is not singular, add an 's', else don't add an 's' &

20030	FNEND &

30000	! &
	&
	&
	!	E r r o r   H a n d l i n g &
	&
	&

30010	IF ERL = 1050% THEN PRINT "?Illegal filename - file ";NAM$ &
	\  PRINT &
	\  RESUME 1030 &
	!  Handle errors from the filename scan SYS call &

30020	IF ERL = 3100% THEN S$ = SYS(CHR$(6%)+CHR$(-5%)+CHR$(KB%)+ &
	CHR$(13%)+CHR$(10%)+"***  ZERO waiting to reattach  ***"+ &
	CHR$(13%)+CHR$(10%)+CHR$(10%)) UNLESS SENT% &
	\  SLEEP 30% &
	\  SENT% = -1% &
	\  RESUME 3100 &
	!  If error on reattach, send message unless we already sent one; &
	!  SLEEP a half minute and try to reattach again &

30030	IF ERL = 3020% THEN S$ = SYS(CHR$(6%)+CHR$(5%)) &
	\  S$ = SYS(CHR$(9%)) &
	\  STOP &
	!  If error on KILL, logout and clear out &

30040	IF ERR = 4% AND ERL = 2000% THEN RESUME 10000% &
	!  Handle errors on file OPEN &

30050	IF ERR = 4% AND ERL = 2040% THEN RESUME 2100% &
	!  We are finished if we've written zeros to the last free block &

30060	IF ERR = 11% THEN RESUME 32000 &
	!  Exit on CTRL/Z &

30900	MSG$ = "?ZERO "+V$+" Unexpected fatal error - " + &
	CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%) &
	\  MSG$ = CHR$(13%)+CHR$(10%)+CHR$(10%)+MSG$+CHR$(13%) + &
	   CHR$(10%)+"Line "+NUM1$(ERL)+"   ERR "+NUM1$(ERR)+CHR$(13%) + &
	   CHR$(10%)+CHR$(10%) &
	\  SYSCAL$ = SYS(CHR$(6%)+CHR$(-5%)+CHR$(KB%)+MSG$) &
	\  GOTO 32000 &
	!  Set up the error message and broadcast it &

32000	! &
	&
	&
	!	E x i t &
	&
	&

32600	NO EXTEND
	!  Disable EXTEND mode processing

32700	S$ = SYS(CHR$(9%))
	!  Clear core and exit fast

32767	END
