1	!

	!		P S T O F C

	!
2	!	Program:	PSTOFC
		Version:	V06A
		Edit:		02
		Edit Date:	25-Sep-79
		Author:		Brant Cheikes
		System:		PDP-11  RSTS/E V06C-03 or later
		Affiliation:	Nassau Community College
	!
5	!
	!		Program Description
	!
	!  PSTOFC allows any user to perform certain MAIL-related functions
	!  that are beyond the scope of the MAIL program. It gives the 
	!  non-privileged user certain powers while giving the privileged
	!  those and more.  The program follows the algorithms outlined in
	!  MAIL.BAS.  Full program documentation can be found within this
	!  program and by using the HELP command.  Each line of PSTOFC is
	!  documented.
	!
	!  Suggested protection code for PSTOFC.BAC:  <232>
	!
7	!
	!		Data File Access Algorithm
	!
	!  There is a special way the data files of the MAIL system are
	!  accessed so that the MAIL programs can be shared by multiple users.
	!  This is the explanation of how it is done.
	!
	!  All users must have read access to the data files at one time.
	!  However, write access is needed for registration, suspension,
	!  renewal, and name correction. Therefore, both files are opened
	!  in read-only mode (MODE 8192%) and, when write access is needed, the
	!  programs CLOSE the file(s) on which write access is needed, and 
	!  re-open them normally (MODE 0%) to get write access. After the
	!  write is performed, the files are immediately CLOSED and re-opened
	!  read-only, relinquishing write access. 
	!
	!  In this way, most all the time, no programs have write access and all
	!  have read access. When write access is required, the programs get it,
	!  perform their writes, and immediately give up write access. Because
	!  of this technique, write access is held by a user for a very brief
	!  period of time, but read access is held by all users all the time.
	!
	!  These procedures, followed by MAIL and PSTOFC, make the MAIL system
	!  a package sharable by multiple users.
	!
9	!
	!		Channel Usage
	!
	!	Channel		Use
	!
	!	1		Keyboard dialogue
	!
	!	2		Accessing ACCT.MAI
	!
	!	3		Accessing NAMES.MAI
	!
15	!
			Modification History

		Version/Edit	Date		Reason

		V06A   / 01	14-Aug-79	New release
		V06A   / 02	25-Sep-79	General repairs

	!
19	!
		M A I N   P R O G R A M   C O D I N G
	!
20	A1$="$"
30	A2$ = "$"

40	!  Line 20 sets up the data file account pointer
	!  Line 30 sets up the MAIL system program account pointer

45	V$ = "V06A-02"
	!  Set up version/edit level

50	ON ERROR GOTO 30000
	\  X$ = SYS(CHR$(6%)+CHR$(-7%))
	\  OPEN 'KB:' AS FILE 1%
	\  P% = PEEK(PEEK(PEEK(520%)+8%)+24%)
	\  P1% = SWAP%(P%) AND 255%
	\  P2% = P% AND 255%
	\  IF P1% = 1% THEN O% = -1%
	!  Set up error trap; set CTRL/C trapping; open keyboard;
	!  PEEK the PPN; P1% = project number, P2% = programmer number
	!  If privileged (P1%=1%), then flag as such

60	OPEN A1$ + 'ACCT.MAI' FOR INPUT AS FILE 2%,MODE 8192%
	\  OPEN A1$ + 'NAMES.MAI' FOR INPUT AS FILE 3%,MODE 8192%
	\  DIM #2%,A%(254%,254%)
	\  DIM C$(5%)
	\  DIM T%(30%)
	\  MAT READ C$
	\  DATA NAME, LIST, HELP, EXIT, ERROR
	!  Open all files; open both ACCT.MAI and NAMES.MAI in read-only
	!  mode; DIMension virtual array file as an integer array;
	!  DIMension command array; DIMension terminal characteristics
	!  holding array; read in commands

70	PRINT
	\  PRINT "PSTOFC   " + V$ + "   " +
	   CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%)
	\  PRINT "System Post Office"
	\  PRINT
	!  Output system header

80	PRINT "Good day.  I'm the Postmaster General.  What can I do for you?"

90	INPUT #1% C$
	\  PRINT
	!  Get the command

100	IF O% THEN IF C$ = "SUSPEND" THEN 1000 ELSE
	           IF C$ = "RENEW"   THEN 2000
	!  Check for privileged-only commands

110	FOR C% = 1% TO 5%
	\  GOTO 120 IF C$(C%) = C$	OR	C$(C%) = "ERROR"
	\  NEXT C%
	!  Check the command for validity

120	ON C% GOTO 3000, 5000, 4000, 32000, 130
	!  Dispatch according to command entered

130	E% = E% + 1%
	\  ON E% GOTO 140, 160, 170, 180
	!  Dispatch based on how many times an invalid command was
	!  entered.  Error messages get meaner as the user acts
	!  stupider.

140	PRINT "I'm sorry, but as civil servants go, I'm rather stupid.  I"
	\  &  "only understand these commands:"
	\  &
145	   &  "'NAME'	- Correct your name on our registration ledger"
	\  &  "'LIST'	- List registered receivers"
	\  &  "'HELP'	- Request help information on PSTOFC"
	\  &  "'EXIT'	- Exit from PSTOFC"
	\  &
	!  Give non-privileged help message

147	IF O% THEN
	   &  "Furthermore, since you are privileged, you may also:"
	\  &
	\  &  "'SUSPEND'	- Suspend any registered user's mail privilege"
	\  &  "'RENEW'		- Renew the mail privilege of any user with"
	\  &  "			  suspended mail service"
	\  &  "Also, the NAME command will allow you to correct the name"
	\  &  "of ANY registered user."
	\  &
	!  Print priv-only-command help message

150	PRINT "Now then, how can I help you?"
	\  GOTO 90
	!  Reprompt user and go back to get the command

160	PRINT "Please don't confuse me. Type either NAME, LIST, HELP,"
	\  IF O% THEN PRINT "EXIT, SUSPEND, or RENEW, okay?"; ELSE
	   PRINT "or EXIT, okay?";

165	PRINT " So what will it be?"
	\  GOTO 90
	!  Invalid command entered twice

170	PRINT "I've told you the commands TWICE!!  Now use them or GET OUT!!"
	\  PRINT "Whaddaya want??"
	\  GOTO 90
	!  Invalid command entered three times - this guy must be stupid

180	PRINT "You need a course in remedial intelligence!  Go away and bother"
	\  PRINT "some OTHER Postmaster!"
	\  PRINT
	\  GOTO 32000
	!  This guy IS stupid!  Inform him of it and get rid of him

1000	!
			S U S P E N D
	!
1010	PRINT "Enter proj,prog to suspend: ";
	\  INPUT LINE #1% S$
	\  S$ = CVT$$(S$,4%)
	\  P% = INSTR(1%,S$,',')
	\  P3% = VAL(LEFT(S$,P%-1%))
	\  P4% = VAL(RIGHT(S$,P%+1%))
	\  V% = SGN(A%(P3%,P4%))
	!  Get PPN; break down at comma to get value of proj & prog;
	!  put SGN of address Proj,Prog into V% for testing account
	!  status

1020	GOTO 1050 IF V% = 1%

1030	IF V% = -1% THEN PRINT
	"Account ["+S$+"] has suspended service now!"
	\  PRINT
	\  GOTO 1010
	!  If suspended already, tell user

1040	PRINT "Account ["+S$+"] is not registered at this time"
	\  PRINT
	\  GOTO 1010
	!  User is not registered so tell user and go get another account

1050	V% = VAL('-' + NUM1$(A%(P3%,P4%)))
	!  Make value a negative to signal suspension

1060	CLOSE #2%
	!  Close file, preparing to get write access

1070	OPEN A1$ + 'ACCT.MAI' AS FILE 2%
	\  IF (STATUS AND 1024%) THEN CLOSE #2%
	\  SLEEP 1%
	\  GOTO 1070
	!  Loop until write access is granted

1080	A%(P3%,P4%) = V%
	!  Replace old value with suspension value

1090	CLOSE #2%
	\  OPEN A1$ + 'ACCT.MAI' AS FILE 2%,MODE 8192%
	\  PRINT "Account ["+S$+"] mail privilege now suspended"
	\  PRINT
	\  GOTO 1010
	!  Close file to relinquish write access; notify user that
	!  suspension went through; go back for another account to
	!  suspend

2000	!
			R E N E W
	!
2010	PRINT "Enter proj,prog to renew: ";
	\  INPUT LINE #1% S$
	\  S$ = CVT$$(S$,4%)
	\  P% = INSTR(1%,S$,',')
	\  P3% = VAL(LEFT(S$,P%-1%))
	\  P4% = VAL(RIGHT(S$,P%+1%))
	\  V% = SGN(A%(P3%,P4%))
	!  Duplicate actions of line 1010

2020	IF V% <> -1% THEN PRINT
	"Account ["+S$+"] isn't suspended!"
	\  PRINT
	\  GOTO 2010
	!  To renew, account's service must be suspended

2030	IF V% = 0% THEN PRINT
	"Account ["+S$+"] isn't registered!"
	\  PRINT
	\  GOTO 2010
	!  Can't renew an unregistered account

2040	V% = ABS(A%(P3%,P4%))
	!  Make address value a positive number to signify user is
	!  registered and not suspended

2050	CLOSE #2%
	!  Prepare to gain write access

2060	OPEN A1$ + 'ACCT.MAI' AS FILE 2%
	\  IF (STATUS AND 1024%) THEN CLOSE #2%
	\  SLEEP 1%
	\  GOTO 2060
	!  Loop until we get write access

2070	A%(P3%,P4%) = V%
	!  Renew the user

2080	CLOSE #2%
	\  OPEN A1$ + 'ACCT.MAI' AS FILE 2%,MODE 8192%
	\  PRINT "Account ["+S$+"] mail privilege renewed"
	\  PRINT
	\  GOTO 2010
	!  Relinquish write access; notify user of successful renewal and
	!  go back for another account to renew

3000	!
			N A M E
	!
3010	GOTO 3070 IF O%
	!  Privileged invocation of the NAME command

3015	GOTO 3100 IF SGN(A%(P1%,P2%)) <> 1%
	!  Go take care of those not registered or suspended

3020	PRINT "Oh my heavens!  Do we have your name down wrong??  Well, we"
	\  &  "better fix that immediately!"
	\  &
	!  Begin non-privileged name correcting

3030	PRINT "What is your CORRECT name?"
	\  INPUT #1% F$
	\  PRINT
	!  Get new name

3040	X$ = FNC$(F$,P1%,P2%)
	!  Make the correction

3045	PRINT

3050	PRINT "Your name is now down as '";FNL$(F$);"' on our registration"
	\  &  "ledger.  Is that correct?"
	\  INPUT #1% Q$
	\  PRINT
	\  IF LEFT(Q$,1%) = 'Y' THEN PRINT "Good."
	\  GOTO 10000
	!  Make sure name is correct

3055	IF LEFT(Q$,1%) = 'N' THEN 3060 ELSE PRINT
	"Please answer Y[es] or N[o]."
	\  GOTO 3045

3060	PRINT "It's not??  Then what IS it?"
	\  INPUT #1% F$
	\  PRINT
	\  GOTO 3040
	!  If incorrect, get another name and try again

3070	PRINT "Enter proj,prog of account to correct: ";
	\  INPUT #1% P3%,P4%
	\  V% = SGN(A%(P3%,P4%))
	!  Get account and SGN test value

3080	IF V% = 0% THEN PRINT
	"That account is not registered at this time"
	\  PRINT
	\  GOTO 3070
	!  Make sure account is valid

3090	INPUT #1% "New name: ";F$
	\  PRINT
	\  X$ = FNC$(F$,P3%,P4%)
	\  PRINT "Name replaced"
	\  PRINT
	\  GOTO 3070
	!  Correct the name

3100	IF SGN(A%(P1%,P2%)) = 0% THEN PRINT
	"You aren't even registered!  I suggest that you run "+A2$+"MAIL to"
	\  &  "do so.  Until then I don't know who you are.  I can't correct"
	\  &  "a name I don't know, silly!"
	\  GOTO 10000
	!  Get rid of those not registered

3110	PRINT "Your service has been suspended by the system manager.  I won't"
	\  &  "correct your name until you see him in order to have your"
	\  &  "suspension revoked."
	\  GOTO 10000
	!  Get rid of those who are suspended

4000	!
			H E L P
	!
4010	PRINT "Would you like the brief help message (type 'B') or the more"
	\  &  "comprehensive help message (type 'C') ?"
	\  INPUT #1% Q$
	\  IF Q$ = "B" THEN PRINT
	\  PRINT "Commands are:"
	\  PRINT
	\  GOTO 145
	!  Get help level; if brief, print heading and go print it

4020	IF Q$ <> 'C' THEN PRINT
	\  GOTO 4010
	!  Insure valid command

4030	PRINT
	\  &  "Comprehensive Help message for "+A2$+"PSTOFC"
	\  &
	!  Print comprehensive help header

4040	PRINT "General Information"
	\  &
	\  &  "PSTOFC allows the user to perform certain MAIL related"
	\  &  "functions that are beyond the scope of the MAIL program."
	\  &
	\  &  "The user may list other users registered for mail, correct"
	\  &  "his/her name on the MAIL registration ledger, or get this help"
	\  &  "information."
	\  &
	\  &  "Commands are:  NAME, LIST, HELP, or EXIT."
	\  &
	!  Print general information

4050	IF O% THEN
	   &  "Privileged Users"
	\  &
	\  &  "Privileged users have greater control over the operation of the"
	\  &  "MAIL system. They have two commands not available to non-priv"
	\  &  "users. They are:  SUSPEND, and RENEW."
	\  &  "They allow the privileged user to suspend and renew the MAIL"
	\  &  "privilege of any registered mail receiver."
	\  &
	\  &  "Generally, PSTOFC gives the privileged user more power in"
	\  &  "operation."
	\  &
	!  Print priv general help

4060	PRINT "The Commands"
	\  &
	\  &  "NAME"
	\  &
	\  &  "The NAME command allows the user to correct his/her name."
	\  &  "Just type NAME when asked for a command and follow the"
	\  &  "instructions. YES or NO type questions can be answered by"
	\  &  "either a Y or an N."
	\  &
	!  Print header and NAME command information

4065	IF O% THEN
	PRINT "If a privileged user invokes the NAME command, he is permitted"
	\  &  "to change the name of ANY registered or suspended user."
	\  &
	!  Priv info

4070	PRINT "LIST"
	\  &
	\  &  "The LIST command allows the user to list registered receivers"
	\  &  "in one of 4 ways.  Listing ALL receivers by typing ALL will"
	\  &  "cause PSTOFC to print out the complete list of receivers."
	\  &  "Commands PROJ and PROG allow the user to list receivers by"
	\  &  "either project number or programmer number. The user specifies"
	\  &  "the project or programmer group to list. Finally, ACC lets the"
	\  &  "user list particular accounts that the user specifies."
	\  &  "Typing '?' gives a brief LIST subcommand help message."
	\  &
	!  Give LIST help

4080	IF O% THEN
	PRINT "LIST, when called by a privileged user, lists registered users"
	\  &  "AND suspended users, denoting suspension by a '(S)' following"
	\  &  "the user's name in a list."
	\  &
	!  Print additional priv-only information

4090	PRINT "HELP"
	\  &
	\  &  "The HELP command gives the user the choice of this comprehensive"
	\  &  "help message or a brief message. To get the comprehensive"
	\  &  "message, the user types 'C' and 'B' for the brief message."
	\  &
	!  HELP help!

4100	IF O% THEN
	PRINT "Privileged users get priv-only HELP information that is not"
	\  &  "available to non-privileged users."
	\  &
	!  Priv-only extra info

4110	PRINT "EXIT"
	\  &
	\  &  "EXIT exits the user from PSTOFC."
	\  &

4120	IF O% THEN
	PRINT "SUSPEND"
	\  &
	\  &  "The SUSPEND command lets the privileged user make the facilities"
	\  &  "of MAIL unavailable to other users. This is to prevent misuse"
	\  &  "of the MAIL system."
	\  &
	\  &  "RENEW"
	\  &
	\  &  "The RENEW command lets the privileged user return the MAIL"
	\  &  "facilities to a previously suspended user."
	\  &
	!  Privileged info

4130	PRINT "Control Characters"
	\  &
	\  &  "Two control characters are useful regarding PSTOFC operation."
	\  &  "CTRL/C performs a fast exit from PSTOFC, ending with a final"
	\  &  "message.  CTRL/Z typed at any query returns the user to PSTOFC"
	\  &  "command level, exiting from any routine in progress."
	\  &
	!  CTRL information

4140	PRINT "YES and NO questions"
	\  &
	\  &  "YES or NO type questions can be answered by either Y or N."
	\  &
	!  Query info

4150	PRINT
	\  PRINT "End of Comprehensive "+A2$+"PSTOFC help message"
	\  PRINT
	\  PRINT "A "+A2$+"MAIL help file is available by typing TY "+A2$+
	   "MAIL.HLP"
	\  PRINT
	\  PRINT
	!  End help message

4160	GOTO 10000
	!  Go get another command

5000	!
			L I S T
	!
5010	C%, S% = 0%
	\  CHANGE SYS(CHR$(6%)+CHR$(16%)+CHR$(0%)+CHR$(255%)) TO T%
	\  W% = T%(5%) - 1%
	!  Zero important variables; put terminal width into W%

5020	PRINT "How would you like your list?  (type '?' for help)"
	\  INPUT #1% M$
	\  PRINT
	!  Get listing mode desired

5030	IF M$ = '?' THEN PRINT
	\  &  "List Information"
	\  &
	\  &  "You may list registered receivers 4 ways.  Choose from listing"
	\  &  "all receivers (type 'ALL'), listing by account (type 'ACC'),"
	\  &  "listing by project number (type 'PROJ'), or listing by"
	\  &  "programmer number (type 'PROG')."
	\  &
	\  GOTO 5020
	!  Print a brief list mode help message

5040	IF M$ = "ALL" THEN 5050 ELSE
	IF M$ = "ACC" THEN 5120 ELSE
	IF M$ = "PROJ" THEN 5160 ELSE
	IF M$ = "PROG" THEN 5240 ELSE
	PRINT "That listing mode does not exist. Type '?' for help."
	\  PRINT "How would you like your list?"
	\  INPUT #1% M$
	\  PRINT
	\  GOTO 5030
	!  Dispatch based on mode entered; if invalid, get another

5050	!	List ALL receivers

5060	C%, S% = 0%
	\  FOR P3% = 0% TO 254%
	\  FOR P4% = 0% TO 254%
	!  Zero counters and start loop

5070	V% = SGN(A%(P3%,P4%))
	\  GOTO 5090 UNLESS V%
	\  GOTO 5080 IF V% = 1%
	\  GOTO 5080 IF V% IF O%
	\  GOTO 5090
	!  If not registered, get next account; print if registered;
	!  print if suspended and user is privileged else get next account

5080	F$ = FNN$(P3%,P4%)
	\  F$ = F$ + " (S)" IF V% = -1%
	\  P$ = '[' + NUM1$(P3%) + ',' + NUM1$(P4%) + '] - ' + F$
	\  X$ = FNP$(P$)
	\  IF V% = -1% THEN S% = S% + 1% ELSE C% = C% + 1%
	!  Get name; set up list item; add (S) to signal suspension if
	!  privileged; print item; add 1 to counter C% if registered, S%
	!  if suspended

5090	NEXT P4%
	\  NEXT P3%
	!  Continue looping

5100	PRINT IF POS(0%)
	\  PRINT IF (C% > 0%) OR (S% > 0%)
	\  PRINT "No registered MAIL receivers" UNLESS C%
	\  PRINT "Total of";C%;"registered MAIL receiver";FNS$(C%) IF C%
	\  PRINT S%;"suspended" IF S%
	\  PRINT
	!  Print totals

5110	GOTO 5020
	!  Go back for another listing mode

5120	!	List receivers by ACCount

5130	INPUT #1% "Account to list: ";P3%,P4%
	\  PRINT
	!  Get account

5135	IF P4% > 254% THEN GOSUB 10030
	\  GOTO 5130

5140	V% = SGN(A%(P3%,P4%))
	\  F$ = "SUSPENDED" IF V% = -1%
	\  F$ = "NOT REGISTERED" UNLESS V%
	\  F$ = FNN$(P3%,P4%) IF V% = 1%
	!  Get name or return account status

5150	P$ = '[' + NUM1$(P3%)+ ',' +NUM1$(P4%) + '] - ' + F$
	\  PRINT P$
	\  PRINT
	\  GOTO 5130
	!  Print account and go back for another

5160	!	List by PROJect number

5170	INPUT #1% "Project group to list: ";P3%
	\  PRINT
	!  Get project group

5180	C%, S% = 0%
	\  FOR P4% = 0% TO 254%
	!  Zero counters; initialize programmer loop

5190	V% = SGN(A%(P3%,P4%))
	\  GOTO 5210 UNLESS V%
	\  GOTO 5200 IF V% = 1%
	\  GOTO 5200 IF V% IF O%
	\  GOTO 5210
	!  See line 5070 documentation

5200	F$ = FNN$(P3%,P4%)
	\  F$ = F$ + " (S)" IF V% = -1%
	\  P$ = '[' + NUM1$(P3%) + ',' + NUM1$(P4%) + '] - ' + F$
	\  X$ = FNP$(P$)
	\  IF V% = 1% THEN C% = C% + 1% ELSE S% = S% + 1%
	!  Set up and print item; record in counters

5210	NEXT P4%

5220	PRINT IF POS(0%)
	\  PRINT IF (C% > 0%) OR (S% > 0%)
	\  PRINT "No registered receivers in ["+NUM1$(P3%)+",*]" UNLESS C%
	\  PRINT "Total of";C%;"registered receiver";FNS$(C%);" in ["+
	   NUM1$(P3%)+",*]" IF C%
	\  PRINT S%;"suspended" IF S%
	\  PRINT
	!  Print totals

5230	GOTO 5170
	!  Go get another project group

5240	!	List by PROGrammer number

5250	INPUT #1% "Programmer group to list: ";P4%
	\  PRINT
	!  Get prog group

5255	IF P4% > 254% THEN GOSUB 10030
	\  GOTO 5250
	!  If invalid entry, print error message and get another programmer

5260	C%, S% = 0%
	\  FOR P3% = 0% TO 254%
	!  Zero counter and begin project loop

5270	V% = SGN(A%(P3%,P4%))
	\  GOTO 5290 UNLESS V%
	\  GOTO 5280 IF V% = 1%
	\  GOTO 5280 IF V% IF O%
	\  GOTO 5290
	!  We've seen this before

5280	F$ = FNN$(P3%,P4%)
	\  F$ = F$ + " (S)" IF V% = -1%
	\  P$ = '[' + NUM1$(P3%) + ',' + NUM1$(P4%) + '] - ' + F$
	\  X$ = FNP$(P$)
	\  IF V% = 1% THEN C% = C% + 1% ELSE S% = S% + 1%
	!  Set up and print item; do counting

5290	NEXT P3%

5300	PRINT IF POS(0%)
	\  PRINT IF (C% > 0%) OR (S% > 0%)
	\  PRINT "No registered users in [*,"+NUM1$(P4%)+"]" UNLESS C%
	\  PRINT "Total of";C%;"registered receiver";FNS$(C%);" in [*,"+
	   NUM1$(P4%)+"]" IF C%
	\  PRINT S%;"suspended" IF S%
	\  PRINT
	!  Print totals

5310	GOTO 5250
	!  Go back for another programmer number

10000	!
		M O R E ?   Q U E R Y
	!
10010	PRINT
	\  PRINT "Will there be anything else?"
	\  INPUT #1% Q$
	\  IF LEFT(Q$,1%) = 'Y' THEN 10020 ELSE PRINT
	\  GOTO 32000
	!  See if there is anything else the user would like to do

10020	PRINT
	\  PRINT "What can I do for you?"
	\  INPUT #1% C$
	\  PRINT
	\  E% = 0%
	\  GOTO 100
	!  Get command; set error flag to first error; go process command

10030	!


	!	P R I N T    A   L I S T   E R R O R   M E S S A G E



10040	PRINT "Aww, c'mon!  Give me a PROPER account!!"
	\  PRINT
	!  Print the error message

10050	RETURN

20000	!
			F U N C T I O N S
	!
20010	DEF FNC$(X$,X%,Y%)
	!  This function replaces the name of user X%,Y% with X$

20020	IF LEN(X$) > 22% THEN PRINT
	"That name is too long - character limit is 22 characters, including"
	\  & "spaces.  Please re-enter your name in a shorter form."
	\  INPUT "Name";X$
	\  GOTO 20020
	!  If name exceeds 22 character limit, notify user, get name, and
	!  re-check it

20030	IF LEN(X$) < 3%   OR   INSTR(1%,X$," ") = 0% THEN PRINT
	"What is your FULL name? (first name AND last name) ";
	\  INPUT X$
	\  GOTO 20020
	!  If name is too short or there is no last name, then get full name
	!  and go check it for length, last name, etc.

20035	F$ = X$

20040	I% = A%(X%,Y%)
	\  I% = ABS(I%)
	\  R% = SWAP%(I%) AND 255%
	\  P% = I% AND 255%
	\  P% = P% + P%
	!  Break down address value according to MAIL algorithm in order
	!  to get position of name in NAMES.MAI 
	!  R% is the RECORD value
	!  P% is the offset value
	!  Fix negatives that indicate suspension

20047	CLOSE #3%
	\  OPEN A1$+'NAMES.MAI' AS FILE 3%,MODE 2%
	\  IF (STATUS AND 1024%) THEN CLOSE #3%
	\  SLEEP 1%
	\  GOTO 20047
	!  Go for write access on NAMES.MAI; if unable to get it, SLEEP and
	!  re-try until write access is obtained

20050	GET #3%, RECORD R%
	\  FIELD #3%,P% AS G$,32% AS N$
	\  LSET N$ = CVT$$(X$,32%)+SPACE$(32%-LEN(X$))
	\  PUT #3%, RECORD R%
	!  GET and FIELD the block, correct the name and write it in
	!  Force the name to upper case

20055	CLOSE #3%
	\  OPEN A1$+'NAMES.MAI' AS FILE 3%,MODE 8192%
	!  Relinquish write access; re-open in read-only mode

20060	FNEND

20070	DEF FNE$ = CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%)
	!  Return error message ERR

20080	DEF FNL$(X$)
	!  This function takes an upper-case name and converts it into
	!  mixed case, i.e. JOHN DOE becomes John Doe.

20090	FOR L% = 1% TO LEN(X$)
	\  G$ = MID(X$,L%,1%)
	\  A% = ASCII(G$)
	\  IF A% = 32% OR A% = 39% OR A% = 45% OR A% = 46% THEN L$ = L$ + G$
	\  GOTO 20110
	!  Loop, taking one character at a time. If it's a space, apostrophe,
	!  hyphen, or a period, then don't alter it; add it to L$.

20100	G$ = CHR$(A% + 32%)
	\  L$ = L$ + G$
	!  Convert a upper-case letter to a lower case one and add it to L$.
	!  L$ will become the name completely LOWER CASE

20110	IF A% = 39% OR A% = 45% THEN L% = L% + 1%
	\  L$ = L$ + MID(X$,L%,1%)
	!  Fix UC following apostrophe and hyphen in hyphenated names

20115	NEXT L%

20120	G$ = CHR$(ASCII(LEFT(L$,1%))-32%)
	\  L$ = G$ + RIGHT(L$,2%)
	!  Raise the first letter to upper-case

20130	G% = 1%
	!  Set INSTR starting point to first letter

20140	G1% = INSTR(G%,L$," ")
	\  GOTO 20170 UNLESS G1%
	!  Find letters following spaces; if no spaces, get out

20150	L$ = LEFT(L$,G1%) + CHR$(ASCII(MID(L$,G1%+1%,1%))-32%) +
	RIGHT(L$,G1%+2%)
	!  Re-form name after raising letter following space to upper-case

20160	G% = G1% + 1%
	\  GOTO 20140
	!  Reset INSTR starting point to point following last letter
	!  raised to upper-case

20170	FNL$ = L$
	\  L$ = ''
	!  Name is now in mixed case; nullify L$ for later use

20180	FNEND

20190	DEF FNN$(X%,Y%)
	!  This function returns the name of the user in [X%,Y%]

20200	I% = A%(X%,Y%)
	\  I% = ABS(I%)
	\  R% = SWAP%(I%) AND 255%
	\  P% = I% AND 255%
	\  P% = P% + P%
	!  Break down address value; get RECORD value (R%) and offset
	!  value (P%) for name slot in NAMES.MAI
	!  Fix negatives that indicate suspension

20210	GET #3%, RECORD R%
	\  FIELD #3%,P% AS G$,22% AS N$
	\  N$ = CVT$$(N$,4%+128%)
	\  FNN$ = FNL$(N$)
	!  Get name; convert it to mixed case and set equal to FNN$

20220	FNEND

20230	DEF FNP$(X$)
	!  This function does the printing of names for LIST

20240	GOTO 20270 IF POS(0%)

20250	PRINT X$;
	\  IF W% < 70% THEN PRINT
	\  GOTO 20285
	!  Print the item; if the terminal width is too small to allow another
	!  item to be printed, return the carriage

20260	PRINT TAB(36%);
	\  GOTO 20285

20270	P9% = POS(0%)

20275	PRINT X$;
	\  IF (P9% + 36% + 34%) >= W% THEN PRINT
	\  GOTO 20285
	!  Print the item; if another item would overshoot width, then
	!  return the carriage to the left margin

20280	PRINT TAB(P9% + 36%);

20285	FNEND

20290	DEF FNS$(X%)
	!  Adds 's' if necessary

20300	FNS$ = ''
	\  IF X% > 1% THEN FNS$ = 's'
	!  If more than 1, add an 's'

20310	FNEND

30000	!
		E R R O R   H A N D L I N G
	!
30010	X$ = SYS(CHR$(6%)+CHR$(-7%))
	\  IF ERR = 28% THEN PRINT
	\  RESUME 32000
	!  On CTRL/C, go to fast exit

30015	IF ERR=11% THEN RESUME 10020 UNLESS ERL = 10020%
	!  Go to PSTOFC command level on a CTRL/Z

30017	IF ERR=11% THEN PRINT
	\  RESUME 32000

30020	IF ERR = 5% AND ERL = 60% THEN PRINT
	"I am missing my data files so I can't help you.  Please do me a"
	\  &  "favor and tell the system manager of this problem so that the"
	\  &  "error condition can be fixed.  Thank you."
	\  &
	\  RESUME 32000
	!  If no data files, tell user and get out

30030	IF ERL=5140% THEN GOSUB 10030
	\  RESUME 5130%

30035	IF ERL = 5130% THEN GOSUB 10030
	\  RESUME 5130

30040	IF ERL=5190% THEN GOSUB 10030
	\  RESUME 5170%

30050	IF ERL=5270% THEN GOSUB 10030
	\  RESUME 5250

30100	IF ERL=60% AND ERR=10% THEN PRINT
	\  PRINT "PSTOFC has been temporarily disabled - try again later"
	\  PRINT
	\  RESUME 32000

30700	IF ERR=50% OR ERR=59% THEN PRINT
	\  PRINT "That account format is invalid.  Please re-enter the PPN"
	\  PRINT "without brackets, parentheses, or wildcards, using a comma"
	\  PRINT "to separate the proj from the programmer #, if necessary."
	\  PRINT
	\  RESUME

30900	PRINT "?Unexpected error - ";FNE$;" at line ";ERL
	\  PRINT
	!  Print unexpected error message

32000	!
		E X I T
	!
32010	CLOSE #1%,2%,3%
	\  PRINT "Good day!"
	\  X$ = SYS(CHR$(9%))
	!  Close all files; print closing message; exit clearing core

32767	END
