1	!


	!		M A I L U P


2	!	Program:	MAILUP
		Version:	V06A
		Edit:		02A
		Edit Date:	11-Jun-80
		Author:		Brant Cheikes
		System:		PDP-11  RSTS/E V06C-03 or later
		Affiliation:	Nassau Community College
	!
3	!
	!		Program Description
	!
	!  MAILUP is a MAIL system utility program for PRIVILEGED users only!
	!  It permits the privileged user to properly initialize and copy the
	!  data files so important to the MAIL system.  Without proper
	!  initialization or copying, many unexpected errors such as
	!  '?Illegal number' will occur.
	!
	!  Suggested MAILUP.BAC protection code:  <124>
	!
5	!
	!		Possible Query Responses
	!
	!  The 'Function?' Query
	!
	!  There are 6 possible responses to the 'Function?' query. Typing
	!  a RETURN is the same as typing INIT, which is the initialization
	!  function.  COPY is the copy data files function.  EXIT or CTRL/Z
	!  will exit the user to BASIC-PLUS command level, clearing MAILUP
	!  from memory.  Any other response results in the printing of a
	!  brief list of valid 'Function?' responses.
	!
	!
	!		The Data Files
	!
	!   File		Description
	!
	!  ACCT.MAI		Virtual array file containing test values and
	!			name indexes as described in MAIL.BAS.
	!			Protection code:  <60>
	!			Size:  approx. 255 blocks
	!			DIMensioned 254% x 254% as an integer
	!			array.
	!
	!  NAMES.MAI		Record I/O files for storage of names of all
	!			registered MAIL users.  16 names to a record
	!			(block) - ACCT.MAI has index values into it as
	!			explained in MAIL.BAS.
	!			Protection code:  <60>
	!			Size begins at 1 block and expands as more
	!			accounts become registered.
	!
	!  NOTE:  An explanation of the MAIL algorithm can be found within the
	!         the source of MAIL.
	!
7	!
	!
	!		The Functions
	!
	!	*** INIT *** (the default)
	!
	!  The INIT function allows the privileged user to initialize the
	!  critical MAIL data files.  It involves creating the files, zeroing
	!  ACCT.MAI and putting the initial values into NAMES.MAI.  If the
	!  data files are not properly initialized, unexpected errors will
	!  result.  The default data file storage account is 1,2 which can
	!  be overridden when asked for the initialization account.
	!
	!  If, for any reason, output files pre-exist, the user will be notified
	!  and given a choice between supersession or a new initialization
	!  account.
	!
	!  When the INIT procedure is finished, the user will be notified and
	!  MAILUP will request another function.
	!
	!
	!	*** COPY ***
	!
	!  The COPY function allows the user to copy the data files from one
	!  account to another without any loss of names or data while
	!  maintaining the integrity of the data files.  The user must specify
	!  which account to copy from and the output account.  If output files
	!  pre-exist, the program will notify the user and give him the
	!  choice of superseding them or giving a new output account.
	!
	!
	!  NOTE:   Whenever the storage account of the data files is changed,
	!          the programs MAIL and PSTOFC must be modified also.
	!          Lines 20 of both programs must be changed as follows:
	!
	!  20 A1$="(x,y)"	where x is the project number of the new
	!			storage account and y is its programmer
	!			number.  A logical may be used as may be a
	!			account representation character, e.g. '%'.
	!
	!  	   This change is VERY important! Without it, MAIL and PSTOFC
	!	   will give '?Missing data files' errors.  A look at the
	!	   source programs will explain why A1$ is so important.
	!
10	!
	!		Channel Usage
	!
	!	Channel		Used for
	!
	!	   1%,3%	Accessing ACCT.MAI
	!
	!	   2%,4%	Accessing NAMES.MAI
	!
12	!
	!		Variable Description
	!
	!	Variable	Use
	!
	!	  A%( , )	Virtual array matrix
	!	  F$		Function
	!	  I$		Input account string
	!	  I%( , )	Input virtual array file matrix
	!	  I2$		Holds a block input from NAMES.MAI
	!	  O$		Output account string
	!	  O2$		Output buffer string for NAMES.MAI
	!	  O%( , )	Output virtual array matrix
	!	  P$		Holds next available position into NAMES.MAI
	!	  P1%		COPY from project number
	!	  P2%		COPY from programmer number
	!	  P3%		COPY to project number
	!	  P4%		COPY to programmer number 
	!	  R$		Holds RECORD value for index into NAMES.MAI
	!	  R%		Loop variable
	!	  S$		Answer to 'Supersede?' query
	!
15	!
			Modification History

16	!	  V06A-01       30-Jul-79	New release
	!	  V06A-02	25-Sep-79	General repairs
	!	  V06A-02A	11-Jun-80	Fix initialization errors

19	!
		M A I N   P R O G R A M   C O D I N G
	!
20	ON ERROR GOTO 30000
25	V$ = "V06A-02A"
	!  Set up version/edit level

30	PRINT
	\ PRINT "MAILUP   "+V$+"   "+
	  CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%)
	\ PRINT "MAIL System Utility"
	\ PRINT
	!  Output the system header

40	!
		C O M M A N D   S E C T I O N
	!
50	INPUT "Function?  <INIT>  ";F$
	\ PRINT
	\ IF F$="INIT" OR F$='' THEN 100 ELSE
		IF F$="COPY" THEN 1000  ELSE
			IF F$="EXIT" THEN 32000 ELSE 60
	! Check for valid function

60	PRINT "?Invalid function"
	\ PRINT
	\ PRINT "Valid functions are:"
	\ PRINT
	\ &     "INIT or <RETURN> 	- initialize the MAIL data files"
	\ &     "COPY			- copy the data files from one"
	\ &     "			  account to another"
	\ &     "EXIT or CTRL/Z		- to exit from MAILUP"
	\ &     "Any other to get this help message"
	\ &
70	GOTO 40
100	!
		I N I T I A L I Z E   D A T A   F I L E S
	!
110	PRINT "In which account would you like the data"
	\ &"files initialized?  <[1,2]>  ";
	\ INPUT LINE I$
	\ IF CVT$$(I$,4%)='' THEN I$="[1,2]"
	\ GOTO 130
	! Get the account - default is system library 1,2

120	I$=CVT$$(I$,4%)
	\ I$='['+I$+']'
	! Format the account if default isn't used

130	PRINT
	\ OPEN I$+'ACCT.MAI' FOR INPUT AS FILE 1%
	\ OPEN I$+'NAMES.MAI' FOR INPUT AS FILE 2%,MODE 1%
	\ S% = -1%
	\ PRINT "Output files exist in "+I$+".  Supersede?  <NO>  ";
	\ INPUT S$
	\ IF LEFT(S$,1%)="Y" THEN 140 ELSE PRINT
	\ CLOSE #1%,2%
	\ GOTO 100
	! Try to open all files; if successful, set flag and see if user
	! wants to supersede the preexisting files

140	OPEN I$+'ACCT.TMP' FOR OUTPUT AS FILE 3%
	\ OPEN I$+'NAMES.TMP' FOR OUTPUT AS FILE 4%
	\ PRINT "Files open in "+I$+" - initializing"
	! Open temporary output files and notify user

150	DIM #3%,A%(254%,254%)
	! Dimension virtual array file as an integer matrix

160	MAT A%=ZER
	! Zero all non-0 elements

170	FOR R%=0% TO 254%
	\ A%(R%,0%)=0%
	\ A%(0%,R%)=0%
	\ NEXT R%
	\ CLOSE #3%
	! Zero all zero elements and close up

180	! ACCT.MAI zeroed - now PUT initial values into NAMES.MAI

190	FIELD #4%,2% AS R$,2% AS P$
	\ LSET R$=CVT%$(1%)
	\ LSET P$=CVT%$(32%)
	\ PUT #4%,RECORD 1%
	! Do the PUT

200	CLOSE #4%
	\ KILL I$ + 'ACCT.MAI' IF S%
	\ KILL I$ + 'NAMES.MAI' IF S%
	\ CLOSE #1%,2% IF S%
	\ NAME I$ + 'ACCT.TMP' AS I$ + 'ACCT.MAI<60>'
	\ NAME I$ + 'NAMES.TMP' AS I$ + 'NAMES.MAI<60>'
	\ PRINT
	\ PRINT "All files initialized - MAIL system up!"
	! Close last temporary file; delete preexisting files and close them
	! if flag was set indicating they existed; rename temp files to
	! permanent files and close up

210	PRINT
	\ GOTO 40
	! Go back for next function

1000	!
		C O P Y   D A T A   F I L E S
	!
1010	INPUT "COPY from which account";P1%,P2%
	\ I$='['+NUM1$(P1%)+','+NUM1$(P2%)+']'
	\ OPEN I$+'ACCT.MAI' FOR INPUT AS FILE 1%
	\ OPEN I$+'NAMES.MAI' FOR INPUT AS FILE 2%,MODE 1%
	! Make sure input files exist

1020	INPUT "COPY to which account";P3%,P4%
	\ O$='['+NUM1$(P3%)+','+NUM1$(P4%)+']'
	\ OPEN O$+'ACCT.MAI' FOR INPUT AS FILE 3%
	\ OPEN O$+'NAMES.MAI' FOR INPUT AS FILE 4%
	\ CLOSE #3%,4%
	\ PRINT
	\ PRINT "Output files exist in "+O$+".  Supersede?  <NO>  ";
	\ INPUT S$
	\ IF LEFT(S$,1%)="Y" THEN 1030 ELSE PRINT
	\ GOTO 1020
	! Make sure output files DON'T exist - if so 'Supersede?'

1030	OPEN O$+'ACCT.MAI<60>' FOR OUTPUT AS FILE 3%
	\ OPEN O$+'NAMES.MAI<60>' FOR OUTPUT AS FILE 4%
	\ PRINT
	\ PRINT "All files open - copying..."
	\ PRINT
	! Notify user; possibly supersede output files
	! Try to shut down the MAIL system by opening NAMES.MAI in
	! update mode

1040	DIM #1%,I%(254%,254%)
	\ DIM #3%,O%(254%,254%)
	! Dimension both virtual array files as integer matrices

1050	FOR R%=0% TO 254%
	\ O%(R%,C%)=I%(R%,C%) FOR C%=0% TO 254%
	\ NEXT R%
	! COPY the virtual array files

1060	! ACCT.MAI copied at this point, now copy NAMES.MAI

1080	GET #2%
	\ PUT #SWAP%(2%)+4%
	\ GOTO 1080
	! COPY files using alternate buffer technique

1090	CLOSE #1%,2%,3%,4%
	\ PRINT "All files copied."
	\ PRINT
	! CLOSE all files and notify user

1100	GOTO 40
	! Go back for next function

10000	!
		S U B R O U T I N E S
	!
10010	PRINT

10015	PRINT "?Bad account format"
	\ PRINT

10020	PRINT "Please enter PPN without brackets, parentheses or wildcards."
	\  PRINT "Use a comma to separate the project from the programmer #."
	\  PRINT

10030	RETURN

20000	!
		F U N C T I O N S
	!
20010	DEF FNE$=CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%)
	! Return error messages

30000	!
		E R R O R   T R A P P I N G
	!
30010	IF ERL=1080% AND ERR=11% THEN RESUME 1090
	!  Resume next line on EOF error on copy

30020	IF ERR=11% THEN RESUME 32000
	!  Exit fast on ^Z

30030	IF ERL=130% AND ERR<>10% THEN IF ERR=5% THEN RESUME 140 ELSE
	IF ERR=5% THEN GOSUB 10015
	\ RESUME 110

30040	IF ERL=1010% AND ERR=5% THEN PRINT
	"?Missing input data files in account "+I$
	\  PRINT
	\  RESUME 1010

30060	IF ERL=1020% AND ERR=5% THEN CLOSE #3%
	\  RESUME 1030
	!  If no files (which is OK) then resume next line

30070	IF ERL=1010% OR ERL=1020% THEN GOSUB 10000 UNLESS ERR=10%
	\  RESUME

30080	IF ERR=10% THEN IF ERL=130% OR ERL=1010% THEN PRINT
	\  PRINT "The MAIL system is in use - try again later"
	\  RESUME 32000

30090	IF ERR=5% AND ERL=140% THEN PRINT "?That account doesn't exist"
	\ PRINT
	\ RESUME 100
	! Error on OPEN FOR OUTPUT, so no account; tell user and reprompt

30100	IF ERR=5% AND ERL=1030% THEN PRINT "?That account doesn't exist"
	\ PRINT
	\ RESUME 1020

30200	IF ERL=130% THEN GOSUB 10015
	\ RESUME 100

30950	PRINT "?Unexpected error - ";FNE$;" at line";ERL
	\ RESUME 32000
	! On unexpected error, exit

32000	!
		E X I T 
	!
32010	X$=SYS(CHR$(9%))
	! Clear memory and exit

32767	END
