1	!


		HALFCE    BALANCING REDOX EQUATIONS BY HALF-CELL METHOD


9!		RICHARD T. O'NEILL, XAVIER UNIVERSITY, CINCINNATI OH 45207

11!		COPYRIGHT BY XAVIER UNIVERSITY, CINCINNATI  1978

20	!


	!MODIFICATION HISTORY OF THE PROGRAM



21!	FEBRUARY 1978
37 L5$=SYS(CHR$(6%)+CHR$(-7%))
\	ONERRORGOTO 19000
\	L7$="BEGUN"
\	L6$=CVT$$(TIME$(0%),2%)
\	PRINT"PRIVACY WARNING! USAGE IS BEING RECORDED"
100!
		THIS PROGRAM GIVES THE USER THE TWO SPECIES OF A CHEMICAL
	COUPLE AND ASKS HIM TO IDENTIFY THE OXIDATION NUMBERS, THE REDUCING
	AGENT, AND THE NUMBER OF ELECTRONS LOST.  THE COUPLE IS THEN PUT
	IN STANDARD OXIDATION POTENTIAL FORM AND THE USER ASKED TO BALANCE
	CHARGE (VIA H+) AND H ATOMS (VIA H2O).  THE PROCESS IS REPEATED
	FOR A SECOND COUPLE.
		THE USER IS THEN GIVEN THE TWO HALF CELL REACTIONS HE
	HAS BALANCED, AND TOLD TO CONSTRUCT A COMPLETE EQUATION FOR
	GIVEN REACTANT BY MULTIPLYING EACH EQUATION BY A (DIFFERENT)
	CONSTANT, AND THEN SUBTRACTING ONE EQUATION FROM THE OTHER.
		EXTENSIVE ERROR CHECKING AND HELP MESSAGES ARE
	PROVIDED DURING THE PROGRAM.


400!
	VARIABLE DEFINITIONS

	N9	NUMBER OF CODED HALF CELLS. SEE LL.2100,9000 FF.
	A$(I,1) ELEMENT INVOLVED IN COUPLE
	A$(I,2)	REDUCING AGENT (LEFT SIDE OF COUPLE)
	A$(I,3) OXIDIZING AGENT (RIGHT SIDE OF COUPLE)
	A(I,1)	OXIDATION NUMBER IN REDUCING AGENT
	A(I,2)	NUMBER OF A$(I,1) ATOMS IN REDUCING AGENT
	A(I,3)	IONIC CHARGE ON REDUCING AGENT
	A(I,4)	OXIDATION NUMBER IN OXIDIZING AGENT
	A(I,5)	NUMBER OF A$(I,1) ATOMS IN OXIDIZING AGENT
	A(I,6)	IONIC CHARGE ON OXIDIZING AGENT
	A(I,7)	NUMBER H+'S ON LEFT SIDE (NEG.IF ON RIGHT)
	A(I,8)	NUMBER H2O'S ON LEFT SIDE (NEG.IF ON RIGHT)
	A(I,9)	OXIDATION POTENTIAL


410!	C(I,J)		COEFFICIENTS IN HALF REACTIONS
			I=1,2		1ST,2ND HALF REACTION
			J=1,2,3,4,5	RA, OA, H+, H2O, (E-)

751	! FUNCTION FNZ1$  (LF1002) RESERVES:
	  VARIABLES SENT:
		Z1% - HORIZONTAL (X) COORDINATE  (COLUMNS 0-79)
		Z2% - VERTICAL (Y) COORDINATE  (ROWS 0-23)
		Z$ - STRING TO BE DISPLAYED


810	!
	GOSUB 10000
	ROUTINE TO GET HALF CELLS IN OXIDATION POTENTIAL ORDER

820	!
	GOSUB 11000
	ROUTINE TO ERASE SCREEN FROM LINE Z9% TO BOTTOM

830	!
	GOSUB 12000
	ROUTINE TO PRINT HALF REACTION
881	!
	  FUNCTION FNZ1$(Z1%,Z2%,Z$)  AT LINE 27100  (LF1002)
	  CURSOR CONTROL FOR THE ADDS-580 & ADDS-520
	  PRINTS CHARACTER AT THE SPECIFIED GRID COORDINATES.
	  TO USE:  PRINT FNZ1$(Z1%,Z2%,Z$)
	   -- SEE "HOW TO USE THE ADDS-580" IN THE MANUAL RACK.


900	DIM A$(3%,3%),A(3%,9%)
910	DIM C(2%,5%),B(6%)
1000	ON ERROR GOTO 19000
		! SET UP STANDARD ERROR TRAP
		THIS BEGINS THE PROGRAM PROPER. THIS LINE CAN
		DEFINE CTRL/C TRAP SYS CALL.
1020	RANDOMIZE
2000	!


	!	P A R T  I

	!CHOOSE HALF CELLS AND PREPARE THE USER


2010	!!!! GOTO 2030 IF WISH TO SKIP INSTRUCTIONS
2020	PRINT
	\PRINT"THIS PROGRAM SHOULD BE RUN **ONLY** ON ADDS-580"
	\PRINT"OR ADDS-520 TERMINALS.  IF YOU ARE WORKING ON ANY"
	\PRINT"OTHER TYPE OF TERMINAL (E.G. A DEC-WRITER),"
	\PRINT"CONTROL/C THIS PROGRAM **NOW** , SIGN OFF, AND "
	\PRINT"SIGN BACK ON ON THE CORRECT TYPE OF TERMINAL."
	\PRINT
	\SLEEP (6)
2030	LET N9=38
2040	FOR J%=2% TO 3%
	\	LET N=INT((N9-1)*RND+1)
	\	FOR P%=1% TO N
	\		READ N1,A$(J%,1%),A$(J%,2%)
	\		READ A(J%,Q%) FOR Q%=1% TO 3%
	\		READ A$(J%,3%)
	\		READ A(J%,Q%) FOR Q%=4% TO 9%
	\	NEXT P%
	\RESTORE
	\NEXT J%
	!  READ TWO HALF CELLS AT RANDOM
2050	IF A(2%,9%)=A(3%,9%) OR A$(2%,2%)=A$(3%,3%) OR A$(3%,2%)=A$(2%,3%)
	THEN 2040
2060	P%=1%
	\IF A(2%,9%)<A(3%,9%) THEN Q%=3%
			      ELSE Q%=2%
2070	GOSUB 10000
	\IF Q%=3% THEN 3020
		  ELSE P%=2%
	\Q%=3%
	\GOSUB 10000
	! PUT THE TWO HALF CELLS IN RIGHT ORDER: A(1,?),A(2,?)

3000	!


	!	P A R T  II

	! USER DETERMINES THE OXIDATION NUMBERS FOR THE COUPLE

3010	P%=1%		!ASK QUESTIONS ABOUT THE FIRST HALF CELL
3020	PRINT CHR$(12%)
	\E%=0%
	\N1%=0%
	\IF INT(2*RND+1)>1 THEN N1%=2%
	\N2%=3%			! DISPLAY OXIDIZING AGENT FIRST
3030	IF N1%=0% THEN N1%=3%
	\N2%=2%			! DISPLAY REDUCING AGENT FIRST
3040	PRINT"CONSIDER THE TWO CHEMICALS:"
	\PRINT
	\PRINT TAB(20%);A$(P%,N1%);TAB(30);"AND";TAB(40);A$(P%,N2%)
3050	X%=N1%
	\Y%=1%
3060	!!!! GOTO 5000 IF WISH TO SKIP TO PART IV
3100

	PRINT FNZ1$(0%,10%,"")
	\PRINT"WHAT IS THE OXIDATION NUMBER OF ";A$(P%,1%);" IN ";A$(P%,X%);
	\INPUT B
	\IF B=A(P%,-5%+3%*X%) THEN PRINT CHR$(6%)
	\PRINT FNZ1$(15%,22%,"RIGHT !")
	\GOTO 3130			! 1ST QUESTION
3110	PRINT"SORRY, THAT'S NOT CORRECT."
	\Z9%=10%
	\E%=E%
	\E%=E%+1%
	\IF E%=2% THEN 3120 ELSE PRINT FNZ1$(0%,17%,"")
	\PRINT"REMEMBER THAT THE SUM OF ALL THE OXIDATION NUMBERS OF ALL"
	\PRINT"THE ATOMS IN ";A$(P%,X%);" HAS TO EQUAL THE IONIC CHARGE,"
	\PRINT"IN THIS CASE ";A(P%,-3%+3%*X%);"."
	\PRINT"(OXYGEN IS -2 EXCEPT IN PEROXIDES, THE ELEMENT, AND SOME";
	\PRINT" F COMPOUNDS."
	\PRINT"HYDROGEN IS USUALLY +1.)"
	\GOSUB 11000
	\GOTO 3100
3120	PRINT FNZ1$(0%,17%,"");"NO, THE OXIDATION NUMBER OF ";A$(P%,1%);" IN ";A$(P%,X%);
	\PRINT" IS ";A(P%,-5%+3%*X%);"."
	\GOTO 3130
3130	E%=0%
	\PRINT FNZ1$(20%*Y%,4%,"("+NUM1$(A(P%,-5%+3%*X%))+")")
	\Z9%=10%
	\GOSUB 11000
3200	IF X%=N2% THEN 4000 ELSE X%=N2%
	\Y%=2%
	\GOTO 3100
4000	!


	!	P A R T III

	! USER DETERMINES BALANCED HALF REACTION FOR THE COUPLE

4001	L7$="FINISHED OXIDATION NUMBER PART"
4005	E%=0%
	\PRINT"AN OXIDATION HALF REACTION CAN BE CONSTRUCTED FROM"
	\PRINT"THE COUPLE ABOVE.  THE REDUCING AGENT (THE CHEMICAL"
	\PRINT"WITH THE LOWER OXIDATION NUMBER) GOES ON THE LEFT OF"
	\PRINT"THE ARROW, AND THE OXIDIZING AGENT (THE CHEMICAL WITH"
	\PRINT"THE HIGHER OXIDATION NUMBER) GOES ON THE RIGHT." \ PRINT
4010	INPUT"WHICH CHEMICAL (OXIDIZED FORM, REDUCING AGENT) GOES ON THE LEFT ";B$
	\IF B$=A$(P%,2%) THEN PRINT "CORRECT !!!"
	\GOTO 4100
4020	E%=E%+1%
	\IF E%=2% THEN 4030 ELSE PRINT "NO, TRY AGAIN."
	\GOTO 4010
4030	PRINT FNZ1$(0%,19%,"");"SINCE ";A(P%,1%);",THE OXIDATION NUMBER IN ";A$(P%,2%);", IS LESS"
	\PRINT"THAN ";A(P%,4%);",THE OXIDATION NUMBER IN ";A$(P%,3%);
	\PRINT","
	\PRINT A$(P%,2%);" GOES ON THE LEFT."
	\SLEEP (8)
	\GOTO 4100
4100

	E%=0%
	\PRINT CHR$(12%)
	\PRINT FNZ1$(2%,2%,A$(P%,2%))
	\PRINT FNZ1$(25%,2%,"-->")
	\PRINT FNZ1$(31%,2%,A$(P%,3%))
	\PRINT FNZ1$(2%,3%,"("+NUM1$(A(P%,1%))+")")
	\PRINT FNZ1$(31%,3%,"("+NUM1$(A(P%,4%))+")")
	\PRINT FNZ1$(0%,10%,"")
	\PRINT"IN ORDER TO BALANCE THIS HALF REACTION, ELECTRONS MUST"
	\PRINT"BE ADDED TO THE RIGHT SIDE." \ PRINT
4110	PRINT"HOW MANY ELECTRONS MUST THE ";A$(P%,2%);" LOSE WHEN IT"
	\PRINT"BECOMES ";A$(P%,3%);
	\E=A(P%,2%)*(A(P%,4%)-A(P%,1%))
4120	INPUT X
	\IF X=E THEN 4200 ELSE E%=E%+1%
	\IF E%<>1% THEN 4150 ELSE PRINT "NO, ";
	\PRINT FNZ1$(0%,18%,"");"EACH ";A$(P%,1%);" ATOM CHANGES FROM ";A(P%,1%);" TO ";
	\PRINT A(P%,4%);
	\IF A(P%,2%)=1% THEN PRINT"."
	\GOTO 4140
4130	PRINT", AND"
	\PRINT"THERE ARE ";A(P%,2%); "ATOMS OF ";A$(P%,1%);" IN ";A$(P%,2%);
	\PRINT".";
4140	PRINT"TRY AGAIN."
	\Z9%=10%
	\GOSUB 11000
	\GOTO 4110
4150	PRINT FNZ1$(0%,17%,"")
	\PRINT"NO, EACH ";A$(P%,1%);" ATOM LOSES";A(P%,4%)-A(P%,1%);
	\PRINT"ELECTRON(S) (GAINS THAT MANY OXIDATION NUMBERS) AND "
	\IF A(P%,2%)=1 THEN 4160 ELSE
	 PRINT "THERE ARE";A(P%,2%);A$(P%,1%);" ATOMS PER ";A$(P%,2%);"UNIT,"
	\GOTO 4170
4160	PRINT"THERE IS ONLY ONE ";A$(P%,1%);" ATOM PER ";A$(P%,2%);" UNIT,"
4170	PRINT"SO ";E;"ELECTRON(S) MUST BE ADDED ON THE RIGHT."\SLEEP (8)
4200	

	PRINT FNZ1$(64%,2%,"+ "+NUM1$(E)+"(E-)")
	\Z9%=10%\GOSUB 11000
	\W=A(P%,2%)/A(P%,5%)
	\PRINT FNZ1$(0%,17%,"")
	\PRINT "NEXT THE ATOMS WHICH CHANGED OXIDATION NUMBER MUST"
	\PRINT"BE BALANCED."
	\IF W=INT(W) THEN 4210 ELSE W=W
	\PRINT FNZ1$(0%,21%,"(AT");" THIS STAGE IT IS NOT IMPORTANT THAT";W;"IS NOT ";
	\PRINT"AN INTEGER.)"
4210	PRINT FNZ1$(31%,3%,SPACE$(6%)); CHR$(6%),FNZ1$(0%,2%,"1")
	\PRINT CHR$(6%),FNZ1$(29%,2%,NUM1$(W))
	\Z9%=10%
	\GOSUB 11000
4300

	PRINT FNZ1$(0%,10%,"");"OXIDATION NUMBERS (AND THUS ELECTRONS) HAVE BEEN BALANCED." \ PRINT
	\INPUT"IS THE CHARGE BALANCED (YES OR NO)";B$
	\IF A(P%,7%)=0 AND LEFT(B$,1%)="Y" THEN 4400 ELSE
	 IF A(P%,7%)<>0 AND LEFT(B$,1%)="N" THEN 4310 ELSE
	PRINT FNZ1$(0%,17%,"NO, ");"THE CHARGE ON THE LEFT IS ";A(P%,3%)
	\PRINT"AND THE CHARGE ON THE RIGHT IS";W;"(";A(P%,6%);
	\PRINT")  -  ";E;"=";W*A(P%,6%)-E  \  SLEEP (8)
4305	IF A(P%,7%)=0 THEN PRINT "THE CHARGE IS BALANCED."
	\GOTO 4400
4310	Z9%=10%
	\GOSUB 11000
	\PRINT"SINCE THE REACTION TAKES PLACE IN ACID SOLUTION, CHARGE"
	\PRINT"CAN BE BALANCED BY ADDING  H+  IONS TO ONE SIDE OR THE"
	\PRINT"OTHER." \ PRINT
	\INPUT"TO WHICH SIDE (LEFT OR RIGHT) SHOULD THE H+'S BE ADDED";B$
	\IF A(P%,7%)>0 AND LEFT (B$,1%)="L" THEN 4320 ELSE
	 IF A(P%,7%)<0 AND LEFT(B$,1%)="R" THEN 4320 ELSE
	 PRINT"NO, ";
	\GOTO 4330
4320	PRINT"YES, ";
4330	B%=0%
	\IF A(P%,7%)>0 THEN B$="LEFT" ELSE B$="RIGHT"
	\B%=30%
4340	PRINT FNZ1$(0%,17%,"");"H+ IONS MUST BE ADDED TO THE ";B$;" SIDE."
4350	Z9%=10%
	\GOSUB 11000
	\PRINT"HOW MANY H+ IONS MUST BE ADDED TO THE ";B$;
	\INPUT X
	\PRINT FNZ1$(B%+10%,2%,"+ "+NUM1$(X) + "H+")
	\PRINT FNZ1$(0%,10%,"")
	\IF X= ABS(A(P%,7%)) THEN PRINT FNZ1$(17%,17%,"CORRECT !!!")
	\PRINT"(AT THIS STAGE IT IS NOT IMPORTANT THAT";X;"ISN'T AN INTEGER"
			IF X<>INT(X)
	\GOTO 4400
4360	PRINT FNZ1$(0%,17%,"");"YOUR CHARGE BALANCE GIVES :"  \  PRINT
	\PRINT TAB(4%);A(P%,3%);TAB(16%);
	\PRINT "+ ";X; IF B%=0%
	\PRINT TAB(30%);"---> ";
	\PRINT W*A(P%,6%);TAB(52%);
	\PRINT "+ ";X; IF B%=30%
	\PRINT TAB(64%);"-";E \ PRINT
	\PRINT"THIS IS NOT CORRECT.  TRY AGAIN."
	\SLEEP (8)
	\PRINT FNZ1$(B%+10%,2%,SPACE$(6%))
	\GOTO 4350
4400

	Z9%=10%
	\GOSUB 11000
	\INPUT"ARE  H  ATOMS BALANCED (YES OR NO)";B$
	\IF A(P%,8%)=0% AND LEFT(B$,1%)="Y" THEN 4500 ELSE
	 IF A(P%,8%)<>0 AND LEFT(B$,1%)="N" THEN 4410 ELSE
	 PRINT"NO, THE HYDROGEN ATOMS ARE ";
	\PRINT "NOT "; IF A(P%,8%)<> 0
	\PRINT "BALANCED."
4405	IF A(P%,8%)=0 THEN 4500
4410	PRINT"HYDROGEN ATOMS CAN BE BALANCED BY ADDING  H2O MOLECULES"
	\PRINT"TO ONE SIDE OR THE OTHER."
	\INPUT"TO WHICH SIDE (LEFT OR RIGHT) SHOULD THEY BE ADDED";B$
	\IF A(P%,8%)<>0 AND LEFT(B$,1%)="L" THEN 4420 ELSE
	 IF A(P%,8%)=0 AND LEFT(B$,1%)="R"  THEN 4420 ELSE
	 PRINT"NO, ";
	\GOTO 4430
4420	PRINT FNZ1$(0%,16%,"CORRECT !")
4430	B%=0%
	\IF A(P%,8%)>0 THEN B$="LEFT" ELSE B$="RIGHT"
	\B%=29%
4440	PRINT FNZ1$(0%,17%,"");"H2O MOLECULES MUST BE ADDED TO THE ";B$;" SIDE."
4450	Z9%=10%
	\GOSUB 11000
	\PRINT"HOW MANY H2O'S MUST BE ADDED TO THE ";B$;
	\INPUT X
	\PRINT FNZ1$(B%+17%,2%,"+ "+NUM1$(X) + "H2O")
	\IF X=ABS(A(P%,8%)) THEN PRINT FNZ1$(17%,17%,"RIGHT !!!")
	\PRINT"(IT IS NOT IMPORTANT AT THIS STAGE THAT";X;"ISN'T AN INTEGER.)" UNLESS X=INT(X)
	\GOTO 4500
4460	PRINT FNZ1$(0%,17%,"LOOK AGAIN!");" THE NUMBER OF HYDROGENS ON THE LEFT"
	\PRINT"ISN'T THE SAME AS THE NUMBER ON THE RIGHT.  TRY AGAIN." \ SLEEP (3)
	\PRINT FNZ1$(B%+17%,2%,SPACE$(8%))
	\GOTO 4450
4500

 	PRINT"YOU NOW HAVE A COMPLETE BALANCED HALF REACTION !!!"\SLEEP(8)
	\IF P%=2% THEN 5000 ELSE P%=2%
	\PRINT CHR$(12%)\E%=0%
	\PRINT"LET'S TRY JUST ONE MORE.  ";
	\GOTO 3040
5000	!


	!	P A R T  IV

	! CONSTRUCT A COMPLETE EQUATION FROM THE TWO HALF REACTIONS

5001	L7$="BALANCED TWO HALF REACTIONS"
5010	FOR I% = 1% TO 2%
	\	C(I%,1%)=1%
	\	C(I%,2%)= A(I%,2%)/A(I%,5%)
	\	C(I%,3%)= A(I%,7%)
	\	C(I%,4%)= A(I%,8%)
	\	C(I%,5%)= A(I%,2%)*( A(I%,4%)-A(I%,1%) )
	\NEXT I%		!COEFFICIENTS IN HALF REACTION
5015	Q=1
5020	IF E9<>0 THEN 5040 ELSE PRINT CHR$(12%)
	\I%=1%
	\GOSUB 12000
	\I%=2%
	\GOSUB 12000			! PRINT TWO HALF REACTIONS
5030	PRINT FNZ1$(0%,14%,"")
	\PRINT"	THE TWO HALF REACTIONS ABOVE CAN BE COMBINED TO PRODUCE"
	\PRINT"A WHOLE REACTION.  EACH MUST BE MULTIPLIED BY AN INTEGER"
	\PRINT"AND THEN ONE SUBTRACTED FROM THE OTHER.  THE INTEGERS ARE"
	\PRINT"CHOSEN SO THAT ELECTRONS WILL CANCEL AFTER THE SUBTRACTION,"
	\PRINT"SINCE THERE CAN BE NO ELECTRONS IN THE FINAL COMPLETE"
	\PRINT"EQUATION.  WHICH HALF REACTION IS TO BE SUBTRACTED FROM"
	\PRINT"WHICH IS DETERMINED BY THE FORM DESIRED FOR THE FINAL"
	\PRINT"EQUATION -- THE TWO CHEMICALS WHICH ARE TO REACT SHOULD BE"
	\PRINT"ON THE LEFT.   ";
	\INPUT"PRESS  'NEW LINE' TO CONTINUE !";A$
5035	Z9%=14%
	\GOSUB 11000
5040	PRINT FNZ1$(0%,14%,"")
	\PRINT"SUPPOSE YOU ARE TRYING TO GET THE EQUATION FOR ";
	\IF E9<>0 THEN 5060 ELSE
	 IF N1%=3% THEN N1%=1%
	\N2%=2%
	\GOTO 5060
5050	N1%=2%
	\N2%=1%
5060	PRINT A$(N1%,2%);" REACTING WITH ";A$(N2%,3%);"."
5070	INPUT"BY WHAT INTEGER SHOULD THE FIRST EQUATION BE MULTIPLIED";F
5080	INPUT"BY WHAT INTEGER SHOULD THE SECOND EQUATION BE MULTIPLIED";S
5090	C(1%,J%)=F*C(1%,J%)	FOR J%=1% TO 5%
	\C(2%,J%)=S*C(2%,J%)	FOR J%=1% TO 5%
5095	Q=1
5100

	PRINT FNZ1$(0%,3%,"")
	\I%=1%
	\GOSUB 12000
	\I%=2%
	\GOSUB 12000
	\PRINT FNZ1$(0%,17%,"")		! PRINT MULTIPLIED HALF REACTIONS
5110	PRINT"DO YOU WISH TO TAKE THE FIRST EQUATION MINUS THE SECOND"
	\PRINT"EQUATION ( TYPE 1 ) OR THE SECOND EQUATION MINUS THE"
	\PRINT"FIRST ( TYPE 2 ) ";
	\INPUT Q
	\IF Q=2 THEN Q= -1
5115	IF ABS(Q)= 1 THEN 5120 ELSE Z9%=15%
	\GOSUB 11000
	\GOTO 5110
5120	I% = (Q+3%)/2%
	\C(I%,J%)=-C(I%,J%) FOR J%=1% TO 5%
	\Z9%=14% \GOSUB 11000 \ PRINT FNZ1$(0%,7%,"")
	\I%=1%
	\G=0
	\GOSUB 12000
	\I%=2%
	\G=1
	\GOSUB 12000
5125	G=0
5130	PRINT FNZ1$(20%,10%,"OR COLLECTING TERMS")  IF R=0
	\PRINT C(2%,1%);A$(2%,2%);"  + ";-C(1%,2%);A$(1%,3%);
		IF Q<0
	\PRINT C(1%,1%);A$(1%,2%);"  + ";-C(2%,2%);A$(2%,3%);
		IF Q>0
	\H=C(1%,3%)+C(2%,3%)
	\PRINT " + ";H;"H+  ";		IF H>0
	\W=C(1%,4%)+C(2%,4%)
	\PRINT " + ";W;"H2O ";		IF W>0
	\PRINT " ---> ";
	\PRINT -C(1%,1%);A$(1%,2%);"  + ";C(2%,2%);A$(2%,3%);
		IF Q<0
	\PRINT -C(2%,1%);A$(2%,2%);"  + ";C(1%,2%);A$(1%,3%);
		IF Q>0
	\PRINT " + ";-H;"H+  ";		IF H<0
	\PRINT " + ";-W;"H20 ";		IF W<0
	\E9=C(1%,5%)+C(2%,5%)
	\PRINT " +";			IF E9>0


5131	PRINT E9;"(E-)";		IF E9<>0
	\PRINT
	\IF R<>0 THEN 5300
	!  PRINT COMBINED EQUATION WITH COLLECTED TERMS

5135	PRINT
	\R=0
5140	IF E9=0 THEN 5150 ELSE
		PRINT"THE ELECTRONS DO NOT CANCEL."
	\Z9%=4%
	\G=0
	\INPUT"PRESS 'NEW LINE' TO TRY AGAIN.";A$
	\GOSUB 11000
	\GOTO 5010
5150	IF N1%=Q OR N1%+Q=1 THEN 5190 ELSE
	PRINT FNZ1$(15%,20%,"GIVEN REACTANTS ARE NOT TO LEFT OF ARROW.")
	\G=0
	\E9=1
	\Z9%=4%
	\INPUT"PRESS 'NEW LINE' TO TRY AGAIN. ";A$
	\GOSUB 11000
	\GOTO 5010
5190	B(1%)=ABS(C(1%,1%))
	\B(2%)=ABS(C(1%,2%))
	\B(3%)=ABS(C(2%,1%))
	\B(4%)=ABS(C(2%,2%))
	\B(5%)=ABS(W)		UNLESS W=0
	\B(5%)=ABS(H)		IF W=0
	\B(6%)=ABS(H)
	\B=4+ABS(SGN(W))+ABS(SGN(H))
	\B0=999
5200 	FOR I%=1% TO B
	\	X=B(I%)
	\	IF X<>INT(X) THEN 5210 ELSE X=1
	\NEXT I%
	\GOTO 5230
	! SEE IF ANY FRACTIONAL COEFFICIENTS
5210	IF X<1 THEN M=1/X ELSE M=X-INT(X)
	\M=1/M
5220	C(1%,I%)=M*C(1%,I%)	FOR I%=1% TO 5%
	\C(2%,I%)=M*C(2%,I%)	FOR I%=1% TO 5%
	\W=W*M
	\H=H*M
	\R=1
	\GOTO 5190	! DO ABOVE IF HAD FRACTIONAL COEFF.
5230	FOR I= 1 TO B
	\	IF B(I)=1 THEN 5260 ELSE X=1
	\	IF B(I)<B0 THEN B0=B(I)
5235	NEXT I
5240	FOR J=2 TO B0+.5
	\	FOR I= 1 TO B
	\		X=B(I)/J
	\		IF X<> INT(X) THEN 5250 ELSE X=1
	\	NEXT I
	\	M=1/J
	\	R=1
	\	GOTO 5220
5250	NEXT J
	! TEST IF COMMON DIVISOR
5260	IF R<>0 THEN PRINT FNZ1$(20%,12%,"OR MULTIPLYING TO GET SMALLEST INTEGERS")
	\GOTO 5130
5300	PRINT"GREAT!! YOU HAVE CORRECTLY FORMED AND BALANCED A REDOX"
	\PRINT"EQUATION BY THE ELECTRON METHOD."
9002 DATA 102,"HG","HG",0,1,0,"HG2++",1,2,2,0,0,-.79 
9003 DATA 103,"O","H2O2",-1,2,0,"O2",0,2,0,-2,0,-.68
9004 DATA 104,"BR","BR-",-1,1,-1,"BR2",0,2,0,0,0,-1.09
9005 DATA 105,"N","HNO2",3,1,0,"N2O4",4,2,0,-1,0,-1.07
9006 DATA 106,"I","I2",0,2,0,"IO3-",5,1,-1,-12,6,-1.2 
9007 DATA 107,"O","H2O",-2,1,0,"O2",0,2,0,-2,0,-1.23
9008 DATA 108,"CR","CR+++",3,1,3,"CR2O7--",6,2,-2,-7,3.5,-1.33
9009 DATA 109,"CL","CL-",-1,1,-1,"CL2",0,2,0,0,0,-1.36
9010 DATA 110,"BR","BR2",0,2,0,"BRO3-",5,1,-1,-12,6,-1.5 
9011 DATA 111,"CL","CL2",0,2,0,"HCLO",1,1,0,-2,2,-1.63 
9012 DATA 112,"O","H2O",-2,1,0,"H2O2",-1,2,0,-1,0,-1.77
9013 DATA 113,"TI","TI",0,1,0,"TIO++",4,1,2,-2,1,.9 
9014 DATA 114,"S","SO2",4,1,0,"HSO4-",6,1,-1,-3,2,-.11
9015 DATA 115,"S","H2S",-2,1,0,"S",0,1,0,-2,0,-.14
9016 DATA 116,"U","U++++",4,1,4,"UO2++",6,1,2,-4,2,-.33
9017 DATA 117,"V","V+++",3,1,3,"VO++",4,1,2,-2,1,-.36
9018 DATA 118,"AS","HASO2",3,1,0,"H3ASO4",5,1,0,-2,2,-.56
9019 DATA 119,"U","U++++",4,1,4,"UO2+",5,1,1,-4,2,-.62
9020 DATA 120,"N","NO",2,1,0,"NO3-",5,1,-1,-4,2,-.96
9021 DATA 121,"N","NO",2,1,0,"HNO2",3,1,0,-1,1,-1
9022 DATA 122,"N","NO",2,1,0,"N2O4",4,2,0,-2,1,-1.03
9023 DATA 123,"PU","PU++++",4,1,4,"PUO2++",6,1,2,-4,2,-1.04
9024 DATA 124,"PU","PU++++",4,1,4,"PUO2+",5,1,1,-4,2,-1.15
9025 DATA 125,"CL","HCLO2",3,1,0,"CLO3-",5,1,-1,-3,1,-1.21
9026 DATA 126,"MN","MN++",2,1,2,"MNO2",4,1,0,-4,2,-1.23
9027 DATA 127,"N","NH4+",-3,1,1,"NH3OH+",-1,1,1,-2,1,-1.35
9028 DATA 128,"CL","HCLO",1,1,0,"HCLO2",3,1,0,-2,1,-1.6
9029 DATA 129,"MN","MNO2",4,1,0,"MNO4-",7,1,-1,-4,2,-1.7
9030 DATA 130,"S","S",0,1,0,"H2SO3",4,1,0,-4,3,-.4 
9031 DATA 131,"AS","AS",0,1,0,"H3ASO3",3,1,0,-3,3,-.24 
9032 DATA 132,"N","N2O4",4,2,0,"NO3-",5,1,-1,-4,2,-.8
9033 DATA 133,"HG","HG2++",1,2,2,"HG++",2,1,2,0,0,-.92
9034 DATA 134,"V","VO++",4,1,2,"V(OH)4+",5,1,1,-2,3,-1
9035 DATA 135,"CL","CLO3-",5,1,-1,"CLO4-",7,1,-1,-2,1,-1.19
9036 DATA 136,"N","N2O",1,2,0,"HNO2",3,1,0,-4,3,-1.29
9037 DATA 137,"MN","MN++",2,1,2,"MNO4-",7,1,-1,-8,4,-1.51
9038 DATA 138,"I","IO3-",5,1,-1,"H5IO6",7,1,0,-1,3,-1.6
9999 L7$=L7$+"FINISHED"
\	GOTO 19002
10000!
	ROUTINE TO GET HALF CELLS IN ORDER (BIGGER O.P. FIRST)

10010	LET A$(P%,B%)=A$(Q%,B%)  FOR B%=1% TO 3%
	\LET A(P%,B%)=A(Q%,B%)   FOR B%=1% TO 9%
	\RETURN
11000!
	ROUTINE FOR ERASING SCREEN FROM LINE Z9% TO END

11010	FOR Z7%=Z9% TO Z9%+24%
	\	PRINT FNZ1$(0%,Z7%,SPACE$(77%));
	\	IF Z7%=23% THEN 11020 ELSE PRINT
	\NEXT Z7%
11020	PRINT FNZ1$(0%,Z9%-1%,"")
	\RETURN

12000	!
	ROUTINE FOR PRINTING HALF REACTION
12010	PRINT C(I%,1%);A$(I%,2%);
	\PRINT" + ";C(I%,3%);"H+  ";		IF Q*C(I%,3%) > 0
	\PRINT" + ";C(I%,4%);"H2O ";		IF Q*C(I%,4%) > 0
	\PRINT TAB(25%);"--->";			UNLESS  G  <> 0
	\PRINT TAB(30%);C(I%,2%);A$(I%,3%);
	\PRINT" + ";-C(I%,3%);"H+  ";		IF Q*C(I%,3%) < 0
	\PRINT" + ";-C(I%,4%);"H2O ";		IF Q*C(I%,4%) < 0
	\PRINT" + ";C(I%,5%);"(E-)";
12020	PRINT
	\RETURN
12030	RETURN
19000 IF(ERR-50%)*(ERR-52%)=0% THEN PRINT FNZ1$(10%,20%,"A PURE NUMBER IS NEEDED.")
	\GOTO 19110
19001 IF ERR<>28% THEN ONERRORGOTO 0%
	ELSE L5$=SYS(CHR$(6%)+CHR$(-7%) )
	\RESUME 19002
19002 L5$="HALFCE"	! CHANGE FOR EACH PROGRAM WITH USE RECORD
19003 OPEN L5$+".REC(140,0)" AS FILE 11%, MODE 2%
19004 K$=CVT$$(NUM$(ASCII(RIGHT(SYS(CHR$(6%)+CHR$(9%)),2%))/2%),2%)
\     DIM S7%(30%)
19005 MAT S7%=ZER
\	  S7%(0%)=0%
\     CHANGE S7% TO S7$
\     S7$=SYS(CHR$(6%)+CHR$(14%)+S7$)
\     CHANGE S7$ TO S7%
19006 U$= CVT$$("[" + NUM$(S7%(8%))+","+NUM$(S7%(7%))+"]",2%)
\	U$=U$+" "+DATE$(0%)+" "+L6$+"-"+TIME$(0%)+"KB:"+K$+" C.T.="
\	U$=U$+NUM$(TIME(2%))+"MIN. "+L7$
\	PRINT #11,U$
\	CLOSE 11
\	GOTO 32767
19100	IF ERR <> 50% THEN 19200 ELSE
		PRINT "A PURE NUMBER IS REQUIRED HERE."
	! DATA FORMAT ERRORS
19110		IF ERL=3100 THEN Z9%=10%
			\GOSUB 11000
			\RESUME 3100
19120		IF ERL=4120 THEN Z9%=10%
			\GOSUB 11000
			\RESUME 4110
19130		IF ERL=4350 THEN RESUME 4350
19140		IF ERL=4450 THEN RESUME 4450
19150		IF ERL=5070 THEN Z9%=16%
			\GOSUB 11000
			\RESUME 5070
19160		IF ERL=5080 THEN Z9% =17%
			\GOSUB 11000
			\RESUME 5080
19170		IF ERL=5110 THEN Z9%=18%
			\GOSUB 11000
			\RESUME 5110
19200!
19999	ONERROR GOTO 0%
27100	DEF FNZ1$(Z1%,Z2%,Z$)=
	CHR$(144%)+CHR$(Z1%/10%*16%+Z1%-Z1%/10%*10%+128%)
	+CHR$(139%)+CHR$(Z2%+64%)
	+Z$

32767 END
