 100	!		P R E X						       &
		I$='V01.0 A'	!Version Number				       &
	!								       &
	!	MFD and UFD PRE-EXTENDER FOR RSTS DISKS			       &
	!								       &
	!	WRITTEN BY BOB SPENCE		17-DEC-78		       &
	!		EDIT X01.5		24-JAN-79		       &
	!		EDIT V01.0		26-Jan-79		       &
	!		EDIT V01.0 A		29-MAR-79		       &
	!			FIX ^O CANCEL FOR INITIAL MESSAGE	       &
									       &

200	!		G E N E R A L    D E S C R I P T I O N		       &
									       &
	!	This program can extend the MFD of a RSTS/E disk,	       &
	!	create UFDs and extend them, and list File Directory Cluster   &
	!	Maps (FDCM) of RSTS Disks.				       &
	!								       &
	!	This Program MUST be run from a privileged account.	       &
	!								       &
	!	When creating UFDs for extension,			       &
	!	the program will use, as input, the the $ACCT.SYS file	       &
	!	which is created by REACT, the backup file from NEWACT,	       &
	!	an in-house accounting manager, or a file produced by	       &
	!	the MONEY program. This provides for rebuilding a disk for     &
	!	which an account file does not exist (private packs).	       &
	!								       &
	!								       &
	!	The Program first asks if you want to Extend directories,      &
	!	List FDCMs, or do Both. It will put the FDCM in a file	       &
	!	as well as print it on the keyboard.			       &
	!								       &
	!	It will asks for the name of the disk to be preextended	       &
	!	or Listed. It then verifies that it has access to that disk.   &
	!								       &
	!								       &
	!	It then asks if you want it to create accounts and preextend   &
	!	each UFD. If you answer yes, it will ask for the name of the   &
	!	file to use for the accounting info. It will then attempt to   &
	!	open the file, (to verify its existence), and figure out       &
	!	whether it was created by REACT, NEWACT or MONEY.	       &
	!								       &
	!	It will ask how many clusters to extend the MFD, and the       &
	!	UFDs. This is the number of additional clusters to add.	       &
	!								       &
	!	The program pre-extends the MFD by creating a large quantity   &
	!	of zero block files in the account [1,1]. When it recieves a   &
	!	'NO ROOM FOR USER ON DEVICE' error, or has extended the	       &
	!	File Directory the requested number of clusters,	       &
	!	it deletes all of the temp files, and  prints the	       &
	!	FILE DIRECTORY CLUSTER MAP for the MFD.			       &
	!	It will then install each account in the account file,	       &
	!	preextend it as it did for the MFD and print the FDCM.	       &
	!								       &
	!	To fully extend the MFD on a newly initialized RP04 pack,      &
	!	it takes about 15 minutes.				       &
	!	I expect it will take about the same for each UFD.	       &
									       &

300	!		I / O   C H A N N E L S				       &
	!								       &
	!	CHANNEL #		USED FOR			       &
	!								       &
	!	1		ACCESSING the ACCOUNT File		       &
	!								       &
	!	2		ALL FILE CREATES FOR DIRECTORY EXTENSION       &
	!								       &
	!	3		For accessing MFDs and UFDs non-file-	       &
	!			structured to print File Directory Cluster     &
	!			Maps					       &
	!								       &
	!	4		USED FOR TEMP FILES			       &
	!								       &
	!	5		USED FOR PRINTING THE FDCM WHILE EXTENDING THE &
	!			DIRECTORIES AND FDCM FILE WHEN REQUESTED       &
									       &
	!
400	!								       &
									       &
									       &
	!	V A R I A B L E    D E F I N I T I O N S		       &
									       &

401	!	VARIABLE NAME		USED FOR			       &
	!
410	!	I$		VERSION NUMBER				       &
	!	CLSTR%		CLUSTERSIZE				       &
	!	I%,J%,C%,A$	UTILITY VARIABLE			       &
	!	M%(),M$		USED IN SYS CALLS			       &
	!	NM$		ACCOUNT NAME				       &
	!	P$		DISK:PASSWORD				       &
	!	PROG%		PROGRAMMER NUMBER			       &
	!	PROJ%		PROJECT NUMBER				       &
	!	QTA,QTA%	QUOTA					       &
	!	DISK.NAME$	THE NAME OF THE TARGET DISK		       &
	!	ACC.FILE.TYPE$	ACCOUNT FILE TYPE (REACT, NEWACT or MONEY)     &
	!	ACC.FILE$	VARIABLE TO HOLD NAME OF ACCOUNT FILE	       &
	!	UFD.NAME$	VARIABLE TO HOLD CURRENT PPN BEEING EXTENDED   &
	!	LINE.TYPE%	FOR NEWACT FILES, TYPE OF LINE READ(1,2,3)     &
	!	FILE.NAME$	NAME OF CURRENT FILE IN THE EXTEND ROUTINE     &
	!	COUNTER%	THE NUMBER OF THE CURRENT FILE		       &
									       &
	!	A R R A Y   D E F I N I T I O N S			       &
	!								       &

500	DIM #3%,MFD%(255%)      !Dimension the array for the		       &
                                !first block of the MFD			       &

505	DIM FDCM1%(10%)		!Used for storing the initial File	       &
				!Directory Cluster Map of the MFD before       &
				!the MFD is extended.			       &

510	DIM M%(30%)		!Used for SYS calls			       &
									       &

999	!	M A I N   C O D I N G   A R E A				       &
									       &

1000	ON ERROR GOTO 19000             !Set the standard error trap	       &
									       &

1100	PRINT 'PREX ';I$						       &
\	print 								       &
\	print 'This program is NOT supported in any way by DIGITAL.'	       &
\	print 								       &
\	print 'This program will pre-extend the MFD and UFDs on a';	       &
\	print ' newly initialized RSTS disk,'				       &
\	print 'or list the File Directory Cluster Map of any RSTS Disk.'       &
\	print 'The disk must be Logically mounted Write Enabled.'	       &
\	PRINT 'It can also enter user accounts and pre-extend them.'	       &
\	print 'It will accept input from a REACT file ($ACCT.SYS), or a file'  &
\	print 'produced with MONEY, or a backup file produced by NEWACT.'      &
\	print 								       &
\	SLEEP 3%							       &
\	A$=SYS(CHR$(0%))		!CANCEL THE ^O			       &
\	PRINT								       &

1150	Input 'Do you wish to (E)xtend the Disk, (L)ist the FDCM, or (B)oth';  &
	F$			!Find out what the user wants to do.	       &
\	F$=CVT$$(F$,2%+4%+32%)	!Convert the response to upper case.	       &
\	If F$ = 'E' OR F$ = 'L' OR F$ = 'B' THEN			       &
			GOTO 1160					       &
		ELSE							       &
			PRINT 'The choices are E, L, or B'		       &
\			GOTO 1150					       &

1160	IF F$ = 'L' OR F$ = 'B' THEN					       &
	INPUT 'Enter Output Device for FDCM ';FDCM.FILE$		       &
\	IF FDCM.FILE$="" THEN						       &
		FDCM.FILE$='KB:'					       &
				!IF THE USER WANTS A CLUSTER MAP, FIND	       &
				!OUT WHERE IT SHOULD GO.		       &

1200	INPUT 'Enter the name of the disk ',DISK.NAME$			       &
\	DISK.NAME$=CVT$$(DISK.NAME$,32%)	!Convert to Upper case	       &
\	IF INSTR(1%,DISK.NAME$,':') = 0 THEN				       &
		DISK.NAME$=DISK.NAME$+':'				       &

1300	If F$ = 'L' THEN	!If the user only wants a Cluster Map then     &
		GOTO 8000	!Go and List the FDCM of this Disk	       &
									       &
!Lines 1400-1500 check that we are not attempting to extend the directories on &
!any of the disks in the Public Structure. We also check that we have access   &
!to the disk to be extended. We first try to create a file on the disk to be   &
!extended. There are several posible errors which can occur here. If the       &
!disk is not mounted, the program will exit to allow the disk to be mounted.   &
!If the user does not have an account on the disk, then the disk is not part   &
!of the Public Structure. If the file is created, we then try to find that     &
!file on the Public Structure. If it is found, then the program will exit      &
!with an appropriate warning. If the file is not found on the Public	       &
!Structure, the program will permit the extension of the  directories,	       &
!and delete the test file from the Public Disk.				       &
									       &

1400	PRINT								       &
\	PRINT								       &
\	OPEN DISK.NAME$+'PREX00.TMP' FOR OUTPUT AS FILE 4%		       &
\	CLOSE 4%							       &

1500	OPEN 'SY:PREX00.TMP' FOR INPUT AS FILE 4%			       &
\	PRINT 'YOU MAY NOT EXTEND THE CURRENT SYSTEM DISK !!!'		       &
\	CLOSE 4%							       &
\	KILL 'PREX00.TMP'						       &
\	GOTO 29000							       &

1600	!If we get here, we know that we are not trying to extend	       &
	!the disk we are running from.					       &

1700	KILL DISK.NAME$+'PREX00.TMP'		!Delete the TEMP file	       &

1800	PROJ% = 1%				!Set up to do the MFD	       &
\	PROG% = 1%							       &
\	UFD.NAME$='['+NUM1$(PROJ%)+','+NUM1$(PROG%)+']'			       &

3000	!This routine copies the FDCM of the MFD so it can be printed out      &
	!later.								       &

3100	OPEN DISK.NAME$+UFD.NAME$+'/RONLY' AS FILE 3%			       &

3200	J%=1%				!Save the current FDCM to be printed   &
\	FOR I% = 248% TO 255%		!out later			       &
\		FDCM1%(J%)=MFD%(I%)					       &
\		J%=J%+1%						       &
\	NEXT I%								       &
\	CLOSE 3%							       &
\	PRINT								       &

3400	INPUT 'Do you want to add and extend UFDs also? [YES or NO]';A$	       &
\	If CVT$$(A$,32%+128%+8%+4%) <> 'YES' then			       &
		ACC.FILE.TYPE$=""					       &
\		GOTO 3520						       &

3410	INPUT 'ENTER the NAME of the ACCOUNT FILE to use for INPUT ';ACC.FILE$ &

3430	OPEN ACC.FILE$ FOR INPUT AS FILE 1%				       &
	!	Find out if we have access to it.			       &
	!	Find out what kind of accounting file it is.		       &
	!	It could be a NEWACT generated file,			       &
	!	a REACT one or a MONEY one.				       &

3440	INPUT LINE #1%,A$						       &

3450	IF LEN(A$) = 98% THEN						       &
	ACC.FILE.TYPE$='NEWACT' ELSE					       &
		IF LEN(A$) = 2% THEN					       &
			ACC.FILE.TYPE$='MONEY' ELSE			       &
				ACC.FILE.TYPE$='REACT'			       &

3460	CLOSE 1%							       &
\	PRINT								       &

3500	PRINT 'UFDs will be added to ';DISK.NAME$;' from ';		       &
		ACC.FILE$;' , a ';ACC.FILE.TYPE$;' file.'		       &

3510	IF ACC.FILE.TYPE$='NEWACT' THEN					       &
	INPUT 'Enter UFD Clustersize (usually 16) ';CLSTR%		       &
	!NEWACT Files do not contain the Clustersize. Most accounts	       &
	!created with NEWACT have clustersizes of 16, but you may	       &
	!specify any valid clustersize here.				       &

3520	INPUT 'How many clusters to extend the MFD [1,1] ';I%		       &
\	MFD.BLKS%=(I%*FDCM1%(1%)*16%)+1%				       &
	!This is how many extra clusters to add. One cluster is always	       &
	!created when the disk in initialized.				       &

3530	IF ACC.FILE.TYPE$<>"" THEN					       &
	INPUT 'How many clusters to extend ALL UFDs ';UFD.SIZE%		       &
	!This is how many extra clusters to add. One cluster is always	       &
	!created when an account is added to the disk.			       &

3600	OPEN 'KB:' AS FILE #5%						       &
\	PRINT								       &
\	GOSUB 14000		!PRINT THE FDCM HEADER			       &
\	PRINT UFD.NAME$;						       &
\	GOSUB 14100		!PRINT THE FDCM BEFORE EXTENSION	       &

3700	PRINT								       &
\	PRINT								       &
\	Print 'Do you really want to Extend the MFD on "';DISK.NAME$;	       &
\	Input '" ? [YES or NO] ';A$					       &
\	If CVT$$(A$,32%+128%+8%+4%) <> 'YES' then			       &
		goto 29000						       &
	!One last chance to quit. You can always ^C after it has started,      &
	!but you will have to start fresh anyway.			       &
									       &
3799	!	M F D    E X T E N S I O N   P H A S E			       &

3800	PRINT								       &
\	PRINT								       &
\	PRINT								       &
\	PRINT 'Starting MFD Extension Phase.'				       &
\	PRINT								       &
\	GOSUB 14000		!PRINT THE FDCM HEADER			       &
\	PRINT 'MFD BEFORE EXTENSION';					       &
\	GOSUB 14100		!PRINT THE FDCM BEFORE EXTENSION	       &

3900	GOSUB 11000		!DO THE EXTENSION OF THE MFD		       &

4000	IF ACC.FILE.TYPE$="" THEN					       &
	GOTO 29500		!EXIT, WE ARE ALL DONE			       &
	!If the ACC.FILE.TYPE is null, then we are not creating		       &
	!UFDs and the EXTENSION PHASE is done.				       &

4100	PRINT 'Starting UFD Creation Phase.'				       &

4300	IF ACC.FILE.TYPE$ = 'NEWACT' THEN				       &
	GOTO 5000							       &
		ELSE							       &
		IF ACC.FILE.TYPE$ = 'REACT' THEN			       &
	GOTO 6000							       &
		ELSE							       &
		IF ACC.FILE.TYPE$ = 'MONEY' THEN			       &
	GOTO 7000							       &
		ELSE							       &
		PRINT ACC.FILE.TYPE$;' TYPE NOT PERMITTED'		       &
\		PRINT 'WILL NOT CREATE UFDs'				       &
\		GOTO 29600						       &
	!Go to appropriate routine to handel the account file.		       &
									       &

5000	!	N E W A C T   A C C O U N T   F I L E   R O U T I N E	       &
	!								       &
	! NEWACT is an In-house accounting manager. It is used in place	       &
	! of REACT and provides for some additional accounting information.    &

5050	ON ERROR GOTO 5600		!SET THE ERROR TRAP FOR FILE NOT FOUND &

5100	OPEN ACC.FILE$ FOR INPUT AS FILE 1				       &

5150	ON ERROR GOTO 5700		!SET THE ERROR TRAP FOR END OF FILE    &
\	INPUT #1%,LINE.TYPE%,PROJ%,PROG%,NM$,CC$,P$,QTA			       &

5200	IF LINE.TYPE% <> 1% THEN					       &
	GOTO 5150							       &

5250	P$=DISK.NAME$+CVT$$(P$,2%+4%+32%)				       &
\	IF PROG%=1% AND PROJ%=1% THEN					       &
		GOTO 5150						       &

5300	GOSUB 10110		!TRY AND CREATE THE ACCOUNT		       &

5500	GOSUB 11000		!TRY AND EXTEND THE NEW ACCOUNT		       &

5595	GOTO 5150		!KEEP GOING UNTILL WE HIT END OF FILE	       &
									       &
									       &
	!
5599	!	ERROR ROUTINES FOR THIS SECTION				       &
	!								       &

5600	RESUME 5610		!COULDN'T OPEN THE ACCOUNT FILE		       &

5610	PRINT 'Account File OPEN Error'					       &
\	GOTO 19900							       &

5700	RESUME 5710		!HIT END OF FILE OR HAD READ ERROR	       &

5710	IF ERR = 11% THEN						       &
		GOTO 29500	!EXIT, WE ARE ALL DONE			       &
	ELSE								       &
		PRINT 'Account File Read Error'				       &
\		GOTO 19900						       &
									       &
									       &

6000	!	R E A C T   F I L E   R O U T I N E			       &
	!								       &
	!	PARTS OF THIS CODE WERE TAKEN FROM THE RSTS/E CUSP 'REACT'     &

6010	ON ERROR GOTO 6900						       &
	\ OPEN ACC.FILE$ FOR INPUT AS FILE 1%				       &
		! SET TRAP IN CASE OF OPEN ERROR; OPEN THE FILE.	       &

6020	ON ERROR GOTO 6800						       &
	\ INPUT #1%,PROJ%,PROG%,P$,QTA,CLSTR%,NM$			       &
	\ IF PROG%=1% AND PROJ%=1% THEN					       &
		GOTO 6020						       &
		! GET THE PROJ,PROG,DISK:PASS,QUOTA,CLUSTER,ACCT NAME.	       &
		! CHECK FOR (1,1) cause we already did it.		       &

6035	P$=DISK.NAME$+MID(P$,INSTR(1%,P$,":")+1%,LEN(P$))		       &
	!MAKE THE DISK NAME BE THE TARGET DISK.				       &

6040	GOSUB 10110							       &
		! GO AND TRY TO CREATE THIS ACCOUNT.			       &

6200	!TIME TO EXTEND THE ACCOUNT					       &
	GOSUB 11000							       &

6400	GOTO 6020							       &
		! KEEP GOING TILL WE HIT THE END OF THE ACCOUNT FILE.	       &
									       &

6800	RESUME 6810							       &
		! PROBLEM WITH THE READ OR END OF FILE.			       &

6810	IF ERR = 11% THEN						       &
		GOTO 29500	!EXIT, WE ARE ALL DONE			       &
	ELSE								       &
		PRINT 'Account File Read Error'				       &
\		GOTO 19900						       &
									       &

6900	RESUME 6910							       &
		! COULDN'T OPEN THE ACCOUNT FILE.			       &

6910	PRINT "Account File OPEN Error"					       &
\	GOTO 19900							       &
		! LET THE USER KNOW AND EXIT.				       &

7000	!	M O N E Y   A C C O U N T   F I L E   R O U T I N E	       &
	!
7050	ON ERROR GOTO 7600		!SET THE ERROR TRAP FOR FILE NOT FOUND &

7100	OPEN ACC.FILE$ FOR INPUT AS FILE 1				       &
\	INPUT LINE #1%,A$						       &
\	INPUT LINE #1%,A$						       &
\	INPUT LINE #1%,A$						       &
\	INPUT LINE #1%,A$	!GET RID OF THE HEADER STUF		       &

7150	ON ERROR GOTO 7700		!SET THE ERROR TRAP FOR END OF FILE    &
\	INPUT LINE #1%,A$						       &

7200	PROJ% = VAL(MID(A$,1%,3%))					       &
\	PROG% = VAL(MID(A$,5%,3%))					       &
\	P$ = CVT$$(MID(A$,10%,6%),2%+4%+32%)				       &
\	QTA = VAL(MID(A$,61%,6%))	!DIG OUT THE VALUES		       &
\	CLSTR% = VAL(MID(A$,70%,2%))	!FROM THE STRING		       &

7230	IF INSTR(1%,P$,':') = 0% THEN 7250 !CHECK FOR A : IN THE PASWORD       &
	ELSE				! IF ONE IS FOUND, REPLACE THE	       &
	P$='?'				! PASWORD WITH ?		       &

7250	P$=DISK.NAME$+P$						       &
	\ IF PROG%=1% AND PROJ%=1% THEN					       &
		GOTO 7150						       &

7300	GOSUB 10110		!TRY AND CREATE THE ACCOUNT		       &

7500	GOSUB 11000		!TRY AND EXTEND THE NEW ACCOUNT		       &

7595	GOTO 7150		!KEEP GOING UNTILL WE HIT END OF FILE	       &
									       &
									       &
	!
7599	!	ERROR ROUTINES FOR THIS SECTION				       &
	!								       &

7600	RESUME 7610		!COULDN'T OPEN THE ACCOUNT FILE		       &

7610	PRINT 'Account File OPEN Error'					       &
\	GOTO 19900							       &

7700	RESUME 7710		!HIT END OF FILE OR HAD READ ERROR	       &

7710	IF ERR = 11% THEN						       &
		GOTO 29500	!EXIT, WE ARE ALL DONE			       &
	ELSE								       &
		PRINT 'Account File Read Error'				       &
\		GOTO 19900						       &
									       &
8000	!	F D C M   L I S T   R O U T I N E			       &
	!								       &
	!This routine lists a FILE DIRECTORY CLUSTER MAP of any RSTS	       &
	!Disk. It was created to work with RSTS/E V06C.			       &
	!It will print it on the users terminal or a Line Printer, or	       &
	!put it in a file for later use.				       &

8020	OPEN FDCM.FILE$ FOR OUTPUT AS FILE 5%				       &

8030	GOSUB 14000		!PRINT  FDCM HEADER			       &
									       &

8055	INDEX%=1%							       &

8100	ON ERROR GO TO  8900						       &
		!Hits error when no more accounts else do forever.	       &
\	CHANGE SYS(CHR$(6%)+CHR$(-10%)+DISK.NAME$) TO M%		       &
\	M%(J%)=0% FOR J%=1% TO 22%					       &
\	M%(J%)=0% FOR J%=27% TO 30%					       &
\	M%(0%)=30%							       &
\	M%(1%)=6%							       &
\	M%(2%)=14%							       &
\	M%(3%)=INDEX%	!SET UP THE INDEX				       &
\	M%(4%)=SWAP%(INDEX%)						       &
\	CHANGE M% TO M$							       &
\	M$=SYS(M$)		!DO THE READ ACCOUNTING INFO SYS CALL	       &

8150	CHANGE M$ TO M%							       &

8200	PROJ%=M%(8%)							       &
\	PROG%=M%(7%)							       &
\	UFD.NAME$='['+NUM1$(PROJ%)+','+NUM1$(PROG%)+']'			       &
\	PRINT #5%, UFD.NAME$;						       &

8300	PRINT #5%, TAB(10%);TIME$(0%);					       &

8400	OPEN DISK.NAME$+UFD.NAME$+'/RONLY' FOR INPUT AS FILE 3%		       &
\	GOSUB 14200		!PRINT THE FDCM FOR THE CURRENT ACCOUNT	       &
\	CLOSE 3%							       &

8700	INDEX%=INDEX%+1%						       &
\	GOTO 8100							       &

8900	IF ERR = 5 THEN							       &
	PRINT #5%,							       &
\	PRINT 'ALL DONE WITH ';DISK.NAME$				       &
\	GOTO 8910							       &

8905	PRINT 'ERROR ';ERR;'AT LINE ';ERL				       &
\	PRINT 'FROM SECTION 8000'					       &

8910	RESUME 29600							       &

8990	GOTO 29600	!EXIT						       &
									       &

10100	!	C R E A T E    T H E    A C C O U N T			       &
	!								       &
	!	PARTS OF THIS CODE TAKEN FROM THE RSTS/E CUSP 'REACT'	       &

10110	ON ERROR GOTO 10300						       &
	\ CHANGE SYS(CHR$(6%)+CHR$(-10%)+P$) TO M%			       &
	\ M%(I%)=M%(I%-2%) FOR I%=12% TO 9% STEP -1%			       &
	\ M%(I%)=0% FOR I%=0% TO 8%					       &
	\ M%(I%)=0% FOR I%=13% TO 22%					       &
	\ M%(I%)=0% FOR I%=27% TO 30%					       &
	\ IF QTA<0. OR QTA>65535. THEN					       &
		QTA=VAL("1..2")						       &
	ELSE	IF QTA<32768. THEN					       &
			QTA%=QTA					       &
		ELSE	IF QTA=32768. THEN				       &
				QTA%=32767%+1%				       &
			ELSE	QTA%=QTA-65536.				       &
		! P$=DISK:PASSWORD					       &
		! ADJUST THE QUOTA IF NECESSARY.			       &

10120	M%(0%)=30%							       &
	\ M%(1%)=6%							       &
	\ M%(2%)=0%							       &
	\ M%(7%)=PROG%							       &
	\ M%(8%)=PROJ%							       &
	\ M%(13%)=QTA%							       &
	\ M%(14%)=SWAP%(QTA%)						       &
	\ M%(27%)=CLSTR%						       &
	\ M%(28%)=SWAP%(CLSTR%)						       &
	\ CHANGE M% TO M$						       &
	\ M$=SYS(M$)							       &
	\ RETURN							       &
		! TRY TO DO THE ACTUAL CREATE ON THIS ACCOUNT.		       &
									       &

10300	!								       &
	!	C R E A T E    A C C O U N T    F A I L U R E		       &
									       &

10310	RESUME 10320							       &
		! ERROR ON THE CREATE CALL.				       &

10320	IF ERR <> 16 AND ERR <> 10 THEN					       &
	PRINT " - Failure to ENTER Account: ";				       &
	"[";NUM1$(PROJ%);",";NUM1$(PROG%);"] ";				       &
	" ";QTA;CLSTR%;NM$						       &
		!If the account create failed because the account already      &
		!existed, then return and extend it.			       &

10330	RETURN								       &
									       &

11000	!	D I R E C T O R Y   E X T E N S I O N   R O U T I N E	       &
	!								       &
	!	F I L E   C R E A T I O N   S E C T I O N		       &
	!								       &
	ON ERROR GOTO 19000		!RESET THE ERROR TRAP		       &
\	COUNTER%=0%			!RESET THE FILE NAME COUNTER	       &
\	IF PROG%=1% AND PROJ%=1% THEN					       &
	FILE.COUNT%=MFD.BLKS%		!We extend MFDs and UFDs diferent      &
	ELSE				!amounts			       &
	FILE.COUNT%=(CLSTR% * 16% * UFD.SIZE%)				       &

11100	UFD.NAME$='['+NUM1$(PROJ%)+','+NUM1$(PROG%)+']'			       &
\	PRINT #5%, UFD.NAME$;		!PRINT THE ACCOUNT NAME		       &

11200	OPEN DISK.NAME$+UFD.NAME$+'/RONLY' AS FILE 3%			       &
\	CLOSE 3%							       &
					!TEST TO SEE IF THE ACCOUNT EXISTS     &

11300	PRINT #5%, TAB(10%);TIME$(0%);	!PRINT THE START TIME		       &

11400	FOR F%=1% TO FILE.COUNT%	!Create files until we fill the	       &
\		COUNTER%=COUNTER%+1%	!directory space, or finish.	       &
\		FILE.NAME$=DISK.NAME$+UFD.NAME$+NUM1$(COUNTER%)+'.TMP'	       &

11500		OPEN FILE.NAME$ FOR OUTPUT AS FILE 2%, FILESIZE 0%, MODE 1024% &
\		CLOSE 2%						       &

11600	NEXT F%								       &
\		COUNTER%=COUNTER%+1%					       &
									       &

11900	!THE NO ROOM FOR USER ON DEVICE ERROR WILL GET			       &
	!US HERE. THEN WE DELETE ALL THE FILES THAT WERE		       &
	!JUST CREATED.							       &
									       &
									       &

12000	!	F I L E   D E L E T I O N   S E C T I O N		       &
	!								       &
	!Delete all of the temp files that were created above.		       &
									       &
	PRINT #5%, '-  ';	!INDICATE THAT THE DELETION PHASE IS STARTED   &
\	FOR I% = COUNTER%-1% TO 1% STEP -1%				       &
\		FILE.NAME$=DISK.NAME$+UFD.NAME$+NUM1$(I%)+'.TMP'	       &
\		KILL FILE.NAME$						       &
\	NEXT I%								       &

12500	OPEN DISK.NAME$+UFD.NAME$+'/RONLY' AS FILE 3%			       &
\	GOSUB 14200		!PRINT THE FDCM FOR THIS UFD		       &
\	CLOSE 3%							       &

12900	RETURN								       &
									       &
									       &
									       &
	!	S U B R O U T I N E S					       &

14000	PRINT #5%							       &
\	PRINT #5%, 'FILE DIRECTORY CLUSTER MAP FOR ';DISK.NAME$;' on ';DATE$(0%) &
\	PRINT #5%							       &
\	PRINT #5%, 'ACCOUNT   START    ';				       &
\	PRINT #5%, 'CLUSTER    CLUSTER POINTER'				       &
\	PRINT #5%, '          TIME      ';				       &
\	PRINT #5%, 'SIZE    1      2      3      4      5      6      7'       &
\	PRINT #5%							       &
\	RETURN								       &

14100	PRINT #5%, TAB(22%);FNPOS(FDCM1%(1%));	!THIS IS A SPECIAL CASE	       &
						!FOR PRINTING THE MFD FDCM     &
\	C%=19%					!BEFORE EXTENSION	       &
\	FOR I% = 2% TO 8%						       &
\	C% = C% + 7%							       &
\	PRINT #5%, TAB(C%);FNPOS(FDCM1%(I%));				       &
\	NEXT I%								       &
\	PRINT #5%							       &
\	RETURN								       &

14200	!	THIS PRINTS THE FDCM FOR THE CURRENT UFD		       &
	IF FNPOS(MFD%(248%)) > 16 THEN					       &
		PRINT #5%, 'No Clusters allocated for this account'	       &
	ELSE								       &
		PRINT #5%, TAB(22%);FNPOS(MFD%(248%));	!CLUSTER SIZE	       &
\	C%=19%								       &
\	FOR I% = 249% TO 255%		!CLUSTER POINTERS		       &
\	C%=C%+7%							       &
\	PRINT #5%, TAB(C%);FNPOS(MFD%(I%));				       &
\	NEXT I%								       &
\	PRINT #5%							       &

14300	RETURN								       &
									       &
									       &
									       &
	!	F U N C T I O N S					       &

15000	DEF FNPOS(X%)			!THIS FUNCTION CHANGES AN	       &
\	IF X% < 0% THEN			!UNSIGNED INTEGER TO A FLOATING	       &
		FNPOS=65536.+X%		!POINT NUMBER.			       &
	ELSE								       &
		FNPOS=X%						       &

15099	FNEND								       &
									       &
	!	E R R O R   R O U T I N E S				       &

19000	!ERROR ROUTINE							       &
	!
19100	IF ERR = 4 AND ERL = 11500 THEN	!This is the No Room for user error    &
		RESUME 11900		!for the file creation routine	       &

19150	IF ERR = 6 AND ERL = 1400 THEN					       &
		PRINT 'I do not have access to ';DISK.NAME$;'. Please be';     &
			' sure that it is Logically mounted'		       &
\		Print 'and Write enabled.'				       &
\		RESUME 32767						       &

19200	IF ERR = 5 AND ERL = 3430 THEN					       &
		PRINT ACC.FILE$;' can not be found. Try again.'		       &
\		RESUME 3400						       &

19250	IF ERR = 5 AND ERL = 1500 THEN	!If we got here, we are not	       &
		RESUME 1600		!trying to do the system disk	       &

19350	IF ERL = 11200 THEN						       &
	PRINT ' does not exist. Skipping this account.';		       &
	CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%)		       &
\	RESUME 12900							       &
					!IF WE GOT HERE, THE ACCOUNT DOES      &
					!NOT EXIST.			       &

19400	IF ERR = 11 AND (						       &
		ERL = 1150 OR						       &
		ERL = 1160 OR						       &
		ERL = 1200 OR		!IF ^Z WAS TYPED AT THE TERMINAL       &
		ERL = 3400 OR		!AT AN INPUT STATEMENT, THEN	       &
		ERL = 3410 OR		!EXIT				       &
		ERL = 3510 OR						       &
		ERL = 3520 OR						       &
		ERL = 3700) THEN					       &
		RESUME 32767						       &

19450	IF ERR = 24 AND ERL = 1400 THEN	!IF WE GOT HERE THEN WE ARE	       &
	RESUME 1800			!NOT ATTEMPTING TO EXTEND ONE OF       &
					!THE DISKS IN THE CURRENTLY RUNNING    &
					!SYSTEM				       &

19899	RESUME 19900							       &

19900	PRINT								       &
\	PRINT								       &
\	PRINT '?PREXUE '; CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%) &
\	PRINT 'Unexpected ERROR ';ERR;' AT LINE ';ERL			       &
\	PRINT 'ABORTING DIRECTORY EXTENSION'				       &
\	GOTO 32767							       &
									       &
									       &
									       &
									       &
!		E X I T   C O D E					       &

29000	PRINT 'THE MFD ON ';DISK.NAME$;' WILL NOT BE EXTENDED.'		       &
\	GOTO 32767							       &

29500	PRINT								       &
\	PRINT 'All accounts in the ACCOUNT file are now extended.'	       &

29550	CLOSE 5%			!Close the Keyboard		       &
\	IF F$ = 'B' THEN		!Check to see if a File Cluster	       &
	PRINT				!Directory Map has been requested      &
\	PRINT 'CREATING FILE CLUSTER DIRECTORY MAP'			       &
\	PRINT								       &
\	GOTO 8000			!Go create the FDCM		       &

29600	PRINT				!Return here from the FDCM code	       &
\	PRINT 'PREX COMPLETED AT ';TIME$(0%);' on ';DATE$(0%)		       &
\	GOTO 32767							       &

32767	END								       &
									       &

