1	!



		L O G A C T . B A S 



	!


10	!

		PROGRAM		: LOGACT.BAS
		VERSION		: 6C
		EDIT		: 03

		AUTHOR		: JIM GREGORY
		INSTALLATION	: WITTENBERG UNIVERSITY

		DATE		: 16-Aug-78


	!

20	!
	****************************************************************
	*                                                              *
	*            M O D I F I C A T I O N    H I S T O R Y          *
	*                                                              *
	****************************************************************


	!
21	!
	EDIT		DATE		REASON



	!

100	!
	****************************************************************
	*                                                              *
	*             P R O G R A M    D E S C R I P T I O N           *
	*                                                              *
	****************************************************************


	!
110	!

		THIS PROGRAM PRODUCES 3 TYPES OF REPORTS FROM INFORMATION
	STORED IN THE LOGINS.FIL BY THE MODIFIED LOGIN.BAS PROGRAM.  OUTPUT
	MAY BE TO THE KEYBOARD OR TO A DISK FILE FOR LATTER PRINTING.

		REPORT #1 IS LOGINS BY KB: #.  IF ALL KB:'S ARE SELECTED, THE
	REPORT IS KB: BY TIME OF DAY WITH % OF TOTAL LOGINS.  IF 1 KB: IS
	SELECTED THE REPORT IS DAY BY TIME FOR THE KB:.

		REPORT #2 IS TOTAL LOGINS BY DAY BY TIME WITH % OF TOTAL
	LOGINS.

		REPORT #3 IS LOGINS BY DAY BY TIME FOR AN INDIVIDUAL ACCOUNT.


		REPORT #1 WILL INDICATE WHEN AND WHICH KB:'S ARE BEING USED
		REPORT #2 WILL INDICATE DAYS AND TIMES THE SYSTEM IS BUSIEST
		REPORT #3 WILL INDICATE WHEN A PARTICULAR ACCOUNT IS USED

		IT IS RECOMMENDED THAT THIS PROGRAM BE RUN ONCE A WEEK WITH
	DATA BEING RESET IN ORDER TO PROVIDE A WEEKLY PICTURE OF SYSTEM AND
	KB: USE.

		THE VIRTUAL ARRAYS HAVE BEEN MADE OVERLY LARGE FOR CURRENT
	USAGE TO ALLOW FOR GROWTH. THE DIMENSION OF (10000,3) FOR THE TWO
	ARRAYS TAKES UP UNDER 400 BLOCKS OF STORAGE, BUT PROVIDES STORAGE
	FOR UP TO 10,000 SEPERATE LOGINS BEFORE REALLY NEEDING TO BE RESET
	AND SO THE PERIOD OF REPORTING COULD BE EXPANDED FROM A WEEK.

		THE KB.LOC$() ARRAY CONTAINS ENOUGH SPACE FOR UP TO 64
	KB:'S TO BE REPORTED ON INCLUDING THE PSEUDO KB:'S.  MORE COULD
	BE REPORTED ON BY ENLARGING THE ARRAY AND CHANGING THE STATEMENTS
	THAT DIMENSION BOTH THE KB.LOC$() AND THE INTERNAL KB.LOGS() ARRAY,
	AND ANY STATEMENT USING '65' OR THE 65 th ROW FOR TOTALS STORAGE.
	THE LAST ELEMENT (65) IN THE KB.LOC$ ARRAY ALSO CONTAINS THE
	NUMBER OF THE HIGHEST NUMBERED KB: ON THE SYSTEM.  ON OURS, WE
	HAVE 10 PSEUDO KB:'S AND 2, 16 LINE MULTIPLEXORS SO KB42: IS OUR
	HIGHEST KB: AND 42 IS STORED IN KB.LOC$(65).

		THE LOGINS.FIL AND LOGACT.FIL FILES ARE STORED IN ACCOUNT
	[1,7] BUT MAY BE CHANGED BY CHANGING THE VALUE OF PPN$ TO THE
	DESIRED ACCOUNT # AT LINE 920.




	!




300	!
	****************************************************************
	*                                                              *
	*                    I / O    C H A N N E L S                  *
	*                                                              *
	****************************************************************


	!
320	!


	CHANNEL		FILE

	    # 1%	[1,7]LOGINS.FIL    VIRTUAL FILE WHERE THE LOGIN.BAS
					   PROGRAM STORES THE LOGIN DATA

	    # 2%	[1,7]LOGACT.FIL    VIRTUAL FILE THAT LOGINS.FIL IS
					   COPIED INTO TO BE USED FOR THE
					   VARIOUS REPORTS

	    # 3%	THE OUTPUT FILE    THE ACTUAL REPORT


	!

400	!
	****************************************************************
	*                                                              *
	*                  V A R I A B L E S    U S E D                *
	*                                                              *
	****************************************************************


	!
420	!

		NUMERIC VARIABLES

		CPY.LGS.VIR%(10000,3)	VIRTUAL ARRAY CONTAINING THE COPIED
					LOGINS DATA FROM THE LOGS.VIR%() ARRAY

			"   (0,0)	PTR TO NEXT ELEMENT TO STORE INFO
						( MINUS 1 = TOTAL LOGINS )
			"   (X,0)	PPN
			"   (X,1)	KB: #
			"   (X,2)	DATE OF LOGIN
			"   (X,3)	TIME OF LOGIN

		DATE.%			DATE TO CHECK FOR CHANGE OF DATE
		DUMMY%			= TO KB.NUM% OR PPN% DEPENDING ON
						TYPE OF REPORT
		I%			DUMMY FOR ITERATIONS
		J%			DUMMY FOR ITERATIONS
		KB.LOGS%(65,25)		INTERNAL ARRAY TO ACCUMULATE DATA
						FOR PRINTOUT
			(X,0)		CONTAINS KB: #
			(X, 1-23)	COLUMNS 1-23 COUNTS OF LOGINS FOR 
						EACH OF THOSE HOURS
			(X, 24)		TOTAL FOR ROW 
			(X, 25)		DATE
			(65, Y)		TOTALS FOR COLUMNS ( HOURLY TOTALS )
		KB.NUM%			KB: # OR = TO -1 IF ALL KB:'S
		LOGS.VIR%(10000,3)	VIRTUAL ARRAY CONTAINING LOGINS DATA
						STORED BY THE LOGINS.BAS PROGRAM
						LAYOUT IS SAME AS CPY.LGS.VIR%()
		M%(30)			ARRAY FOR SYS CALL
		MAX%			END POINT FOR PRINTOUT OF REPORT. EQUALS
						LAST VALID ROW IN KB.LOGS() OR
						HIGHEST NUMBERED KB:
		OLD.NEW%		SWITCH TO USE OLD OR GET NEW INFO
		PPN%			PROJECT , PROGRAMMER #
		PROG%			PROGRAMMER #
		PROJ%			PROJECT #
		REPORT%			TYPE OF REPORT ( 1, 2, 3 )
		RESET%			SWITCH TO RESET LOGS.VIR() TO ZEROES
		TOT.LOGS%		TOTAL # OF LOGINS


	!


480	!

		ALPHABETIC VARIABLES

		D$			DETAIL LINE
		D2$ - D7$		DUMMYS FOR DETAIL LINE
		F$			DUMMY FOR HEADING FUNCTION
		H$ - H9$		HEADINGS
		KB.LOC$(65)=8		VIRTUAL ARRAY CONTAINING KB: TYPE AND
						LOCATION. 
						KB.LOC$(15)='V- R  59' =>
							VT52 TERMINAL
							IN RECITATION HALL
							ROOM 59
						THE LAST ELEMENT (65) CONTAINS
						# OF THE HIGHEST NUMBERED KB:
						ON THE SYSTEM
		M$			DUMMY
		PPN$			PROJECT , PROGRAMMER #





	!


800	!
	****************************************************************
	*                                                              *
	*      F U N C T I O N S    A N D    S U B R O U T I N E S     *
	*                                                              *
	****************************************************************


	!
820	!

		SUBROUTINES

		10100		FORMAT HEADINGS
		11000		ACCUMULATE ALL KB:'S BY TIME ROUTINE
		12000		ACCUMULATE INFO BY DATE BY TIME ROUTINE


	!


860	!

		FUNCTIONS

		FNH$		FORMAT ROW HEADINGS
		FNI%		CONVERT TIME VALUE INTO A COLUMN SUBSCRIPT
		FNP$()		FIND % OF TOTAL LOGINS


	!


900	!
	****************************************************************
	*                                                              *
	*                 P R O G R A M    S E T    U P                *
	*                                                              *
	****************************************************************


	!
910	  ON ERROR GOTO 19000
	\ EXTEND
	\ T$  =  'LOGINS REPORTER'
	\ Z1$ = CHR$(155%) + "H" + CHR$(155%) + "J"
	!


920	  DIM KB.LOGS%(65%,25%), M%(30%)
	\ D2$  =  SPACE$(2%)
	\ D4$  =  SPACE$(4%)
	\ D7$  =  SPACE$(7%)
	\ OLD.NEW%, RESET% = 0%
	\ PPN$  =  '[1,7]'
	!
		CONSTANT LENGTHS FOR REPORT FORMATTING
		PPN$  =  ACCOUNT FILES ARE KEPT IN
	!


990	  PRINT Z1$;
	\ E$ = SYS(CHR$(6%) + CHR$(9%) + CHR$(0%))
	\ E% = INSTR(3%,E$,CHR$(0%))
	\ J% = ASCII(E$)/2%
	\ K% = ASCII(RIGHT(E$,2%))/2%
	\ E$ = MID(E$,3%,E%-3%)
	\ PRINT
	\ PRINT T$;'  ';E$;' JOB =  ';J%;'  KB =  ';K%
	\ PRINT
	!

	PRINT HEADER ROUTINE
	!



1000	!
	****************************************************************
	*                                                              *
	*                   M A I N L I N E    C O D E                 *
	*                                                              *
	****************************************************************


	!
1100	  PRINT
	\ INPUT 'Use Old Data <YES> ';M$
	\ GOTO 32700 IF M$ = 'EXIT'
	\ OLD.NEW% = 1% IF ASCII(M$) = 78%
	\ GOTO 1160 IF OLD.NEW% = 0%
	\ PRINT
	\ INPUT 'Reset LOGINS.FIL <NO> ';M$
	\ GOTO 32700 IF M$ = 'EXIT'
	\ RESET% = 1% IF ASCII(M$) = 89%
	!
		CHOOSE TO USE OLD DATA OR GET NEW
		SKIP OPEN OF LOGINS.FIL IF USING OLD DATA
		IF GET NEW, THEN ASK IF RESET LOGINS.FIL DATA
	!


1140	  OPEN PPN$ + 'LOGINS.FIL' AS FILE 1%
	\	DIM #1%, LOGS.VIR%(10000%,3%)
	\ GOTO 1140 IF RESET% <> 0% AND ( STATUS AND 1024% ) <> 0%
	!
		OPEN LOGINS THEN IF RESET SWITCH IS ON CHECK FOR
			WRITE STATUS.  IF DO NOT HAVE WRITE STATUS
			THEN TRY OPEN AGAIN.
	!


1160	   OPEN PPN$  +  'LOGACT.FIL' AS FILE 2%
	\ 	DIM #2%, CPY.LGS.VIR%(10000%,3%), KB.LOC$(65%) = 8%
	\ MAX% = VAL( KB.LOC$(65%) )
	\  IF OLD.NEW% THEN
		MAT CPY.LGS.VIR% = LOGS.VIR%
	\	CPY.LGS.VIR%(I%,0%) = LOGS.VIR%(I%,0%)
			FOR I% = 0% TO LOGS.VIR%(0%,0%)-1%
	\	IF RESET% THEN MAT LOGS.VIR% = ZER
	\		LOGS.VIR%(0%,0%) = 1%
	!
			OPEN LOGACT.FIL

			HIGHEST CONFIGURED KB: # IS STORED IN LAST ELEMENT
				OF KB.LOC$()

			IF GETTING NEW DATA THEN COPY LOGS.VIR%()
				INTO CPY.LGS.VIR%()
			IF RESET THEN SET LOGS.VIR%(0,0) TO 1%
	!


1180	  PRINT
	\ PRINT
	\ PRINT 'Output File Name <KB:> ';
	\ INPUT LINE M$
	\ M$ = CVT$$(M$,-1%)
	\ M$ = 'KB:LOGACT.RPT' UNLESS LEN(M$)
	\ OPEN M$ FOR OUTPUT AS FILE 3%
	!
		GET AND OPEN OUTPUT FILE
	!


1240	  REPORT% = 1%
	\ PRINT
	\ INPUT 'Type of Report ( 1, 2, 3 ) <1> ';M$
	\ GOTO 32700 IF M$ = 'EXIT'
	\ IF M$ > '0' AND M$ < '4' THEN REPORT% = VAL(M$)
	!
		1 = KB: REPORT  ( BY DATE BY TIME IF IND KB: OR
				  KB: BY TIME OF ALL KB:'S )
		2 = LOGINS REPORT ( BY DATE BY TIME )
		3 = ACCOUNT # REPORT  ( BY DATE BY TIME )
	!


1260	  IF REPORT% = 1% THEN PRINT
	\	KB.NUM% = -1%
	\	INPUT "All KB:'s <YES> ";M$
	\	GOTO 32700 IF M$ = 'EXIT'
	\	IF ASCII(M$) = 78% THEN
			PRINT
	\		INPUT 'KB: # ';KB.NUM%
	!
		DO ALL KB:'S OR AN INDIVIDUAL KB:
		KB.NUM% = -1% => DO ALL KB:'S
	!


1280	  IF REPORT% = 3% THEN PRINT
	\	INPUT 'Account # ';PROJ%, PROG%
	\	M%(0%) = 2%
	\	M%(1%) = PROJ%
	\	M%(2%) = PROG%
	\	CHANGE M% TO M$
	\	PPN% = CVT$%(M$)
	!
		IF BY ACCOUNT # THEN GET ACCOUNT AND PUT INTO SAME
			FORM AS CPY.LGS.VIR(X,0) AS STORED BY LOGIN.BAS
			FOR COMPARISON
	!


2000	  TOT.LOGS% = CPY.LGS.VIR%(0%,0%) - 1%
	\ MAT KB.LOGS% = ZER
	\ KB.LOGS%(I%,0%) = 0% FOR I% =0% TO 65%
	\ KB.LOGS%(0%,I%) = 0% FOR I% = 0% TO 25%
	\ GOSUB 10100
	\ IF REPORT% = 1% AND KB.NUM% < 0% THEN GOSUB 11000
	  ELSE
		GOSUB 12000
	!
		GET TOTAL # OF LOGINS
		ZERO OUT ACCUMULATION ARRAY
		FORMAT HEADINGS
		ACCUMULATE DESIRED VALUES INTO KB.LOGS%()
	!


3000	  PRINT #3%,  
	\ PRINT #3%, 
	\ PRINT #3%,  H$
	\ PRINT #3%, 
	\ PRINT #3%,  H1$
	\ PRINT #3%, 
	\ PRINT #3%,  TAB(20%);'TIME'
	\ PRINT #3%, 
	\ PRINT #3%,  H2$;H9$
	\ PRINT #3%, H8$
	!
		HEADINGS 
	!
4000	  FOR I% = 0% TO 65%
	\	I% = 65% IF I% > MAX%
	\	D$ = FNH$
	\	FOR J% = 0% TO 23%
	\		RSET D4$ = ''
	\		RSET D4$ = NUM1$(KB.LOGS%(I%,J%)) IF KB.LOGS%(I%,J%)
	\		D$ = D$ + D4$
	\	NEXT J%
	\	RSET D7$ = ''
	\	RSET D7$ = NUM1$(KB.LOGS%(I%,24%))
	\	D$ = D$ + D7$
	\	D$ = D$ + FNP$(KB.LOGS%(I%,24%)) + ' *' UNLESS I% = 65% AND
			(KB.NUM%<0% OR REPORT% = 2%)
	\	RSET D2$ = NUM1$(I%)
	\	D$ = D$ + D2$ IF REPORT% = 1% AND KB.NUM%<0% AND I%<>65%
	\	PRINT #3%, H8$ IF I% = 65%
	\	PRINT #3%, D$ UNLESS
			REPORT% = 1% AND KB.NUM%<0% AND
				((I%>0% AND I%<11% AND KB.LOGS%(I%,24%) = 0%)
			OR KB.LOC$(I%) = 'UNUSED  ')
	\ NEXT I%
	\ D$ = '         % ALL      '
	\ D$ = D$ + FNP$(KB.LOGS%(65%,J%)) FOR J% = 0% TO 23%
	\ PRINT #3%, D$
	!
		PRINT OUT DETAIL LINES AND TWO TOTAL LINES
		WHEN I% > THEN TOTAL VALID ROWS THEN JUMP TO TOTALS
		MAX% = # OF KB:'S ON SYSTEM IF DOING ALL KB: REPORT OR
			# OF MEANINGFULL ROWS OTHERWISE

	!
5000	  GOTO 1240
	!
		RETURN TO OPTION
	!
10000	!
	****************************************************************
	*                                                              *
	*                     S U B R O U T I N E S                    *
	*                                                              *
	****************************************************************


	!
10100	!
		******  FORMAT HEADINGS  ******
	!

10120	   H$ = SPACE$(34%) + 'LOGINS REPORT FOR PERIOD  ' + DATE$(CPY.LGS.VIR%(1%,2%)) + ' ' + 
		TIME$(CPY.LGS.VIR%(1%,3%)) + ' THROUGH  ' + DATE$(CPY.LGS.VIR%(TOT.LOGS%,2%)) + ' ' + 
		TIME$(CPY.LGS.VIR%(TOT.LOGS%,3%))
	\  H1$ = SPACE$(10%) + 'REPORT FOR '
	\	H1$ = H1$ + 'KB: ' + NUM1$(KB.NUM%) IF REPORT% = 1% AND KB.NUM% >= 0%
	\	H1$ = H1$ + 'ALL KEYBOARDS'   IF REPORT% = 1% AND KB.NUM%<0%
	\	H1$ = H1$ + 'ALL LOGINS'      IF REPORT% = 2%
	\	H1$ = H1$ + 'ACCOUNT # ' + NUM1$(PROJ%) + ',' + NUM1$(PROG%) IF REPORT% = 3%
	\  H1$ = H1$ + SPACE$(30%) + 'TOTAL LOGINS FOR PERIOD  =  ' + NUM1$(TOT.LOGS%)
	\  H2$ = '          DATE      '
	\  H2$ = ' LOCATION  KB:      '     IF REPORT% = 1% AND KB.NUM%<0%
	\  H8$ = SPACE$(16%) + STRING$(113%,42%)
	\  H9$ = ''
	\	FOR I% = 0% TO 23%
	\		RSET D4$ = NUM1$(I%)
	\		H9$ = H9$ + D4$
	\	NEXT I%
	\  H9$ = H9$ + '  TOTAL  %  KB:'
	\  RETURN
	!
	
        
11000	!
		******  ALL KEYBOARD ROUTINE  ******
	!

11100	   FOR I% = 1% TO TOT.LOGS%
	\	X% = CPY.LGS.VIR%(I%,1%)
	\	Y% = FNI%
	\	KB.LOGS%(X%,Y%) = KB.LOGS%(X%,Y%) + 1%
	\	KB.LOGS%(X%,24%) = KB.LOGS%(X%,24%) + 1%
	\	KB.LOGS%(65%,Y%) =  KB.LOGS%(65%,Y%) + 1%
	\	KB.LOGS%(65%,24%) = KB.LOGS%(65%,24%) + 1%
	\ NEXT I%
	\ RETURN
	!
	!	ACUMULATE LOGINS BY KB: # INTO KB.LOGS%() ARRAY
		X% = KB: #  =  ROW
		Y% = FNI%   =  COLUMN
		KB.LOGS%(X,24%)  =  ROW TOTAL OR TOTAL LOGINS FOR THAT KB:
		KB.LOGS%(65%,Y)  =  COLUMN TOTAL OR TOTAL LOGINS FOR THAT HOUR
	!



12000	!
		******  ROUTINE FOR DAY AND TIME  ******
	!

12100	  IF REPORT% = 1% THEN J% = 1% ELSE
		IF REPORT% = 3% THEN
			J% = 0%
	!
		IF 1% THEN BY KB: # ELSE
		IF 3% THEN BY ACCOUNT #
	!


12200	  X% = 0%
	\ DUMMY% = KB.NUM%
	\ DUMMY% = PPN% IF REPORT% = 3%
	\ DATE.%, KB.LOGS%(0%,25%) = CPY.LGS.VIR%(1%,2%)
	\ FOR I% = 1% TO TOT.LOGS%
	\	Y% = FNI%
	\	IF REPORT% <> 2% THEN
			IF DUMMY% <> CPY.LGS.VIR%(I%,J%) THEN 12900
	!

		X%  =  ROW FOR KB.LOGS%(X,Y)  
		Y%  =  COLUMN FOR KB.LOGS%(X,Y)
		J%  =  EITHER ACCOUNT # OR KB: #
		DATE.% = DATE VALUE FOR BREAK CHECK

		DUMMY% WILL BE EITHER PPN% OR KB: # DEPENDING ON
			TYPE OF REPORT

		IF REPORT% = 2%  ( LOGINS REPORT ) THEN GET ALL LOGINS ELSE
		IF KB: OR ACCOUNT # REPORT THEN COMPARE LOGIN ENTRY
			WITH SELECTED KB: OR ACCOUNT #
	!


12300		IF CPY.LGS.VIR%(I%,2%) > DATE.% THEN X% = X% + 1%
	\	DATE.%, KB.LOGS%(X%,25%) = CPY.LGS.VIR%(I%,2%)
	!
		CHECK FOR DATE BREAK AND STORE DATE IN COLUMN 25
	!


12320		KB.LOGS%(X%,Y%) = KB.LOGS%(X%,Y%) + 1%
	\	KB.LOGS%(X%,24%) = KB.LOGS%(X%,24%) + 1%
	\	KB.LOGS%(65%,Y%) = KB.LOGS%(65%,Y%) + 1%
	\	KB.LOGS%(65%,24%) = KB.LOGS%(65%,24%) + 1%
	!
			INCREMENT HOURLY COUNTER KB.LOGS%(X,Y)
			INCREMENT TOTAL DAILY LOGINS COUNTER KB.LOGS%(X%,24%)
			INCREMENT TOTAL HOURLY LOGINS COUNTER KB.LOGS%(65%,Y%)
	!


12900	  NEXT I%
	\ MAX% = X%
	\ RETURN
	!
		MAX%  =  TOTAL ROWS OF DATA TO BE OUTPUT
	!


15000	!
	****************************************************************
	*                                                              *
	*                       F U N C T I O N S                      *
	*                                                              *
	****************************************************************


	!
15100	!
	******  CONVERT TIME INTO COLUMN SUBSCRIPT FOR KB.LOGS%()  ******
	!
15110	   DEF FNI% = VAL(LEFT(TIME$(CPY.LGS.VIR%(I%,3%)),2%))
	!
		TURN TIME VALUE INTO COLUMN SUBSCRIPT FOR KB.LOGS%(I,J)
	!



15200	!
	******  FORMAT LOCATION & # OF KB: OR DATE OF LOGIN  ******
	!
15210	  DEF FNH$
	\ IF REPORT%<>1% OR KB.NUM% >= 0% THEN
		F$ = ' ' + DATE$(KB.LOGS%(I%,25%)) + '      *   '  
	  ELSE
			RSET D4$ = NUM1$(I%)
	\		F$ = ' ' + KB.LOC$(I%) + D4$ + '   *   '
	!
		LOCATION OF KB: AND KB: # IF ALL KB:'S OR
		DATE OF LOGIN
	!

15220	  F$ = '         TOTAL      ' IF I% = 65%
	\ FNH$ = F$
	\ FNEND
	!



15300	!
	******  FORMAT PERCENT OF TOTAL LOGINS  ******
	!

15310	  DEF FNP$(X%)
	\ RSET D4$ = ''
	\ X = X%
	\ RSET D4$ = PLACE$(NUM1$(100.*X/TOT.LOGS%),0%) + '%' 
		IF X% AND 100.*X/TOT.LOGS% >= .5
	\ FNP$ = D4$
	\ FNEND
	!
		FORMAT % OF TOTAL LOGINS
	!



19000	!
	****************************************************************
	*                                                              *
	*                     E R R O R    T R A P S                   *
	*                                                              *
	****************************************************************


	!
19100	IF ERR = 11% THEN RESUME 32700
	!
		CLOSE FILES AND END IF ^Z ENTERED
	!
19990	  ON ERROR GOTO 0
	!

32700	!
	****************************************************************
	*                                                              *
	*                    E O J    R O U T I N E S                  *
	*                                                              *
	****************************************************************


	!
32730	CLOSE #1%, 2%, 3%
	!
32760	  NO EXTEND
	!


32767	  END
