

		===> S A M P L E <===

	THE FOLLOWING LISTINGS ARE OF A SAMPLE PROGRAM WRITTEN

FOR THE MICROCOMPUTER SIMULATOR 'MICRO.BAS'.  THE HEX FILE

'SAMPLE.HEX' CONTAINS THE INTEL HEX CODE FOR THE PROGRAM AND

MAY BE LOADED DIRECTLY BY USE OF THE 'LP' COMMAND.  THE EXECUTION

ADDRESS IS (HEX) 1000.

	THE PROGRAM, WHEN RUN, WILL PRINT OUT A QUESTION MARK (?).

WHEN A LINE IS ENTERED (TERMINATED BY A <CR> <LF> OR ESC) IT WILL

BE ECHOED TO THE USER TERMINAL.

	NOTE: THE SOURCE LISTINGS AND OBJECT CODE IN THIS

	      SAMPLE PROGRAM WERE PRODUCED USING 8080.BAS

	      (RSTS 11-75).


PAGE 1        PRNTMS.SUB

 1                          ;
 2                          ;		===> P R N T M S <===
 3                          ;
 4                          ;	THE FOLLOWING SUBROUTINE WILL PRINT A MESSAGE
 5                          ;	LOCATED AT THE ADDRESS IN REGISTERS H & L. THE
 6                          ;	FIRST BYTE OF THE MESSAGE, WHICH IS NOT PRINTED,
 7                          ;	CONTAINS THE NUMBER OF BYTES TO BE PRINTED.
 8                          ;
 9                          ;
10    0000    C5            PRNTMS: PUSH  B             ;SAVE B,C REGS
11    0001    E5                    PUSH  H             ;SAVE H,L REGS
12    0002    F5                    PUSH  PSW           ;SAVE A,STATUS
13    0003    4E                    MOV   C,M           ;GET BYTE COUNT
14    0004    0D                    DCR   C             ;ADJUST BYTE COUNT
15    0005    23            TOP:    INX   H             ;INCREMENT H,L REGS
16    0006    7E                    MOV   A,M           ;MOVE BYTE TO PRINT INTO A
17    0007    D301                  OUT   %1            ;OUTPUT THE BYTE
18    0009    0D                    DCR   C             ;DECREMENT BYTE COUNT
19    000A    F20500                JP    TOP           ;GO TO PRINT NEXT CHAR
20    000D    F1            DONE:   POP   PSW           ;RESTORE A,STATUS
21    000E    E1                    POP   H             ;RESTORE H,L
22    000F    C1                    POP   B             ;RESTORE B,C
23    0010    C9                    RET                 ;RETURN
24                                  END                 
25    
PAGE 2  PRNTMS.SUB

 1            DONE    = # 000D = % 13     PRNTMS  = # 0000 = % 0      TOP     = # 0005 = % 5 

PAGE 1        GETLIN.SUB

 1                          ;
 2                          ;		===> G E T L I N <===
 3                          ;
 4                          ;  THE FOLLOWING SUBROUTINE WILL INPUT UP TO 255
 5                          ;  CHARACTERS FROM INPUT PORT ONE (1) AND PLACE 
 6                          ;  THEM IN MEMORY STARTING AT (H,L) + 1.  THE
 7                          ;  NUMBER OF CHARACTERS INPUTTED IS STORED AT
 8                          ;  (H,L).  THE ROUTINE STOPS INPUTTING WHEN
 9                          ;  A <LF>, A <CR> OR AN ESC IS TYPED.  IF A <CR>
10                          ;  IS TYPED, A <LF> IS APPENDED TO THE INPUT 
11                          ;  STRING AND THE COUNT IS INCREMENTED.  IF A
12                          ;  <LF> IS TYPED A <CR> IS APPENDED TO THE END
13                          ;  OF THE INPUTTED STRING AND THE COUNT IS INCR
14                          ;  EMENTED.
15                          ;
16                          ;
17                          ;
18                                  ORG   #11           ;LOCATE MODULE
19    0011    C5            GETLIN: PUSH  B             ;SAVE B,C
20    0012    F5                    PUSH  PSW           ;SAVE A,STATUS
21    0013    3E3F                  MVI   A,#3F         ;GET '?' INTO A REG
22    0015    D301                  OUT   %1            ;PRINT '?'
23    0017    E5                    PUSH  H             ;SAVE H,L PAIR
24    0018    23                    INX   H             ;INCREMENT H,L PAIR
25    0019    0E00                  MVI   C,%0          ;ZERO C REG FOR COUNTER
26                          ;
27    001B    DB00          GET:    IN    %0            ;GET STATUS
28    001D    E640                  ANI   %64           ;ISOLATE PROPER BIT
29    001F    CA1B00                JZ    GET           ;CHECK FOR CHARACTER
30    0022    DB01                  IN    %1            ;GET CHARACTER
31    0024    D301                  OUT   %1            ;ECHO CHAR
32    0026    0C                    INR   C             ;INCREMENT COUNTER
33    0027    DA5300                JC    DONE          ;CHECK FOR > 255 CHARS
34    002A    77                    MOV   M,A           ;STORE CHAR
35    002B    DE0A                  SBI   #A            ;CHECK FOR 'LF'
36    002D    CA4000                JZ    LF            ;GO TO ADD <CR>
37    0030    7E                    MOV   A,M           ;RESTORE 'A'
38    0031    DE0D                  SBI   #D            ;CHECK FOR 'CR'
39    0033    CA4B00                JZ    CR            ;GO TO ADD <LF>
40    0036    7E                    MOV   A,M           ;RESTORE 'A'
41    0037    DE1B                  SBI   #1B           ;CHECK FOR 'ESC'
42    0039    CA5300                JZ    DONE          
43    003C    23                    INX   H             ;INCREMENT ADDRESS
44    003D    C31B00                JMP   GET           ;GO TO GET NEXT CHAR
45                          ;
46    0040    0C            LF:     INR   C             ;INCREMENT COUNT
47    0041    23                    INX   H             ;INCREMENT ADDRESS
48    0042    360D                  MVI   M,#D          ;INSERT A <CR> CHAR
49    0044    3E0D                  MVI   A,#D          ;PUT <CR> INTO A REG
50    0046    D301                  OUT   %1            ;OUTPUT <CR> CHAR

PAGE 2        GETLIN.SUB

 1    0048    C35300                JMP   DONE          ;GET OUT
 2                          ;
 3                          ;
 4    004B    0C            CR:     INR   C             ;INCREMENT COUNT
 5    004C    23                    INX   H             ;INCREMENT ADDRESS
 6    004D    360A                  MVI   M,#A          ;INSERT A <LF> CHAR
 7    004F    3E0A                  MVI   A,#A          ;PUT <LF> INTO A REG
 8    0051    D301                  OUT   %1            ;OUTPUT <LF> CHAR
 9                          ;
10                          ;
11    0053    E1            DONE:   POP   H             ;RESTORE H
12    0054    71                    MOV   M,C           ;MOVE COUNT TO BYTE 1
13    0055    F1                    POP   PSW           ;RESTORE A,STATUS
14    0056    C1                    POP   B             ;RESTORE B,C
15    0057    C9                    RET                 ;RETURN
16                          ;
17                                  END                 
18    
PAGE 3  GETLIN.SUB

 1            CR      = # 004B = % 75     DONE    = # 0053 = % 83     GET     = # 001B = % 27     GETLIN  = # 0011 = % 17 
 2            LF      = # 0040 = % 64 

PAGE 1        MAIN.PRO

 1                          ;
 2                          ;	TEST.PRO - TEST PROGRAM TO TEST PRINT AND INPUT
 3                          ;	SUBROUTINES.
 4                          ;
 5                                  ORG   #1000         ;LOCATE AT 1000 (HEX)
 6    1000    21FF07                LXI   H,SPVAL       ;GET INITIAL SP VALUE
 7    1003    F9                    SPHL                ;STORE VALUE IN STACK POINTER
 8    1004    210E10                LXI   H,MESS        ;GET ADDR OF MESSAGE AREA
 9    1007    CD1100                CALL  GETLIN        ;CALL INPUT ROUTINE
10    100A    CD0000                CALL  PRNTMS        ;CALL PRINT ROUTINE
11    100D    76                    HLT                 ;HALT
12    100E    20            MESS:   ASCII ' '           ;MESSAGE AREA
13            07FF                  SET   SPVAL=#7FF    ;INITIAL VALUE OF STACK POINTER
14            0000                  SET   PRNTMS=#00    ;ADDR OF PRINT SUBR
15            0011                  SET   GETLIN=#11    ;ADDR OF INPUT SUBR
16                                  END                 
17    
PAGE 2  MAIN.PRO

 1            GETLIN  = # 0011 = % 17     MESS    = # 100E = % 4110   PRNTMS  = # 0000 = % 0      SPVAL   = # 07FF = % 2047 
