1 !
	500.15 - STAT11 - TRANSF

		DATA TRANSFORMATION MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.



6 !	THIS MODULE CAN COMPUTE SEVERAL FUNCTIONS (TRANSFORMATIONS) OF ONE
	OR TWO VARIABLES AND WILL STORE THE RESULTS IN COLUMNS IN THE DATA
	MATRIX.


7 ! 	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973



8  !	MODIFICATIONS:  MAY, 1975

	MODIFIED TO ACCEPT MISSING DATA POINTS

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA








00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !
	CALLING ARGUMENTS

		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			NAME OF 250 ROW BY 15 COLUMN
					DATA MATRIX

13 !		2) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			NUMBER OF ROWS IN DATA MATRIX

		3) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			NUMBER OF COLUMNS IN DATA MATRIX

20 !

	RETURNING ARGUMENTS

		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			NAME OF 250 ROW BY 15 COLUMN
					DATA MATRIX

22 !		2) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			NUMBER OF COLUMNS IN DATA MATRIX


30 !	DESCRIPTION OF FUNCTION

		THIS MODULE CAN COMPUTE SEVERAL FUNCTIONS (TRANSFORMATIONS)
		OF ONE OR TWO VARIABLES AND WILL STORE THE RESULTS IN
		COLUMNS IN THE DATA MATRIX.

31 !		IT ASKS THE USER TO TYPE TRANSFORMATION CODE NUMBER AND
		TRANSFERS CONTROL TO THE CORRESPONDING ROUTINE.

		FOR MOST TRANSFORMATIONS, THE USER MUST ALSO SPECIFY INPUT
		AND OUTPUT COLUMN NUMBER(S) AND SOMETIMES A CONSTANT.

32 !		THE OUTPUT COLUMN NUMBER CAN BE THE SAME AS AN INPUT COLUMN
		NUMBER; IN THAT CASE, THE RESULT OF THE FUNCTION WILL BE
		WRITTEN OVER THE INPUT DATA COLUMN.

33 !		IF AN ARGUMENT IS OUTSIDE THE DOMAIN OF DEFINITION FOR THE
		FUNCTION OR IF A RESULT CAUSES FLOATING POINT OVERFLOW OR 
		UNDERFLOW, THEN APPROPRIATE ERROR ROUTINES ARE EXECUTED.

34 !		NORMAL EXECUTION IS RESUMED WITH THE NEXT ELEMENTS DOWN THE
		COLUMNS AS THE ARGUMENTS.

		AT THE END, CONTROL IS PASSED TO ESCRWM FOR RECALCULATION OF
		THE ELEMENTARY STATISTICS FOR THE CURRENT MATRIX.

99 !










	THIS CODE RETRIEVES THE CALLING ARGUMENTS FROM COMMON AND OPENS
	THE DATA MATRIX FILE.



100 	ON ERROR GOTO 250: GOSUB 10000: F$=SYS(CHR$(7%))
	: R%=VAL(MID(F$,46%,5%)): C%=VAL(MID(F$,51%,5%))
	: F3$=MID(F$,31%,15%): OPEN F3$ AS FILE 3
110	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	H9=.9E-38
150  DIM #3,A(250%,15%):
     X9%=0%: C5%=C%:
     S1%=0%
170  PRINT "THERE ARE ";R%;" ROWS AND ";C%;" COLUMNS IN YOUR DATA MATRIX"
180  PRINT:PRINT "TYPE HELP FOR A LIST OF THE TRANSFORMATION CODES":
     PRINT:GOTO 205
199 !


	HERE THE USER TYPES IN A TRANSFORMATION CODE. IF HE TYPES HELP,
	CONTROL GOES TO A ROUTINE THAT PRINTS A LIST OF THE TRANSFORMATION
	OPTIONS. IF HE TYPES AN INVALID OPTION, ERROR ROUTINES HERE TELL
	HIM SO.


200  PRINT:PRINT "TRANSFORMATION";T%;" HAS BEEN COMPLETED":PRINT
205	ON ERROR GOTO 250: INPUT "TYPE TRANSFORMATION CODE";C$: PRINT
210  IF C$="HELP" GOTO 6000
230  T%=VAL(C$)
235  ON ERROR GOTO 3980
240  GOTO 280
250	IF ERR=28% THEN GOSUB 10000: RESUME 9000
252	PRINT "INVALID TRANSFORMATION CODE, RETYPE IT CORRECTLY."
255  PRINT "(TYPE 0 TO END TRANSFORMATION)" : PRINT
260  INPUT C$ : PRINT
270  RESUME 210
280  IF T%>=0% AND T%<=19% GOTO 310
290  PRINT "THERE IS NO TRANSFORMATION CODE ";T% :
     PRINT "RETYPE CODE CORRECTLY (TYPE 0 TO END TRANSFORMATION)":
     PRINT
300  GOTO 180     !


	HERE CONTROL IS TRANSFERRED TO THE APPROPRIATE TRANSFORMATION
	ROUTINE. IF T%=0, THEN TRANSFORMATIONS ARE OVER AND CONTROL WILL
	LEAVE THIS MODULE.



310  IF T%=0% GOTO 9000
320  ON T% GOTO 1000,1100,1200,1300,1400,1500,1600,1700,1800,1900,2000,
     2100,2200,2300,2400,2500,2600,2700,3000
399 !


	THIS SUBROUTINE IS REFERENCED BY ALMOST EVERY TRANSFORMATION ROUTINE
	IN ORDER TO GET CONSTANTS AND COLUMN (VARIABLE) NUMBERS.



400  PRINT "ENTER VARIABLE X AND THE VARIABLE NUMBER TO BE ASSIGNED":
     PRINT "TO THE TRANSFORMED DATA"
420  INPUT "(FORM XX,XX)";X%,A%: PRINT: GOTO 530
450  PRINT "ENTER VARIABLES X AND Y, AND THE VARIABLE NUMBER TO BE ASSIGNED":
     PRINT "TO THE TRANSFORMED DATA"
470  INPUT "(FORM XX,XX,XX)";X%,Y%,A%: PRINT : GOTO 540
500  PRINT "ENTER VARIABLE X, THE CONSTANT, AND THE VARIABLE NUMBER TO BE ASSIGNED":
     PRINT "TO THE TRANSFORMED DATA"
520  INPUT "(FORM XX,XX.X,XX)";X%,C,A% : PRINT
530  Y%=1%
540  GOSUB 600
550  IF S9%=1% GOTO 4000
555	A(0%,A%)=0
560  K1%=0%: K2%=0%: K3%=0%:
	RETURN


  !	THIS ROUTINE CHECKS TO MAKE SURE THE USER HAS TYPED IN VALID COLUMN
	NUMBERS.



600  IF Y%<1% OR Y%>C5% GOTO 660
610  IF X%<1% OR X%>C5% GOTO 660
620  IF A%<1% OR A%>C5%+1% OR A%>15% GOTO  660
630	IF A%>C5% THEN C5%=C5%+1%
640  S9%=0%:
     GOTO 670
660  S9%=1%
670  RETURN     !


	THIS ROUTINE TAKES THE SQUARE ROOT OF EACH ELEMENT IN A COLUMN (A(J,X))
	AND STORES THE RESULT IN THE SPECIFIES OUTPUT COLUMN (A(J,A)).



1000 GOSUB 400
1030 ON ERROR GOTO 32000
1032	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 1042
1035	A(J%,A%)=SQR(A(J%,X%)): A(0%,A%)=A(0%,A%)+1
1042 NEXT J%
1050  GOTO 200     !


	THIS SECTION TAKES THE BASE-10 LOG OF EACH ELEMENT IN A COLUMN (A(J,X))
	AND STORES THE RESULT IN THE SPECIFIED OUTPUT COLUMN (A(J,A)).



1100 GOSUB 400
1130 ON ERROR GOTO 32000
1135	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 1140
1137	A(J%,A%)=LOG10(A(J%,X%)): A(0%,A%)=A(0%,A%)+1
1140 NEXT J%
1150  GOTO 200     !


	THIS SECTION COMPUTES NATURAL LOGS.



1200 GOSUB 400
1230 ON ERROR GOTO 32000
1235	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 1240
1237	A(J%,A%)=LOG(A(J%,X%)): A(0%,A%)=A(0%,A%)+1
1240 NEXT J%
1250  GOTO 200     !


	THIS SECTION COMPUTES EXPONENTIALS ( E TO THE A(J,X) POWER ).



1300 GOSUB 400
1330 ON ERROR GOTO 32000
1335	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 1340
1337	A(J%,A%)=EXP(A(J%,X%)): A(0%,A%)=A(0%,A%)+1
1340 NEXT J%
1350  GOTO 200     !


	THIS SECTION ADDS EACH TWO ELEMENTS FROM THE TWO INPUT COLUMNS
	AND STORES THE RESULT IN THE SPECIFIED OUTPUT COLUMN.



1400 GOSUB 450
1430 ON ERROR GOTO 32000
1435	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 OR A(J%,Y%)=H9 THEN A(J%,A%)=H9: GOTO 1440
1437	A(J%,A%)=A(J%,X%)+A(J%,Y%): A(0%,A%)=A(0%,A%)+1
1440 NEXT J%
1445	IF A(0%,A%)=0 GOTO 8000
1450  GOTO 200     !


	THIS SECTION SUBTRACTS ONE COLUMN FROM ANOTHER, ELEMENT BY ELEMENT.



1500 GOSUB 450
1520 ON ERROR GOTO 32000
1525	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 OR A(J%,Y%)=H9 THEN A(J%,A%)=H9: GOTO 1530
1527	A(J%,A%)=A(J%,X%)-A(J%,Y%): A(0%,A%)=A(0%,A%)+1
1530 NEXT J%
1535	IF A(0%,A%)=0 GOTO 8000
1540  GOTO 200     !


	THIS SECTION FINDS THE PRODUCT OF EACH TWO ELEMENTS FROM THE INPUT
	COLUMNS AND STORES THE RESULT IN THE OUTPUT COLUMN.



1600 GOSUB 450
1620 ON ERROR GOTO 32000
1625	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 OR A(J%,Y%)=H9 THEN A(J%,A%)=H9: GOTO 1630
1627	A(J%,A%)=A(J%,X%)*A(J%,Y%): A(0%,A%)=A(0%,A%)+1
1630 NEXT J%
1635	IF A(0%,A%)=0 GOTO 8000
1640 GOTO 200     !


	THIS SECTION FINDS THE QUOTIENT, ELEMENT BY ELEMENT, OF TWO COLUMNS.



1700 GOSUB 450:
     ON ERROR GOTO 32000
1730	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 OR A(J%,Y%)=H9 OR A(J%,Y%)=0 
	THEN A(J%,A%)=H9: GOTO 1740
1735	A(J%,A%)=A(J%,X%)/A(J%,Y%): A(0%,A%)=A(0%,A%)+1
1740	NEXT J%
1750	IF A(0%,A%)=0 GOTO 8000
1760	GOTO 200
1799	!

	THIS SECTION ADDS A CONSTANT 8C) TO EACH A(J%,X%) AND STORES THE
	RESULT IN THE CORRESPONDING A(J%,A%).


1800 GOSUB 500:
     ON ERROR GOTO 32000
1830	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 1840
1835	A(J%,A%)=A(J%,X%)+C: A(0%,A%)=A(0%,A%)+1
1840 NEXT J%:
     GOTO 200     !


	THE NEXT SECTION MULTIPLIES EACH A(J%,X%) BY A CONSTANT (C) AND
	STORES THE RESULT IN THE CORRESPONDING A(J%,A%).



1900 GOSUB 500:
     ON ERROR GOTO 32000
1930	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 1940
1935	A(J%,A%)=A(J%,X%)*C: A(0%,A%)=A(0%,A%)+1
1940 NEXT J%:
	GOTO 200      !


	THE NEXT SECTION TAKES THE INVERSE, ELEMENT BY ELEMENT, OF A COLUMN.



2000 GOSUB 400:
     ON ERROR GOTO 32000
2030	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 OR A(J%,X%)=0 THEN A(J%,A%)=H9: GOTO 2040
2035	A(J%,A%)=1/A(J%,X%): A(0%,A%)=A(0%,A%)+1
2040 NEXT J%:
     GOTO 200     !


	THE FOLLOWING SECTION FINDS THE ARCSIN OF EACH A(J,X) AND STORES THE
	RESULTS IN THE A(J,A)'S.



2100 GOSUB 400:
     ON ERROR GOTO 32000
2105	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO  2150
2110	IF A(J%,X%)>1 OR A(J%,X%)<-1 THEN A(J%,A%)=0:
	PRINT "ARGUMENT (ROW";J%;") OUTSIDE DOMAIN OF DEFINITION";
	" VALUE RETURNED IS 0": GOTO 2150
2120 IF A(J%,X%)=1 THEN A(J%,A%)=1.570796: GOTO 2150
2130 IF A(J%,X%)=-1 THEN A(J%,A%)=-1.570796: GOTO 2150
2140 A(J%,A%)=ATN(A(J%,X%)/SQR(1-A(J%,X%)^2%))
2150 NEXT J%:
	GOTO 200     !


	THE NEXT SECTION RAISES EACH A(J,X) TO THE C POWER, STORING THE RESULT
	IN EACH A(J,A).



2200 GOSUB 500:
     ON ERROR GOTO 32000
2222	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 2240
2230	A(J%,A%)=A(J%,X%)^C
2240 NEXT J%:
	GOTO 200     !


	THE NEXT SECTION PERFORMS A DECISION FUNCTION;
	IF A GIVEN A(J%,X%) IS >= THE USER-SPECIFIED CONSTANT C, THEN THE
	CORRESPONDING A(J%,A%) WILL BE SET TO 1; OTHERWISE IT WILL BE SET TO 0.



2300 GOSUB 500
2340	FOR J%=1% TO R%:
	IF A(J%,X%)=H9 THEN A(J%,A%)=H9: GOTO 2350
2345 IF A(J%,X%)>=C THEN A(J%,A%)=1% ELSE A(J%,A%)=0%
2350 NEXT J%
2360 GOTO 200     !


	THE NEXT SECTION DELETES A COLUMN AND SHIFTS ALL THE HIGHER-NUMBERED
	COLUMNS OVER ONE TO CLOSE THE GAP.



2400 ON ERROR GOTO 2409
2403 S1%=0%
2405 IF C5%<>1% GOTO 2445
2407 GOTO 2420
2409 PRINT "YOU TYPED A NON-NUMERIC COLUMN NUMBER"
2411 PRINT "PLEASE TYPE ONLY NUMBERS"
2413 PRINT "YOU MUST SPECIFY A COLUMN NUMBER BETWEEN 1 AND ";C5%
2415 IF S1%=0% THEN RESUME 2400
2417 GOTO 2400
2420 PRINT "YOU CANNOT DELETE A COLUMN. . ."
2430 PRINT "YOU ONLY HAVE ONE COLUMN LEFT"
2440 GOTO 200
2445 INPUT "WHICH COLUMN DO WANT TO DELETE"; A%
2447 PRINT
2450 IF A%>=1% AND A%<=C5% GOTO 2460
2453 S1%=1%
2456 GOTO 2413
2460	FOR K%=0% TO R%
2470	A(K%,J%)=A(K%,J%+1%) FOR J%=A% TO C5%-1%
2480 NEXT K%
2490 C5%=C5%-1%
2495 GOTO 200      !


	THE NEXT SECTION COMPUTES THE SCALAR PRODUCT OF TWO VARIABLES; I.E. IT
	SUMS UP THE ELEMENT BY ELEMENT PRODUCTS AND PRINTS THE RESULT; I.E. IT
	COMPUTES THE SUM OF CROSS-PRODUCTS OF TWO COLUMNS.



2500 INPUT "ENTER VARIABLES X AND Y ";X%,Y% : PRINT : A%=1%
2510 GOSUB 600
2520 IF S9%=1% GOTO 4000
2525 S8=0
2530	FOR J%=1% TO R%
2535	IF A(J%,X%)=H9 OR A(J%,Y%)=H9 GOTO 2550
2540 S8=S8+A(J%,X%)*A(J%,Y%)
2550 NEXT J%
2555	IF S8=0 THEN PRINT "SCALAR PRODUCT IS 0": GOTO 2570
2560 PRINT USING "SCALAR PRODUCT = #.######^^^^      RECIPROCAL = #.######^^^^",S8,1/S8
2570 PRINT
2580 GOTO 200     !


	THE NEXT LINE SETS PARAMETERS TO DIRECT THE PRINTING OF THE
	ENTIRE CURRENT MATRIX.

2600 C1%=1%:C8%=1%:C2%=C5%:C9%=C5%:R1%=1%:R2%=R%:GOTO 2730
2699 !


	THIS SECTION GETS PARAMETERS FROM THE USER FOR PRINTING A SUBMATRIX.



2700 INPUT "TYPE BEGINNING ROW, END ROW";R1%,R2%:
     IF R1%<=0% OR R2%<=0% OR R1%>R% OR R2%>R% THEN
     PRINT "YOUR ROW NUMBERS MUST BE BETWEEN 1 AND";R%:
     GOTO 2700
2710 INPUT "TYPE BEGINNING COLUMN, END COLUMN";C1%,C2%:
     IF C1%<=0% OR C2%<=0% OR C1%>C5% OR C2%>C5% THEN
     PRINT "YOUR COLUMN NUMBERS MUST BE BETWEEN 1 AND";C5%:
     GOTO 2710
2720 C8%=C1%: C9%=C2%: PRINT     !


	THE NEXT SECTION IS USED BY BOTH OF THE ABOVE PRINT ROUTINES FOR
	THE ACTUAL PRINTING OF MATRICES OR SUBMATRICES.



2730 IF (C9%-C8%)>5% THEN C9%=C8%+5%
2740 PRINT : PRINT "ROW";TAB(35);"COLUMN" : PRINT
2750 I%=10%
2760 FOR K%=C8% TO C9%
2770 PRINT TAB(I%);K%;
2780 I%=I%+11%
2790 NEXT K%
2800 PRINT
2810	FOR I%=R1% TO R2%
2820	PRINT I%;TAB(5%);
2830	FOR J%=C8% TO C9%
2835	IF A(I%,J%)=H9 THEN PRINT "           ";: GOTO 2850
2840 PRINT USING " #####.####",A(I%,J%);
2850 NEXT J%
2860 PRINT
2870 NEXT I%
2880 PRINT : PRINT
2890 IF C2%=C9% GOTO 200
2900 C8%=C9%+1% : C9%=C2%
2910 GOTO 2730     !


	THE NEXT SECTION GENERATES A COLUMN OF RANDOM NUMBERS WITHIN SPECIFIED
	UPPER AND LOWER LIMITS.



3000 PRINT "ENTER VARIABLE NUMBER TO BE ASSIGNED TO THE RANDOM NUMBERS"
3010 INPUT "(FORM XX) "A% : PRINT
3015 IF A%<1% OR A%>15% OR A%>C5%+1% GOTO 4000
3030 INPUT "ENTER LOWER LIMIT , UPPER LIMIT ";L,U : PRINT
3040 RANDOMIZE
3050	A(J%,A%)=(U-L)*RND+L FOR J%=1% TO R%
3052	A(0%,A%)=R%
3055	IF A%>C5% THEN C5%=C5%+1%
3060 GOTO 200     !


	THIS BIG ERROR ROUTINE IS DESIGNED TO HANDLE ALL THE TIMES AND
	PLACES THE USER TYPES IN INAPPROPRIATE AND/OR NON-NUMERIC ANSWERS TO
	KEYBOARD QUESTIONS.



3980	IF ERR=28% THEN GOSUB 10000: RESUME 9000
3982	PRINT "YOU TYPED NON-NUMERIC VARIABLE NUMBER(S) OR CONSTANTS"
3985 PRINT
3987 S1%=1%
3990 GOTO 4001
4000 PRINT "YOU HAVE GIVEN AN INVALID RESPONSE !" : PRINT
4001 PRINT "YOUR INPUT VARIABLE NUMBER(S)"
4002 PRINT "MUST BE BETWEEN 1 AND "; C5%
4003 IF C5%=15% GOTO 4008
4004 PRINT "YOUR OUTPUT VARIABLE NUMBER"
4005 PRINT "MUST BE BETWEEN 1 AND "; C5%+1%
4006 GOTO 4010
4008 PRINT "YOUR OUTPUT VARIABLE NUMBER "
4009 PRINT "MUST BE BETWEEN 1 AND "; C5%
4010 INPUT "DO YOU WISH TO CONTINUE TRANSFORMATION (TYPE YES OR NO)";W$
4015 IF S1%=1% GOTO 4060
4020 IF W$="NO" OR LEFT(W$,1%)="N" OR W$="" GOTO 9000
4022 IF LEFT(W$,1%)<>"Y" GOTO 4040
4024 IF T%=16% GOTO 2500
4026 IF T%=17% OR T%=18% GOTO 2700
4030 IF T%=19% GOTO 3000
4035 ON T% GOTO 400,400,400,400,450,450,450,450,500,500,400,400,500,500
4040 INPUT "YOU MUST TYPE EITHER YES OR NO";W$
4050 GOTO 4015
4060 IF W$<>"NO" AND LEFT(W$,1%)<>"N" AND W$<>"" GOTO 4075
4065 S1%=0%
4070 RESUME 9000
4075 IF W$<>"YES" AND LEFT(W$,1%)<>"Y" GOTO 4040
4080 S1%=0%
4085 IF T%=16% THEN RESUME 2500
4086 IF T%=17% OR T%=18% THEN RESUME 2700
4087 IF T%=19% THEN RESUME 3000
4088 ON T% GOTO 4090,4090,4090,4090,4092,4092,4092,4092,4094,4094,
          4090,4090,4094,4094
4090 RESUME 400
4092 RESUME 450
4094 RESUME 500     !


	THIS SECTION IS EXECUTED WHEN THE USER TYPES HELP INSTEAD OF A
	TRANSFORMATION CODE NUMBER. IT PRINTS A LIST OF THE TRANSFORMATION
	OPTIONS.


6000 PRINT:
     PRINT "FOLLOWING IS AN EXPLANATION OF THE TRANSFORMATION CODES":
     PRINT "(X AND Y ARE VARIABLES, C IS A CONSTANT)":
     PRINT " 1  SQUARE ROOT OF X":
     PRINT " 2  COMMON LOG OF X"
6100 PRINT " 3  NATURAL LOG OF X":
     PRINT " 4  EXPONENTIAL OF X":
     PRINT " 5  X + Y":
     PRINT " 6  X - Y":
     PRINT " 7  X * Y":
     PRINT " 8  X / Y"
6200 PRINT " 9  X + C":
     PRINT "10  X * C":
     PRINT "11  1 / X":
     PRINT "12  ARCSIN OF X":
     PRINT "13  X ^ C":
     PRINT "14  IF X>=C, THEN X=1; OTHERWISE, X=0"
6300 PRINT"15  DELETE A COLUMN":
     PRINT"16  SCALAR PRODUCT":
     PRINT"17  PRINT ENTIRE MATRIX":
     PRINT"18  PRINT A SUBMATRIX":
     PRINT"19  GENERATE RANDOM NUMBERS":
     PRINT" 0  NO MORE TRANSFORMATION":
     PRINT:GOTO205
8000	!

	THIS SECTION IS USED WHEN A TRANSFORMATION USING TWO VARIABLES
	FAILS--I.E. NO DATA EXISTS FOR ANY PAIR


8005	PRINT "NOT ENOUGH PAIRS OF DATA EXISTED TO PERFORM THIS";
	" TRANSFORMATION": PRINT "DATA CANNOT BE SAVE IN COLUMN";A%:
	PRINT "IF YOU WERE REPLACING COLUMN";A%;", THE ORIGINAL DATA";
	" IS LOST.  SORRY."
8010	IF A%>=C5% THEN C5%=C5%-1%: GOTO 8060
8020	FOR K%=0% TO R%
8030	A(K%,J%)=A(K%,J%+1%) FOR J%=A% TO C5%-1%
8040	NEXT K%
8050	C5%=C5%-1%
8060	GOTO 205
8999 !


	THIS SECTION IS BRANCHED TO WHEN THE USER TYPES 0 FOR THE TRANSFORMATION
	CODE. THE RETURNING ARGUMENTS ARE LOADED INTO COMMON AND CONTROL IS
	PASSED TO ESCRWM FOR RECALCULATION OF THE ELEMENTARY STATISTICS.



9000 PRINT "YOU NOW HAVE  "; C5%; " VARIABLES IN YOUR DATA MATRIX"
9030 C%=C5%
9040 CLOSE 3
9100 F$=LEFT(F$,50%) : G$=RIGHT(F$,56%)
9110 C$="00000"+RIGHT(NUM$(C%),2%)
9120 F$=F$+MID(C$,LEN(C$)-5%,5%)+G$
9122 F$=LEFT(F$,55%)
9124 F$=F$+"STATCM"+A9$+"   "
9130 R$=SYS(CHR$(8)+F$)
9140 CHAIN "ESCRWM"+A9$
9145 !

	THIS BIG ERROR ROUTINE IS DESIGNED TO HANDLE ERRORS PRIMARILY
	ARISING FROM ARGUEMENTS OUTSIDE THE DOMAINS OF DEFINITION FOR
	THE VARIOUS FUNCTIONS.
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32000	IF ERR=28% THEN GOSUB 10000: RESUME 9000
32005	IF ERR=54 THEN A(J%,A%)=SQR(ABS(A(J%,X%)))
	: PRINT "ROW";J%;"CONTAINS THE MAGNITUDE OF A COMPLEX NUMBER"
32010	IF ERR=53 THEN A(J%,A%)=A(J%,X%):
	PRINT "LOG WORKS ONLY FOR POSITIVE NUMBERS":
	PRINT "ORIGINAL ARGUMENT RETURNED IN ROW";J%
32020	IF ERR=61 THEN A(J%,A%)=0:
	PRINT "0 RETURNED FOR DIVISION BY 0 IN ROW";J%
32030	IF ERR=48 OR ERR=49 THEN A(J%,A%)=0:
	PRINT "VALUE RETURNED IN ROW";J%;" TOO LARGE OR":
	PRINT "TOO SMALL FOR THIS MACHINE - 0 SUBSTITUTED":
	IF T%=4% THEN RESUME 1340 ELSE IF T%=5% THEN RESUME 1440
32032 IF T%=1% THEN RESUME 1042 ELSE IF T%=2% THEN RESUME 1140
32034 IF T%=3% THEN RESUME 1240
32040 IF T%=6% THEN RESUME 1530 ELSE IF T%=7% THEN RESUME 1630
32050 IF T%=8% THEN RESUME 1740 ELSE IF T%=9% THEN RESUME 1840
32060 IF T%=10% THEN RESUME 1940 ELSE IF T%=11% THEN RESUME 2040
32070 IF T%=12% THEN RESUME 2150 ELSE IF T%=13% THEN RESUME 2240
32080 RESUME 205
32767 END
