1 !
	500.26 - STAT11 - SCATTE

		SCATTER DIAGRAM MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.



6 !	THIS MODULE PRINTS A SCATTER DIAGRAM (X VS.Y) FOR ANY TWO
	VARIABLES IN THE DATA MATRIX.


7 ! 	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973



8 !	MODIFICATIONS:  MAY, 1975

	MODIFIED TO ACCEPT MISSING DATA POINTS

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !
	CALLING ARGUMENTS

11 !		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			THIS IS THE NAME OF THE 250 ROW
					BY 15 COLUMN VIRTUAL DATA MATRIX
					USED BY ALL STAT11 MODULES.

13 !		2) VARIABLE NAME:	F4$
		   RANGE OF VALUES:	S00000.ESF - S99999.ESF
		   USE:			THIS IS THE NAME OF THE FILE THAT
					CONTAINS ELEMENTARY STATISTICS

15 !		3) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			CONTAINS THE NUMBER OF ROWS OF
					ACTUAL DATA IN MATRIX F3$

17 !		4) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			CONTAINS THE NUMBER OF COLUMNS
					OF ACTUAL DATA IN MATRIX F3$

20 !


	RETURNING ARGUMENTS

		NONE -- THIS MODULE DOES NOT ALTER OR ADD TO ANY OF THE
			FILES OR VARIABLES PASSED TO IT.



30 !
	DESCRIPTION OF FUNCTION

		THIS MODULE PRINTS A SCATTER DIAGRAM (X VS. Y) FOR ANY
		TWO VARIABLES IN THE DATA MATRIX.

31 !		IT FIRST ASKS THE USER TO ENTER THE HORIZONTAL AND VERTICAL
		VARIABLE NUMBERS AND THEN USES THOSE NUMBERS AND THE ELEMENTARY
		STATISTICS TO COMPUTE THE LIMITS AND INTERVALS FOR THE DIAGRAM.

32 !		AFTER TRANSFERING THE VARIABLES FROM THE DATA MATRIX TO A
		TEMPORARY ARRAY, IT SORTS THE VERTICAL DATA POINTS IN
		DECREASING ORDER OF MAGNITUDE, KEEPING HORIZONTAL DATA
		POINTS MATCHING.

33 !		IT THEN PRINTS THE SCATTER DIAGRAM, USING ONE PRINTLINE
		FOR EACH VERTICAL INTERVAL.

34 !		FINALLY, IT ASKS THE USER IF HE WANTS ANOTHER SCATTER
		DIAGRAM.  IF HE DOESN'T, IT CHAINS TO STATCM.

35 !










95 !

	THIS FIRST SECTION OPENS THE DATA AND ELEMENTARY STATISTICS
	FILES AND ASKS THE USER TO ENTER THE HORIZONTAL AND VERTICAL
	VARIABLES FOR THE SCATTER DIAGRAM.



100 	ON ERROR GOTO 915: GOSUB 10000: DIM X(250%),Y(250%),D$(60%)
110  F$=SYS(CHR$(7))
115	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	H9=.9E-38
120  R%=VAL(MID(F$,46%,5%))
130  C%=VAL(MID(F$,51%,5%))
140  F3$=MID(F$,31%,15%)
150  F4$=LEFT(F3$+"      ",6%)+".ESF"
160  OPEN F3$ FOR INPUT AS FILE 3
170  DIM #3,A(250%,15%)
180  OPEN F4$ FOR INPUT AS FILE 4
190  DIM #4,S(10%,15%)
200  PRINT "ENTER X(HORIZONTAL) AND Y(VERTICAL) VARIABLES "
210  INPUT "SEPARATE X AND Y WITH A COMMA"; X%,Y%: PRINT
220  IF X%>=1% AND X%<=C% AND Y%>=1% AND Y%<=C% GOTO 240
225  PRINT "YOUR VARIABLE NUMBERS MUST BE BETWEEN 1 AND"; C%
230  GOTO 200
235 !


	THIS SECTION COMPUTES THE LIMITS AND INTERVALS FOR THE DIAGRAM,
	MAKING ONE VERTICAL INTERVAL CORRESPOND TO ONE PRINTLINE.



240	!
250	U=(S(1%,X%)-S(2%,X%))/30
260	X1=S(2%,X%)-U: X9=S(1%,X%)+U
270	V=(S(1%,Y%)-S(2%,Y%))/18
280	Y1=S(2%,Y%)-V: Y9=S(1%,Y%)+V
290  X5=(X9-X1)/60 : Y5=(Y9-Y1)/36
292  IF U<>0 AND V<>0 GOTO 300
294	IF U=0 THEN PRINT "*** VARIABLE NUMBER";X%;" IS A CONSTANT***"
296	IF V=0 THEN PRINT "*** VARIABLE NUMBER";Y%;" IS A CONSTANT***"
298  PRINT
299  GOTO 950     !


	NEXT THE USER IS ASKED TO ENTER A PLOT SYMBOL; THE DEFAULT
	CHARACTER IS AN ASTERISK.


300  INPUT "TYPE A PLOT SYMBOL IN THE FORM X ";P$
305  P$=LEFT(P$+"*",1%) : PRINT : PRINT
309 !


	HERE THE DATA IS TRANSFERRED FROM THE INPUT MATRIX TO TEMPORARY
	X(J%) AND Y(J%) MATRICES.


310	J1%=0%: FOR J%=1% TO R%
315	IF A(J%,X%)=H9 OR A(J%,Y%)=H9 GOTO 330
320	J1%=J1%+1%: X(J1%)=A(J%,X%): Y(J1%)=A(J%,Y%)
330	NEXT J%: IF J1%=0% THEN PRINT "NO DATA EXISTS FOR THESE";
	" VARIABLES": GOTO 950
399 !

	HERE THE Y'S ARE SORTED IN DECREASING ORDER OF MAGNITUDE USING AN
	INTERCHANGE SORT. THE X'S ARE KEPT MATCHING WITH CORRESPONDING Y'S;
	I.E., IF Y(2) AND Y(3) ARE INTERCHANGED, THEN X(2) AND X(3) ARE
	INTERCHANGED, ALSO.


400	T9%=J1%-1%
410	FOR K%=1% TO J1%
420  S9%=0%
430	FOR J%=1% TO T9%
440  IF Y(J%)>=Y(J%+1%) GOTO 490
450  Q1=X(J%) : Q2=Y(J%)
460  X(J%)=X(J%+1%) : Y(J%)=Y(J%+1%)
470  X(J%+1%)=Q1 : Y(J%+1%)=Q2
480  S9%=1%
490  NEXT J%
500  IF S9%=0% GOTO 600
510  T9%=T9%-1%
520  NEXT K%
590 !


	HERE THE SCATTER DIAGRAM IS PRINTED. FOR EACH LINE CORRESPONDING
	TO Y POSITION(S), THE ASSOCIATED X POSITION(S) ARE FILLED IN WITH
	THE PRINT CHARACTER, AND THE LINE IS PRINTED.



600	V1=Y9: N%=1%
610  FOR J%=0% TO 35%
620  IF J%-(J%/6%)*6%<>0% GOTO 660
630  PRINT USING "######.###",V1;
640  PRINT " +";
650  GOTO 670
660  PRINT "           .";
670  D$(I%)=" " FOR I%=0% TO 60%
680	IF N%>J1% GOTO 800
690  IF Y(N%)<V1 GOTO 740
700  I5%=(X(N%)-X1)/X5
710  D$(I5%)=P$
720  N%=N%+1%
723	IF N%<=J1% GOTO 680
725  FOR I%=0% TO 58%
729  PRINT D$(I%);
733  NEXT I%
737  PRINT D$(59%)
739  GOTO 680
740  V1=V1-Y5
743  FOR I%=0% TO 58%
745  PRINT D$(I%);
747  NEXT I%
748  PRINT D$(59%)
750  NEXT J%
800  PRINT USING "######.### ",Y1;
810  PRINT "+ . . . . . "; FOR I%=1% TO 5%
815  PRINT
820  PRINT "                ";
830  T=12*X5+X1
840  FOR J%=1% TO 4%
850  PRINT USING "  #####.####",T;
860  T=T+12*X5
870  NEXT J%
880  PRINT
890  PRINT "      "; : PRINT USING "#####.####",X1;
900  PRINT TAB(61%); : PRINT USING "######.####",X9
910  PRINT : PRINT
912  GOTO 950
914 !

	THIS IS THE ERROR ROUTINE FOR WHEN THE USER ENTERS NON-NUMERIC
	VARIABLE NUMBERS.


915 	IF ERR=28% THEN GOSUB 10000: RESUME 950
917	PRINT "YOU TYPED NON-NUMERIC CHARACTERS"
920  PRINT "FOR YOUR VARIABLE NUMBERS"
925  PRINT "PLEASE TYPE ONLY NUMBERS WHEN NUMBERS ARE REQUESTED"
930  RESUME 225
945 !


	THIS CLOSING ROUTINE EITHER CYCLES BACK FOR ANOTHER PLOT OR ELSE
	CHAINS TO STATCM.



950  INPUT "DO YOU WISH TO PLOT MORE VARIABLES ";W$:PRINT
955  IF W$="YES" OR LEFT(W$,1%)="Y" GOTO 200
960  IF W$="NO" OR LEFT(W$,1%)="N" OR W$="" GOTO 970
965  PRINT "YOU MUST ANSWER EITHER YES OR NO"
967  GOTO 950
970	R$=SYS(CHR$(8)+F$)
980  CHAIN "STATCM"+A9$
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32750	END
