1 !
	500.13 - STAT11 - ESCRWM

		ELEMENTARY STATISTICS CALCULATION MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.



6 !	THIS MODULE COMPUTES SIX ELEMENTARY STATISTICS FOR EACH VARIABLE
	IN THE DATA MATRIX.



7 ! 	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973



8  !	MODIFICATIONS:  MAY, 1975
	
	MODIFIED TO ACCEPT MISSING DATA

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !
	CALLING ARGUMENTS

11 !		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			NAME OF THE 250 ROW BY 15 COLUMN
					VIRTUAL DATA MATRIX.

13 !		2) VARIABLE NAME:	F4$
		   RANGE OF VALUES:	S00000.ESF - S99999.ESF
		   USE:			NAME OF ELEMENTARY STATISTICS FILE

15 !		3) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			NUMBER OF ROWS IN DATA MATRIX

17 !		4) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			NUMBER OF COLUMNS IN DATA MATRIX


19 !		5) VARIABLE NAME:	A$
		   RANGE OF VALUES:	MOST OTHER STAT11 MODULE NAMES
		   USE:			USED TO CHAIN TO THE NEXT ANALYSIS
					TO BE PERFORMED.


20 !
	RETURNING ARGUMENTS

21 !		1) VARIABLE NAME:	F4$
		   RANGE OF VALUES:	S00000.ESF - S99999.ESF
		   USE:			NAME OF THE ELEMENTARY STATISTICS
					FILE WHICH HAS BEEN UPDATED.

23 !		2) VARIABLE NAME:	A$
		   RANGE OF VALUES:	MOST OTHER STAT11 MODULE NAMES
		   USE:			NAME OF NEXT ANALYSIS MODULE TO BE
					PERFORMED; IT IS PASSED TO EDIT00


30 !
	DESCRIPTION OF FUNCTION

31 !		THIS MODULE COMPUTES SIX ELEMENTARY STATISTICS FOR EACH VARIABLE
		IN THE DATA MATRIX.

32 !		UNLESS THE MATRIX CONTAINS INVALID DATA (TOO BIG OR TOO SMALL,
		USUALLY), THERE IS NO INTERACTION OF THIS MODULE WITH THE USER

33 !		THE OLD ELEMENTARY STATISTICS ARE ZEROED OUT AND THEN THE NEW
		MAXIMA, MINIMA, MEANS, STANDARD DEVIATIONS, STANDARD ERRORS,
		AND RANGES ARE COMPUTED.

34 !		IF THE USER WANTS TO EDIT HIS DATA, CONTROL IS PASSED TO
		EDIT00. IF NOT, CONTROL IS PASSED DIRECTLY TO THE NEXT
		ANALYSIS TO BE PERFORMED.

35 !		IF THERE IS BAD DATA IN THE MATRIX, A BIG MESSAGE IS PRINTED
		OUT. THE USER IS GIVEN THREE OPTIONS, BUT IS FORCED TO TAKE
		CORRECTIVE ACTION.


37 !



38 !


	HERE THE CALLING ARGUMENTS ARE RETRIEVED AND THE FILES ARE OPENED.



39	ON ERROR GOTO 500: GOSUB 10000: F$=SYS(CHR$(7%)):
	R%=VAL(MID(F$,46%,5%)): C%=VAL(MID(F$,51%,5%))
40   F3$=MID(F$,31%,15%)
45	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	H9=.9E-38
50   OPEN F3$ FOR INPUT AS FILE 3
60   DIM #3,A(250%,15%)
70   F4$=LEFT(F3$,6%)+".ESF"
80   OPEN F4$ FOR OUTPUT AS FILE 4
90   DIM#4,S(10%,15%)
95   E%=0%
99 !


	THIS CODE ZEROES OUT THE PREVIOUS ELEMENTARY STATISTICS.



100  FOR I%=0% TO 10%
110  S(I%,J%)=0.0 FOR J%=0% TO 15%
120  NEXT I%
149 !

	HERE THE MAXIMA AND MINIMA ARE BOTH ARBITRARILY SET EQUAL TO THE
	FIRST DATA POINT FOR EACH VARIABLE.


150	FOR I%=1% TO C%: J%=1%
152	IF A(J%,I%)<>H9 GOTO 155
	ELSE J%=J%+1%: IF J%<=R% GOTO 152
		ELSE PRINT "NO DATA EXISTS FOR VARIABLE";I%: GOTO 900
155	S(1%,I%)=A(J%,I%): S(2%,I%)=A(J%,I%): NEXT I%
163 !


	HERE THE SUM AND SUM OF SQUARES FOR EACH VARIABLE ARE COMPUTED AND
	THE DATA POINTS ARE SCANNED FOR THE REAL MAXIMA AND MINIMA.
164 !	NOTE THAT FLOATING POINT ERRORS, WHICH WOULD BE CAUSED (PROBABLY)
	BY SQUARING VERY LARGE NUMBERS (OR VERY SMALL ONES), ARE TRAPPED AND
	COUNTED BY THE ERROR ROUTINE AT LINE 500.



165  ON ERROR GOTO 500
167	A(0%,J%)=0 FOR J%=1% TO C%
170  FOR I%=1% TO R%
180  FOR J%=1% TO C%
185  IF A(I%,J%)=H9 GOTO 260
187	A(0%,J%)=A(0%,J%)+1
190  S(3%,J%)=S(3%,J%)+A(I%,J%)
200  S(5%,J%)=S(5%,J%)+A(I%,J%)^2
210  IF S(1%,J%)-A(I%,J%)>=0.0 GOTO 240
220  S(1%,J%)=A(I%,J%)
230  GOTO 260
240  IF S(2%,J%)-A(I%,J%)<=0.0 GOTO 260
250  S(2%,J%)=A(I%,J%)
260  NEXT J%
270  NEXT I%
272  !
	THIS SECTION COMPUTES THE MEAN (S(4%,I%)) AND STANDARD DEVIATION
	(S(5%,I%)) FOR EACH VARIABLE.  IF THERE IS ONLY ONE OBSERVATION
	FOR EACH VARIABLE THEN THE STANDARD DEVIATION IS SET TO ZERO.
273 !	THE "ON ERROR GOTO 550" IS SO THAT ROUND-OFF ERROR THAT CAUSES A
	NEGATIVE SQUARE ROOT WILL BE TRAPPED AND THE CORRESPONDING
	STANDARD DEVIATION SET TO 0.
274 !	THE NUMBER OF ROWS(R) TIMES THE SUM OF SQUARES (S(5%,I%)) SHOULD
	ALWAYS BE EQUAL TO OR GREATER THAN THE SQUARES OF SUMS
	(S(3%,I%)) EXCEPT FOR ROUND OFF ERROR.
275  IF E%<>0% GOTO 600
277  ON ERROR GOTO 550
280  FOR I%=1% TO C%
285  R=A(0%,I%): R%=R: S(0%,I%)=R
290  S(4%,I%)=S(3%,I%)/R
292  IF R%>1% GOTO 300
294  S(5%,I%)=0.0
296  GOTO 310
300  S(5%,I%)=SQR((S(5%,I%)-S(3%,I%)^2/R)/(R-1))
309 !
	HERE THE STANDARD ERROR (S(6%,I%)) AND RANGE (S(7%,I%)) ARE
	CONPUTED

310  S(6%,I%)=S(5%,I%)/SQR(R)
320  S(7%,I%)=S(1%,I%)-S(2%,I%)
330  NEXT I%
339 !


	IF THE USER DOESN'T WANT TO EDIT HIS DATA, CONTROL PASSES TO THE
	NEXT ANALYSIS MODULE. IF HE WANTS TO EDIT, THE NAME OF THE NEXT
	ANALYSIS ROUTINE, A$, IS PASSED AS AN ARGUMENT AND CONTROL IS PASSED
	TO EDIT00.



340  CLOSE 3,4
360  A$=MID(F$,56%,20%)
365  F$=LEFT(F$,55%)
370  INPUT "DO YOU WISH TO EDIT, PRINT OR SAVE YOUR DATA";N$
375  PRINT
377  IF N$="NO" OR LEFT(N$,1%)="N" OR N$="" GOTO 410
379  IF N$="YES" OR LEFT(N$,1%)="Y" GOTO 385
381  PRINT "YOU MUST ANSWER EITHER YES OR NO"
383  GOTO 370
385  F$=F$+A$
390  R$=SYS(CHR$(8)+F$)
400  CHAIN "EDIT00"+A9$
410  F$=F$+"STATCM"+A9$+"   "
420  R$=SYS(CHR$(8)+F$)
430  CHAIN A$
499 !

	THIS ERROR ROUTINE TRAPS AND COUNTS FLOATING POINT OVERFLOWS,
	WHICH WILL USUALLY BE CAUSED BY SQUARING VERY LARGE OR SMALL NUMBERS.


500	IF ERR=28% THEN GOSUB 10000: RESUME 410
505	E%=E%+1%
510  RESUME 260
549 !

	THIS ERROR ROUTINE TRAPS IMAGINARY SQUARE ROOTS CAUSED BY ROUND-OFF
	ERROR IN THE STANDARD DEVIATION CALCULATIONS.



550	IF ERR=28% THEN GOSUB 10000: RESUME 410
555	IF ERR<>54% THEN RESUME 600
560  S(5%,I%)=0.0
570  RESUME 310
599 !



	THIS ERROR ROUTINE INFORMS THE USER THAT HE HAS INVALID (ALMOST
	ALWAYS TOO BIG OR TOO SMALL) DATA AND FORCES HIM TO TAKE CORRECTIVE
	ACTION.



600  PRINT "****"
610  PRINT "**** YOUR MATRIX CONTAINS";E%;" DATA POINTS"
620  PRINT "**** THAT STAT11 CANNOT HANDLE."
630  PRINT "**** THIS COULD BE DUE TO INVALID DATA IN YOUR INPUT FILE"
640  PRINT "**** (POSSIBLY CAUSED BY INCORRECT ROW AND COLUMN SPECIFICATIONS"
650  PRINT "**** OR IT COULD BE BECAUSE YOU CAUSED STAT11 TO COMPUTE"
660  PRINT "**** NUMBERS THAT IN SUBSEQUENT COMPUTATIONS WILL EXCEED"
670  PRINT "**** THE MINIMUM OR MAXIMUM CAPACITY OF THE MACHINE"
680  PRINT "**** (DATA POINTS FOR STAT11 MUST BE WITHIN THE RANGE"
690  PRINT "****     1E-19 TO 1E+19 )."
700  PRINT "**** TO CORRECT THIS SITUATION, TYPE ONE OF THE FOLLOWING COMMANDS"
710  PRINT
720  PRINT "****    COMMAND          MEANING"
730  PRINT "****"
740  PRINT "****     NEW        READ NEW DATA FROM ANOTHER INPUT FILE"
750  PRINT "****"
760  PRINT "****     EDIT       GO TO EDIT ROUTINE, WHERE YOU MUST"
770  PRINT "****                CHANGE OR DELETE THE INVALID DATA"
780  PRINT "****"
790  PRINT "****     TRANSF     GO TO TRANSFORMATIONS ROUTINE, WHERE"
800  PRINT "****                YOU MUST SCALE DOWN (OR UP) YOUR DATA"
810  PRINT "****                TO GET IT WITHIN THE ACCEPTABLE RANGE"
820  PRINT
825  R$=SYS(CHR$(8)+F$)
826  CLOSE 3,4
830  INPUT "PLEASE TYPE ONE OF THE ABOVE THREE COMMANDS";E$
840  IF E$="NEW" THEN CHAIN "DATAIN"+A9$
850  IF E$="EDIT" THEN CHAIN "EDIT00"+A9$ 45
860  IF E$="TRANSF" THEN CHAIN "TRANSF"+A9$
870  PRINT "PLEASE TYPE EITHER NEW, EDIT, OR TRANSF"
880  INPUT "IF YOU WANT TO QUIT NOW, HIT CARRIAGE RETURN";E$
890  IF E$<>"" GOTO 840
900  KILL F3$
910  KILL LEFT(F3$,6%)+".ESF"
920  PRINT "STAT11 ABORTED   ";TIME$(0);"   ";DATE$(0)
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32767 END
