1 !
	500.12 - STAT11 - DATAIN

		DATA ENTRY MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.



6 !	THIS MODULE READS IN THE USER'S DATA FROM EITHER A VIRTUAL MATRIX FILE
	OR THE KEYBOARD AND THEN STORES THE DATA IN A WORKING STORAGE VIRTUAL
	MATRIX.


7 ! 	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973



8  !   	MODIFICATIONS:   MAY, 1975
	
	MODIFIED TO ACCEPT MISSING DATA POINTS

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !
	CALLING ARGUMENTS

		1) VARIABLE NAME:	F1$
		   RANGE OF VALUES:	ANY VALID BASIC-PLUS FILE NAME
		   USE:			NAME OF USER'S INPUT DATA FILE

11 !		2) VARIABLE NAME:	F2$
		   RANGE OF VALUES:	ANY VALID BASIC-PLUS FILE NAME
		   USE:			NAME FOR OUTPUT FILE TO SAVE DATA

12 !		3) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			NAME OF FILE WHERE 250 ROW BY
					15 COLUMN DATA MATRIX WILL BE STORED

13 !		4) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			NUMBER OF ROWS IN DATA MATRIX

14 !		5) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			NUMBER OF COLUMNS IN DATA MATRIX


15 !
	RETURNING ARGUMENTS

		THE RETURNING ARGUMENTS ARE THE SAME AS THE CALLING
		ARGUMENTS -- ALL ARE PASSED VIA COMMON STORAGE TO THE
		NEXT MODULE.


20 !	DESCRIPTION OF FUNCTION

		THIS MODULE READS IN THE USER'S DATA FROM EITHER A VIRTUAL
		MATRIX FILE OR THE KEYBOARD AND THEN STORES THE DATA IN A
		WORKING STORAGE VIRTUAL MATRIX FILE.

21 !		AFTER OBTAINING INPUT AND OUTPUT FILE NAMES FROM THE USER,
		THIS MODULE GETS THE ROW AND COLUMN NUMBER INFORMATION EITHER
		DIRECTLY FROM THE INPUT FILE MATRIX (IN THE CASE OF STAT11-
		CREATED FILES), OR FROM USER.

22 !		DATAIN THEN READS THE DATA, EITHER FROM A VIRTUAL MATRIX
		FILE OR FROM THE KEYBOARD AND STORES IT IN THE WORKING
		STORAGE FILE, F3$.

23 !		THE USER IS GIVEN THE OPTION OF HAVING ALL, PART, OR NONE OF
		THE DATA PRINTED.

24 !		AFTER THE PRINT ROUTINE, CONTROL IS PASSED TO ESCRWM FOR
		COMPUTATION OF THE ELEMENTARY STATISTICS FOR THE NEWLY
		READ DATA.

26 !


	THESE STATEMENTS ASK THE USER TO ENTER HIS FILE NAMES AND
	IF HE ENTERS AN ASTERISK, IT IS CHANGED TO "KB:" TO INDICATE
	A KEYBOARD--INPUT OR OUTPUT FILE.

27 !	THESE STATEMENTS ALSO RETRIEVE THE TEMPORARY WORK FILE NAME
	FROM COMMON, PAD THE USER'S SPECIFIED FILE NAMES WITH SPACES,
	AND OPEN AND CLOSE NON-KEYBOARD INPUT FILES TO BE SURE THAT
	THEY EXIST.



28	ON ERROR GOTO 9000: GOSUB 10000: DIM C(15%): F$=SYS(CHR$(7%))
	: PRINT "PLEASE ENTER NAMES OF INPUT AND OUTPUT FILES";:
	PRINT " (FORM: IN,OUT)"
29	GOSUB 4500: INPUT "(* FOR TERMINAL) "; F1$,F2$:
	PRINT:
	IF F1$="*" THEN F1$="KB:"
30	IF F2$="*" THEN F2$="KB:"
31	F3$=MID(F$,31%,15%):
	F2$=LEFT(F2$+SPACE$(15%),15%):
	F1$=LEFT(F1$+SPACE$(15%),15%):
	A$=MID(F$,56%,20%)
32	IF F2$<>"KB:" THEN OPEN F2$ AS FILE 3:
	CLOSE 3
33	GOTO 60
35

	ON ERROR GOTO 9000: GOSUB 10000: F$=SYS(CHR$(7%))

	! THIS IS WHERE CONTROL IS RECEIVED FROM THE STAT11 MODULE
	SINCE IT ALREADY HAS ASKED FOR THE INPUT AND OUTPUT FILES.

40	F1$=LEFT(F$,15%)
45	F2$=MID(F$,16%,15%)
50	F3$=MID(F$,31%,15%)
55	A$=MID(F$,56%,20%)
57	GOSUB 4500
59 !


	THIS SECTION OPENS THE USER'S SPECIFIED INPUT FILE (F1$)
	AND THE VIRTUAL MATRIX STORAGE FILE (F3$) PRIOR TO TRANSFERRING
	DATA FROM F1$ TO F3$.



60	!
70	OPEN F1$ FOR INPUT AS FILE 1
75	!
80	OPEN F3$ AS FILE 2
81	DIM #2,B(250%,15%):
	S1%=0%
85 !


	IF THE KEYBOARD IS TO BE THE INPUT FILE, CONTROL IS DIRECTED
	TO THE KEYBOARD INPUT ROUTINE.
86 !	FOR VIRTUAL MATRIX FILE INPUT, THE FILE IS CHECKED TO SEE IF
	ROW AND COLUMN INFORMATION IS STORED IN THE 0TH AND 1ST ROWS
	OF THE UNUSED 15TH COLUMN (ONLY COLUMNS 0 - 14 ARE USED TO
	STORE DATA.
87 !	THE ROW/COLUMN INFORMATION IS STORED THERE BY EDIT MODULE OPTION
	#7. HENCE ONLY STAT11 - CREATED FILES WILL HAVE THIS INFORMATION.
88 !	IF THE INFORMATION IS WITHIN EXPECTED BOUNDARIES (1 - 250 FOR
	ROWS, 1 - 15 FOR COLUMNS), IT IS ASSUMED TO BE CORRECT AND IS
	USED AS THE NUMBERS OF ROWS AND COLUMNS.
89 !	IF IT IS NOT WITHIN CORRECT LIMITS, THEN THE USER IS ASKED TO
	ENTER THE NUMBERS OF ROWS AND COLUMNS.



92	!
93	IF F1$="KB:            " GOTO 100
94	DIM #1,A(250%,15%)
95	!
96	R=A(0%,0%): R%=R: C=A(1%,0%): C%=C
97	!
98	IF R-R%<>0 OR C-C%<>0 OR R<1 OR R>250 OR C<1 OR C>15 GOTO 100
99	GOTO 200     !


	THIS IS THE ROW AND COLUMN NUMBER INPUT ROUTINE, USED FOR
	BOTH KEYBOARD AND VIRTUAL MATRIX INPUT FILES.



100	PRINT "TYPE NUMBER OF ROWS AND COLUMNS OF DATA."
110	INPUT "(FORM: ROWS,COLUMNS)"; R%,C%
115	IF R%>0% AND R%<=250% AND C%>0% AND C%<=15% GOTO 125
117	PRINT "NUMBER OF ROWS MUST BE BETWEEN 1 AND 250"
119	PRINT "NUMBER OF COLUMNS MUST BE BETWEEN 1 AND 15"
121	PRINT "PLEASE TRY TYPING THEM AGAIN"
123	GOTO 110
125	PRINT
130	IF F1$<>"KB:            " GOTO 200
139 !


	THIS IS THE KEYBOARD INPUT ROUTINE, WHICH USES THE GOSUB 2000
	FOR EACH ROW OF INPUT.



140	PRINT "IF YOU HAVE DATA MISSING, TYPE AN 'X' WHERE THE VALUE":
	PRINT "WOULD NORMALLY OCCUR": PRINT:
	PRINT "ENTER";R%," ROWS, ONE AT A TIME."
145   	B(0%,K%)=0 FOR K%=1% TO C%
150	FOR J%=1% TO R%
155	PRINT "ROW";J%;
160	GOSUB 2000
180	NEXT J%
182 	B(0%,0%)=R%: B(1%,0%)=C%
185	PRINT
190	GOTO 3000
199 !


	HERE THE VIRTUAL MATRIX INPUT FILE IS READ INTO THE F3$ FILE.


200	H9=.9E-38
210	B(0%,K%)=0 FOR K%=1% TO C%
250	FOR J%=1% TO R%
260	FOR K%=1% TO C%
270	IF A(J%,K%)<>H9 THEN B(0%,K%)=B(0%,K%)+1
300	B(J%,K%)=A(J%,K%)
310	NEXT K%
320	NEXT J%
325	B(0%,0%)=R: B(1%,0%)=C
330	PRINT
340	PRINT F1$;" CONTAINS";R%;" ROWS AND";C%;" COLUMNS OF DATA"
345	PRINT
350	GOTO 3000
498 !


	THIS SECTION MIGHT BE RE-ACTIVATED FOR VERSION #2. IT IS FOR
	SEQUENTIAL RECORD INPUT FILES.

499 ! NOTE 500-1010 ARE INACTIVE SINCE ONLY VIRTUAL ARRAYS ALLOWED:
500  FIELD #1,512% AS B$
550  P%=1%  :   U%=0%
560  FOR J%=1% TO R%
570  FOR K%=1% TO C%
580  N$=""
590  IF P%<>1% GOTO 600
595  GET #1
600  IF ASCII(B$)=26 GOTO 1000
610  IF ASCII(B$)=32 GOTO 702
620  IF ASCII(B$)=13 GOTO 702
630  IF ASCII(B$)=10 GOTO 702
635  IF ASCII(B$)=44 GOTO 702
640  N$=N$+LEFT(B$,1%)
650  U%=1%
655  B$=RIGHT(B$,2%)
660  P%=P%+1%
670  IF P%<=512% GOTO 600
690  P%=1%
700  GOTO 590
702  IF U%=1% GOTO 710
704  B$=RIGHT(B$,2%)
706  P%=P%+1%
707  IF P%<=512% GOTO 600
708  P%=1%
709  GOTO 590
710  U%=0%
720  B(J%,K%)=VAL(N$)
725  B$=RIGHT(B$,2%)
730  P%=P%+1%
740  IF P%<=512% GOTO 760
750  P%=1%
760  NEXT K%
770  NEXT J%
775  PRINT
780  PRINT "LAST DATA ITEM READ FROM INPUT FILE ";F1$
785  PRINT
790  GOTO 3000
1000 PRINT "END OF FILE ENCOUNTERED BEFORE ALL THE DATA WAS READ."
1010 GOTO 3100
1999 !


	HERE IS WHERE THE USER'S KEYBOARD-ENTERED DATA IS ACCEPTED AND
	STORED, ROW BY ROW, IN THE F3$ FILE.



2000 Z%=1%: H9=.9E-38
2003	ON ERROR GOTO 2140
2005 INPUT LINE L$
2020 L$=LEFT(L$,LEN(L$)-2)+","
2030 FOR K%=1% TO C%
2040 Z%=INSTR(1%,L$,",")
2050 IF Z% = 0% GOTO 2090
2060	IF Z%=1% OR LEFT(L$,Z%-1%)="X" THEN B(J%,K%)=H9 ELSE
	B(J%,K%)=VAL(LEFT(L$,Z%-1%)): B(0%,K%)=B(0%,K%)+1
2070 L$=RIGHT(L$,Z%+1%)
2080 GOTO 2120
2090 INPUT LINE L$
2100 L$=LEFT(L$,LEN(L$)-2)+","
2110 GOTO 2040
2120 NEXT K%
2130 GOTO 2300
2140	IF ERR=28% THEN GOSUB 10000: R%,C%=0%: RESUME 3002
2142	IF LEFT(L$,Z%-1%)="" THEN B(J%,K%)=H9: RESUME 2070
2145 PRINT "YOU TYPED IN NON-NUMERICS FOR YOUR DATA"
2150 PRINT"PLEASE TYPE ONLY NUMBERS, SEPARATED BY COMMAS"
2160 PRINT "YOU MUST RE-TYPE THE ENTIRE ROW,"; C%; " VALUES"
2230 RESUME 2005
2300	ON ERROR GOTO 9000: RETURN
2990 !


	HERE RETURNING ARGUMENTS ARE LOADED INTO COMMON AND CONTROL
	IS PASSED ONTO ESCRWM SO THAT THE ELEMENTARY STATISTICS FOR
	THE DATA MATRIX CAN BE COMPUTED.
2991 !	CONTROL IS NEVER PASSED TO STATCM (LINE 3100) SINCE THE ONLY
	REFERENCE TO THAT STATEMENT IS FROM THE ROUTINE FOR SEQUENTIAL
	FILE INPUT (LINES 500-1010) , WHICH IS NOT USED IN THIS VERSION
	OF STAT11.



3000 GOSUB 4000
3002 CLOSE 1,2
3005 F$=""
3010 R$="00000"+RIGHT(NUM$(R%),2%)
3020 C$="00000"+RIGHT(NUM$(C%),2%)
3030 F$=F$+MID(R$,LEN(R$)-5%,5%)
3040 F$=F$+MID(C$,LEN(C$)-5%,5%)
3050 F$=F1$+F2$+F3$+F$
3060 F$=F$+A$
3070 R$=SYS(CHR$(8)+F$)
3090	CHAIN "ESCRWM"+A9$ IF R%<>0% AND C%<>0%
3100 CHAIN "STATCM"+A9$
3999 !


	THIS ROUTINE PROVIDES PRINTING OF ALL OR PART OF THE USER'S
	DATA MATRIX. IT IS COMPLICATED BY THE FACT THAT THE TABLE MUST
	BE PRINTED IN TWO OR THREE PARTS IF THE MATRIX CONTAINS MORE
	THAN 6 COLUMNS OF DATA.



4000	!
4010 INPUT "ENTER PRINT OPTION (0=NO PRINT,1=ENTIRE MATRIX,2=SUBMATRIX)";O%
4020 ON O%+1% GOTO 4400,4050,4080
4030 PRINT "PLEASE TRY AGAIN; TYPE ONLY 0,1, OR 2"
4040	GOTO 4000
4050 C1%=1% : C8%=1% : C2%=C% : C9%=C%
4060 R1%=1% : R2%=R%
4070 GOTO 4130
4080	!
4085 S1%=1%
4090 INPUT "TYPE BEGINNING ROW, END ROW"; R1%,R2%
4093 IF R1%>=1% AND R2%>=1% AND R1%<=R% AND R2%<=R% GOTO 4110
4096 PRINT "YOUR ROW NUMBERS MUST BE BETWEEN 1 AND"; R%
4099 PRINT "PLEASE TRY AGAIN"
4101 GOTO 4090
4110 S1%=2%
4111 INPUT "TYPE BEGINNING COLUMN, END COLUMN";C1%,C2%
4112 IF C1%>=1% AND C2%>=1% AND C1%<=C% AND C2%<=C% AND C2%>=C1%
	GOTO 4120
4114 PRINT "YOUR COLUMN NUMBERS MUST BE BETWEEN 1 AND"; C%
4116 PRINT "PLEASE TRY AGAIN"
4118 GOTO 4110
4120 C8%=C1% : C9%=C2% : PRINT
4125 S1%=0%
4130 IF (C9%-C8%)>5% THEN C9%=C8%+5%
4140 PRINT : PRINT "ROW";TAB(35);"COLUMN" : PRINT
4150 I%=10%
4160 FOR K%=C8% TO C9%
4170 PRINT TAB(I%);K%;
4180 I%=I%+11%
4190 NEXT K%
4200 PRINT: H9=.9E-38
4210 FOR I%=R1% TO R2%
4220 PRINT I%;TAB(5%);
4230 FOR J%=C8% TO C9%
4235 IF B(I%,J%)=H9 THEN PRINT SPACE$(11%);: GOTO 4250
4240 PRINT USING " #####.####",B(I%,J%);
4250 NEXT J%
4260 PRINT
4270 NEXT I%
4280 PRINT : PRINT
4290 IF C2%=C9% GOTO 4400
4300 C8%=C9%+1% : C9%=C2%
4310 GOTO 4130
4400 RETURN
4500	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	RETURN
08999	!

	ERROR ROUTINES

09000	IF ERR=28% THEN GOSUB 10000: R%,C%=0%: RESUME 3002
09010	IF ERL<85% THEN PRINT
	"STAT11 IS UNABLE TO USE THE DESIGNATED FILE. YOU SHOULD CHECK"
	: PRINT "THE FILE NAME AND PROTECTION CODE FOR STARTERS"
	: RESUME 28
09020	IF ERL<98 THEN R%,C%=0%: RESUME 100
09030	IF ERL>4000 AND ERL<4040 THEN PRINT
	"PLEASE ENTER 0, 1 OR 2": RESUME 4010
09040	PRINT "YOU TYPED NON-NUMERIC ROW AND/OR COLUMN NUMBERS":
	PRINT "PLEASE TYPE ONLY NUMBERS AND SEPARATE THEM WITH A COMMA"
09050	IF S1%=1% THEN RESUME 4090 ELSE IF S1%=2% THEN RESUME 4110
09060	RESUME 100
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32750	END
