1 REM	!	P K D E M O

2!		PROGRAM		: PKDEMO
5!		VERSION		: 6B
6!		EDIT		: 01
7!		EDIT DATE	: 27-JAN-76
8!
9!		AUTHOR		: MARTIN MINOW

10	EXTEND

20	!

21!	VER/ED		EDIT DATE	REASON
  !
100 REM	! This program demonstrates pseudo keyboard usage	&
	! by spooling a control file to the PK: device and	&
	! writing all output from the controlled job to a log	&
	! file.  PKDEMO is intended as a demonstration		&
	! of pseudo keyboard usage only.  It lacks adequate 	&
	! functionality and error-handling needed for general	&
	! usage.  						&
	! Control characters (CTRL/C, CTRL/Z, etc.)		&
	! cannot be transmitted to the controlled job.		&
	!							&

300	!

301!	CHANNEL #		USED FOR
   !
310 REM	!	1 KB%		KEYBOARD COMMUNICATION		&
	!	2 PK%		PSEUDO KEYBOARD CONTROL		&
	!	3 IN%		CONTROL FILE INPUT		&
	!	4 OUT%		LOG FILE OUTPUT			&
	!							&

800	!

801!	FUNCTION/SUBROUTINE		USE
   !
810 REM	! FNERR$		RETURN ERROR CODE TEXT		&
	! FNOPEN$		PROMPT AND OPEN A FILE		&
	! FNRECEIVE$		READ FROM PK:			&
	! FNRSTATUS%		CHECK FOR PK: DATA AVAILABLE	&
	! FNSEND%		SEND DATA TO THE PK:		&
	! FNSSTATUS%		CHECK CONTROLLED JOB STATUS	&
	!							&

900 REM	!	DIMENSION STATEMENTS				&
	!							&

999 REM	!							&
	!							&
1000	REM							&
	!							&
	!	I N I T I A L I Z A T I O N			&
	!							&

1010	V$="V06B-01"						&
		! SETUP VERSION-EDIT NUMBER			&

1020	PRINT IF POS(0%)					&
	\ PRINT "PKDEMO"; CHR$(9%); V$; CHR$(9%); FNERR$(0%)	&
	\ ON ERROR GOTO 19000					&
		! SIGN-ON AND INITIALIZE ERROR TRAP		&

1030	CR%=13%\ LF%=10%\ CR$=CHR$(CR%)\ LF$=CHR$(LF%)		&
	\ CRLF$=CR$+LF$\ LFCR$=LF$+CR$				&
	\ NULL$=CHR$(0%)\ LFCRNULL$=LFCR$+NULL$			&
	\ KB%=1%\ PK%=2%\ IN%=3%\ OUT%=4%			&
	\ TRUE%=(1%=1%)\ FALSE%=NOT TRUE%\ PKUNIT% = 0%		&
	\ ON ERROR GOTO 1120					&
		! SETUP SOME CANNED STRINGS AND FILE NUMBERS:	&
		! KB%	USER TERMINAL				&
		! PK%	CONTROLLED PSEUDO-KB:			&
		! IN%	CONTROL FILE				&
		! OUT%	LOG FILE				&
		! THEN START LOOKING FOR A FREE PK: LINE	&

1110	PKFILE$="PK"+NUM1$(PKUNIT%)+":"				&
	\ OPEN PKFILE$ AS FILE PK%\ GOTO 1200			&
		! TRY OPENING ONE, EXIT IF WE GET IT		&

1120	GOTO 19000 IF ERL<>1110%				&
	\ RESUME 1140 IF ERR=8%\ GOTO 19000 IF ERR <> 6%	&
	\ PRINT "?No PK: units available"\ RESUME 32700		&
		! ERROR WHEN OPENING PK: UNIT:			&
		! 6	ILLEGIAL DEVICE (NONE AVAILABLE)	&
		! 8	DEVICE IN USE (TRY ANOTHER)		&

1140	PKUNIT%=PKUNIT%+1%\ GOTO 1110				&
		! THIS UNIT BUSY, TRY ANOTHER			&

1200	PRINT "Communicating with "; PKFILE$			&
	\ OPEN "KB:PKDEMO.CMD" AS FILE KB%			&
	\ IN$=FNOPEN$("Input","PKDEMO","CTL",IN%,TRUE%)		&
	\ INFILE$=TEMP$						&
	\ OUT$=FNOPEN$("Log",IN$,"LOG",OUT%,FALSE%)		&
	\ OUTFILE$=TEMP$\ FROMPK$=""				&
		! OPEN INPUT AND LOG FILES			&
		! INITIALIZE PK: BUFFER STRINGS:		&
		! FROMPK$	LAST LINE SENT FROM PK:		&

1210	LOGGING%=FALSE%						&
	\ IF LEFT(OUT$,3%) <> "KB:" THEN			&
	    PRINT "Log on KB: "; \ INPUT LINE TEMP$		&
	    \ LOGGING%=LEFT(CVT$$(TEMP$,-1%),1%) = "Y"		&
		! SETUP LOGGING FLAG IF NEEDED			&

2000	REM							&
	!							&
	!	M A I N    S E Q U E N C E			&
	!							&

2010	WHILE FNRSTATUS%(TRUE%) > 0%				&
	    \ TEXT$=FNRECEIVE$(TRUE%)				&
	    \ PRINT #OUT%, TEXT$;				&
	    \ PRINT #KB%,  TEXT$; IF LOGGING%			&
		! COPY RECEIVED DATA TO LOG AS LONG AS THERE	&
		! IS ANY TO COPY.  LOG ON KB: IF NEEDED.	&

2020	NEXT							&
		! GET ALL THE TEXT THERE IS TO GET		&

2100	IF FNSSTATUS% > 2% THEN SLEEP 5%			&
	    \ GOTO 2010						&
		! DON'T SEND DATA UNTIL THE CONTROLLED JOB	&
		! WANTS IT.					&

2120	ON ERROR GOTO 3000					&
	\ INPUT LINE #IN%, INLINE$				&
	\ Q%=FNSEND%(FNSQUEEZE$(INLINE$))			&
		! GET SOME INPUT STUFF AND SEND IT ALONG	&

2130	GOTO 2000						&
		! AND GO BACK FOR MORE				&

3000	GOTO 19000 IF ERR <> 11% AND ERL <> 2120%		&
	\ RESUME 3010						&
		! END OF INPUT FILE -- WE HOPE			&

3010	CLOSE IN%, OUT%, PK%					&
	\ PRINT\ PRINT #KB%, "Done, control file = "; INFILE$;	&
			", log file = "; OUTFILE$		&
	\ CLOSE KB%						&
	\ GOTO 32767						&
		! NORMAL FINISH					&
15000	DEF FNRSTATUS%(FLAG%)					&
		!						&
		! F N R S T A T U S % ( F L A G % )		&
		!						&
		! RETURN RECEIVER STATUS (=0 IF NOTHING HAS	&
		! BEEN SENT).  ANYTHING SENT IS IN FROMPK$.	&
		! IF FLAG% IS TRUE%, WE REALLY TRY TO RECEIVE;	&
		! IF FALSE%, ONLY CURRENTLY BUFFERED TEXT IS	&
		! EXAMINED.					&
		!						&

15010	FROMPK$ = FNRECEIVE$(FLAG%)\ FNRSTATUS% = LEN(FROMPK$)	&
		! RESET FROMPK$ TO BUFFERED STRING AND RETURN	&
		! STRING LENGTH					&

15020	FNEND							&

15100	DEF FNRECEIVE$(FLAG%)					&
		!						&
		! F N R E C E I V E $ ( F L A G % )		&
		!						&
		! RETURN ANY STRING FROM THE PK: UNIT.  RETURN	&
		! THE NULL STRING IF NOTHING IS AVAILABLE.	&
		! IF FLAG% IS FALSE%, ONLY CURRENTLY BUFFERED	&
		! TEXT WILL BE RETURNED:  NO I/O WILL OCCUR.	&
		!						&

15110	IF FROMPK$ = "" AND FLAG% = TRUE% THEN			&
	    ON ERROR GOTO 15160					&
	    \ INPUT LINE #PK%, FROMPK$				&
		! IF NOTHING IS CURRENTLY BUFFERED AND WE DO	&
		! WANT TO READ, READ ONE LINE FROM THE PK:	&

15120	ON ERROR GOTO 19000					&
	\ FNRECEIVE$=FROMPK$\ FROMPK$=""			&
		! RETURN WHAT WE GOT -- IF ANYTHING		&

15150	FNEND							&

15160	IF ERL <> 15110% OR ERR <> 11% THEN GOTO 19000		&
	    ELSE RESUME 15120					&
		! NOTHING AVAILABLE, RETURN NULL STRING		&
15200	DEF FNSSTATUS%						&
		!						&
		! F N S S T A T U S %				&
		!						&
		! STATUS OF PK: (SEND SIDE).  RETURNS:		&
		!    VALUE ERR  MEANING				&
		!	0    0	EDITOR WAIT			&
		!	1   28	PROGRAM INPUT WAIT		&
		!	2    5	NOT LOGGED IN			&
		!	3    3	NOT IN A WAIT STATE		&
		!	4    4	INPUT BUFFER FULL		&
		! ALL OTHER ERRORS ARE FATAL.			&
		!						&

15210	ON ERROR GOTO 15230					&
	\ PUT #PK%, RECORD 6%					&
	\ FNSSTATUS% = 0%					&
	\ GOTO 15280						&
		! DO A STATUS CHECK.  OK = EDITOR INPUT WAIT	&

15230	GOTO 19000 IF ERL <> 15210% OR				&
		(ERR <> 28% AND ERR > 5%)			&
	\ FNSSTATUS% = ERR					&
	\ FNSSTATUS% = 1% IF ERR = 28%				&
	\ FNSSTATUS% = 2% IF ERR = 5%				&
	\ RESUME 15280						&
		! CHECK FOR OK ERR AND GET THE CODE		&

15280	ON ERROR GOTO 19000					&

15290	FNEND							&

15300	DEF FNSEND%(TEXT$)					&
		!						&
		! F N S E N D % ( T E X T $ )			&
		!						&
		! SEND TEXT DOWN THE PK: LINE			&
		!						&

15310	PRINT #PK%, RECORD 9%, TEXT$;				&
	\ FNSEND%=0%						&

15390	FNEND							&

18000	DEF FNERR$(CODE%) =					&
		CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(CODE%)),	&
			3%),4%)					&
		!						&
		! F N E R R $ ( C O D E % )			&
		!						&
		! RETURN ERROR MESSAGE CODE%			&
		!						&

18100	DEF FNOPEN$(PROMPT$,FILE$,EXT$,UNIT%,INPUTMODE%)	&
		!						&
		! F N O P E N $ ( P R O M P T $ ,   F I L E $ ,	&
		!	E X T $ ,   U N I T % ,			&
		!	I N P U T M O D E % )			&
		!						&
		! OPEN A FILE AFTER PROMPTING.  FILE$.EXT$ IS	&
		! THE DEFAULT SPECIFICATION.  KEEP TRYING IF	&
		! WE GET AN ERROR.				&
		! RETURN FILE NAME (ONLY).  THE FULL FILE	&
		! SPECIFICATION IS RETURNED IN TEMP$.		&
		!						&

18110	ON ERROR GOTO 18150					&
	\ PRINT #KB%, PROMPT$; " file <"; FILE$; ".";		&
			EXT$; "> ? ";				&
	\ INPUT LINE #KB%, TEMP$\ TEMP$=CVT$$(TEMP$,-1%)	&
	\ TEMP$=FILE$ IF TEMP$=""				&
	\ TEMP$=TEMP$+"."+EXT$ IF INSTR(1%,TEMP$,".") = 0%	&
	\ FNOPEN$=LEFT(TEMP$,INSTR(1%,TEMP$,".")-1%)		&
	\ IF INPUTMODE% THEN OPEN TEMP$ FOR INPUT AS FILE UNIT%	&
	    ELSE OPEN TEMP$ FOR OUTPUT AS FILE UNIT%		&
		! PROMPT AND GET FILE NAME.  FIXUP DEFAULTS	&
		! AND OPEN IN THE DESIRED MANNER		&

18120	ON ERROR GOTO 19000					&

18130	FNEND							&

18150	IF ERL <> 18110% THEN GOTO 19000			&
	    ELSE IF ERR = 11% THEN RESUME 32700			&
	    ELSE PRINT IF POS(0%) <> 0%				&
		\ PRINT '?Error opening file "'; TEMP$;		&
			' -- '; FNERR$(ERR)			&
		\ RESUME 18110					&
		! TROUBLE -- EXIT IF END FROM KB:		&
		! ELSE, TRY TO GET ANOTHER (BETTER) FILE	&

18200	DEF FNSQUEEZE$(TEXT$)					&
		!						&
		! F N S Q U E E Z E $ ( T E X T $ )		&
		!						&
		! CONVERT <CR><LF> TO <CR> AND			&
		!	  <LF><CR><NULL> TO <LF>		&
		!						&

18210	TEMP$=LFCRNULL$\ GOSUB 18230				&
	\ TEMP$=CRLF$\ GOSUB 18230				&
	\ FNSQUEEZE$=TEXT$					&
		! SEARCH FOR THE TERMINATOR AND CONVERT IT	&

18220	FNEND							&

18230	TEMP%=LEN(TEXT$)-LEN(TEMP$)+1%				&
	\ TEXT$=LEFT(TEXT$,TEMP%) IF RIGHT(TEXT$,TEMP%) = TEMP$	&
	\ RETURN						&
		! SEARCH FOR THE TERMINATOR, STRIP IT AWAY.	&
19000	RESUME 19010						&
		! FATAL ERROR TRAP				&

19010	E%=ERR\ E1%=ERL						&
		! SAVE ERROR VALUES (ERROR TRAP GOTO)		&

19020	PRINT IF POS(0%) <> 0%					&
	\ PRINT "?Fatal error";E%;" at line";E1%;" -- ";	&
			FNERR$(E%)				&
		! PRINT THE TROUBLE
19050	STOP							&
		! DEBUGGING HALT				&

19090	GOTO 32700						&
		! FATAL EXIT					&

32700	CLOSE Q% FOR Q%=1% TO 12%				&
		! CLOSE ALL FILES				&

32766	ON ERROR GOTO 0						&
		! DISABLE ERROR TRAPPING			&

32767	END
