1	!
	! RSTS/E SYSTEM PERFORMANCE MEASUREMENT - V5B-24
	! WRITTEN BY :
			I.F. (BUD) DAWSON
			MACMILLAN BLOEDEL LTD.
			1075 W. GEORGIA STREET
			VANCOUVER, B.C.
			CANADA       V6E3R9

2!
	RELATED PROGRAMS
		LOGTIM - CREATES INPUT FILES FOR THIS PROGRAM
		PRTIME - READS SAME INPUT FILES, AND PRINTS
			 DATA IN TABULAR FORM
		GRAPH  - READS SAME INPUT FILES FOR A MONTH,
			 PRINTS CPU TIME STATS IN GRAPH FORM


3!	DATE WRITTEN : MARCH, 1975

	'LOGTIM' WILL HAVE CREATED A VIRTUAL ARRAY OF SYSTEM STATISTICS
	FOR EACH DAY THAT IT WAS RUNNING. THIS PROGRAM WILL PRINT A GRAPH
	SHOWING A SUMMARY OF THOSE STATISTICS, ONE LINE PER DAY, FOR
4!	ANY PERIOD OF TIME, WITHIN A CERTAIN MONTH OR SPANNING SEVERAL
	MONTHS. A 'WEEKLY AVERAGE' LINE IS ALSO PRINTED, TO REFLECT THE
	TREND OF CPU TIME USAGE. THE CPU TIME CHARTED IS THE SAME AS THAT
5!	PRODUCED BY 'GRAPH'. THAT IS, CPU TIME CHARGED TO USERS, '*',
	AND TOTAL CPU TIME USED, '+'.


35	DIM X8%(5%), X9%(5%)			! SAVE 5 DAYS OF CPU TIME %'S
40	DIM M1$(12%)			! TABLE OF MONTHS FOR RANGE REQUEST
42	M1$(1) = 'JAN' : M1$(2) = 'FEB' :
	M1$(3) = 'MAR' : M1$(4) = 'APR' :
	M1$(5) = 'MAY' : M1$(6) = 'JUN'
43	M1$(7) = 'JUL' : M1$(8) = 'AUG' :
	M1$(9) = 'SEP' : M1$(10) = 'OCT' :
	M1$(11) = 'NOV' : M1$(12) = 'DEC'	! AVOID USE OF 'DATA' STATE-
						  MENT, TO NOT CONFLICT WITH
						  SUB 30000


50	DIM #1%, T$(32%) = 128%
60	INPUT 'STARTING MONTH NUMBER (1-12)'; M% :
	IF M% < 1% OR M%>12% THEN 
	&'INVALID MONTH - VALUE MUST BE 1 TO 12' :
		GOTO 60
65	INPUT 'ENDING MONTH NUMBER (1-12)'; M1% :
	IF M1% < 1% OR M1%>12% THEN 
	&'INVALID MONTH - VALUE MUST BE 1 TO 12' :
		GOTO 65
70	INPUT 'START DAY '; S8% :
	INPUT 'STOP DAY'; S9%		! GET RANGE OF DAYS TO REPORT ON
75	IF M% = M1% AND S9% < S8% THEN
		&'START DAY MUST BE < OR = STOP DAY' :
		GOTO 70		! SAME MONTH, DAYS ARE WRONG
77	INPUT 'START TIME'; S1% :
	INPUT 'STOP TIME'; S2% :
	IF S2% < S1% THEN
		&'START TIME MUST BE EARLIER THAN STOP TIME' :
		GOTO 77
78	IF S1% < 1% OR S1% > 24% 
	OR S2% < 1% OR S2% > 24% THEN
		&'TIMES MUST BE 1-24' :
		GOTO 77
79	L$ = NUM$(TIME(0)) + '.GPH' :
	GOSUB 1040			! OPEN OUTPUT AND DO HEADING
80	IF M% = M1% THEN 90		! RANGE DOES NOT GO OVER 1 MONTH
85	S7% = S9% :
	S9% = 31%			! SAVE STOP DAY IN LAST MONTH,
					  AND SET LAST DAY TO MAX FOR 1ST MTH
90	M$ = M1$(M%)			! GET NAME OF TEST MONTH
100	FOR J% = S8% TO S9% :
	GOSUB 1000			! GET REQUIRED DAYS IN THIS MONTH
120	IF E% = 1% THEN
		E% = 0% : GOTO 500	! NO FILE FOR THAT DAY - CONTINUE
130	GOSUB 30000			! SEE IF IT IS A WEEKEND
135	IF W1$ = 'SAT' OR W1$ = 'SUN' THEN
	GOTO 140 ELSE GOTO 150		! YES - NO DATA TO BE PRINTED
140	PRINT #2%,
		LEFT(D$,6%);
		'   ('; 
		W1$;
		')' : PRINT #2% :
			GOTO 500	! SHOW DATE AND SAT. OR SUN. ON REPORT
					  THEN QUIT FOR THIS LINE

150	FOR I% = 8% TO 32%		! ONLY LOOK AT ACTUAL DATA LINES
200	T1$ = T$(I%) :
	IF LEFT(T1$,4%) = '****' THEN
		GOTO 260		! NO DATA FOR THAT HOUR
250	GOSUB 2000			! SUMMARIZE LINES IN REQUESTED RANGE
255	IF P1% > S2% THEN 270		! END LOOP IF PAST STOPPING TIME
260	NEXT I%				! GET NEXT HOUR IN RANGE
270	IF U9% = 0% THEN 
		GOTO 345		! NO DATA IN REQUESTED RANGE FOR DAY
300	U9 = U9/U9% :
	U8 = 100.0 - (U8/U9%)		! GET AVERAGE CPU TIME CHARGED
					  TO USERS IN U9, AND AVERAGE FREE
					  TIME (100 % - AVG TIME USED BY USERS
							PLUS SYSTEM)

302	U7% = U7% / U9%			! GET DAILY AVERAGE OF AVG # OF USERS
305	PRINT #2%, MID(T$(1%),86%,6%);		! DATE OF THIS LINE'S DATA
307	PRINT #2%, '   '; U7%;		! PRINT DAILY AVG OF AVG # OF USERS
310	PRINT #2%, TAB(INT(U9)+16%); '*';	! PRINT '*' FOR USER RUN TIME
320	PRINT #2%, TAB(INT(U8)+16%); '+'	! PRINT '+' FOR TOTAL TIME
325	IF W7% < 5% THEN
	W7% = W7%+1% :
	X8%(W7%) = INT(U8) :
	X9%(W7%) = INT(U9) :
		PRINT #2% :
		GOTO 345			! STORE CPU TIME % BY DAYS
						  AND PRINT BLANK LINE
327	X8%(0%), X9%(0%) = 0%			! ZERO AREA TO HOLD AVERAGES
329	FOR W7% = 1% TO 4% :
	X8%(W7%) = X8%(W7%+1%) :
	X9%(W7%) = X9%(W7%+1%) :
	NEXT W7% :
		X8%(5%) = INT(U8) :
		X9%(5%) = INT(U9)		! DROP DAY 1, MOVE 2-5 ALONG,
						  INSERT NEW DAY 5
330	FOR W7% = 1% TO 5% :
	X8%(0%) = X8%(0%) + X8%(W7%) :
	X9%(0%) = X9%(0%) + X9%(W7%) :
	NEXT W7% :
		X8%(0%) = X8%(0%)/5% :
		X9%(0%) = X9%(0%)/5%		! ACCUM 5 DAYS OF CPU %
						  AND CALC AVERAGE

335	PRINT #2%,
	TAB(16%+X9%(0%)); '.'; :
	PRINT #2%,
	TAB(16%+X8%(0%)); '.'		! PRINT PERIODS TO INDICATE 
					  AVERAGE CPU TIME OF PREVIOUS 5 DAYS
345	U8, U9 = 0.00 :
	U7%, U9% = 0%			! CLEAR WORK FIELDS
350	CLOSE 1%			! CLOSE THAT INPUT FILE
500	NEXT J%
510	IF S7% = 0% THEN 550		! ONLY DOING 1 MONTH - DONE
515	M% = M% + 1% :
	S8% = 1% :
	S9% = S7% :
	IF M% = M1% THEN S7% = 0% ELSE
		S9% = 31%		! IS THIS WILL BE THE LAST MONTH,
					  (IE. M%=M1%), THEN ZERO S7% AND
					  STOP AT DAY IN S9%, ELSE DO FULL
					  MONTH AND COME BACK HERE LATER
530	GOTO 90				! DO THE NEXT MONTH
550	CLOSE 2:
	GOSUB 32100			! CLOSE GRAPH FILE AND SEND TO SPOOLER
600	GOTO 32767
1000	!
	! ESTABLISH NAMES OF FILES USING MONTH FROM M$ AND DATES FROM
	! 1 TO 31 IN FORMAT 'MMMDD.'  ALSO OPEN CORRESPONDING TEMP. DISK
	! FILE TO SEND TO SPOOLER FOR EACH DAY, IN FORMAT 'MMMDD.GPH'
	!
1010	J$ = NUM$(J%) :
	J$ = RIGHT(J$,2%) :
	IF J% < 10% THEN
		J$ = '0' + J$
1012	J$ = M$ + LEFT(J$,2%)		! PUT MONTH AND DAY TOGETHER FOR NAME
1015	ON ERROR GO TO 1100
1020	OPEN '[10,2]' + J$ FOR INPUT AS FILE 1%
1025	RETURN


1030	!
	! OPEN OUTPUT FILE AND DO PAGE HEADING
	!

1040	OPEN L$ FOR OUTPUT AS FILE 2%
1050	PRINT #2%, CHR$(12%)		! SKIP TO NEW PAGE
1051	PRINT #2%, TAB(15%);
1052	PRINT #2%,
	"CPU TIME CHARGED TO USER'S, (*), AND TOTAL CPU TIME USED, (+)";
	' WITH RSTS/E V5B - 24'
1053	PRINT #2%, TAB(33%);
	"(5-DAY ROLLING AVERAGES ARE INDICATED BY '.')" :
	PRINT #2%
1054	S1$=NUM$(S1%) : S2$=NUM$(S2%) :
	PRINT #2%, TAB(40%);
		'HOURS ON GRAPH ARE'; LEFT(S1$,LEN(S1$)-1%); ':00 TO';
		LEFT(S2$,LEN(S2$)-1%); ':59'
1055	PRINT #2% : PRINT #2% :
	PRINT #2%, TAB(6%);
		'AVG USERS 0';
1060	PRINT #2%, 
	'....5...10...15...20...25...30...35...40...45...50';
	'...55...60...65...70...75...80...85...90...95..100'
1065	PRINT #2%
1099	RETURN


1100	!
	! TRAP IF NO INPUT FILE FOR A CERTAIN DAY
	!
1110	IF ERR = 5% AND ERL = 1020 THEN
	E% = 1% : RESUME 1099		! SET SWITCH TO SAY 'NO FILE'
1120	ON ERROR GO TO 0


2000	!
	! THIS ROUTINE SUMMARIZES USER RUN TIME AND TOTAL RUN TIME FOR ALL
	! HOURS IN THE SELECTED RANGE, FOR EACH DAY. 2 LINES ARE THEN PRINTED
	! ON THE REPORT, TO REFLECT THE AVERAGES.
	!
2015	P% = INSTR(1%,T1$,':')			! FIND : BETWEEN HR AND MINUTE
2020	P1% = VAL(MID(T1$,P%-2%,2%)) :
	IF P1% < S1% OR P1% > S2% THEN 2999	! FORGET LINES EARLIER THAN
						  START TIME OR LATER THAN
						  STOP TIME
2030	U1% = INSTR(1%,T1$,'.') 		! FIND '.' IN 'USER RUN TIME'
2040	U = VAL(MID(T1$,U1%-2%,2%))		! GET INTEGER OF USER RUN TIME
2050	U1 = U + VAL(MID(T1$,U1%+1%,2%))/100.	! ADD DEC. TO INT. OF RUNTIME
2051	IF U1 = 0.00 THEN 2999			! DON'T COUNT ZERO ENTRIS
2060	U9 = U9 + U1				! ACCUM ALL USER RUN TIME,
						  TO GET AVERAGE LATER
2070	U9% = U9% + 1%				! ADD 1 TO # OF HOURS SAMPLED
2080	U1% = INSTR(43%,T1$,'.')		! FIND '.' IN 'NULL TIME'
2090	U = VAL(MID(T1$,U1%-2%,2%))		! GET INT. OF 'NULL TIME'
2100	U1 = U + VAL(MID(T1$,U1%+1%,2%))/100.	! ADD DEC. TO INT. OF NULL TIME
2110	U8 = U8 + U1				! ACCUM ALL CPU TIME USED
2120	IF INSTR(1%,T1$,':') = 3% THEN 2999	! NO AVE #USERS ON THIS DAY
2130	U7% = U7% + VAL(LEFT(T1$,2%))		! ACCUM AVG # OF USERS
2999	RETURN


30000	!
	! THIS SUB-ROUTINE WILL RETURN TODAY'S DATE, WITH THE
	! MONTH IN UPPER CASE, IN D$, WITH THE NAME OF THE
	! DAY OF THE WEEK IN W1$
	!
30002	!
	! THE FOLLOWING VARIABLE NAMES ARE USED IN THIS ROUTINE:
		FLOATING POINT:-  A,B,D,FNB,I1,I2,M,T(),Y,Y2,Y3
		INTEGER:	  D%,D%(),I%,
		STRINGS:	  D$,D1$,T1$(),W$(),W1$,Y1$


30004	!
	! SEVERAL 'DATA' STATEMENTS ARE ALSO USED. IF THE PROGRAM TO
	  WHICH THIS ROUTINE WILL BE APPENDED ALSO USES 'DATA'
	  STATEMENTS, CARE MUST BE TAKEN TO ENSURE THEY DO NOT CONFLICT.


30006	RESTORE
30008 DEF FNB(A) = INT(A/7)
30010 DIM D%(9%)
30020 DIM T(12), T1$(12), W$(7)	! VALUES, MONTH-NAMES AND DAY-NAMES
30030 READ W$(I%) FOR I% = 1% TO 7%	! GET WEEK-DAY NAMES
30040 DATA 'SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT'
30050 READ T(I%) FOR I% = 1 TO 12
30060 DATA 0,3,3,6,1,4,6,2,5,0,3,5
30070 READ T1$(I%) FOR I% = 1% TO 12%	! GET NAMES OF MONTHS IN TABLE
30080 DATA 'JAN','FEB','MAR','APR','MAY','JUN'
30090 DATA 'JUL','AUG','SEP','OCT','NOV','DEC'
30100	D$ = CVT$$(MID(T$(1%),86%,9%),32%)	! GET MM-DDD-YY IN UP CASE
30110 FOR I% = 1% TO 12% :
	IF MID(D$,4%,3%) = T1$(I%) THEN
		GO TO 30130
30120 NEXT I%
30130 D1$ = LEFT(D$,INSTR(1%,D$,'-')-1%) :
	D = VAL(D1$)			! GET TODAYS DAY
30140 M = I%				! GET TODAYS MONTH
30150 Y1$ = RIGHT(D$,8%) :
	Y = VAL(Y1$)			! GET TODAY'S YEAR
30160 Y = Y + 1900			! MAKE THE YEAR 19NN
30170 I1 = INT((Y-1500)/100)
30180 A = I1*5. + (I1+3)/4
30190 I2 = INT(A-FNB(A)*7)
30200 Y2 = INT(Y/100)
30210 Y3 = INT(Y-Y2*100)
30220 A = Y3/4 + Y3 + D + T(M) + I2
30230 B = INT(A-FNB(A)*7)+1
30240 W1$ = W$(B)			! GET DAY OF THE WEEK IN W1$
30250 RETURN
32100	!
	! THIS ROUTINE SUBMITTED THE PRINTED OUTPUT TO A SPOOLER.
	! THE NECESSARY LOGIC MAY BE INSERTED IN HERE, OR THE OUTPUT
	! DISK FILE MAY BE DUMPED TO ANY HARD-COPY TERMINAL USING $PIP
32520 RETURN				! EXIT FROM QUEUE.FIL UPDATE




32767 END
