!POVBLD -- "POV" BUILDER FOR S1401 RUN-TIME-SYSTEM.
!
! QUICK BASIC-PLUS PROGRAM FOR LOADING THE "POV.LDA" FILE
! FROM DECTAPE TO "[0,1]S1401.POV" IN THE PROPER FORMAT.
!
! YOU MUST HAVE DT0: READY (AND CONTAINING "POV.LDA")
! ********** MODIFY LINES 7 AND 9 IF LENGTH CHANGES **********
! OUTPUT IS TO "[0,1]S1401.POV"
!
! !!!!!!!!!! RUN FROM A PRIV ACCOUNT !!!!!!!!!!
!
! 13-NOV-74 --- E GIEGLER
!
5 O$="[0,1]S1401.TMP"
7 X0%=4%	!***** LENGTH OF ORIGINAL "POV.LDA" FILE
8		!***** (CONTIGUOUS FILE IN DOS).
9 C0%=4%	!********** CLUSTERSIZE BIG ENOUGH TO CONTAIN
10		!********** THE ENTIRE FILE (AT LEAST X0%)
22 I$="DT0:POV.LDA"	!CHANGE TO "POVO.LDA" FOR ODT VERSION
24 OPEN I$ FOR INPUT AS FILE 1%
30 OPEN O$ FOR OUTPUT AS FILE 2%, CLUSTERSIZE C0%
40 B1%=BUFSIZ(1%) : B2%=BUFSIZ(2%)
50 I0%=B1% : O0%=0%		!SET FOR FORCED INPUT, NO OUTPUT
60 ON ERROR GOTO 900
!
! MAIN LOOP....
!
!	I0% IS NUMBER OF "USED" CHARS OF INPUT BUFFER
!	O0% IS NUMBER OF "USED" POSITIONS OF OUTPUT BUFFER
!
100	GOSUB 300 IF O0%=B2%	!OUTPUT IF FULL OUTPUT BUFFER
110	GOSUB 200 IF I0%=B1%	!INPUT IF EMPTY INPUT BUFFER
120	T%=(B1%-I0%):
	S%=(B2%-O0%):
	T%=S% IF S%<T%		! T%=MIN((B1%-I0%),(B2%-O0%))
130	FIELD #1, I0% AS B1$, T% AS B1$
140	FIELD #2, O0% AS B2$, T% AS B2$
150	LSET B2$=B1$		! THE TRANSFER !!!!!!!!!!!!!!
160	I0%=I0%+T%:
	O0%=O0%+T%
170	GOTO 100
!
! SUBROUTINES
!
200	GET #1: I0%=0%: RETURN	!INPUT
!
300	PUT #2: O0%=0%		!OUTPUT
310	X0%=X0%-1%		!SPECIAL "ENDING" TO CONSERVE SPACE
320	RETURN IF X0%>0%	!ON THE SYSTEM DISK
330	CLOSE 2%,1% : GOTO 940
!
! ERRORS
!
900	ON ERROR GOTO 0 IF ERL<>200% OR ERR<>11%
905	RESUME 910
910	FIELD #2, O0% AS B2$, (B2%-O0%) AS B2$
920	LSET B2$=STRING$((B2%-O0%),0%)			!NULL FILL
930	GOSUB 300 : CLOSE 2%, 1%
940	NAME O$ AS "[0,1]S1401.POV"
950	CHAIN "DT0:RTSNAM.BAS"		!******CHAIN******
32767 END
