	title	'Disk Drive Table Module for CP/M V3.0'
; EDIT DATE 8-1-83, 11:23 BY DWP. (for strange side formats)

fdvers	dw	5		; floppy disk drive table version identifier
				; this value is tested by FDDRV module
				; to ensure that disk defs are compatable
	public	fdvers


false	equ	0
true	equ	not false

;  Customized for Wave Mate Bullet Single Board Computer.

bootdrive	equ	5	; set boot drive as 5"
harddisk	equ	true	; conditionally assemble hard disk
hardsize	equ	20	; set harddisk size = 20MB

	maclib	dskdef		; invoke disk definition mocros:


; Equates for all XDPH's and DPB's:
;
sd	equ	0		; flag for single density
dd	equ	-1		; flag for double density
s1	equ	0		; flag for single sided
s2	equ	-1		; flag for double sided


unit0	equ	0		; hardware unit numbers
unit1	equ	1
unit2	equ	2
unit3	equ	3
fdsel	equ	4h		; bit to select 8" drive
mdsel	equ	0		; bit to select 5" drive
wdsel	equ	80h		; winchester disk bit

rate0	equ	0		; 3/6 ms step rate
rate1	equ	1		; 6/12 ms step rate
rate2	equ	2		; 10/20 ms step rate
rate3	equ	3		; 15/30 ms step rate
mxrate	equ	4		; 3 ms step rate on minifloppies
;
; default all disk drives to nonexistent then fill in
;
Adisk	set	false
Bdisk	set	false
Cdisk	set	false
Ddisk	set	false
Edisk	set	false
Fdisk	set	false
Gdisk	set	false
Hdisk	set	false
Idisk	set	false
Jdisk	set	false
Kdisk	set	false
Ldisk	set	false
Mdisk	set	false
Ndisk	set	false
Odisk	set	false
Pdisk	set	false
	page
; Naming conventions for XDPH's:
;
;	hd5x20 = 5" hard disk, 20 megabyte
;	fdx1(n) = 8" diskette, double density, 1 side, unit (n)
;	fsx1(n) = 8" diskette, single density, 1 side, unit (n)
;	fdx2(n) = 8" diskette, double density, 2 side, unit (n)
;	md4x1(n) = 5" diskette, double density, 40 track, 1 side, unit (n)
;	md8x2(n) = 5" diskette, double density, 80 track, 2 side, unit (n)

; Generate the disk drive table so BIOSKRNL can find out if a drive exists

	cseg			; place drive table in common memory
	public	@dtbl

	if bootdrive = 8
Adisk	set	fdx10
Bdisk	set	fdx11
Cdisk	set	md8x20
Ddisk	set	md8x21
Edisk	set	md4x10
Fdisk	set	md4x11
	else
Adisk	set	md8x20
Bdisk	set	md8x21
Cdisk	set	md4x10
Ddisk	set	md4x11
Edisk	set	fdx10
Fdisk	set	fdx11
	endif
	if harddisk
	if hardsize = 20
Gdisk	set	hd5x20
	endif
	if hardsize = 15
Gdisk	set	hd5x15
	endif
	endif				; end of harddisk
;
; now generate the drive table
;
@dtbl	dw	Adisk
	dw	Bdisk
	dw	Cdisk
	dw	Ddisk
	dw	Edisk
	dw	Fdisk	
	dw	Gdisk
	dw	Hdisk
	dw	Idisk
	dw	Jdisk
	dw	Kdisk
	dw	Ldisk
	dw	Mdisk
	dw	Ndisk
	dw	Odisk
	dw	Pdisk
	page

; equates for alternate drive table
 
dssize0	equ	00000000b	; 128 bytes/sector
dssize1	equ	00000001b	; 256 bytes/sector
dssize2	equ	00000010b	; 512 bytes/sector
dssize3	equ	00000011b	; 1024 bytes/sector
dfive	equ	00000000b	; 5 inch
deight	equ	00000100b	; 8 inch
dsside	equ	00000000b	; Single sided
ddside	equ	00001000b	; Double sided
dsdens	equ	00000000b	; Single density
dddens	equ	00010000b	; Double density
 
; alternate DPB table
 
adpbtb0:

; 8" SS/SD 128 byte sectors (3740 format) 64 directory entries
 
	db	deight or dsside or dsdens or dssize0
	dw	trans		; Translate table
	dw	dpbfsx1		; Point to DPB
 
; 8" SS/DD 256 byte sectors 128 directory entries
 
	db	deight or dsside or dddens or dssize1
	dw	0		; No translate table
	dw	dpbfdx1		; Point to DPB
 
; 8" DS/DD 256 byte sectors 256 directory entries
 
	db	deight or ddside or dddens or dssize1
	dw	0		; No translate table
	dw	dpbfdx2		; Point to DPB

; 8" SS/DD 1024 byte sectors 256 directory entries
 
	db	deight or dsside or dddens or dssize3
	dw	0		; No translate table
	dw	dpbfdxk		; Point to DPB
 
; 8" DS/DD 1024 byte sectors 256 directory entries
 
	db	deight or ddside or dddens or dssize3
	dw	0		; No translate table
	dw	dpbfdxl		; Point to DPB
 
	db	0ffh		; End of table
	page
; extended disk parameter headers (XDPH's)
;
	dseg			; XDPH's can be in system memory.

	if 	harddisk
; externals for hard disk driver

	extrn	hdread,hdwrit,hdlgin,hdinit

; generate the XDPH for hard disk

	dw	0		; no alternate DPB
				; not really necessary
	dw	hdwrit
	dw	hdread
	dw	hdlgin
	dw	hdinit
	db	wdsel+unit0	; winchester disk unit 0
	db	0
	if hardsize = 20
hd5x20	dw	0		; no sector translate table
	db  0,0,0,0,0,0,0,0,0	; BDOS scratch area
	db	0		; media flag
	dw	dpbhd20		; disk parameter block
	dw	0		; CSV 0 ==> drive is permanent
	dw	0fffeh		; alloc vector set by gencpm
	dw	0fffeh,0fffeh	; let gencpm setup
	dw	0fffeh		; dirbcb, dtabcb, hash
	db	0		; hash bank is zero
	endif

;

	if hardsize = 15
hd5x15	dw	0		; no sector translate table
	db  0,0,0,0,0,0,0,0,0	; BDOS scratch area
	db	0		; media flag
	dw	dpbhd15		; disk parameter block
	dw	0		; CSV 0 ==> drive is permanent
	dw	0fffeh		; alloc vector set by gencpm
	dw	0fffeh,0fffeh	; let gencpm setup
	dw	0fffeh		; dirbcb, dtabcb, hash
	db	0		; hash bank is zero
	endif
	endif
	page

; externals for floppies

	extrn	fdread,fdwrit,fdlgin,fdinit

; set up 8 inch floppy drive unit 0.

	dw	adpbtb0		; alternate DPB available
	dw	fdwrit
	dw	fdread
	dw	fdlgin
	dw	fdinit
	db	fdsel+unit0	; physical unit 0
	db	0
fdx10	dph	0,dpbfdxl	; make it double sided/double density
				; MUST be max size for gencpm

; set up 8 inch floppy drive unit 1.

	dw	adpbtb0		; alternate DPB available
	dw	fdwrit
	dw	fdread
	dw	fdlgin
	dw	fdinit
	db	fdsel+unit1	; physical unit 1
	db	0
fdx11	dph	0,dpbfdxl	; make it double sided/double density
				; MUST be max size for gencpm
	page

; define 5" floppy, double density, 80 track 2 sided drive, unit 0.

	dw	0		; no alternate DPB
	dw	fdwrit
	dw	fdread
	dw	fdlgin
	dw	fdinit
	db	mdsel+unit0	; physical unit 0
	db	0
md8x20	dph	0,dpbmd8x2


; define 5" floppy, double density, 80 track 2 sided drive, unit 1.

	dw	0		; no alternate DPB
	dw	fdwrit
	dw	fdread
	dw	fdlgin
	dw	fdinit
	db	mdsel+unit1	; physical unit 1
	db	0
md8x21	dph	0,dpbmd8x2
	page

; define 5" floppy, double density, 80 track 2 special sided, unit 2

	dw	0		; no alternate DPB
	dw	fdwrit
	dw	fdread
	dw	fdlgin
	dw	fdinit
	db	mdsel+unit2	; physical unit 2
	db	0
md4x10	dph	0,dpbmd4x1


; define 5" floppy, double density, 80 track 2 special sided, unit 3

	dw	0		; no alternate DPB
	dw	fdwrit
	dw	fdread
	dw	fdlgin
	dw	fdinit
	db	mdsel+unit3	; physical unit 3
	db	0
md4x11	dph	0,dpbmd4x1
	page
; Now generate the DPB's for the disk drives

	cseg		; DPB must be resident in common memory
	if harddisk
	if hardsize = 20

; define 5" hard disk, 20 megabyte (unformatted)

; note that the DPB's for devices over 8MB must be constructed by hand.

surf	set	6		; number of surfaces
hdsec	set	68		; 68 sectors per surface

dpbhd20
	dw	hdsec*surf	; sectors per track
	db	5		; block shift for 4096 block size
	db	31		; block mask for 4096 block size
	db	1		; extent mask
	dw	3887		; max allocation blocks minus 1
	dw	2048-1		; max directory entries minus 1
	db	0ffh,0ffh	; directory allocation
	dw	8000h		; directory ck vector, drive is permanent
	dw	1		; one reserved track
	db	2		; physical record shift factor
	db	3		; physical record mask
	endif
	if hardsize = 15

; define 5" hard disk, 15 megabyte (unformatted)

surf	set	4		; number of surfaces
hdsec	set	68		; 68 sectors per surface

dpbhd15
	dw	hdsec*surf	; sectors per track
	db	5		; block shift for 4096 block size
	db	31		; block mask for 4096 block size
	db	1		; extent mask
	dw	2591		; max allocation blocks minus 1
	dw	2048-1		; max directory entries minus 1
	db	0ffh,0ffh	; directory allocation
	dw	8000h		; directory ck vector, drive is permanent
	dw	1		; one reserved track
	db	2		; physical record shift factor
	db	3		; physical record mask
	endif
	endif


; Wave Mate standard floppy disk defs

psec	set	5		; physical sectors/track
prec	set	1024		; bytes/physical sector
rec	set	128		; size of CP/M physical record
rec	set	128		; size of record
spt	set	(prec/rec)*psec	; records/track
sides	set	2
trk	set	80*sides
blk	set	2048
dir	set	128
cks	set	dir/4
off	set	2		; reserved tracks
den	set	DD		; set double density
side	set	S2		; set double sided
rps	set	prec/rec	; compute number records/sector
srat	set	mxrate		; set 3 ms step rate
				; buffer timeout constants in 1/10 sec
rto	set	22		; read buffer data valid timeout const.
				; 2.2 sec timeout of read data
wto	set	19		; write buffer data valid timeout const
				; 1.9 sec timeout of write data
wptrk	set	0		; write precomp track number

; define Wave Mate mini-floppy, double density, 80 track 2 side

dpbmd8x2	dpb	rec,spt,trk,blk,dir,off,cks,den,side,rps,srat,wptrk,rto,wto
	page
;
; Revised to add different double sided formats.  The Wave Mate standard
; double sided disk is configured as follows:
;
; Tracks alternate from side to side on the same cylinder such that
; all even numbered tracks are on side 0, all odd numbered tracks are
; on side 1, all tracks are placed on the disk such that the lowest
; numbered track is at the edge of the disk and the highest is at
; the innermost cylinder.
;
;	TRACK	SIDE	CYLINDER
;	0	0	0
;	1	1	0
;	2	0	1
;	3	1	1
;	4	0	2
;	ETC
;
; Alternate approaches are possible and the following scheme is now
; supported:
;
; The first 1/2 of the tracks are on side 0 and the second 1/2 of
; the tracks are on side 1.  They are arranged such that on side 0
; the track number is the same as the cylinder number, on side 1 the
; track number minus the maximum number of cylinders is the same as
; the cylinder number.
;
;	TRACK	SIDE	CYLINDER
;	0	0	0
;	1	0	1
;	2	0	2
;	MAX/2-1	0	MAX
;	MAX/2	1	0
;	MAX/2+1	1	1
;	MAX/2+2	1	2
;	MAX	1	MAX
;
; Parameters to support alternate diskette side schemes are passed to
; the FDDRV module in the sides flag as follows:
;
; IFF bit 0 = 0, ==> single sided
; IFF bit 0 = 1, ==> double sided
; IFF bit 0 = 1, then:
; IFF bit 1 = 1, ==> Wave Mate standard cylinder scheme
; IFF bit 1 = 0, then bits 2-7 define the scheme
; IFF bit 2 = 1, ==> the first 1/2 of the tracks are on side 0 in ascending
;			order and the last 1/2 are on side 1 in ascending order
;			with the maximum cylinders being 80.
; bits 3-7 are currently undefined
;
	page
; define a 5' disk with alternate side scheme
;
side	set	00000101b	; alternate side scheme

;dpbmdxx1	dpb	rec,spt,trk,blk,dir,off,cks,den,side,rps,srat,wptrk,rto,wto

;
; define Wave Mate mini-floppy, double density, 40 track 1 side.

sides	set	1
trk	set	40*sides
blk	set	1024
dir	set	64
cks	set	dir/4
den	set	DD
side	set	S1
rps	set	prec/rec
srat	set	rate0

dpbmd4x1	dpb	rec,spt,trk,blk,dir,off,cks,den,side,rps,srat,wptrk,rto,wto

; define 8" double density, single sided disk.

psec	set	26		; number of physical sectors
prec	set	256		; number bytes/physical sector
spt	set	(prec/rec)*psec	; 128 byte records/track
sides	set	1
trk	set	77*sides
blk	set	2048
dir	set	128
cks	set	dir/4
den	set	DD
side	set	S1
rps	set	prec/rec
srat	set	rate0


dpbfdx1	dpb	rec,spt,trk,blk,dir,off,cks,den,side,rps,srat,wptrk,rto,wto



; define 8" double density, double sided disk

sides	set	2
trk	set	77*sides
dir	set	256
cks	set	dir/4
side	set	s2

dpbfdx2	dpb	rec,spt,trk,blk,dir,off,cks,den,side,rps,srat,wptrk,rto,wto

; define 8" double density, single sided disk 1024 byte sectors

psec	set	8		; number of physical sectors
prec	set	1024		; number bytes/physical sector
spt	set	(prec/rec)*psec	; 128 byte records/track
sides	set	1
trk	set	77*sides
blk	set	2048
dir	set	256
cks	set	dir/4
den	set	DD
side	set	S1
rps	set	prec/rec
srat	set	rate0


dpbfdxk	dpb	rec,spt,trk,blk,dir,off,cks,den,side,rps,srat,wptrk,rto,wto
; define 8" double density, double sided disk 1024 byte sectors

sides	set	2
trk	set	77*sides
side	set	s2


dpbfdxl	dpb	rec,spt,trk,blk,dir,off,cks,den,side,rps,srat,wptrk,rto,wto

; define 8" single density, single sided, drive.

den	set	SD
side	set	s1
rps	set	1
srat	set	rate0
dir	set	64
cks	set	dir/4
wptrk	set	0ffh		; no precomp on single density disk

dpbfsx1	dpb	128,26,77,1024,dir,off,cks,den,side,rps,srat,wptrk,rto,wto
	page
; set up a standard sector translation table for 8" IBM diskette:

trans	skew	26,6,1
	end
