(*************************************************************)
(* This file contains the data type for fuseplot programs    *)
(* There are two main dynamic data structures - chip_ptr for *)
(* pinlist and tree_ptr for eqntree.                         *)
(*************************************************************)

const   index = 15 ;            (* max length of the id_name *)

type    chstring = packed array [1..index] of char;

        chip_ptr = ^chip_rec;   (*This is a ptr to a node in pinlist*)
        chip_rec = record
                    level:integer;
                    id_name : chstring;
                    pinflag : boolean;
                    polarity: boolean;
                    lsibling,rsibling,child : chip_ptr;
                    father:chip_ptr;
                   end;

        tree_ptr = ^tree_rec;    (* This is a ptr to a eqntree node *)
        tree_rec = record
                    kind,level : integer;
                    father,child,rsibling,lsibling:tree_ptr;
                    chiptr : chip_ptr;
                    polarity : boolean;
                   end;

        op_node = ^op_rec;
        op_rec  = record
                   ptr:tree_ptr;
                   next:op_node;
                  end;

        fusearray = array [1..80,1..42] of char;
        polarray  = array [1..10] of char;


;
                  e