;
; SPACEWAR FOR IMSAI 8080 AND TEKTRONIX 4013 (9600 BAUD).
;
;	COPYRIGHT (C) 1977
;	BY JEFFREY L. ZURKOW
;
; MODIFIED FOR Z80SIM BY UDO MUNK, SEPTEMBER 2008
; START CPMSIM FROM XTERM WITH WORKING TEKTRONIX EMULATION TO RUN THIS!
;
	ORG	100H
;
;
	DI
;
	IN	30	;SAVE CURRENT Z80SIM CPU SPEED
	STA	SAVEZ
	IN	31
	STA	SAVEZ+1
	MVI	A,4	;SET Z80SIM CPU SPEED TO 4 MHZ
	OUT	30
	XRA	A
	OUT	31
;
	LXI	H,0
	DAD	SP
	SHLD	SPSAVE
	LXI	SP,STACK
	LDA	70Q
	STA	SAVE71
	LHLD	71Q
	SHLD	SAVE72
	MVI	A,0C3H
	STA	70Q
	LXI	H,INT7
	SHLD	71Q
;
	MVI	C,ESC	;ADDED FOR Z80SIM TO SWITCH
	CALL	TYOUT	;XTERM TO TEKTRONIX EMULATION
	MVI	C,'['
	CALL	TYOUT
	MVI	C,'?'
	CALL	TYOUT
	MVI	C,'3'
	CALL	TYOUT
	MVI	C,'8'
	CALL	TYOUT
	MVI	C,'h'
	CALL	TYOUT
;
RESTART:
	DI
	MVI	C,ESC
	CALL	TYOUT
	MVI	C,FF
	CALL	TYOUT
;	IN	0FFH	;IMSAI FRONT PANEL, NOT APPLICABLE	
;	ANI	1	;WITH Z80SIM
;	JZ	RS1
	MVI	C,ESC
	CALL	TYOUT
	MVI	C,112
	CALL	TYOUT
RS1:	MVI	A,1
;	OUT	8	;ENABLE TEKTRONIX IN AND OUT INTERRUPTS
	OUT	27	;ENABLE Z80SIM 10MS INTERRUPT
	DB	0EDH,56H;Z80 IM 1
	XRA	A
	STA	BUFSW
	STA	TLIFE1
	STA	RSTAR1
	STA	RSTAR2
	STA	HIT1
	STA	HIT2
	STA	MTHRUST1
	STA	MTHRUST2
	STA	VTHETA1
	STA	VTHETA2
	LXI	H,BUF1
	SHLD	OUTBUF
	SHLD	BPOINT
	MVI	M,0
	INX	H
	MVI	M,13
	LXI	H,BUF2
	SHLD	CURBUF
	LXI	H,BUF3
	SHLD	MIDBUF
	MVI	M,13
	MVI	A,PI/2
	STA	THETA1
	MVI	A,3*PI/2
	STA	THETA2
	LXI	H,32 * X1INIT
	SHLD	X1
	SHLD	T1X
	LXI	H,32 * Y1INIT
	SHLD	Y1
	SHLD	T1Y
	LXI	H,32 * X2INIT
	SHLD	X2
	LXI	H,32 * Y2INIT
	SHLD	Y2
	LXI	H,0
	SHLD	VX1
	SHLD	VY1
	SHLD	VX2
	SHLD	VY2
	EI
	JMP	START
;
;
SAVE71:	DB	0
SAVE72: DW	0
SAVEZ:	DW	0	;SAVE Z80SIM CPU SPEED
BPOINT:	DW	0
;
;	GLOBAL EQUATES
;	====== =======
;
;
;TEKSTAT  EQU	3	;IMSAI PORTS FOR TEKTRONIX TERMINAL
;TEKDATA  EQU	2
TEKSTAT  EQU	0	;Z80SIM PORTS FOR TEKTRONIX TERMINAL
TEKDATA  EQU	1
PI	 EQU	200Q
THRUST	 EQU	0FH	;MAIN THRUST MAGNITUDE
TSPEED	 EQU	09H	;TORPEDO SPEED
TLIFE	 EQU	20H	;TORPEDO LIFETIME
ESC	 EQU	27
FF	 EQU	12
FRATE	 EQU	07H
RRATE	 EQU	01H
DELTA	 EQU	0FFH
EXRATE	 EQU	03H
SMAX	 EQU	14
X1INIT	 EQU	150
Y1INIT	 EQU	150
X2INIT	 EQU	875
Y2INIT	 EQU	640
THETA0	 EQU	PI/2
DELAY	 EQU	100
SIZE	 EQU	3
;
;
;
;
;	KEYBOARD SHIP CONTROL CHARACTERS
;	======== ==== ======= ==========
;
;
;LEFT1C	EQU	'A'
;RT1C	EQU	'S'
;FOR1C	EQU	'D'
;TORP1C	EQU	'F'
;
LEFT1C	EQU	'a'
RT1C	EQU	's'
FOR1C	EQU	'd'
TORP1C	EQU	'f'
;
;LEFT2C	EQU	'J'
;RT2C	EQU	'K'
;FOR2C	EQU	'L'
;TORP2C	EQU	';'
;
LEFT2C	EQU	'h'
RT2C	EQU	'j'
FOR2C	EQU	'k'
TORP2C	EQU	'l'
;
CTRLC	EQU	03
;
;
;
;	OUTPUT BUFFER STUFF
;	====== ====== =====
;
;
BUFSW:	DB	0
OUTBUF:	DW	0
MIDBUF:	DW	0
CURBUF:	DW	0
;
;
;
;
;
;
START:	LHLD	CURBUF
ST0:	CALL	SHIP1
	CALL	TORP1
	CALL	SHIP2
	CALL	TORP2
	MVI	M,13
;
	LXI	H,RATE
	INR	M
;
	DI
	LHLD	CURBUF
	XCHG
	LHLD	MIDBUF
	SHLD	CURBUF
	XCHG
	SHLD	MIDBUF
	MVI	A,1
	STA	BUFSW
	EI
;
;
;  ROTATION INTEGRATORS
;
	LDA	RATE
	ANI	RRATE
	JNZ	ST1
;
	LDA	THETA1
	MOV	B,A
	LDA	VTHETA1
	ADD	B
	STA	THETA1
;
	LDA	THETA2
	MOV	B,A
	LDA	VTHETA2
	ADD	B
	STA	THETA2
;
ST1:	LHLD	X1
	XCHG
	LHLD	VX1
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	X1
;
	LHLD	Y1
	XCHG
	LHLD	VY1
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	Y1
;
	LHLD	VX2
	XCHG
	LHLD	X2
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	X2
;
	LHLD	VY2
	XCHG
	LHLD	Y2
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	Y2
;
	LDA	TLIFE1
	ORA	A
	JZ	ST2
	LHLD	T1X
	XCHG
	LHLD	VT1X
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	T1X
;
	LHLD	T1Y
	XCHG
	LHLD	VT1Y
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	T1Y
;
	JMP	ST2A
;
;
ST2:	LHLD	X1
	SHLD	T1X
	LHLD	Y1
	SHLD	T1Y
;
;
ST2A:	LDA	TLIFE2
	ORA	A
	JZ	ST2B
	LHLD	T2X
	XCHG
	LHLD	VT2X
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	T2X
;
	LHLD	T2Y
	XCHG
	LHLD	VT2Y
	DAD	D
	MOV	A,H
	ANI	7FH
	MOV	H,A
	SHLD	T2Y
	JMP	ST3A
;
ST2B:	LHLD	X2
	SHLD	T2X
	LHLD	Y2
	SHLD	T2Y
;
;
ST3A:	LDA	RATE
	ANI	EXRATE
	JNZ	ST4
	LDA	HIT2
	ORA	A
	JZ	ST3B
	LXI	H,DELAY2
	DCR	M
	JZ	RESTART
	LXI	H,RSTAR2
	MOV	A,M
	CPI	SMAX*4
	JNC	ST3B
	INR	A
	MOV	M,A
;
ST3B:	LDA	HIT1
	ORA	A
	JZ	ST4
	LXI	H,DELAY2
	DCR	M
	JZ	RESTART
	LXI	H,RSTAR1
	MOV	A,M
	CPI	SMAX*4
	JNC	ST4
	INR	A
	MOV	M,A
;
ST4:	LDA	TLIFE1
	ORA	A
	JZ	ST6
	LHLD	X2
	XCHG
	LHLD	T1X
	CALL	NBRHD
	JNZ	ST5
	LHLD	Y2
	XCHG
	LHLD	T1Y
	CALL	NBRHD
	JNZ	ST5
	XRA	A
	STA	TLIFE1
	CALL	KILL2
;
ST5:	LHLD	X1
	XCHG
	LHLD	T1X
	CALL	NBRHD
	JNZ	ST6
	LHLD	Y1
	XCHG
	LHLD	T1Y
	CALL	NBRHD
	JNZ	ST6
	XRA	A
	STA	TLIFE1
	CALL	KILL1
;
ST6:	LDA	TLIFE2
	ORA	A
	JZ	ST8
	LHLD	X1
	XCHG
	LHLD	T2X
	CALL	NBRHD
	JNZ	ST7
	LHLD	Y1
	XCHG
	LHLD	T2Y
	CALL	NBRHD
	JNZ	ST7
	XRA	A
	STA	TLIFE2
	CALL	KILL1
;
ST7:	LHLD	X2
	XCHG
	LHLD	T2X
	CALL	NBRHD
	JNZ	ST8
	LHLD	Y2
	XCHG
	LHLD	T2Y
	CALL	NBRHD
	JNZ	ST8
	XRA	A
	STA	TLIFE2
	CALL	KILL2
;
ST8:	LHLD	X1
	XCHG
	LHLD	X2
	CALL	NBRHD
	JNZ	ST9
	LHLD	Y1
	XCHG
	LHLD	Y2
	CALL	NBRHD
	JNZ	ST9
	CALL	KILL1
	CALL	KILL2
;
ST9:	JMP	START
;
;
;
;
KILL1:	LDA	HIT1
	ORA	A
	RNZ
	STA	MTHRUST1
	INR	A
	STA	HIT1
	STA	RSTAR1
	MVI	A,DELAY
	STA	DELAY2
	RET
;
;
KILL2:	LDA	HIT2
	ORA	A
	RNZ
	STA	MTHRUST2
	INR	A
	STA	HIT2
	STA	RSTAR2
	MVI	A,DELAY
	STA	DELAY2
	RET
;
;
;
;
LEAVE:	DI
	LHLD	SPSAVE
	SPHL
	MVI	C,13
	CALL	TYOUT
	MVI	C,10
	CALL	TYOUT
;
	MVI	C,ESC	;ADDED FOR Z80SIM
	CALL	TYOUT	;TO SWITCH FROM TEKTRONIX EMULATION BACK TO XTERM
	MVI	C,CTRLC
	CALL	TYOUT
;
	LDA	SAVE71
	STA	70Q
	LHLD	SAVE72
	SHLD	71Q
	XRA	A
;	OUT	8
	OUT	27	;DISABLE Z80SIM 10MS INTERRUPT
;
	LDA	SAVEZ	;RESET Z80SIM CPU SPEED
	OUT	30
	LDA	SAVEZ+1
	OUT	31
;
	RET
;
;
;
;
NBRHD:	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	JP	NB1
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
NB1:	LXI	D,NOT DELTA
	MOV	A,D
	ANA	H
	MOV	H,A
	MOV	A,E
	ANA	L
	ORA	H
	RET
;
;
;
;
;	POINT
;	=====
;
;	POINT GENERATES A POINT FROM POLAR COORDINATES, WITH ORIGIN
;	AT (X,Y) AND THE WHOLE COORDINATE SYSTEM ROTATED BY THETA
;	ABOUT THE ORIGIN.  CALL POINT WITH THE RADIUS IN B,
;	THE ANGLE IN C, AND HL POINTING TO THE MEMORY BUFFER WHERE
;	THE RESULTS ARE TO BE PUT.  ON RETURN, THE BUFFER WILL CONTAIN
;	FIVE NEW BYTES, STARTING AT THE PREVIOUS (HL):  4 BYTES ARE
;	THE TEK 4013 COORDINATES OF THE FINAL POINT, Y FIRST,
;	AND THE FIFTH IS A ZERO BYTE TO ALLOW PROPER SETTLING TIME FOR
;	THE VECTOR GENERATOR IN THE 4013.  HL WILL POINT TO THE BYTE
;	AFTER THE NUL (ZERO) BYTE.
;
;
POINT:	PUSH	H	;SAVE BUFFER ADDRESS
	LDA	THETA	;GET SHIP ANGLE
	ADD	C	;ADD ANGLE FOR THIS POINT
	MOV	C,A
	PUSH	B	;SAVE RADIUS (R) AND NEW ANGLE
	CALL	SIN
	POP	B	;GET R AGAIN (SIN CLOBBERED B)
	PUSH	B	; BUT LEAVE IT ON STACK.
	MOV	E,A	;PUT SINE IN E FOR MULTIPLIER
	CALL	MUL	;THIS GETS R*SIN(THETA+PHI) IN HL
	CALL	SHIFT	;THIS SCALES THE RESULT
	XCHG		;NOW ADD Y
	LHLD	Y
	DAD	D
	MOV	A,H
	RLC
	JC	ERASE1
	CALL	TEKY	;CONVERT TO 4013 FORMAT
	POP	B
	XCHG		;SAVE RESULT
	POP	H	;GET BUFFER ADDRESS
	MOV	M,D	;SAVE FIRST BYTE
	INX	H
	MOV	M,E	;SAVE SECOND BYTE
	INX	H
	PUSH	H
	PUSH	B
	MOV	A,C
	CALL	COS	;GET COSINE(THETA+PHI)
	POP	B	;GET R AGAIN
	MOV	E,A	;SET UP FOR MULTIPLY
	CALL	MUL
	CALL	SHIFT
	XCHG
	LHLD	X
	DAD	D
	MOV	A,H
	RLC
	JC	ERASE2
	CALL	TEKX
	XCHG
	POP	H
	MOV	M,D
	INX	H
	MOV	M,E
	INX	H
	XRA	A
;	MOV	M,A
;	INX	H
;	MOV	M,A
;	INX	H
	ORA	A
	RET
ERASE1:	POP	B
ERASE2:	POP	H
	STC
	RET
;
;
;
;
SHIP1:	PUSH	H
	LDA	THETA1
	STA	THETA
	LHLD	X1
	SHLD	X
	LHLD	Y1
	SHLD	Y
	LHLD	VX1
	SHLD	VX
	LHLD	VY1
	SHLD	VY
	LDA	MTHRUST1
	ORA	A
	JZ	SHP1B
	LDA	RATE
	ANI	FRATE
	JNZ	SHP1B
	MVI	A,THRUST
	STA	MAG
	CALL	RESOLVE
	LHLD	VX
	SHLD	VX1
	LHLD	VY
	SHLD	VY1
;
SHP1B:	LDA	T1GO
	ORA	A
	JZ	SHP1C
	XRA	A
	STA	T1GO
	MVI	A,TLIFE
	STA	TLIFE1
	CALL	FIRE
	LHLD	VX
	SHLD	VT1X
	LHLD	VY
	SHLD	VT1Y
;
	LHLD	X
	SHLD	T1X
	LHLD	Y
	SHLD	T1Y
SHP1C:	POP	H
;
	LDA	HIT1
	ORA	A
	LDA	RSTAR1
	JNZ	STARB
;
	PUSH	H
	MVI	M,29
	INX	H
	MVI	B,5*SIZE
	MVI	C,0
	CALL	POINT
	JC	BLANK1
	MVI	B,4*SIZE
	MVI	C,200Q
	LDA	MTHRUST1
	ORA	A
	JZ	SHP1A
	MVI	B,6*SIZE
SHP1A:	CALL	POINT
	JC	BLANK1
	MVI	M,29
	INX	H
	MVI	B,5*SIZE
	MVI	C,9AH
	CALL	POINT
	JC	BLANK1
	MVI	B,5*SIZE
	MVI	C,66H
	CALL	POINT
	JC	BLANK1
	POP	B	;CLEAR STACK
	RET
BLANK1:	POP	H
	RET
;
;
;
;
SHIP2:	PUSH	H
	LDA	THETA2
	STA	THETA
	LHLD	X2
	SHLD	X
	LHLD	Y2
	SHLD	Y
	LHLD	VX2
	SHLD	VX
	LHLD	VY2
	SHLD	VY
	LDA	MTHRUST2
	ORA	A
	JZ	SHP2A
	LDA	RATE
	ANI	FRATE
	JNZ	SHP2A
	MVI	A,THRUST
	STA	MAG
	CALL	RESOLVE
	LHLD	VX
	SHLD	VX2
	LHLD	VY
	SHLD	VY2
;
SHP2A:	LDA	T2GO
	ORA	A
	JZ	SHP2B
	XRA	A
	STA	T2GO
	MVI	A,TLIFE
	STA	TLIFE2
	CALL	FIRE
	LHLD	VX
	SHLD	VT2X
	LHLD	VY
	SHLD	VT2Y
	;
	LHLD	X
	SHLD	T2X
	LHLD	Y
	SHLD	T2Y
;
SHP2B:	POP	H
	LDA	HIT2
	ORA	A
	LDA	RSTAR2
	JNZ	STARB
	PUSH	H
	MVI	M,29
	INX	H
	MVI	B,5*SIZE
	MVI	C,0
	CALL	POINT
	JC	BLANK2
	MVI	B,5*SIZE
	MVI	C,66H
	CALL	POINT
	JC	BLANK2
	MVI	B,5*SIZE
	MVI	C,9AH
	CALL	POINT
	JC	BLANK2
	MVI	B,5*SIZE
	MVI	C,0
	CALL	POINT
	JC	BLANK2
	LDA	MTHRUST2
	ORA	A
	JZ	SHP2C
	MVI	M,29
	INX	H
	MVI	B,3*SIZE
	MVI	C,PI
	CALL	POINT
	JC	BLANK2
	MVI	B,5*SIZE
	MVI	C,PI
	CALL	POINT
	JC	BLANK2
SHP2C:	POP	B
	RET
BLANK2:	POP	H
	RET
;
;
;
;
TORP1:	MVI	M,29
	INX	H
	PUSH	H
	LHLD	T1Y
	CALL	TEKY
	XCHG
	POP	H
	MOV	M,D
	INX	H
	MOV	M,E
	INX	H
	PUSH	H
	LHLD	T1X
	CALL	TEKX
	XCHG
	POP	H
	MOV	M,D
	INX	H
	MOV	M,E
	INX	H
	MVI	M,0
	INX	H
	MVI	M,0
	INX	H
	MOV	M,E
	INX	H
	RET
;
;
;
;
;
TORP2:	MVI	M,29
	INX	H
	PUSH	H
	LHLD	T2Y
	CALL	TEKY
	XCHG
	POP	H
	MOV	M,D
	INX	H
	MOV	M,E
	INX	H
	PUSH	H
	LHLD	T2X
	CALL	TEKX
	XCHG
	POP	H
	MOV	M,D
	INX	H
	MOV	M,E
	INX	H
	XRA	A
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,E
	INX	H
	RET
;
;
;
;
;
STARB:	PUSH	H
	STA	RSTAR
	MVI	M,29
	INX	H
	MVI	C,0
	CALL	STARB1
	MVI	C,PI
	CALL	STARB1
	MVI	M,29
	INX	H
	MVI	C,5*PI/4
	CALL	STARB1
	MVI	C,PI/4
	CALL	STARB1
	MVI	M,29
	INX	H
	MVI	C,PI/2
	CALL	STARB1
	MVI	C,3*PI/2
	CALL	STARB1
	MVI	M,29
	INX	H
	MVI	C,7*PI/4
	CALL	STARB1
	MVI	C,3*PI/4
	CALL	STARB1
	POP	B
	RET
;
STARB1:	LDA	RSTAR
	MOV	B,A
	CALL	POINT
	RNC
	POP	B
	POP	H
	RET
;
;
;
;
;
;
INT7:	PUSH	PSW
	PUSH	H
	IN	TEKSTAT
	ANI	2	;WORKS WITH Z80SIM BECAUSE STATUS = 0FFH WHEN
	JNZ	INPUT	;INPUT IS AVAILABLE
	LHLD	BPOINT
	MOV	A,M
	CPI	13
	JZ	BUFEND
	OUT	TEKDATA
	INX	H
	SHLD	BPOINT
;
EXIT7:	POP	H
	POP	PSW
	EI
	RET
;
BUFEND:	LDA	BUFSW
	ORA	A
	JZ	BUFEN1
	PUSH	D
	XRA	A
	STA	BUFSW
	LHLD	MIDBUF
	XCHG
	LHLD	OUTBUF
	SHLD	MIDBUF
	XCHG
	SHLD	OUTBUF
	POP	D
;
BUFEN1:	LHLD	OUTBUF
	MOV	A,M
	OUT	TEKDATA
	INX	H
	SHLD	BPOINT
	LXI	H,TLIFE1
	MOV	A,M
	ORA	A
	JZ	BUFEN2
	DCR	A
	MOV	M,A
;
BUFEN2:	INX	H
	MOV	A,M
	ORA	A
	JZ	EXIT7
	DCR	A
	MOV	M,A
	JMP	EXIT7
;
INPUT:	IN	TEKDATA
	ANI	7FH
	CPI	CTRLC
	JZ	LEAVE
	MOV	H,A
	LDA	HIT1
	ORA	A
	MOV	A,H
	JNZ	INP1
	LXI	H,VTHETA1
	CPI	LEFT1C
	JZ	LEFT
	CPI	RT1C
	JZ	RIGHT
	LXI	H,MTHRUST1
	CPI	FOR1C
	JZ	FORWD
	CPI	TORP1C
	JZ	FIRE1
INP1:	MOV	H,A
	LDA	HIT2
	ORA	A
	MOV	A,H
	JNZ	INP2
	LXI	H,VTHETA2
	CPI	LEFT2C
	JZ	LEFT
	CPI	RT2C
	JZ	RIGHT
	LXI	H,MTHRUST2
	CPI	FOR2C
	JZ	FORWD
	CPI	TORP2C
	JZ	FIRE2
;
INP2:	JMP	EXIT7
;
LEFT:	INR	M
	JMP	EXIT7
;
RIGHT:	DCR	M
	JMP	EXIT7
;
FORWD:	MOV	A,M
	ANI	1
	XRI	1
	MOV	M,A
	JMP	EXIT7
;
FIRE1:	LDA	TLIFE1
	ORA	A
	JNZ	EXIT7
	INR	A
	STA	T1GO
	JMP	EXIT7
;
;
FIRE2:	LDA	TLIFE2
	ORA	A
	JNZ	EXIT7
	INR	A
	STA	T2GO
	JMP	EXIT7
;
;
;
;
FIRE:	LDA	THETA
	PUSH	PSW
	CALL	COS
	MOV	E,A
	PUSH	D
	MVI	B,5*SIZE
	CALL	MUL
	CALL	SHIFT
	XCHG
	LHLD	X
	DAD	D
	SHLD	X
	POP	D
	MVI	B,TSPEED
	CALL	MUL
	CALL	SHIFT
	XCHG
	LHLD	VX
	DAD	D
	SHLD	VX
	POP	PSW
	CALL	SIN
	MOV	E,A
	PUSH	D
	MVI	B,5*SIZE
	CALL	MUL
	CALL	SHIFT
	XCHG
	LHLD	Y
	DAD	D
	SHLD	Y
	POP	D
	MVI	B,TSPEED
	CALL	MUL
	CALL	SHIFT
	XCHG
	LHLD	VY
	DAD	D
	SHLD	VY
	RET
;
;
;
;
;
RESOLVE:
	LDA	THETA
	PUSH	PSW
	CALL	COS
	MOV	E,A
	LDA	MAG
	MOV	B,A
	CALL	MUL
	MOV	E,H
	MVI	D,0
	MOV	A,H
	RLC
	JNC	FORW1
	MVI	D,0FFH
FORW1:	LHLD	VX
	DAD	D
	SHLD	VX
	POP	PSW
	CALL	SIN
	MOV	E,A
	LDA	MAG
	MOV	B,A
	CALL	MUL
	MOV	E,H
	MVI	D,0
	MOV	A,H
	RLC
	JNC	FORW2
	MVI	D,0FFH
FORW2:	LHLD	VY
	DAD	D
	SHLD	VY
	RET
;
;
;
;
SHIFT:	MOV	A,L
	RRC
	RRC
	ANI	3FH
	MOV	L,A
	MOV	A,H
	RRC
	RRC
	ANI	0C0H
	ORA	L
	MOV	L,A
	MOV	A,H
	RLC
	RRC
	RAR
	RLC
	RRC
	RAR
	MOV	H,A
	RET
;
RSTAR	DB	0
RSTAR1	DB	0
RSTAR2	DB	0
HIT1:	DB	0
HIT2:	DB	0
T1GO	DB	0
T2GO	DB	0
DELAY2	DB	0
Y1	DW	390*32
X1	DW	514*32
Y	DW	390*32
X	DW	514*32
VX	DW	0
VY	DW	0
THETA	DB	0
THETA1	DB	0
THETA2	DB	0
VTHETA1	DB	0
VTHETA2	DB	0
MTHRUST1  DB	0
MTHRUST2 DB	0
VX1	DW	0
VY1	DW	0
VX2	DW	0
VY2	DW	0
X2	DW	400*32
Y2	DW	250*32
T1X	DW	0
T1Y	DW	0
VT1X	DW	0
VT1Y	DW	0
T2X	DW	0
T2Y	DW	0
VT2X	DW	0
VT2Y	DW	0
TLIFE1	DB	0
TLIFE2	DB	0
RATE	DB	0
MAG	DB	0
SPSAVE	DW	0
BUF1	DS	150
BUF2	DS	150
BUF3	DS	150
STACK	DS	256
;
;
;
;
;	MULTIPLICATION ROUTINE
;	============== =======
;
;
;	THIS ROUTINE USES BOOTH'S ALGORITHM TO MULTIPLY
;	TWO 8-BIT TWO'S-COMPLEMENT NUMBERS AND GENERATE
;	A 16-BIT TWO'S-COMPLEMENT PRODUCT.  ARGUMENTS
;	ARE PASSED IN B AND E, AND THE PRODUCT IS RETURNED
;	IN HL.  ALL REGISTERS AND FLAGS ARE CLOBBERED
;	EXCEPT E.  ON RETURN, C IS ZERO, E IS INTACT, AND
;	THE SIGN BIT OF E HAS BEEN EXTENDED THROUGH D.
;
;
;
MUL:	LXI	H,0	;CLEAR PRODUCT
	MOV	A,E	;GET MULTIPLICAND
	MVI	D,0	;CLEAR HIGH BYTE OF MULTIPLICAND
	RLC		;TEST MULTIPLICAND SIGN BIT
	JNC	POS
	MVI	D,0FFH	;IF NEGATIVE, EXTEND SIGN BIT THRU D
POS:
;
	ORA	A	;CLEAR CARRY=B(-1)
	MVI	C,8	;STEP COUNT
	MOV	A,B	;GET MULTIPLIER
	RAL		;SET UP TO BEGIN WITH BIT 7
;
LOOP:	JC	HBS	;JUMP IF B(K)=1
	RLC		;TEST B(K-1)
	MOV	B,A	;SAVE ROTATED MULTIPLIER
	JC	LBS	;JUMP IF B(K-1)=0
;
NEXT:	DCR	C	;DECREMENT STEP COUNT
	RZ		;FINISHED IF C=0
	DAD	H	;SHIFT PRODUCT LEFT ONE PLACE
	MOV	A,B	;GET MULTIPLIER AGAIN
	RRC		;RESTORE CARRY CHANGED BY DAD INSTR.
	MOV	A,B	;ONCE AGAIN GET MULTIPLIER
	JMP	LOOP
;
HBS:	RLC		;TEST B(K-1)
	MOV	B,A	;SAVE ROTATED MULTIPLIER
	JC	NEXT	;JUMP IF B(K)=B(K-1)=1
	MOV	A,L	;SUBTRACT MULTIPLICAND FROM PARTIAL PRODUCT
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	JMP	NEXT
;
LBS:	DAD	D	;ADD MULTIPLICAND TO PARTIAL PRODUCT
	JMP	NEXT
;
;
;
;
;
;
;
;
;	SINE AND COSINE ROUTINE
;	=======================
;
;
;	THIS ROUTINE FINDS SIN(X) AND COS(X) BY A TABLE
;	LOOK-UP. ARGUMENTS ARE PASSED IN A AND VALUES 
;	RETURNED THERE.  THE VALUE RETURNED IS AN EIGHT-
;	BIT NUMBER IN TWO'S COMPLEMENT FORM, SUCH THAT
;	SIN(0) YIELDS 7F HEX AND SIN(PI/2) YIELDS FF.
;	ANGLES ARE REPRESENTED AS BINARY FRACTIONS OF
;	2 PI; THAT IS, PI=80H, PI/2 = 40H, AND SO FORTH.
;	THERE ARE SEPARATE ENTRY POINTS FOR SINE AND
;	COSINE.  THE TABLE USED IS ONLY FOR THE FIRST
;	QUADRANT AND CONTAINS 8-BIT UNSIGNED VALUES OF
;	SIN(X).  ONE BIT OF PRECISION IS LOST WHEN THESE
;	ARE CONVERTED TO SIGNED 8-BIT NUMBERS.
;
;
;	SINE TABLE
;	==========
;
SINES:  DB  000H,006H,00CH,013H,019H,01FH,025H,02CH
	DB  032H,038H,03EH,044H,04AH,050H,056H,05CH
	DB  062H,067H,06DH,073H,078H,07EH,083H,086H
	DB  08EH,093H,098H,09DH,0A2H,0A7H,0ACH,0B0H
	DB  0B5H,0B9H,0BDH,0C2H,0C6H,0CAH,0CDH,0D1H
	DB  0D5H,0D8H,0DBH,0DEH,0E2H,0E4H,0E7H,0EAH
	DB  0ECH,0EFH,0F1H,0F3H,0F5H,0F6H,0F8H,0FAH
	DB  0FBH,0FCH,0FDH,0FEH,0FFH,0FFH,0FFH,0FFH
	DB  0FFH
;
;
;
;
;	COSINE ENTRY POINT
;	====== ===== =====
;
COS:	ADI	100Q
;
;
;	SINE ENTRY POINT
;	==== ===== =====
;
;
SIN:	MVI	C,1	;CLEAR FLAG
	MOV	B,A	;SAVE ARGUMENT
	RLC		;TEST BIT 7
	JC	Q34	;SET- QUADRANT 3 OR 4
	RLC		;TEST BIT 6
	MOV	A,B	;GET ARGUMENT BACK
	JNC	Q1	;JUMP IF 1ST QUADRANT
	MVI	A,200Q	;BIT 6 SET- 2ND QUADRANT
	SUB	B	;TAKE SIN(PI-X)
Q1:	LXI	H,SINES	;GET START OF SINE TABLE
	MVI	D,0	;GET OFFSET IN DE
	MOV	E,A
	DAD	D	;GET ENTRY ADDRESS
	MOV	A,M	;GET VALUE FROM TABLE
	ORA	A	;CLEAR CARRY
	RAR		;DIVIDE BY TWO
	DCR	C	;TEST FLAG
	RZ		;RETURN IF RESULT POSITIVE
	CMA		;NEGATE RESULT
	INR	A
	RET
;
Q34:	MVI	C,2	;SET FLAG
	RLC		;TEST BIT 6
	MOV	A,B	;GET ARGUMENT BACK
	JC	Q4	;JUMP IF 4TH QUADRANT
	SUI	200Q	;SUBTRACT PI FROM ARGUMENT
	JMP	Q1	;NOW TREAT AS FIRST QUADRANT
;
Q4:	CMA		;NEGATE ARGUMENT
	INR	A
	JMP	Q1
;
;
;
;
;
;
;
;	OUTPUT CHARACTER TO SCOPE
;	====== ========= == =====
;
;	CALL WITH CHARACTER IN C.
;	CLOBBERS A AND FLAGS.
;
;
TYOUT:
;	IN	TEKSTAT	;NO OUTPUT STATUS FOR Z80SIM
;	RRC
;	JNC	TYOUT
	MOV	A,C
	OUT	TEKDATA
	RET
;
;
;
;
;	TEKX AND TEKY
;	=============
;
;	THESE ROUTINES TAKE A 10-BIT QUANTITY IN HL, CONVERT IT
;	TO TEKTRONIX 4013 COORDINATES, AND LEAVE THE TWO RESULTING
;	BYTES IN H AND L.  TEKY APPENDS THE PROPER HIGH-ORDER
;	OCTAL DIGIT (IN EACH BYTE) FOR Y-COORDINATES, AND
;	TEKX DOES THE SAME FOR X-COORDINATES.
;
;
;
TEKX:	MVI	B,40H
	DB	11H
TEKY:	MVI	B,60H
	MOV	C,H
	MOV	A,H
	RRC
	RRC
	ANI	1FH
	ORI	20H
	MOV	H,A
	MOV	A,L
	RLC
	RLC
	RLC
	ANI	7
	MOV	L,A
	MOV	A,C
	RLC
	RLC
	RLC
	ANI	18H
	ORA	L
	ORA	B
	MOV	L,A
	RET
;
;
;
;
;
;
;
	END
