
;##########################################################################
;###                   Header sector for XPRO system                    ###
;###	This sector goes where the boot sector normally goes on CPM     ###
;###	systems (first sector of system image) and contains information ###
;###	about the disk drives on your system. Use this file when first  ###
;###	bringing up your XPRO system. After boot the SET prorams will   ###
;###    allow you to make any changes.    DmC 10/4/84                   ###
;###    Added retry # at 0Bh.   BG 10/24/84                             ###
;###	Added more explanation of ABCDabcd. BG 1/11/85			###
;###                                                                    ###
;###	Assemble with ASM.COM - ASM boot                                ###
;##########################################################################


	ORG	900h


;############################
;### Address calculations ###
;############################

msize	equ	63		; msize must match 'msize' in XBIOS.AZM
bias	equ	(msize-20)*1024
ccp	equ	3400h+bias
bios	equ	ccp+1600h	

;################################
;### Define sector variables  ###
;################################

loadpt	equ	ccp
length	equ	33h		; XPRO CP/M  system length in sectors
config	equ	0DCh		; don't change this

;###########################
;### Drives A and B type ###
;###########################

drvtype	equ	10010001b	; quad density flag for drives A & B
;		^  ^   ^	; must be 0 for 96 TPI drives
;               |  |   |	; or 1 for 8 inch and 48 TPI drives
;		|  |   |_______ Bit for drive B (48 TPI or 8 inch as shown)
;               |  |___________ don't change this 
;		|______________ Bit for drive A (48 TPI or 8 inch as shown)

;###########################
;### Drives C and D type ###
;###########################

xdrvtyp	equ	10000001b	; same as above- 1 for 8" or 48 TPI
;		^      ^	;		 0 for 96 TPI
;		|      |________Bit for drive D (48 TPI or 8 inch as shown)
;		|_______________Bit for drive C (48 TPI or 8 inch as shown)

;######################################
;### 8 inch and slow steprate flags ###
;######################################

x8flg	equ	11110011b	; ABCDabcd where each letter describes drive.
;		^^^^^^^^	 A one in a given drive position in the ABCD
;		ABCDabcd	 group will mean that the slow steprate must
;		||||||||	 be used with that drive.
;		||||drivetype	 A one in a given drive position in the abcd
;		||||||||	 group indicates that the drive is 8 inch, a
;	    steprate||||	 zero means 5 1/4 inch
;		||||||||_________D drive = 8 inch
;		|||||||__________C drive = 8 inch
;		||||||___________B drive = 5 1/4 inch
;		|||||____________A drive = 5 1/4 inch
;		||||_____________slow step drive D (1=yes)
;		|||______________slow step drive C (1=yes)
;		||_______________slow step drive B (1=yes)
;		|________________slow step drive A (1=yes)
;				
;#################################
;### step rate for slow drives ###
;#################################
speed	equ	02h		; Steprate to use on drives requiring
				; slow steprates. 00H is 3ms (6 ms)
				;		  01H is 6 ms (12 ms)
				;		  02H is 10 ms (20 ms)
				;		  03H is 15 ms (30 ms)
				; Times for 8 inch operations (all times
				; double for 5 1/4 inch).

;################################
;### Cursor default character ###
;################################
cursor	equ	0DFh		; cursor character use 0DFH for blinking
				; underscore (05FH for non-blink). Use ascii
				; for ascii e.g. cursor   equ	'#'.
				; blinking solid block = 082h  (non-blink=02h)
				; blinking halftone block = 08Dh (n-b=0Dh)
				; blinking heavy underscore = 093h (n-b=13h)
;################################

retry	equ	002h		; number of 'homes' per retry +1


;################################
;### Begin sector image       ###
;################################

	db	18h,0FEh	; self:	jr	self
	dw	loadpt		; where to load the system image
	dw	bios		; where to jump after loading
	dw	length		; length of system image in 128 byte sectors
	db	drvtype		; what type of drives are a and b
	db	0		; reserved for expansion
	db	config		; disk configuration flag
	db	retry		; number of 'homes' per retry +1

	db	cursor		; hex value of the cursor character
	db	speed		; slow steprate to use for drives needing it
	db	xdrvtyp		; what type of drives are c and d
	db	x8flg		; which drives are 8 inch and which need
				; slow step rate


;0900	18 FE 00 E0 00 F6 33 00   91 00 DC 02 DF 02 81 F3 sample dump of above


	dw	0,0,0,0,0,0,0,0		;the rest of the sector is not used
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0


	end
