#define STATUS 0x3ba
#define  M_INDEX 0x3b4
#define  M_CONTROL 0x3b5
#define C_INDEX 0x3d4
#define C_CONTROL 0x3d5
#include <conio.h>
#include <dos.h>
#include <stdio.h>
union REGS inregs, outregs;
/* Demonstration of methods for detecting the different kinds of video cards 
   available for an IBM PC.  Based on various sources such as the Hercules 
   documentation, the IBM EGA Technical Reference, Robert Jourdain's
   The Programmer's Problem Solver, and Microcornucopia magazine.
   Collected by Richard Knowles, School of Optometry, University of California
   Berkeley.  Compiles under Microsoft C ver. 4.0 */

/* Test for Hercules by watching for a change of state in the MSB of the
   STATUS port of the Hercules card.  Not entirely reliable, some non-Hercules
   cards set this bit as well.  From the C column in Microcornucopia.  */

int herc()
{
	char test;
	unsigned int i;

	test = inp(STATUS) & 0x80;
	for(i=0; i<0x8000;i++) if ((inp(STATUS) & 0x80) != test) return 1;
	return 0;
}

/* The EGA test makes use of the EGA ROM's extension to the BIOS video
   interrupt and I think is a better test than others I've seen.  Note, I 
   throw away a lot of information that this function returns.  For example, 
   the amount of memory available which is only important to those with the 
   actual IBM EGA, most clones have 256K.  Also, whether the EGA is the primary
   display or not.  For more detail, look at the IBM documentation. */

int ega()
{
	int  Switches,result;
	inregs.x.bx = 0xFF10;
	inregs.h.ah = 0x12;
	int86(0x10,&inregs,&outregs);
	if ( outregs.h.bh == 0xff) return 0;
	else
	    {
		Switches = outregs.h.cl;
		if (Switches > 5 ) Switches = Switches - 6;
		if (Switches < 3 ) return 1;
		else if (Switches == 3) return 2;
		else return 3;
	}
}

/* The following two tests are from Jourdain's book. */
int monochrome()
{
	int temp, test;	
	outp(MINDEX, 0x0F);
	temp=inp(M_CONTROL);
	outp(M_CONTROL, 100);
	test=inp(M_CONTROL);
	outp(M_CONTROL, temp);
	if (test==100) return -1;
	else return 0;
}

int colorcard()
{
	int temp, test;	
	outp(C_INDEX, 0x0F);
	temp=inp(C_CONTROL);
	outp(C_CONTROL, 100);
	test=inp(C_CONTROL);
	outp(C_CONTROL, temp);
	if (test==100) return -1;
	else return 0;
}

/* Now check for adapters.  The Hercules should also satisfy the monochrome
   test and the EGA should pass the CGA test.  An additional test for the
   Hercules, if there is no EGA or CGA, would be to activate page 1 and test
   for memory present.  */
   
main()
{
    int result;
   
    result = monochrome();
    if (result == 0)  puts("No Monochrome adapter present");
    else  puts("Monochrome adapter present");
   
    result=colorcard();
    if (result == 0)  puts("No Color Graphics Adapter");
    else  puts("Color Graphics Adapter present");

    result = herc();
   if (result == 1)  puts("Hercules present");
   else result = puts("No Hercules present");
   result = ega();
   switch (result) {
      case 0: puts("No EGA present");
           break;
      case 1: puts("EGA present, set for Color Graphics Display");
           break;
      case 2: puts("EGA present, set for Enhanced Graphics Display");
           break;
      case 3: puts("EGA present, set for Monochrome Display"); 
      }
} 
