1000 REM       3-D TIC TAC TOE       by Tom Sarbeck      May 20, 1987
1010 REM Copyright 1987 Tom Sarbeck.  Rights granted to First Osborne Group
1020 REM (F.O.G) for the exclusive use and enjoyment of its members.  Any
1030 REM reproduction or distribution for profit, or inclusion with any other 
1040 REM product or service for profit, is strictly forbidden.
1050 DEFINT A-Z: OPTION BASE 1: R11!=.67: R12!=.75: R21!=.5: R22!=.25
1060 PRINT CHR$(26):PRINT TAB(24) "TIC-TAC-TOE  IN  THREE  DIMENSIONS"
1070 PRINT TAB(24) "FOR  FROM  ONE  TO  THREE  PLAYERS"
1080 PRINT TAB(24) "=================================="
1090 PRINT:PRINT TAB(28) "Copyright 1987 Tom Sarbeck"
1100 PRINT"   Rights granted to First Osborne Group for the exclusive use ";
1110 PRINT"and enjoyment"
1120 PRINT"   of its members, and reproduction or distribution for profit ";
1130 PRINT"is forbidden.":PRINT
1140 BYTE2$="=": REM FOR OZZY, KAYPRO 2, 4, 10, AND OTHER ADM-3A TERMINALS
1150 REM +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
1160 PRINT TAB(15) "Of the cursor positioning bytes ESC BYTE2 Y+32 X+32"
1170 PRINT"        for your terminal, enter BYTE2.";
1180 PRINT"  Press ENTER or RETURN to quit. ";BYTE2$
1190 PRINT:PRINT TAB(19) "(I've set BYTE2$ to = for ADM-3A terminals)"
1200 IF LEN(BYTE2$)=0 THEN END
1210 CP$=CHR$(27)+BYTE2$: REM === POSITION CURSOR: MDT 60 (ESC=Y X)
1220 REM +++++++ Optionally, replace the above with CP$=CHR$(27)+"=" +++++++
1230 PRINT:PRINT TAB(32) "  Setting up";
1240 REM ===================================================== THE GAME SETUP
1250 DIM STACK$(4,4,4), STACKI(64): VACANT$="  .  "
1260 REM -----(S)helf------ STACK$(1,R,C) IS BOTTOM   STACK$(4,R,C) IS TOP
1270 REM -----(R)ow-------- STACK$(S,1,C) IS FRONT    STACK$(S,4,C) IS REAR
1280 REM -----(C)olumn----- STACK$(S,R,1) IS LEFT     STACK$(S,R,4) IS RIGHT
1290 FOR S=1 TO 4: FOR R=1 TO 4: FOR C=1 TO 4: REM === POINTERS INTO STACK$
1300 STACKI(16*S+4*R+C-20)=100*S+10*R+C: NEXT C: NEXT R: NEXT S
1310 DIM DEFAULTS$(4), PLAYERS$(4), MARKERS$(4), ADDENDS(4)
1320 DEFAULTS$(1)="Player One  ": MARKERS$(1)=" XXX ": ADDENDS(1)= 1 
1330 DEFAULTS$(2)="Player Two  ": MARKERS$(2)=" [*] ": ADDENDS(2)= 5 
1340 DEFAULTS$(3)="Player Three": MARKERS$(3)=" @@@ ": ADDENDS(3)=21 
1350 DEFAULTS$(4)="Mike Rochips": MARKERS$(4)=" OOO ": ADDENDS(4)=85
1360 FOR I=1 TO 4: PLAYERS$(I)=DEFAULTS$(I): NEXT I
1370 DIM CMT1$(2),CMT2$(2),CMT3$(4),CMT4$(4),CMT5$(4),CMT6$(2),CMT7$(4)
1380 CMT1$(1)="Bye bye.            ": CMT1$(2)="And I gotcha!       "
1390 CMT2$(1)="here's a fourth.    ": CMT2$(2)="here's 1 more....   "
1400 CMT3$(1)="Good try, but...    ": CMT3$(2)="Not yet, pal.       "
1410 CMT3$(3)="Forking around?     ": CMT3$(4)="Not this time.      "
1420 CMT4$(1)="Hm-m-m.             ": CMT4$(2)="Uno momento....     "
1430 CMT4$(3)="I'm thinking....    ": CMT4$(4)="...?                "
1440 CMT5$(1)="Oh hell.": CMT5$(2)="Dammit! ": CMT5$(3)="Shee-it!"
1450 CMT6$(1)="Don't think so.     ": CMT6$(2)="Three are enough.   "
1460 CMT7$(1)="Don't like this...  ": CMT7$(2)="Pluggin' a leak...  "
1470 CMT7$(3)="If not now, when...?": CMT7$(4)="Yer up to no good..."
1480 NCMT1=2: NCMT2=2: NCMT3=4: NCMT4=4: NCMT5=3: NCMT6=2: NCMT7=4: PRINT".";
1490 DIM SUMS(76): REM === WORKING SPACE
1500 REM ================================================= READ THE PLAY DATA
1510 DIM LINES(76,4): REM === AS DEFINED BY THE POINTS ON THEM
1520 DATA  1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16
1530 DATA  1, 5, 9,13, 2, 6,10,14, 3, 7,11,15, 4, 8,12,16
1540 DATA 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32
1550 DATA 17,21,25,29,18,22,26,30,19,23,27,31,20,24,28,32
1560 DATA 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48
1570 DATA 33,37,41,45,34,38,42,46,35,39,43,47,36,40,44,48
1580 DATA 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64
1590 DATA 49,53,57,61,50,54,58,62,51,55,59,63,52,56,60,64
1600 DATA  1,17,33,49, 2,18,34,50, 3,19,35,51, 4,20,36,52
1610 DATA  5,21,37,53, 6,22,38,54, 7,23,39,55, 8,24,40,56
1620 DATA  9,25,41,57,10,26,42,58,11,27,43,59,12,28,44,60
1630 DATA 13,29,45,61,14,30,46,62,15,31,47,63,16,32,48,64
1640 DATA  1, 6,11,16, 4, 7,10,13,17,22,27,32,20,23,26,29
1650 DATA 33,38,43,48,36,39,42,45,49,54,59,64,52,55,58,61
1660 DATA  1,18,35,52, 4,19,34,49, 5,22,39,56, 8,23,38,53
1670 DATA  9,26,43,60,12,27,42,57,13,30,47,64,16,31,46,61
1680 DATA  1,21,41,61,13,25,37,49, 2,22,42,62,14,26,38,50
1690 DATA  3,23,43,63,15,27,39,51, 4,24,44,64,16,28,40,52
1700 DATA  1,22,43,64, 4,23,42,61,13,26,39,52,16,27,38,49
1710 DIM PLANES(18,3): REM === AS DEFINED BY THE LINES ON THEM
1720 REM (1: 100*LOW LINE #+10*INCREMENT+# OF LINES, DIAG LINES, FLAG)
1730 DATA 0114, 4950, 0, 0914, 5152, 0
1740 DATA 1714, 5354, 0, 2514, 5556, 0
1750 DATA 3314, 5758, 0, 3714, 5960, 0
1760 DATA 4114, 6162, 0, 4514, 6364, 0
1770 DATA 0584, 6566, 0, 0684, 6768, 0
1780 DATA 0784, 6970, 0, 0884, 7172, 0
1790 DATA 0194, 7374, 0, 0474, 7576, 0
1800 DATA 0594, 7375, 0, 0874, 7476, 0
1810 DATA 3354, 7376, 0, 3634, 7475, 0
1820 DIM RAYS(64,7): REM === THE LINES THROUGH EACH POINT
1830 DATA  1, 5,33,49,57,65,73, 1, 6,34,67, 0, 0, 0
1840 DATA  1, 7,35,69, 0, 0, 0, 1, 8,36,50,58,71,74
1850 DATA  2, 5,37,59, 0, 0, 0, 2, 6,38,49, 0, 0, 0
1860 DATA  2, 7,39,50, 0, 0, 0, 2, 8,40,60, 0, 0, 0
1870 DATA  3, 5,41,61, 0, 0, 0, 3, 6,42,50, 0, 0, 0
1880 DATA  3, 7,43,49, 0, 0, 0, 3, 8,44,62, 0, 0, 0
1890 DATA  4, 5,45,50,63,66,75, 4, 6,46,68, 0, 0, 0
1900 DATA  4, 7,47,70, 0, 0, 0, 4, 8,48,49,64,72,76
1910 DATA  9,13,33,51, 0, 0, 0, 9,14,34,57, 0, 0, 0
1920 DATA  9,15,35,58, 0, 0, 0, 9,16,36,52, 0, 0, 0
1930 DATA 10,13,37,65, 0, 0, 0,10,14,38,51,59,67,73
1940 DATA 10,15,39,52,60,69,74,10,16,40,71, 0, 0, 0
1950 DATA 11,13,41,66, 0, 0, 0,11,14,42,52,61,68,75
1960 DATA 11,15,43,51,62,70,76,11,16,44,72, 0, 0, 0
1970 DATA 12,13,45,52, 0, 0, 0,12,14,46,63, 0, 0, 0
1980 DATA 12,15,47,64, 0, 0, 0,12,16,51,48, 0, 0, 0
1990 DATA 17,21,33,53, 0, 0, 0,17,22,34,58, 0, 0, 0
2000 DATA 17,23,35,57, 0, 0, 0,17,24,36,54, 0, 0, 0
2010 DATA 18,21,37,66, 0, 0, 0,18,22,38,53,60,68,76
2020 DATA 18,23,39,54,59,70,75,18,24,40,72, 0, 0, 0
2030 DATA 19,21,41,65, 0, 0, 0,19,22,42,54,62,67,74
2040 DATA 19,23,43,53,61,69,73,19,24,44,71, 0, 0, 0
2050 DATA 20,21,45,54, 0, 0, 0,20,22,46,64, 0, 0, 0
2060 DATA 20,23,47,63, 0, 0, 0,20,24,48,53, 0, 0, 0
2070 DATA 25,29,33,55,58,66,76,25,30,34,68, 0, 0, 0
2080 DATA 25,31,35,70, 0, 0, 0,25,32,36,56,57,72,75
2090 DATA 26,29,37,60, 0, 0, 0,26,30,38,55, 0, 0, 0
2100 DATA 26,31,39,56, 0, 0, 0,26,32,40,59, 0, 0, 0
2110 DATA 27,29,41,62, 0, 0, 0,27,30,42,56, 0, 0, 0
2120 DATA 27,31,43,55, 0, 0, 0,27,32,44,61, 0, 0, 0
2130 DATA 28,29,45,56,64,65,74,28,30,46,67, 0, 0, 0
2140 DATA 28,31,47,69, 0, 0, 0,28,32,48,55,63,71,73
2150 DIM MYGAMES(9,28),THISGAME(28)
2160 DATA    4,   2,  20,   2, 111, 113, 122, 123
2170 DATA -143,-144, 133,-112,-114,-121,-124,-131,-132, 141
2180 DATA -112,-132, 114,-124,-131, 121,   0,   0,   0,   0
2190 DATA    4,   2,  22,   3, 111, 114, 122, 123
2200 DATA -121,-124,-131,-132, 141,-141,-124,-131, 121,-121
2210 DATA -124,-133,-134, 144,-144,-121,-134, 124,   0,   0
2220 DATA    4,   2,  22,   2, 111, 114, 132, 133
2230 DATA -121,-123,-131,-134, 141,-141,-121,-134, 131,-122
2240 DATA -124,-131,-134, 144,-144,-124,-131, 134,   0,   0
2242 PAIRSWAP=3: REM === PLACE YOUR GAME BELOW THIS POINT UNLESS
2244 REM === ITS FIRST TWO PAIRS OF POSITIONS MAY BE SWAPPED
2250 DATA    4,   2,  12,   5, 111, 114, 132, 143
2260 DATA -112,-123,-133,-141, 113,-133,-141, 123,   0,   0
2270 DATA    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
2280 DATA    4,   4,  17,   4, 111, 114, 141, 144
2290 DATA -122,-123,-124,-131, 121,-123,-124,-133, 122,-124
2300 DATA -132, 123, 124,   0,   0,   0,   0,   0,   0,   0
2310 DATA    4,   4,  20,   1, 111, 113, 131, 133
2320 DATA -114,-121,-123,-132,-134,-143, 141,-114,-123,-134
2330 DATA -143, 132,-114,-143, 123, 114,   0,   0,   0,   0
2340 DATA    4,   4,  20,   8, 111, 112, 121, 122
2350 DATA -114,-123,-124,-131,-132,-142, 141,-114,-123,-124
2360 DATA -142, 132,-114,-124, 123, 114,   0,   0,   0,   0
2370 DATA    4,   3,  13,   7, 121, 122, 131, 132
2380 DATA -111,-114,-123,-124, 141,-114,-124, 123, 114,   0
2390 DATA    0,   0,   0,   0,   0,   0,   0,   0,   0,   0
2400 DATA    4,   3,  20,   3, 122, 123, 132, 133
2410 DATA -112,-113,-114,-142,-143,-144, 111,-113,-114,-142
2420 DATA -143, 112,-114,-143, 113, 114,   0,   0,   0,   0
2430 NSTRATS=9
2440 FOR I=1 TO 76: FOR J=1 TO  4: READ LINES(I,J):  NEXT J: NEXT I: PRINT".";
2450 FOR I=1 TO 18: FOR J=1 TO  3: READ PLANES(I,J): NEXT J: NEXT I
2460 FOR I=1 TO 64: FOR J=1 TO  7: READ RAYS(I,J):   NEXT J: NEXT I: PRINT".";
2470 FOR I=1 TO  9: FOR J=1 TO 28: READ MYGAMES(I,J):NEXT J: NEXT I
2480 GOTO 2510
2490 REM ============================== CHOOSE, OR RE-CHOOSE, THE SKILL LEVEL
2500 PRINT CHR$(26): PRINT
2510 PRINT CP$;CHR$(45);CHR$(46)
2520 PRINT TAB(15) "To play, choose the skill level you";
2530 PRINT" want me to have:       "
2540 PRINT CP$;CHR$(47);CHR$(40);
2550 FOR I=20 TO 84:PRINT" ";:NEXT I:PRINT
2560 PRINT TAB(16) "0   -   You don't want to play?"
2570 PRINT TAB(16) "1   -   I've played a little.  You play first."
2580 PRINT TAB(16) "2   -   I've been around...and you can play first."
2590 PRINT TAB(16) "3   -   You and me -- taking turns going first."
2600 PRINT:PRINT TAB(31)"Enter your choice"
2610 PRINT CP$;CHR$(53);CHR$(80);
2620 I$=INKEY$: IF LEN(I$) < 1 THEN 2620
2630 IF I$ = "0" THEN END ELSE IF I$ > "0" AND I$ < "4" THEN 2650
2640 PRINT CP$;CHR$(54);CHR$(62);"Uh-uh; try again.": GOTO 2610
2650 SKILL=VAL(I$): PRINT CP$;CHR$(53);CHR$(79);SKILL
2660 DELAY=20: GOSUB 6060: PRINT CHR$(26)
2670 REM ======================================== GET NUMBER OF HUMAN PLAYERS
2680 IF SKILL=3 THEN NSTRATS=3: NUM=1: GOTO 2750
2690 PRINT CP$;CHR$(34);CHR$(64);"Enter 0 to quit"
2700 PRINT TAB(10) "Up to three of you human types may play.  How many ";
2710 PRINT CP$;CHR$(35);CHR$(92);:INPUT"will play";NUM
2720 IF NUM=0 THEN PRINT:PRINT:END
2730 IF NUM>0 AND NUM<4 THEN PRINT:PRINT: GOTO 2750
2740 PRINT TAB(36) "Try again";: GOTO 2710 
2750 PRINT CP$;CHR$(38);CHR$(43);: REM =========== PLAYER NAME/MARKER CHANGES
2760 PRINT"Unless you change them we will use these names and markers."
2770 PRINT: I$=INKEY$: FOR I=1 TO NUM: PRINT CP$;CHR$(I+39);CHR$(56);
2780 PRINT I;"     ";PLAYERS$(I);"     ";MARKERS$(I): NEXT I
2790 PRINT TAB(25) " 4      ";PLAYERS$(4);"     ";MARKERS$(4):PRINT
2800 PRINT TAB(18) "To change a name or marker enter its number."
2810 PRINT TAB(18) "To begin the game enter a different number."
2820 PRINT CP$;CHR$(NUM+45);CHR$(32);"Enter a digit ";
2830 I$=INKEY$: SEED!=RND: IF LEN(I$)=0 THEN 2830
2840 PRINT I$: I=ASC(I$)-48: J=I: IF I<1 OR I>NUM AND I<>4 THEN 2980
2850 PRINT"For no change, CR"
2860 PRINT CP$;CHR$(NUM+45);CHR$(60);: INPUT"Name [1 to 12 letters]: ",NAM$
2870 IF LEN(NAM$)=0 THEN 2890
2880 SEED=SEED+ASC(NAM$): PLAYERS$(I)=LEFT$(NAM$+"            ",12)
2890 PRINT CP$;CHR$(NUM+46);CHR$(60);: INPUT"Marker [3 characters]:  ",NAM$
2900 IF LEN(NAM$)=0 THEN 2920
2910 SEED=SEED+ASC(NAM$): MARKERS$(I)=" "+LEFT$(NAM$,3)+" "
2920 IF I=4 THEN J=NUM+1
2930 PRINT CP$;CHR$(J+39);CHR$(64);PLAYERS$(I);
2940 PRINT CP$;CHR$(J+39);CHR$(81);MARKERS$(I);
2950 PRINT CP$;CHR$(NUM+45);CHR$(46);"    ";
2960 PRINT CP$;CHR$(NUM+45);CHR$(84);"               "
2970 PRINT CP$;CHR$(NUM+46);CHR$(84);"               ": GOTO 2820
2980 PRINT:PRINT:PRINT:PRINT TAB(31) "And away we go..."
2990 GANGCTR=0: IF SKILL=3 AND RND < .5 THEN SKILL=-SKILL
3000 REM <<============================================= BEGIN EACH GAME HERE
3010 FOR S=1 TO 4: FOR R=1 TO 4: FOR C=1 TO 4: STACK$(S,R,C)=VACANT$
3020 NEXT C: NEXT R: NEXT S: EMPTY=64: GANGSW=0
3030 FOR I=1 TO 18: PLANES(I,3)=0: NEXT I
3040 FOR I=1 TO 76: SUMS(I)=0: SUMS(I)=0: NEXT I
3050 FOR I=1 TO 28: THISGAME(I)=0: NEXT I: PATTERN=1
3060 GAMEWON=0: ROUND=0: MYROUND=0: MYPLAY=0: OFFSET=0: OHELL=0: CHEAT=0
3070 VIEWFROM=1: MOVEFROM=1: GOSUB 6230: REM === DISPLAY THE STACK
3080 IF ABS(SKILL)=3 THEN SKILL=-SKILL: REM === ALTERNATE FIRST PLAY
3090 IF SKILL<0 THEN ROUND=ROUND+1: OFFSET=1: GOTO 3410
3100 REM <<============================================ BEGIN EACH ROUND HERE
3110 ROUND=ROUND+1
3120 FOR PLAYER=1 TO NUM: EMPTY=EMPTY-1: IF EMPTY<1 THEN 6880
3130 PLAYEE=PLAYER: ON PLAYER GOTO 3140,3190,3240
3140 GOSUB 6080: IF VIEWFROM=0 THEN 3170: REM === PLAYER 1
3150 ON VIEWFROM GOSUB 6230,6310,6390,6470
3160 GOTO 3140
3170 ON MOVEFROM GOSUB 6560,6580,6600,6620
3180 GOSUB 6050: GOSUB 6710: GOTO 3290
3190 GOSUB 6080: IF VIEWFROM=0 THEN 3220: REM === PLAYER 2
3200 ON VIEWFROM GOSUB 6230,6310,6390,6470
3210 GOTO 3190
3220 ON MOVEFROM GOSUB 6560,6580,6600,6620
3230 GOSUB 6050: GOSUB 6710: GOTO 3290
3240 GOSUB 6080: IF VIEWFROM=0 THEN 3270: REM === PLAYER 3
3250 ON VIEWFROM GOSUB 6230,6310,6390,6470
3260 GOTO 3240
3270 ON MOVEFROM GOSUB 6560,6580,6600,6620
3280 GOSUB 6050: GOSUB 6710
3290 IF GAMEWON <> 0 THEN 6770: REM === IF A PLAYER HAS WON
3300 IF MYROUND >= THISGAME(1) THEN 3400
3310 IF MYROUND < 1 OR OHELL > 0 THEN 3400 ELSE I=MYROUND: J=THISGAME(3)
3320 I=I+1: IF I >= J THEN 3400
3330 IF MYROUND < THISGAME(1) THEN 3350: REM === IF OPENING PLAY
3340 IF THISGAME(I+4) > 0 THEN 3400: REM === FORCING PLAY
3350 SRC=ABS(THISGAME(I+4)): GOSUB 6030: I$=STACK$(S,R,C)
3360 IF I$=VACANT$ OR I$=MARKERS$(4) THEN 3320
3370 OHELL=1: IF MYROUND < 2 THEN 3400
3380 PRINT CP$;CHR$(42);CHR$(88);CMT5$(INT(NCMT5*RND+1));
3390 DELAY=40: GOSUB 6060: PRINT CP$;CHR$(42);CHR$(88);"         "
3400 NEXT PLAYER
3410 REM ======================================== PLAYER 4
3420 PLAYER=4: PLAYEE=4: IVEMOVED=0: EMPTY=EMPTY-1
3430 PRINT CP$;CHR$(36);CHR$(88);PLAYERS$(4);"        "
3440 PRINT CP$;CHR$(37);CHR$(88);MARKERS$(4);"         "
3450 PRINT CP$;CHR$(36);CHR$(101);
3460 IF ROUND > 1 THEN 3610: REM === I'VE ALREADY CHOSEN MY GAME
3470 I=INT(NSTRATS*RND+1): REM === GAME PATTERN
3480 J=INT(3*RND+1): REM === BASE PLANE
3490 K=INT(4*RND+1): REM === IN-PLANE SPIN
3500 L=INT(12*RND+1): REM === TRANSLATE (1-4) OR ROTATE 45 DEG (5-12)
3510 IF L > 4 THEN IF L < 9 THEN L=6 ELSE L=8
3520 REM PRINT:PRINT CP$;CHR$(36);CHR$(33);:INPUT"I,J,K,L";I,J,K,L
3530 ISTRAT=I: CLEAN=1: GOSUB 5350: IF CLEAN=0 THEN 3470
3540 JBASE=J: KSPIN=K: LPLANE=L
3542 IF ISTRAT > PAIRSWAP OR RND > .5 THEN 3560
3550 FOR M=1 TO 2: SWAP THISGAME(M+4), THISGAME(M+6): NEXT M
3560 FOR M=1 TO 4: THISGAME(M)=MYGAMES(I,M): NEXT M
3570 IF CHEAT <> 9 THEN 3600
3580 PRINT CP$;CHR$(32);CHR$(33);I: FOR M=5 TO THISGAME(3)+4
3590 PRINT THISGAME(M): NEXT M: PRINT CP$;CHR$(33);CHR$(33)
3600 PRINT: GOTO 4690: REM === GAME SET; MAKE FIRST PLAY
3610 REM <<=============================== IN ROUNDS 3+: LOOK FOR 3 IN A LINE
3620 IF ROUND < OFFSET+3 THEN 4690
3630 GOSUB 5840: IF FOUND=0 THEN PLAYEE=NUM+1: GOTO 3660
3640 PRINT CP$;CHR$(38);CHR$(88);CMT1$(INT(NCMT1*RND+1));
3650 GOSUB 6650: GOSUB 6710: GOTO 6770: REM === I WIN
3660 PLAYEE=PLAYEE-1: IF PLAYEE<1 THEN 3780
3670 GOSUB 5840: IF FOUND=0 THEN 3660
3680 IF PLAYEE>1 THEN 3740
3690 PRINT CP$;CHR$(42);CHR$(88);"                    "
3700 PRINT CP$;CHR$(42);CHR$(88);PLAYERS$(1)
3710 PRINT CP$;CHR$(43);CHR$(88);CMT2$(INT(NCMT2*RND+1));: REM BLOCK PLAYER 1
3720 GOSUB 6050: GOSUB 6650: GOSUB 6710: IF GAMEWON > 0 THEN 6770
3730 IF OHELL=0 THEN 3100 ELSE MYROUND=0: GOTO 3100
3740 PRINT CP$;CHR$(42);CHR$(88);"Someone else can    "
3750 PRINT CP$;CHR$(43);CHR$(88);"                    "
3760 PRINT CP$;CHR$(43);CHR$(88);"block ";PLAYERS$(PLAYEE);
3770 GANGSW=1: GOSUB 6050: GOTO 3660
3780 REM <<================= IN ROUNDS 4+: COMPLETE/WARN OF/BLOCK A NEAR-FORK
3790 IF ROUND < OFFSET+4 THEN 4210
3800 IF SKILL < 2 AND RND < R11! THEN 4210: REM AT === IF SKILL=1 MAYBE
3810 PLAYEE=4: GOSUB 5910: IF FOUND = 0 THEN PLAYEE=NUM+1: GOTO 3860
3820 GOSUB 6650: GOSUB 6710: IF NUM > 1 THEN 3850
3830 PRINT CP$;CHR$(42);CHR$(88);"D'ya wanna enter"
3840 PRINT CP$;CHR$(43);CHR$(88);"888 and surrender?"
3850 IF GAMEWON = 0 THEN 3100 ELSE 6770
3860 PLAYEE=PLAYEE-1: IF PLAYEE < 1 THEN 4210: REM === CHECK 3/2/1
3870 GOSUB 5910: IF FOUND = 0 THEN 3860: REM === IF NO NEAR-FORK PENDING
3880 IF PLAYEE > 1 THEN 3940 ELSE R11!=R11!/1.5: REM === IF BY 3/2 ELSE BY 1
3890 IF MYPLAY > 0 AND MYPLAY < THISGAME(3) THEN 4210: REM === IF FORCING
3900 PRINT CP$;CHR$(42);CHR$(88);CMT3$(INT(NCMT3*RND+1)): REM === BLOCK 1
3910 PRINT CP$;CHR$(43);CHR$(88);"                    "
3920 GOSUB 6050: GOSUB 6650: GOSUB 6710: IF GAMEWON > 0 THEN 6770
3930 IF OHELL=0 THEN 3100 ELSE MYROUND=0: GOTO 3100
3940 PRINT CP$;CHR$(42);CHR$(88);"                    "
3950 PRINT CP$;CHR$(42);CHR$(88);PLAYERS$(PLAYEE): REM === WARN OF 3/2
3960 PRINT CP$;CHR$(43);CHR$(88);"                    "
3970 PRINT CP$;CHR$(43);CHR$(88);"is forking around...";:GOSUB 6050:GOTO 3860
3980 REM <<=============================== IN ROUNDS 4+: TRY TO SET UP A FORK
3990 IF PATTERN < 2 THEN 4210
4000 IF MYPLAY > 0 AND MYPLAY < THISGAME(3) THEN 4210
4010 PRINT CP$;CHR$(42);CHR$(88);CMT4$(INT(NCMT4*RND+1));
4020 IF RND > .5 THEN IB=1: IS=1: IT=77: I=IB ELSE IB=76: IS=-1: IT=0: I=IB
4030 IF SUMS(I) <> 2*ADDENDS(4) THEN 4190
4040 IF RND < .5 THEN JB=1: JS=1: JT=77: J=JB ELSE JB=76: JS=-1: JT=0: J=JB
4050 IF SUMS(J) <> ADDENDS(4) THEN 4180
4060 IF RND > .5 THEN KB=1: KS=1: KT=5: K=KB ELSE KB=4: KS=-1: KT=0: K=KB
4070 IF RND < .5 THEN LB=1: LS=1: LT=5: L=LB ELSE LB=4: LS=-1: LT=0: L=LB
4080 IF LINES(I,K)=LINES(J,L) THEN 4110: REM === IF COMMON POINT
4090 L=L+LS: IF L=LT THEN 4100 ELSE 4080
4100 K=K+KS: IF K=KT THEN 4180 ELSE 4070
4110 SRC=STACKI(LINES(J,L)): GOSUB 6030
4120 IF STACK$(S,R,C) <> VACANT$ THEN 4180
4130 M=SRC: REM === CHECK THE OTHER LINE
4140 IF RND > .5 THEN NB=1: NS=1: NT=5: N=NB ELSE NB=4: NS=-1: NT=0: N=NB
4150 SRC=STACKI(LINES(J,N)): GOSUB 6030: IF SRC=M THEN 4170
4160 IF STACK$(S,R,C)=VACANT$ THEN FORK=SRC: GOTO 4200: REM === MAKE MY FORK
4170 N=N+NS: IF N=NT THEN 4180 ELSE 4150
4180 J=J+JS: IF J=JT THEN 4190 ELSE 4050
4190 I=I+IS: IF I=IT THEN 4210 ELSE 4030
4200 GOSUB 6650: GOSUB 6710: IF OHELL=0 THEN 3100 ELSE MYROUND=0: GOTO 3100
4210 REM <<================== IN ROUNDS 3+ AND IF NOT FORCING: PREVENT A FORK
4220 REM IF PATTERN < 2 THEN 4480
4230 IF MYPLAY > 0 AND MYPLAY < THISGAME(3) THEN 4690
4240 IF SKILL < 2 AND RND < R12! THEN 4450: REM === IF SKILL=1 MAYBE
4250 IF SKILL < 3 AND RND < R21! THEN 4450: REM === IF SKILL=2 MAYBE+
4260 PRINT CP$;CHR$(43);CHR$(88);"                    "
4270 PRINT CP$;CHR$(42);CHR$(88);CMT4$(INT(NCMT4*RND+1));
4280 IF RND > .5 THEN IB=1: IS=1: IT=77: I=IB ELSE IB=76: IS=-1: IT=0: I=IB
4290 IF SUMS(I) <> 2*ADDENDS(1) THEN 4400
4300 IF RND < .5 THEN JB=1: JS=1: JT=77: J=JB ELSE JB=76: JS=-1: JT=0:J=JB
4310 IF SUMS(J) <> ADDENDS(1) THEN 4390
4320 IF RND > .5 THEN KB=1: KS=1: KT=5: K=KB ELSE KB=4: KS=-1: KT=0: K=KB
4330 IF RND < .5 THEN LB=1: LS=1: LT=5: L=LB ELSE LB=4: LS=-1: LT=0: L=LB
4340 IF LINES(I,K)=LINES(J,L) THEN 4370
4350 L=L+LS: IF L=LT THEN 4360 ELSE 4340
4360 K=K+KS: IF K=KT THEN 4390 ELSE 4330
4370 SRC=STACKI(LINES(J,L)): GOSUB 6030
4380 IF STACK$(S,R,C)=VACANT$ THEN 4410: REM === PREVENT PLAYER 1'S FORK
4390 J=J+JS: IF J=JT THEN 4400 ELSE 4310
4400 I=I+IS: IF I=IT THEN 4460 ELSE 4290
4410 PRINT CP$;CHR$(42);CHR$(88);CMT7$(INT(NCMT7*RND+1));: GOSUB 6050
4420 PRINT CP$;CHR$(42);CHR$(88);"                    "
4430 R12!=R12!/1.5: R21!=R21!/2: REM === IMPROVE MIKE'S CHANCES
4440 GOSUB 6650: GOSUB 6710: IF OHELL=0 THEN 3100 ELSE MYROUND=0: GOTO 3100
4450 REM <<================= IF NOT FORCING, PREVENT 4 LINES JOINING 4 POINTS
4460 IF SKILL < 2 THEN 4690 ELSE IF SKILL < 3 AND RND < R22! THEN 4690
4470 I=1: REM === FIRST PLANE
4480 IF PLANES(I,3)=1 THEN 4540: REM === IF ALREADY BLOCKED IN IT
4490 J=INT(PLANES(I,1)/100): K=INT((PLANES(I,1)-100*J)/10)
4500 L=PLANES(I,1)-100*J-10*K: L=J+K*(L-1): M=J: N=M+K
4510 IF SUMS(M)+SUMS(N)=3 THEN 4550: REM === IF 3 POINTS ON 2 LINES
4520 N=N+K: IF N <= L THEN 4510: REM === NEXT 2ND LINE
4530 M=M+K: IF M <= L-K THEN N=M+K: GOTO 4510: REM === NEXT 1ST LINE
4540 I=I+1: IF I <= 18 THEN 4490 ELSE 4690: REM === NEXT PLANE
4550 O=INT(PLANES(I,2)/100): P=PLANES(I,2)-100*O: REM === GET THE DIAGONALS
4560 IF SUMS(O) = O THEN Q=O ELSE IF SUMS(P) = 0 THEN Q=P ELSE 4600
4570 IF RND > .5 THEN IB=1: IS=4: IT=9: II=IB: ELSE IB=4: IS=-3: IT=-2: II=IB
4580 SRC=STACKI(LINES(Q,II)): GOSUB 6030: IF STACK$(S,R,C)=VACANT$ THEN 4650
4590 II=II+IS: IF II=IT THEN 4600 ELSE 4580: REM === 1ST DIAGONAL
4600 IF SUMS(O) = 1 THEN Q=O ELSE IF SUMS(P) = 1 THEN Q=P ELSE 4540
4610 IF RND > .5 THEN IB=1: IS=4: IT=9: II=IB: ELSE IB=4: IS=-3: IT=-2: II=IB
4620 SRC=STACKI(LINES(Q,II)): GOSUB 6030: IF STACK$(S,R,C)=VACANT$ THEN 4650
4630 II=II+IS: IF II=IT THEN 4640 ELSE 4620: REM === 2ND DIAGONAL
4640 MSG$="PREVENT 4L-4P ": GOTO 5310: REM LOGIC ERROR
4650 R22!=R22!/1.25: PLANES(I,3)=1: REM === BLOCK THIS PLANE & PLAYER 1
4660 PRINT:PRINT CP$;CHR$(42);CHR$(88);CMT6$(INT(NCMT6*RND+1))
4670 GOSUB 6050: PRINT CP$;CHR$(42);CHR$(88);"                    "
4680 GOSUB 6650: GOSUB 6710: IF OHELL=0 THEN 3100 ELSE MYROUND=0: GOTO 3100
4690 REM <<============================================= FINALLY, MY OWN PLAY
4700 IF MYROUND < -1 THEN 5300: REM === BY POSITION
4710 IF MYROUND <  0 THEN 5150: REM === BY LINE
4720 IF OHELL > 0 THEN 4880 ELSE MYROUND=MYROUND+1
4730 IF MYROUND > THISGAME(1) THEN 4780: REM === IF FORCING PLAY
4740 THISGAME(2)=MYROUND: I=THISGAME(1): J=0: REM === OPENING PLAY
4750 J=J+1: IF J > I THEN 4880
4760 SRC=THISGAME(J+4): GOSUB 6030
4770 IF STACK$(S,R,C) = VACANT$ THEN 4870 ELSE 4750
4780 MYPLAY=THISGAME(2): K=0: REM === FORCING PLAY
4790 MYPLAY=MYPLAY+1: IF MYPLAY > THISGAME(3) THEN 4880
4800 IF THISGAME(MYPLAY+4) < 0 THEN 4810 ELSE 4840
4810 SRC=ABS(THISGAME(MYPLAY+4)): GOSUB 6030: I$=STACK$(S,R,C)
4820 IF I$ = VACANT$ AND K = 0 THEN 4790
4830 IF I$ = MARKERS$(4) AND K = 0 THEN 4790 ELSE K=1: GOTO 4790
4840 IF K <> 0 THEN K=0: GOTO 4790 ELSE THISGAME(2)=MYPLAY
4850 SRC=THISGAME(MYPLAY+4): GOSUB 6030
4860 IF STACK$(S,R,C) = VACANT$ THEN 4870 ELSE K=0: GOTO 4790
4870 GOSUB 6650: GOSUB 6710: IF GAMEWON <> 0 THEN 6770 ELSE 3100
4880 IB=0: IT=0: JB=0: JT=0: REM === OPTIMIZE MY RECOVERY
4890 PRINT CP$;CHR$(42);CHR$(88);CMT4$(INT(NCMT4*RND+1))
4900 PRINT CP$;CHR$(43);CHR$(88);"                    "
4910 PRINT CP$;CHR$(43);CHR$(88);: REM === FOR SOME SCREEN ACTIVITY
4920 IF MYROUND > 2 THEN 4930 ELSE 4940: REM === LONG OR SHORT OPTIMIZE
4930 I=THISGAME(4): FOR J=1 TO 3: GOTO 4950: REM === NEW PATTERN & FULL SCAN
4940 I=ISTRAT: J=JBASE: LT=5: REM === SAME PATTERN & BASE PLANE
4950 FOR K=1 TO 4: L=10: PRINT CHR$(INT(26*RND+97));
4960 L=L-1: CLEAN=1: GOSUB 5350: IF CLEAN=0 THEN 4990
4970 IF JS > JB THEN JB=JS: JT=1000*I+100*J+10*K+L
4980 IF IS=MYGAMES(I,3) THEN IT=1000*I+100*J+10*K+L
4990 IF L > LT THEN 4960: REM === TRANSLATE-ROTATE (1-9) OR ROTATE ONLY (5-9)
5000 NEXT K: REM === SPIN
5010 IF MYROUND < 3 THEN 5030: REM === IF SHORT OPTIMIZE
5020 NEXT J: REM === BASE PLANE (LONG OPTIMIZE)
5030 IF JT=0 THEN 5050: REM === NO BEST GAME
5040 MYROUND=JB: I=INT(JT/1000): SRC=JT-I*1000: GOTO 5070
5050 IF IT=0 THEN 5150: REM === NO OPEN GAME
5060 MYROUND=0: I=INT(IT/1000): SRC=IT-I*1000
5070 GOSUB 6030: J=S: K=R: L=C
5080 OHELL=0: MYROUND=0: CLEAN=1: GOSUB 5350: PRINT: REM === AFTER ; A LF
5090 PRINT CP$;CHR$(42);CHR$(88);"                    "
5100 PRINT CP$;CHR$(43);CHR$(88);"                    "
5110 FOR N=1 TO 4: THISGAME(N)=MYGAMES(I,N): NEXT N: PATTERN=PATTERN+1
5120 IF CHEAT <> 9 THEN 5140 ELSE PRINT CP$;CHR$(32);CHR$(33);I
5130 FOR M=5 TO THISGAME(3)+4: PRINT THISGAME(M): NEXT M
5140 IF IVEMOVED=0 THEN 4690 ELSE 3100
5150 REM <<======================== MY GAME BUSTED; CHECK FOR TWO/ONE IN LINE
5160 MYROUND=-1: IB=0: IT=0: JB=0: JT=0
5170 IF RND > .5 THEN KB=1: KS=1: KE=76: K=KB ELSE KB=76: KS=-1: KE=1: K=KB
5180 IF SUMS(K)=2*ADDENDS(4) THEN IB=2: IT=K: GOTO 5200
5190 IF SUMS(K)=ADDENDS(4) THEN JB=1: JT=K
5200 K=K+KS: IF K=KE THEN 5210 ELSE 5180
5210 IF IB=2 THEN K=IT: GOTO 5240
5220 IF JB=1 THEN K=JT: GOTO 5240
5230 GOTO 5300: REM === I CAN'T WIN
5240 IF RND < .5 THEN LB=1: LS=1: LE=4: L=LB ELSE LB=4: LS=-1: LE=1: L=LB
5250 SRC=STACKI(LINES(K,L)): GOSUB 6030
5260 IF STACK$(S,R,C)=VACANT$ THEN 5280
5270 L=L+LS: IF L=0 OR L=5 THEN MSG$="MY GAME BUSTED":GOTO 5310 ELSE 5250
5280 GOSUB 6050: DELAY=15: GOSUB 6060
5290 GOSUB 6650: GOSUB 6710: IF GAMEWON=0 THEN 3100 ELSE 6770
5300 PRINT CP$;CHR$(43);CHR$(88);"I give up.": GOTO 6870
5310 REM <<================================================ ABORT THE PROGRAM
5320 PRINT CP$;CHR$(34);CHR$(33);"Logic Error"
5330 PRINT MSG$: END
5340 REM ======== MOVE CHOSEN PATTERN INTO PLAYING PLANE AND CHECK FOR VACANT
5350 IS=0: JS=0: N=0
5360 N=N+1: IF N > MYGAMES(I,3) THEN RETURN
5370 SRC=ABS(MYGAMES(I,N+4)): GOSUB 6030
5380 ON J GOTO 5390,5400,5410: REM === BASE PLANE
5390 X=C: Y=R: Z=S: GOTO 5420: REM SHELF 1
5400 X=C: Y=S: Z=R: GOTO 5420: REM ROW 1
5410 X=S: Y=R: Z=C: REM COLUMN 1
5420 ON K GOTO 5550,5430,5470,5510: REM === SPIN
5430 ON J GOTO 5440,5450,5460: REM  90 DEG CW
5440 O=X: X=Y: Y=5-O: GOTO 5550: REM IN XY PLANE
5450 O=X: X=Z: Z=5-O: GOTO 5550: REM IN XZ PLANE
5460 O=Z: Z=Y: Y=5-O: GOTO 5550: REM IN YZ PLANE
5470 ON J GOTO 5480,5490,5500: REM 180 DEG CW
5480 X=5-X: Y=5-Y: GOTO 5550
5490 X=5-X: Z=5-Z: GOTO 5550
5500 Y=5-Y: Z=5-Z: GOTO 5550
5510 ON J GOTO 5520,5530,5540: REM 270 DEG CW
5520 O=Y: Y=X: X=5-O: GOTO 5550
5530 O=Z: Z=X: X=5-O: GOTO 5550
5540 O=Y: Y=Z: Z=5-O
5550 IF L > 4 THEN 5600
5560 ON J GOTO 5570,5580,5590: REM === TRANSLATE
5570 Z=Z+L-1: GOTO 5760
5580 Y=Y+L-1: GOTO 5760
5590 X=X+L-1: GOTO 5760
5600 ON J GOTO 5610,5660,5710: REM === ROTATE
5610 ON L-4 GOTO 5760,5620,5630,5640,5650
5620 Z=Y: GOTO 5760
5630 SWAP Y,Z: GOTO 5760
5640 Z=5-Y: GOTO 5760
5650 Z=5-Y: Y=4: GOTO 5760
5660 ON L-4 GOTO 5760,5670,5680,5690,5700
5670 Y=X: GOTO 5760
5680 SWAP X,Y: GOTO 5760
5690 Y=5-X: GOTO 5760
5700 Y=5-X: X=4: GOTO 5760
5710 ON L-4 GOTO 5760,5720,5730,5740,5750
5720 X=Z: GOTO 5760
5730 SWAP X,Z: GOTO 5760
5740 X=5-Z: GOTO 5760
5750 X=5-Z: Z=4: GOTO 5760
5760 S=Z: R=Y: C=X
5770 IF S < 1 OR S > 4 OR R < 1 OR R > 4 OR C < 1 OR C > 4 THEN 5820
5780 IF STACK$(S,R,C)=VACANT$ THEN IS=IS+1: GOTO 5810
5790 IF STACK$(S,R,C) <> MARKERS$(4) THEN 5820
5800 IF N <= MYGAMES(I,1) THEN JS=JS+1
5810 SRC=100*S+10*R+C: THISGAME(N+4)=SGN(MYGAMES(I,N+4))*SRC: GOTO 5360
5820 N=MYGAMES(I,3): CLEAN=0: GOTO 5360
5830 REM ====================================== PROGRESS-CHECKING SUBROUTINES
5840 FOUND=0: I=0: REM <<====================== THREE IN A LINE?
5850 I=I+1: J=0: IF I > 76 THEN RETURN
5860 IF SUMS(I) <> 3*ADDENDS(PLAYEE) THEN 5850
5870 J=J+1: IF J > 4 GOTO 5850
5880 SRC=STACKI(LINES(I,J)): GOSUB 6030
5890 IF STACK$(S,R,C) <> VACANT$ THEN 5870
5900 GOSUB 6050: FOUND=PLAYEE: RETURN
5910 FOUND=0: I=0: REM <<====================== A FORK?
5920 I=I+1: J=I: IF I > 75 THEN RETURN
5930 IF SUMS(I) <> 2*ADDENDS(PLAYEE) THEN 5920
5940 J=J+1: L=0: IF J > 76 THEN 5920
5950 IF SUMS(J) <> 2*ADDENDS(PLAYEE) THEN 5940
5960 L=L+1: M=0: IF L > 4 THEN 5940
5970 M=M+1:      IF M > 4 THEN 5960
5980 IF LINES(I,L) <> LINES(J,M) THEN 5970
5990 SRC=STACKI(LINES(I,L)): GOSUB 6030
6000 IF STACK$(S,R,C) <> VACANT$ THEN 5940
6010 FOUND=PLAYEE: RETURN
6020 REM ================================================ SERVICE SUBROUTINES
6030 S=INT(SRC/100): REM ====== FROM SRC, GET S, R AND C
6040 R=INT((SRC-S*100)/10): C=(SRC-S*100)-R*10: RETURN
6050 DELAY=50: REM ====== STANDARD DELAY
6060 FOR DLY=1 TO DELAY: TIME=1.5^1.5: NEXT DLY: RETURN
6070 REM ====== GET PLAYER'S MOVE
6080 PRINT CP$;CHR$(36);CHR$(88);PLAYERS$(PLAYER);"        "
6090 PRINT CP$;CHR$(37);CHR$(88);MARKERS$(PLAYER);"         "
6100 PRINT CP$;CHR$(36);CHR$(100);:INPUT" ";SRC
6110 IF SRC=999 THEN 6950 ELSE IF SRC=888 THEN 3000 ELSE IF SRC=777 THEN 2500
6120 IF SRC > 0 AND SRC < 5 THEN VIEWFROM=SRC: MOVEFROM=SRC: RETURN
6130 VIEWFROM=0: GOSUB 6030
6140 IF S > 0 AND S < 5 AND R > 0 AND R < 5 AND C > 0 AND C < 5 THEN 6180
6150 IF SRC <> 748 THEN 6170: REM CHEAT ON/OFF
6160 IF CHEAT=0 THEN CHEAT=9: GOTO 6170 ELSE CHEAT=0
6170 PRINT CHR$(7);CP$;CHR$(37);CHR$(94);"Out of range.";: GOTO 6100
6180 IF STACK$(S,R,C)=VACANT$ THEN 6200
6190 PRINT CHR$(7);CP$;CHR$(37);CHR$(94);"    Occupied.";: GOTO 6100
6200 PRINT CP$;CHR$(37);CHR$(94);"             "
6210 STACK$(S,R,C)=MARKERS$(PLAYER): RETURN
6220 REM ===================================== DISPLAY THE STACK$ SUBROUTINES
6230 PRINT CHR$(26): REM ====== PLAYER 1
6240 PRINT CP$;CHR$(32);CHR$(35);
6250 FOR S=4 TO 1 STEP -1: PRINT TAB(10) "Shelf";S;
6260 FOR R=4 TO 1 STEP -1: PRINT TAB(20);"Row";R;"  |";
6270 FOR C=1 TO 4: PRINT STACK$(S,R,C);"|";: NEXT C: PRINT
6280 NEXT R: IF S>1 THEN PRINT:PRINT
6290 NEXT S: PRINT CP$;CHR$(54);CHR$(50);"Column      1     2     3     4";
6300 PRINT"     As seen by ";PLAYERS$(1);: RETURN
6310 PRINT CHR$(26): REM ====== PLAYER 2
6320 PRINT CP$;CHR$(32);CHR$(35);
6330 FOR S=4 TO 1 STEP -1: PRINT TAB(18) "Shelf";S;
6340 FOR C=4 TO 1 STEP -1: PRINT TAB(28);"|";
6350 FOR R=4 TO 1 STEP -1: PRINT STACK$(S,R,C);"|";: NEXT R
6360 PRINT TAB(58) "Column";C: NEXT C: IF S>1 THEN PRINT:PRINT
6370 NEXT S: PRINT CP$;CHR$(54);CHR$(53);"Row      4     3     2     1";
6380 PRINT"     As seen by ";PLAYERS$(2);: RETURN
6390 PRINT CHR$(26): REM ====== PLAYER 3
6400 PRINT CP$;CHR$(32);CHR$(35);
6410 FOR S=4 TO 1 STEP -1: PRINT TAB(18) "Shelf";S;
6420 FOR C=1 TO 4: PRINT TAB(28);"|";
6430 FOR R=1 TO 4: PRINT STACK$(S,R,C);"|";: NEXT R
6440 PRINT TAB(58) "Column";C: NEXT C: IF S>1 THEN PRINT:PRINT
6450 NEXT S: PRINT CP$;CHR$(54);CHR$(53);"Row      1     2     3     4";
6460 PRINT"     As seen by ";PLAYERS$(3);: RETURN
6470 PRINT CHR$(26): REM ====== MIKE ROCHIPS
6480 PRINT CP$;CHR$(32);CHR$(35);
6490 FOR S=4 TO 1 STEP -1: PRINT TAB(10) "Shelf";S;
6500 FOR R=1 TO 4: PRINT TAB(20);"Row";R;"  |";
6510 FOR C=4 TO 1 STEP -1: PRINT STACK$(S,R,C);"|";: NEXT C: PRINT
6520 NEXT R: IF S>1 THEN PRINT:PRINT
6530 NEXT S: PRINT CP$;CHR$(54);CHR$(50);"Column      4     3     2     1";
6540 PRINT"     As seen by ";PLAYERS$(4);: RETURN
6550 REM =========================================== MOVE DISPLAY SUBROUTINES
6560 PRINT CP$;CHR$(60-6*S-R);CHR$(6*C+54);MARKERS$(PLAYER);: GOSUB 6050
6570 RETURN
6580 PRINT CP$;CHR$(60-6*S-C);CHR$(84-6*R);MARKERS$(PLAYER);: GOSUB 6050
6590 RETURN
6600 PRINT CP$;CHR$(55-6*S+C);CHR$(54+6*R);MARKERS$(PLAYER);: GOSUB 6050
6610 RETURN
6620 PRINT CP$;CHR$(55-6*S+R);CHR$(84-6*C);MARKERS$(PLAYER);: GOSUB 6050
6630 RETURN
6640 REM ============================================================ MY MOVE
6650 PRINT CP$;CHR$(42);CHR$(88);"                    "
6660 PRINT CP$;CHR$(43);CHR$(88);"                    "
6670 PRINT CP$;CHR$(37);CHR$(88);"I'll take";SRC
6680 ON MOVEFROM GOSUB 6560,6580,6600,6620
6690 STACK$(S,R,C)=MARKERS$(4): IVEMOVED=1: RETURN
6700 REM ===================================== ADJUST ADDENDS AND CHECK FOR 4
6710 I=16*S+4*R+C-20: J=0
6720 J=J+1: IF J>7 THEN RETURN
6730 K=RAYS(I,J): IF K=0 THEN 6720
6740 SUMS(K)=SUMS(K)+ADDENDS(PLAYER)
6750 IF SUMS(K)=4*ADDENDS(PLAYER) THEN GAMEWON=PLAYEE
6760 IF GAMEWON=0 THEN 6720 ELSE RETURN
6770 REM <<================================================= THE GAME IS OVER
6771 IF GAMEWON = 4 THEN GANGSW=0: GANGCTR=0: GOTO 6780
6772 IF NUM > 1 AND GANGCTR > 0 THEN 6877
6780 PRINT CP$;CHR$(42);CHR$(88);"And the winnah is..."
6790 FOR I=1 TO 4: SRC=STACKI(LINES(K,I)): GOSUB 6030
6800 ON MOVEFROM GOTO 6810,6820,6830,6840
6810 PRINT CP$;CHR$(60-6*S-R);CHR$(54+6*C);"*";: GOTO 6850
6820 PRINT CP$;CHR$(60-6*S-C);CHR$(84-6*R);"*";: GOTO 6850
6830 PRINT CP$;CHR$(55-6*S+C);CHR$(54+6*R);"*";: GOTO 6850
6840 PRINT CP$;CHR$(55-6*S+R);CHR$(84-6*C);"*";
6850 DELAY=10: GOSUB 6060: NEXT I: PRINT
6860 PRINT CP$;CHR$(43);CHR$(88);PLAYERS$(GAMEWON);
6870 DELAY=20: GOSUB 6060: I$=INKEY$
6871 IF NUM < 2 THEN 6880
6872 IF GANGSW > 0 THEN GANGCTR=GANGCTR+1 ELSE 6880
6873 IF GANGCTR > 1 THEN 6877 ELSE DELAY=40: GOSUB 6060
6874 IF GAMEWON = 4 THEN 6880
6875 PRINT CP$;CHR$(42);CHR$(88);"If you folks are    "
6876 PRINT CP$;CHR$(43);CHR$(88);"ganging up on me... ": GOTO 6880
6877 PRINT CP$;CHR$(42);CHR$(88);"You are ganging up! "
6878 PRINT CP$;CHR$(43);CHR$(88);"Find another patsy. "
6879 PRINT CP$;CHR$(53);CHR$(33): SYSTEM
6880 PRINT CP$;CHR$(48);CHR$(88) "Enter 7 to restart  "
6890 PRINT CP$;CHR$(49);CHR$(88) "      8 to play again"
6900 PRINT CP$;CHR$(50);CHR$(88) "      9 to quit"
6910 PRINT CP$;CHR$(50);CHR$(104);
6920 I$=INKEY$: IF LEN(I$)=0 THEN 6920
6930 PRINT I$;: IF I$="7" THEN DELAY=20: GOSUB 6060: GOTO 2500
6940 IF I$ = "8" THEN 3000 ELSE IF I$ <> "9" THEN 6910
6950 END
0 PRINT I$;: IF I$="7" THEN DELAY=20: GOSUB 6060: GOTO 2500
6940 IF I$ = "8" THEN 3000 ELSE IF I$ <> "9" THEN 6910
