print macro string
       lea dx,string
       mov ah,9
       int 21h
       endm
;
;
; this is a skeleton for passthrough  or resident programs
;
; when compiled as a pass through program it will use a little over
; 5K of system memory. When compiled as resident program it takes
; about 1.5k. When you add your own routines an work areas this
; will increase.
;
passthru = 0  ; if = 1 it means MASM will create the passthrough
              ; version. 0 means it will make the resident version
; if you are making a passthroug version then rou are not making
; a resident version. And if you are not making a passthrough then
; you are making a resident.
;
if passthru
   resident = 0
else
   resident = 1
endif
CSEG        SEGMENT PARA PUBLIC 'CODE'
        ASSUME CS:CSEG,DS:CSEG,SS:CSEG,ES:CSEG
        ORG        100H
ENTPT:        JMP        setpass
; this area is used by the resident and passthrough versions
;
        db  'Next 4 bytes are scan1,shift1,scan2,shift2:'
scan1   db 30h     ; these are the hot key combinations
shift1  db 10      ; scan being the scan code and shift being
scan2   db 83h     ; the shift state.
shift2  db 12      ;
         db 'Copyright 1985. 1987 by',13,10
         db 'Keith P. Graham',13,10,'238 Germonds Rd.',13,10
         db 'W. Nyack, NY 10994',13,10
;
;
;
mess2   db  'BOSS-SW is Already Resident',13,10,'$'
; data areas
nine       db  9
ten        db  10
eighty     db  80
keyin      db 48
key        dw 4f4fh
return     dw 0f4f4h
color      db 0f0h
c123x      db 0
c123y      db 0
almode     db 0
ahcols     db 0
window  db  'A1:                                     '
        db  '                                   READY'
        db  2*80 dup(' ')
        db  '        A        B        C        D    '
        db  '    E        F        G        H        '
        db  '1                Keith P. Graham        '
        db  '                                        '
        db  '2               238 Germonds Road       '
        db  '                                        '
        db  '3              W. Nyack, NY 10994       '
        db  '                                        '
        db  '4    Call PC-Rockland at (914) 353-2176 '
        db  'for the latest version of this program  '
        db  '5 ',78 dup(' ')
        db  '6 ',78 dup(' ')
        db  '7 ',78 dup(' ')
        db  '8 ',78 dup(' ')
        db  '9 ',78 dup(' ')
        db  '10',78 dup(' ')
        db  '11',78 dup(' ')
        db  '12',78 dup(' ')
        db  '13',78 dup(' ')
        db  '14',78 dup(' ')
        db  '15',78 dup(' ')
        db  '16',78 dup(' ')
        db  '17',78 dup(' ')
        db  '18',78 dup(' ')
        db  '19',78 dup(' ')
        db  '20',78 dup(' ')
        db   80 dup(' ')
sccx       dw 0
vseg       dw 0b800h
kbuffl   dw 0
kbuff    db  80 dup(0)
;
;
;
stack   dw   256  dup(0)
int9      dd  0
int9ip   equ word ptr int9
int9cs   equ word ptr int9 + 2
int17     dd  0
int17ip   equ word ptr int17
int17cs   equ word ptr int17 + 2
savesp   dw  0
savess   dw  0
savespl  dw  0
savessl  dw  0
semaphore db  0
cursor    dw  0
cursmode  dw  0
bhpage    db  0
rmess    db  "Boss_switch deinstalled",13,10,10,'$'
;
; this data is used by the passthru program only
;
if passthru
command_line db 129 dup(0)
; parmblock is used for the parmeters for the execute
parmblock  dw  0  ; this is the parmblock for execute
           dw command_line
tailds     dw  0
           dw 5ch ; fcb in psp
fcb1       dw  0
           dw 6ch ; fcb in psp
fcb2       dw  0
endif
START        PROC        NEAR
; the printint area is used to double check that we are installed twice
printint:
        cmp ax,cs:key
        jne  no98
        mov ax,cs:return
        iret
no98:
        jmp  cs:int17
keyboard:
; we are entering here due to a key being struck
; first check the keyboard area to see if the CTRL and ALT are ppasssed
;
; first call the keyboard interrupt so that it can handle the
; keystroke
;
        pushf          ; fake the way an interrupt pushes flags
        cli
        call cs:int9
        sti
        push  ax
        mov  al,1
lock    xchg cs:semaphore,al
        test al,al
        jz   int9_shift
        pop  ax
        iret
int9_return:
        mov  cs:semaphore,0
        pop  ax
        iret
int9_shift:
; no one is using this guy so we will check out the shift state
; this uses two hot keys, one is Alt-Left Shift-B and the other
; is Alt-Ctrl-Equal.
;
        mov  ah,2   ; get shift status
        int  16h    ; get keyboard
; status returns in al
        and  al,0fh ; get rid of caps or num lock stuff
;
        cmp  al,cs:shift1 ; has the Alt and Left shift been pressed
        je   test_hot_1
        cmp  al,cs:shift2 ; has the Alt and Ctrl been pressed
        je   test_hot_2
        jmp  int9_return
test_hot_1:
; check to see if the next key to come in is B  scan 40h
        mov  ah,1
        int  16h
        jnz  check_key1
        jmp  int9_return
check_key1:
        cmp  ah,cs:scan1   ; Is the next character the "B" key?
        je   goforit
        jmp  int9_return
test_hot_2:
; check to see if the next key to come in is =  scan 83h
        mov  ah,1
        int  16h
        jnz  check_key2
        jmp  int9_return
check_key2:
        cmp  ah,cs:scan2  ; Is the next character the "=" key?
        je   goforit
        jmp  int9_return
goforit:
; save the world first switch to the local stack to save the
; actual stack.
; ax is the only thing in the local stack ( plus the interrupt ret)
        sti
        mov   cs:savessl,ss
        mov   cs:savespl,sp
        mov   ax,cs
        mov   ss,ax
        lea   sp,stack+510  ; double duty out of the local stack
        push bx
        push cx
        push dx
        push si
        push di
        push bp
        push ds
        push es
; get the p so others won't be messed up
        mov  ah,0
        int  16h
        mov  ax,cs
        mov  ds,ax
        mov  es,ax
        call getcurs   ; gets the current cursor position
;
;
;   the program goes here
; in program
        mov   color,030h
        cmp   almode,2
        je    col80c
        cmp   almode,3
        je    col80c
        cmp   almode,7
        je    col80M
; in a graphics mode
        mov   sccx,16*1024
        jmp   savescr
col80c:
; video state is 80 col color
        mov   sccx,4*1024
        jmp   savescr
col80m:
; video state is 80 col mono
        mov   sccx,4*1024
        mov   vseg,0b000h
        mov   color,01111000b
        jmp   savescr
savescr:
 ; save the video screen
        mov   cx,sccx
        mov   ds,cs:vseg
        mov   si,0
        lea   di,wsave
        cld
rep     movsb
        mov   ax,cs
        mov   ds,ax
; switch to display mode
        mov   ah,0
        mov   al,3
        int   10h
;       mov   dx,3d8h
;       mov   al,9
;       out   dx,al
; display fake screen
        mov   es,vseg
        mov   di,0
        lea   si,window
        mov   cx,25*80
        mov   bx,1
        mov   dx,1
        cld
disploop:
        lodsb
        mov   ah,07h
        cmp  bx,80
        jng  sameline
        mov  bx,1
        inc  dx
sameline:
        cmp  dx,4
        je   blue
        cmp  dx,4
        jl   topline
        cmp  bx,5
        jl   blue
        jmp  dispsto
blue:
        cmp  dx,25
        je   dispsto
        mov  ah,color
        jmp  dispsto
topline:
        cmp  dx,1
        jne  dispsto
        cmp  bx,75
        jg   blue
dispsto:
        stosw
        inc  bx
        loop disploop
        mov   ax,cs
        mov   es,ax
bigcurs:
; set the cell number
        mov  es,vseg
        mov  di,0
        mov al,c123x
        add  al,41h
        mov  ah,07h
        stosw
        mov  al,c123y
        inc  al
        mov  ah,0
        div  ten
        push ax
        add  al,30h
        mov  ah,07h
        cmp  al,30h
        je   zsupp
        stosw
zsupp:
        pop  ax
        mov  al,ah
        add  al,30h
        mov  ah,07h
        stosw
        mov  al,':'
        mov  ah,07h
        stosw
        mov  cx,30
        cld
        mov  ax,0720h
rep     stosw
        mov  ax,cs
        mov  es,ax
; set the cursor
        mov al,c123x
        mov ah,0
        mul nine
        add al,4
        mov dl,al
        mov dh,c123y
        add dh,4
        mov cx,9
        mov si,0
loop123:
; locate the cursor at current byte
        push  cx
        push dx
        mov  ah,2
        mov  bh,0
        int  10h
        mov  ah,8
        int  10h
        push ax
        mov  bl,color
        mov  cx,1
        mov  ah,9
        int  10h
; now the  other location
        mov  dx,0004h
        add  dx,si
        inc  si
        mov  ah,2
        int  10h
        pop  ax
        mov  bl,07
        mov  cx,1
        mov  ah,9
        int  10h
        pop  dx
        add  dl,1
        pop  cx
        loop loop123
; wait for keyboard input
waitkey:
        mov  dx,0004h
        add  dx,kbuffl
        mov  ah,2
        mov  bh,0
        int  10h
        mov  ah,0
        int  16h
        push ax
; now undo the big cursor
        mov al,c123x
        mov ah,0
        mul nine
        add al,4
        mov dl,al
        mov dh,c123y
        add dh,4
        mov cx,9
        mov si,0
loop123C:
; locate the cursor at current byte
        push  cx
        push dx
        mov  ah,2
        mov  bh,0
        int  10h
        mov  ah,8
        int  10h
        mov  bl,07h
        mov  cx,1
        mov  ah,9
        int  10h
        pop  dx
        add  dl,1
        pop  cx
        loop loop123c
        pop  ax
        cmp  ah,1
        jne  noesc
        jmp  restore
noesc:
        cmp  ah,72
        jne  noup
; up key was hit
        cmp  c123y,0
        jg   upz
        mov  c123y,20
upz:
        sub  c123y,1
        jmp  do13
noup:
        cmp  ah,75
        jne  noleft
; left key was pressed
        cmp  c123x,0
        jg   leftz
        mov  c123x,8
leftz:
        sub  c123x,1
        jmp  do13
noleft:
        cmp  ah,77
        jne  noright
; right cursor pressed
        cmp  c123x,7
        jl   rightz
        mov  c123x,0
        jmp  do13
rightz:
        add  c123x,1
        jmp  do13
noright:
        cmp  ah,80
        jne  nodown
; down key pressed
        cmp  c123y,19
        jl   downz
        mov  c123y,0
        jmp   do13
downz:
        add  c123y,1
        jmp  do13
nodown:
        cmp  ah,71
        jne  nohome
        mov  c123y,0
        mov  c123x,0
        jmp  do13
nohome:
        cmp  ah,79
        jne  noend
        mov  c123y,19
        mov  c123x,7
        jmp  do13
noend:
        cmp  al,8
        jne  noback
; got a backspace
        cmp  kbuffl,0
        jne  fixk
        jmp  bigcurs
fixk:
        sub  kbuffl,1
        jmp  bigcurs
noback:
; we have a character
        cmp  al,13
        jne  dobuff
        cmp  al,0
        jne  nozero
        jmp  bigcurs
nozero:
        jmp  do13
dobuff:
        add  kbuffl,1
        mov  bx,kbuffl
        mov  kbuff[bx]-1,al
        push bx
; store in window
        push ax
        mov  al,c123x
        mov  ah,0
        mul  nine
        add  ax,3
        push ax
        mov  al,c123y
        mov  ah,0
        add  al,4
        mul  eighty
        pop  bx
        add  bx,ax
        add  bx,kbuffl
        pop  ax
        mov  window[bx],al
        pop  bx
        mov  dx,0004h
        add  dx,bx
        dec  dx
        push ax
        mov  ah,2
        mov  bh,0
        int  10h
        pop  ax
        mov  bl,07h
        mov  cx,1
        mov  ah,9
        int  10h
        inc  dx
        mov  ah,2
        mov  bh,0
        int  10h
        jmp  waitkey
do13:
        cmp  kbuffl,0
        jne  action
        jmp  bigcurs
action:
        mov al,c123x
        mov ah,0
        mul nine
        add al,4
        mov dl,al
        mov dh,c123y
        add dh,4
        mov di,0
        mov  cx,kbuffl
        mov  kbuffl,0
        lea si,kbuff
doline:
        push  cx
        push dx
        mov  ah,2
        mov  bh,0
        int  10h
        lodsb
        mov  bl,color
        mov  cx,1
        mov  ah,9
        int  10h
        pop  dx
        add  dl,1
        pop  cx
        loop doline
        mov  ax,cs
        mov  es,ax
        jmp  bigcurs
; restore the screen
restore:
        mov  ah,0
        mov  al,almode
        int  10h
        mov   cx,sccx
        mov   es,cs:vseg
        mov   di,0
        lea   si,wsave
        cld
rep     movsb
        mov   ax,cs
        mov   es,ax
;
;
;
exit_prog:
        call retcurs   ; restores the old cursor position
        pop  es
        pop  ds
        pop  bp
        pop  di
        pop  si
        pop  dx
        pop  cx
        pop  bx
        mov  ss,cs:savessl
        mov  sp,cs:savespl
        pop  ax
        mov   cs:semaphore,0
        iret
START        ENDP
getcurs   proc  near
; get video state
          mov ah,15
          int 10h
          mov bhpage,bh
          mov almode,al
          mov ahcols,ah
          mov ah,3
          mov bh,bhpage
          int  10h
          mov  cursor,dx
          mov  cursmode,cx
          ret
getcurs   endp
retcurs   proc  near
          mov ah,2
          mov  dx,cursor
          mov bh,bhpage
          int  10h
          ret
retcurs   endp
; the tone routines produce glisandos based on the value of si
blip    proc  near
        push  si
        mov   si,30
        call  tone
        pop   si
        ret
blip    endp
blop    proc  near
        push  si
        mov   si,-30
        call  tone
        pop   si
        ret
blop    endp
tone    proc  near
        push  ax
        push  bx
        push  cx
        push  dx
        mov   dx,3    ; tone rate
        mov   bx,240  ; starting freq
        mov   cx,750  ; ending frequency
        cmp   si,0
        jg    do_blip
; here we do blop
        mov   bx,630  ; starting freq
        mov   cx,150  ; ending frequency
do_blip:
; turn on tone
i0:
        push  cx
        push  bx
        in     al,61h
        or     al,3
        out    61h,al
; loop parameters
        mov    cx,bx
 ; set frequency
        mov    dx,12h
        mov    ax,34deh
        div    cx
        mov    cx,ax
; set tone
        mov    al,cl
        out    42h,al
        mov    al,ch
        out    42h,al
i2:     loop i2
        pop    bx
        pop    cx
        cmp    bx,cx
        je     ip3
        add    bx,si
        jmp    i0
ip3:
 ;turn off tone
        in  al,61h
        and al,11111100b
        out 61h,al
        pop  dx
        pop  cx
        pop  bx
        pop  ax
        ret
tone    endp
if resident
wsave equ this byte
endif
setpass  proc  near
; set up a local stack
        lea  sp,stack+510
; first check the printer interrupt by asking for a character
        mov  ax,key
        int  17h
        cmp  ax,return
        jne  okinstall
        print mess2
        int  20h
okinstall:
;
; redirect interrupts here
;
        push  es
        mov   ax,3509h
        int   21h
        mov   int9cs,es
        mov   int9ip,bx
        pop   es
        mov   ah,25h
        mov   al,9h
        lea   dx,keyboard
        int   21h
;
        push  es
        mov   ax,3517h
        int   21h
        mov   int17cs,es
        mov   int17ip,bx
        pop   es
        mov   ah,25h
        mov   al,17h
        lea   dx,printint
        int   21h
print   mess1
if  passthru
;
;  prepare for the exec function
; shrink memory
   lea   bx,last_byte+(32*1024)    ; last byte of program
   add   bx,15           ; trick to round up
   mov   cl,4
   shr   bx,cl           ; divide by 16 to get number of 16 byte blocks
   mov   ah,4ah          ; shrink
   int   21h
; create the commandline
;
; the command line has to start with /C and then the command
; and then end with a carriage return. It must have a byte at
; the front saying how long it is
   cld
   lea   di,command_line+1
   mov   al,'/'
   stosb
   mov   al,'C'
   stosb
   mov   al,' '
   stosb
; now copy the real command line in
   mov   si,81h
   mov   cl,byte ptr ds:[80h]
   mov   ch,0
   push  cx
   cmp   cx,0
   je    no_move
   cld
rep movsb
no_move:
   pop   cx
   add   cx,3
   mov   command_line,cl
; set up the control block with segment information
   mov    tailds,ds
   mov    fcb1,ds
   mov    fcb2,ds
;
; find the comspec
;
   mov    es,word ptr  ds:[2ch]
   mov     di,0
   mov     cx,255
env_loop:
   cld
   mov   al,'='
repne   scasb
; if there is no comspec, there is something wrong with the system
   cmp   word ptr es:[di-3],'CE'
   jne   env_loop
   cmp   word ptr es:[di-5],'PS'
   jne   env_loop
   cmp   word ptr es:[di-7],'MO'
   jne   env_loop
   cmp   byte ptr es:[di-8],'C'
   jne   env_loop
; got the comspec
;
; save the stack
;
   mov   savess,ss
   mov   savesp,sp
;
; set up the segment registers
;
; the comspec segment is in ES and should be in DS
;
   push  es
   pop   ds
   push  cs
   pop   es
   mov   dx,di
   lea   bx,parmblock
   mov   al,0
   mov   ah,4bh
; execute the thing
   int   21h
; here is where we return
   mov   ss,cs:savess
   mov   sp,cs:savesp
   mov   ax,cs
   mov   ds,ax
   mov   es,ax
; say that we did it
   lea   dx,rmess
   mov   ah,9
   int  21h
;
; now reset the interrupts so we can leave
;
        push  ds
        lds   dx,int9
        mov   ah,25h
        mov   al,9h
        int   21h
        pop   ds
        push  ds
        lds   dx,int17
        mov   ah,25h
        mov   al,17h
        int   21h
        pop   ds
        int   20h
endif
if resident
        lea   dx,setpass+(32*1024)
        int 27h
endif
setpass  endp
last_byte equ this byte
if passthru
wsave equ this byte
endif
mess1   db  'Boss Switch',13,10
        db  'Press ALT-LEFT SHIFT-B',13,10
        db  'when the boss comes',13,10,'$'
        db  'Copyright 1985, 1987 by Keith P. Graham',13,10,'$'
CSEG        ENDS
        END        ENTPT
