TITLE 'ALLOY C. P. D.  IBM C LINKER '


;         8086 CODE FOR LINKING TREAD, TWRITE, 
;	 AND TDUMP TO THE ITS-PC AND IDS-PC 
;	 CONTROLLERS FOR THE IBM PERSONAL 
;        COMPUTER.







; THIS CODE WAS WRITTEN EXPRESSLY FOR ALLOY
; ENGINEERING, COMPUTER PRODUCTS DIVISION 
; OF 100 PENNSYLVAINA AVENUE 
; FRAMINGHAM,  MA. U. S. OF A.
; THUS BECOMES THEIR PROPERTY 












;	{REVISIONS}
;
; VERSION  EDIT   WHO    DATE   CHANGE
; -------  ----   ---    ----   ------
;   1.0     0     CPK  06/01/83	INITIAL
;   1.1           CPK  08/10/83 CPM86 & MSDOS
;   1.2           CPK  09/09/83 OVRLAP O	






FALSE	EQU	0
TRUE	EQU	NOT FALSE

; OVERLAPPED I/O (LESS THE I)
; FLAG FOR OVERLAPPING THE WRITES

OOO	EQU	NOT FALSE


; MSDOS FLAG SHOULD BE EQUATED TO TRUE
; FOR AN MSDOS SYSTEM OR SET TO FALSE
; FOR A CPM86 SYSTEM.

MSDOS	EQU	TRUE
CPM86	EQU	NOT MSDOS







IF CPM86
IFLIST
EJECT
ENDIF


; THE CODE SEGEMENT AND DATA SEGMENT
; HAVE THE SAME BASE ADDRESSES AND ARE
; FULLY OVERLAPPED. THE EXTRA SEGMENT 
; WILL CONTAIN THE C DATA SEGMENT. THE
; STACK SEGMENT WILL BE THE SAME AS THE 
; C PROGRAM.


IF MSDOS
.LFCOND
PAGE

PGROUP GROUP PROG

PROG SEGMENT PARA PUBLIC 'PROG'
ASSUME CS:PGROUP,DS:PGROUP
PUBLIC MTU,type9,set9,DTYPE
MTU	PROC  NEAR
ENDIF

IF CPM86
CSEG $
MTU:
ENDIF

  JMP   BASFRT
LEAVE:  POP	BP
	RET	

IF MSDOS
MTU	ENDP
ENDIF




;    RESERVED RAM

DTYPE	DB	0H	; 00 = CARTRIDGE FF = 9-TRACK
PORT	DW	300H	; I/O PORT BASE ADDRESS
; COMMON DATA AREA FOR THOSE OF YOU WHO CARE   	
;
DBUFER	DW	3000H	; DATA BUFFER ADDRESS
MBUFER	DW	2900H	; MASK BUFFER ADDRESS   C
WRDCNT	DW	0	; WRITE / READ RECORD BYTE COUNT
MA	DB	0	; MODE ARGUMENT         O  D  A
PA	DB	0	; POSITION ARGUMENT
CA	DB	0	; COMMAND ARGUMENT      M  A  R
DST	DB	0	; DRIVE STATUS
IST	DB	0	; INTERFACE STATUS      M  T  E
VER	DB	1	; VERSION NUMBER
ECODE	DB	0	; ERROR CODE		N  A  A
;

; END OF COMMON DATA AREA
DSSAVE	DW	0	; STORAGE FOR DS
RSSAVE	DW	0	; STACK POSITION FOR REGS
SSAVE	DW	0	; STACK POSITION FOR PARMS
;
;
;
IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF
;
;
DBUFAD	DW	0	; C-ADDRESS FOR BUFFER ADDRESS
MBUFAD	DW	0	; C-ADDRESS FOR M-BUFFER ADDRESS
WRDAD	DW	0	; C-ADDRESS FOR BYTE COUNT
DSTAD	DW	0	; C-ADDRESS FOR DS
ISTAD	DW	0	; C-ADDRESS FOR IS
ECODAD	DW	0	; C-ADDRESS FOR ECODE
VERAD	DW	0	; C-ADDRESS FOR VERSION
;
DATBUF	DW	0	; BUFFER ADDRESS
ESSAVE	DW	0	; STORAGE FOR ES
ERFLG	DB	0	; ERROR FLAG
TEMPWD	DW	0	; TEMPORARY WORD STORAGE
TEMP	DB	0	; TEMPORARY STORAGE
FORNOW	DB	0	;	"
TEMPMA	DB	0	; TEMPORARY STORAGE FOR MA
TEMPCA	DB	0	; TEMPORARY STORAGE FOR CA
CTWBCT	DW	8208	; CONTROLLER WRITE BYTE COUNTER
;
BUFEND	DW	0	; ADDRESS OF THE END OF THE BUFFER
		;	  FOR PUTTING DATA
BEGBUF	DW	0	; ADDRESS OF THE BEGINNING OF THE
		;	  BUFFER FOR TAKING DATA
STATPD  DB	0	; STATUS PENDING FLAG
;
;
;
;
;
WRITE	EQU	2
;
DEFREC	EQU	8208	; DEFAULT RECORD LENGTH
;
;
DBA	EQU	3000H	; BUFFER ADDRESS
;
MBA	EQU	2900H	; MASK BUFFER ADDRESS
;
;
IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF



;  ***************************************
;---------  I/O PORTS  -------------
;
ISTAT  EQU  1		; INPUT PORT STATUS
;
;	B0-	OPA	; OUTPUT PORT 
;			   AVAILABLE = 1
;	B1-	IDR	; INPUT DATA READY = 1
;
IDATA  EQU  2		; INPUT PORT DATA
;
;
OMA    EQU  0		; OUTPUT MA VALUE
;
OPA    EQU  1		; OUTPUT PA VALUE
;
OCA    EQU  2		; OUTPUT CA VALUE
;
ODATA  EQU  3		; OUTPUT DATA OR MASK


	DB	0




         

IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF

; BASFRT  SAVES ALL THE REGISTERS, CHANGES THE    
; C-DATA SEGMENT TO THE EXTRA SEGMENT TO ACCESS
; C-VARIABLES AND BUFFER AREAS. 



type9	proc	near

mov	al,cs:DTYPE
	ret

type9	endp
 
set9	proc	near

	mov	cs:DTYPE,0FFh
	ret

set9	endp 
 
BASFRT: 
	PUSH	BP	 	; SAVE BP
	MOV	BP,SP
	MOV	DX,DS		; SAVE DS
	MOV	BX,CS
	MOV	DS,BX
	MOV	SSAVE,BP	; SAVE FOR PARAM USE	
	MOV	RSSAVE,SP	; SAVE FOR SP RESET
	MOV	DSSAVE,DX
        MOV     BX,ES
        MOV     ES,DX
 
	MOV	ESSAVE,BX	; TEMP FOR ES

	MOV	ERFLG,0		; ZERO ERROR FLAG
	CALL	UNSTK		; CATCH PARAMETERS PASSED

; OVERLAPPED O
; 
;
	IF OOO
;
; CHECK IF STATUS PENDING
;
CKSP:	CMP	STATPD,1
	JNZ	DRITE		; JIF NO STATUS PENDING
;
; GET PENDING STATUS
;
	MOV	STATPD,0	; ZERO STATUS PENDING
	CALL	POLL		; CHECK DATA READY
	CALL 	INSTAT		; GET STATUS
	AND 	AL,30H		; ANY ERROR?
	JZ	DRITE		; JIF OK TO CONTINUE
	JMP	EFFY		; OR JUST EXIT

	ENDIF
	

DRITE:	MOV	AL,CA
	CMP	AL,0FFH		; CHECK FOR STATUS PENDING
	JZ	NREST
	AND	AL,10H		; CHECK FOR RESET COMMAND
	JZ	NOREST 		; JIF NOT RESET COMMAND
	
	JMP	RESETT


NOREST:	CALL	DRV		; DO COMMANDS
NREST:	MOV	AL,IST
	AND	AL,30H
	JNZ	EFFY
	CMP	CA,2
	JNZ	EFF0
	MOV	BX,WRDCNT
	MOV	CTWBCT,BX
EFF0:	MOV	ECODE,0
	JMP	DOSTK
EFFY:	MOV	BL,IST		; LOAD ERROR CODE
	AND	BL,0FH
	MOV	ECODE,BL
DOSTK:	CALL	STK
	MOV	ES,ESSAVE	; RESTORE ES 
	MOV	SP,RSSAVE	; RESTORE SP
	MOV	DS,DSSAVE	; RESTORE DS
	JMP	LEAVE

IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF

; UNSTK TAKES THE ADDRESSES OF THE VARIABLES
; FROM THE STACK FOR USE WHEN MODIFYING THE
; CONTENTS.  EXCEPT FOR THE BUFFERS, WHICH
; ARE THE ACTUAL ADDRESSES OF THE BUFFER AREAS.


UNSTK:	MOV	BP,SSAVE
	MOV	BX,[BP]+4	; DATA BUFFER	
	MOV	DBUFAD,BX
	MOV	DBUFER,BX
	MOV	BX,[BP]+6	; MASK BUFFER
	MOV	MBUFAD,BX
	MOV	MBUFER,BX
	MOV	BX,[BP]+8	; BYTE COUNTER
	MOV	WRDAD,BX
	MOV	SI,WRDAD
	MOV	DX,ES:[SI]
	MOV	WRDCNT,DX
	MOV	BX,[BP]+10	; CA
	MOV	CA,BL
	MOV	BX,[BP]+12	; MA
	MOV	MA,BL
	MOV	BX,[BP]+14	; PA
	MOV	PA,BL
	MOV	BX,[BP]+16	; DRIVE STATUS
	MOV	DSTAD,BX
	MOV	BX,[BP]+18	; INTERFACE STATUS
	MOV	ISTAD,BX
	RET

; STK MODIFIES THE DRIVE STATUS, INTERFACE STATUS, 
; AND ERROR CODE EVERY TIME BEFORE RETURNING TO THE
; C PROGRAM EXCEPT ON A RESET COMMAND.

STK:	MOV	AH,0		
	MOV	AL,DST		; DRIVE STATUS
	MOV	SI,DSTAD
	MOV	ES:[SI],AX
	MOV	AL,IST		; INTERFACE STATUS
	MOV	SI,ISTAD
	MOV	ES:[SI],AX
	MOV	AL,ECODE	; ERROR CODE	
	RET

IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF
  

; DRV IS THE DRIVER FOR THE FOLLOWING CODE.  THIS
; ROUTINE IS CALLED FROM BASFRT.  THIS ROUTINE THEN 
; CALLS THE APPROPRIATE PROCEDURES TO PERFORM THE 
; TASK AT HAND. ERROR CODES ARE RETURNED IN THE 
; DS (DST) AND IS (IST).
; MAY MR. BABBAGE AND MS. ADA WATCH OVER US
; THEMSELVES.




DRV:  	MOV	BX,DBUFER	; SET BUFFER ADDRESS TO
	MOV	DATBUF,BX	; DATA BUFFER
	MOV	AL,CA

	CALL	CKDTOT		; CHECK TO SEE IF DATA SENT BEFORE CA

	MOV	AL,0FH
	AND	AL,CA		; CHECK FOR RECORD
	CMP	AL,11		; SEARCH UNDER MASK COMMAND
	JNZ	NORSUM		; JIF NOT R.S.U.M.(^)
	MOV	BX,CTWBCT	; IF SO RESET
	MOV	WRDCNT,BX	; WRITE BYTE COUNTER

NORSUM:	CMP	ERFLG,1
	JZ	PIT
	CALL	CAOUT		; BEAM UP CA


	IF OOO
	CMP	STATPD,1	; JIF OOO AND WRITTING
	JZ	PIT		; ELSE CONTINUE
	ENDIF


	CALL	POLL		; POLL FOR INPUT PORT READY

	CALL	INSTAT		; READ IN DS AND IS

	CALL	CKDTIN		; CHECK FOR INPUT DATA

PIT:	

	RET


IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF


; RESET PROCEDURE PERFORMS THE RESET AS DESCRIBED IN 
; THE CONTROLLER MANUAL.  THIS PROCEDURE DOES NOT
; DIRECTLY AFFECT ANY REGISTERS (ONLY IN PROCEDURES
; IT CALLS). THEREFOR, REGISTER CONTENTS ARE OF NO
; CONCERN TO IT, WITHIN REASON, UPON ENTRY AND EXIT.


RESETT:	
	CALL 	MAOUT		; BEAM UP MA
	CALL	PAOUT		; BEAM UP PA
	CALL	CAOUT		; BEAM UP CA
	MOV	WRDCNT,DEFREC	; RESET RECORD LENGTH
	MOV	CTWBCT,DEFREC
	MOV	DBUFER,DBA	; RESET DATA BUFFER
	MOV	MBUFER,MBA	; RESET MASK BUFFER
	MOV	AX,DEFREC
	MOV	SI,WRDAD
	MOV	ES:[SI],AX
	JMP	NREST		; JMP TO BSFRT
	


; MAOUT SENDS THE MA BYTE TO THE CONTROLLER WHEN THE
; OUTPUT PORT BUFFER IS READY, THEN RETURNS TO THE 
; DRIVER.  ANY PROCEDURE CALLED FROM HERE SHOULD
; SAVE REGISTERS USED IN THIS PROCEDURE AND RESTORE
; THEM BEFORE RETURNING.

MAOUT:	
	MOV	AL,MA
	MOV	DX,PORT
	ADD	DX,OMA 		; SET OUTPUT PORT
	CALL	OTPRT		; WAIT FOR OUTPUT PORT READY
	OUT	DX,AL		; BEAM UP
	RET
     



; PAOUT SENDS THE PA BYTE TO THE CONTROLLER WHEN THE
; OUTPUT PORT BUFFER IS READY, THEN RETURNS TO THE
; DRIVER.  ANY PROCEDURE CALLED FROM HERE SHOULD
; SAVE REGISTERS USED IN THIS PROCEDURE AND RESTORE
; THEM BEFORE RETURNING.


PAOUT:	
	MOV	AL,PA
	MOV	DX,PORT
	ADD	DX,OPA 		; SET OUTPUT PORT
	CALL	OTPRT		; WAIT FOR OUTPUT PORT READY
	OUT	DX,AL		; BEAM UP
	RET
     


; CKDTOT CHECKS TO SEE IF DATA IS TO BE SENT TO THE
; CONTROLLER BEFORE THE CA IS SENT  TO THE CONTROLLER.
; IF THERE IS DATA TO BE SENT DTOUT IS CALLED TO HANDLE
; THE TRANSFER, OTHERWISE, WE RETURN TO THE DRIVER DIRECTLY.
; CARE OF THE REGISTERS IS NECESSARY IF CALLING OTHER
; PROCEDURES FROM HERE.

CKDTOT:	
	MOV	AL,0FH   	; 
	AND	AL,CA
	CMP	AL,2		; CHECK FOR WRITE
	JZ	DTOUT		; JIF WRITE

		; CHECK IF SET RECORD LENGTH COMMAND
	CMP	AL,9
	JZ	RSTRL		; IF SO SET RECORD LENGTH


		; CHECK IF RECORD SEARCH UNDER MASK
	CMP	AL,11
	JZ	STMSK		; IF SO SEND DATA	
  	
TUTE:   
	CALL	MAOUT		; BEAM UP MA
 
	CALL	PAOUT		; BEAM UP PA


DTO:	RET


TRBLE:	MOV	IST,0B0H	; THIS SHOULDN'T HAVE HAPPENED
	MOV	DST,0FFH	; SYNTAX REJEC AND NOT VALID
	MOV	ERFLG,1		; ERROR CODES INTO IS
	JMP	DTO		; ALL ONES INTO DS. RETURN W/ERROR



;   DTOUT READIES EVERYBODY TO MOVE DATA TO THE CONTROLLER

DTOUT:	CALL	CKSTRL  	; MAKE SURE RECORD LENGTH IS SET

GOMSK:	CALL	MAOUT		; BEAM MA FOR WRITE

	CALL 	PAOUT		; BEAM PA FOR WRITE

	CALL	WRITIT		; BEAM UP DATA TO CONTROLLER

	IF OOO
	MOV	AL,CA
	AND 	AL,0FH		; MAKE SURE WRITE
	CMP	AL,02H		; AND IF NOT
	JNZ	NORITE		; DON'T SET PENDING
	MOV	STATPD,1	; SET STATUS PENDING	
	MOV	IST,80H		; ASSUME IS
	MOV	DST,91H		; ASSUME DS TO RETURN
	ENDIF

NORITE: RET


; SET NUMBER OF BYTES IN MASK TO SIXTEEN
; MAKE SURE B7 OF MA SET

STMSK:	MOV	WRDCNT,16
	OR	MA,80H		; SET B7 FOR MASK COMMAND
	MOV	BX,MBUFER
	MOV	DATBUF,BX	; SET BUFFER TO MASK BUFFER
	JMP	GOMSK

; SET RECORD LENGTH WITH NUMBER IN WRDCNT
; AFTER SENDING MA AND PA


RSTRL:	

	CALL	MAOUT

	CALL	PAOUT

	MOV	AX,WRDCNT
	MOV	CTWBCT,AX
	MOV	TEMP,AL
	MOV	AL,AH
	MOV	DX,PORT
	ADD	DX,ODATA 

	CALL	OTPRT
	OUT	DX,AL

	MOV	AL,TEMP
	CALL	OTPRT
	OUT	DX,AL

DONE:	
	RET




; CHECK TO SEE IF WRDCNT IS SAME AS CTWBCT.  IF
; NOT, SET THE RECORD LENGTH TO WRDCNT.  REGISTERS
; USED ARE SAVED ON ENTRY AND RESTORED ON EXIT.


CKSTRL:	
	PUSH	AX		
	MOV	AX,WRDCNT
	CMP	AX,CTWBCT
	JNZ	SETRL
	POP	AX
	RET

SETRL:	
	PUSH	DX
	MOV	AL,MA
	MOV	TEMPMA,AL	; SAVE CURRENT MA
	MOV	MA,0		; CREATE NEW MA
	CALL	MAOUT		; BEAM MA FOR RECORD LENGTH SET INSTR

	CALL	PAOUT		; SAME PA SHOULD NOT MATTER

	MOV	AX,WRDCNT
	MOV	CTWBCT,AX
	MOV	DX,PORT
	ADD	DX,ODATA 	; SET OUTPUT PORT
	MOV	TEMP,AL		; SAVE LSB BEAM SECOND
	MOV	AL,AH
	CALL	OTPRT

	OUT	DX,AL   	; BEAM UP MSB FIRST
	MOV	AL,TEMP
	CALL	OTPRT

	OUT	DX,AL		; BEAM UP LSB SECOND

	MOV	AL,CA
	MOV	TEMPCA,AL       ; SAVE CURRENT CA
	AND	AL,0F0H
	OR	AL,9
	MOV	CA,AL           ; MAKE SET RECORD LENGTH CA
	CALL	OTPRT

	CALL	CAOUT

	CALL	POLL

	CALL	INSTAT

CKS:	MOV	AL,TEMPCA	; RESTORE ORIGINAL CA
	MOV	CA,AL
    	MOV	AL,TEMPMA
	MOV	MA,AL		; RESTORE ORIGINAL MA
	POP	DX
	POP	AX
CK:	RET



; WRITIT WRITES DATA TO THE CONTROLLER UNLESS A TIME 
; LIMIT ERROR.  REGISTERS CONTENTS ARE NOT IMPORTANT,
; WITHIN REASON, UPON ENTRY AND EXIT.


WRITIT:	
	MOV	CX,WRDCNT	; SET BYTE COUNTER
	MOV	BX,DATBUF	; SET BX TO BUFFER ADDRESS
	MOV	SI,0

	MOV	DX,PORT
	ADD	DX,ODATA	; SET PORT FOR BEAMING
AGAIN:	MOV	AL,ES:[BX + SI]	; SET DATA FOR BEAM
	CALL	OTPRT

	OUT	DX,AL		; BEAM DATA
	INC	SI
	LOOP	AGAIN

	RET




; CAOUT SENDS THE CA BYTE TO THE CONTROLLER.  ANY
; PROCEDURE CALLED FROM HERE SHOULD SAVE REGISTERS 
; USED IN THIS PROCEDURE AND RESTORE THEM BEFORE
; RETURNING.


CAOUT:	
	MOV	DX,PORT
	ADD	DX,OCA 		; SET OUTPUT PORT
	MOV	AL,CA		; MOV CA FOR OUTPUT
	CALL	OTPRT		; WAIT FOR PORT READY
	OUT	DX,AL		; BEAM UP
	RET
     




; POLL CHECKS PORT STATUS FOR DATA READY FOR INPUT.  
; REGISTERS CONTENTS ARE NOT IMPORTANT, WITHIN 
; REASON, UPON ENTRY AND EXIT.


POLL:	

	MOV	DX,PORT
	ADD	DX, ISTAT	; SET PORT FOR PORT STATUS
AWAIT:	IN	AL,DX		; READ STATUS
	MOV	CL,2
	RCR	AL,CL   	; CHECK FOR READY
	JC	ACCP		; JIF READY
	JMP	AWAIT		; JIF NOT TIME 


; READY TO READ IN DS 

ACCP:	RET



; INSTAT READS IN THE DS AND IS. REGISTERS
; CONTENTS ARE NOT IMPORTANT, WITHIN REASON,
; UPON ENTRY AND EXIT.


INSTAT:	
	MOV	DX,PORT
	ADD	DX,IDATA 	; SET INPUT DATA PORT
	IN	AL,DX		; READ IN DS
	MOV	DST,AL

	CALL	INPRT		; WAIT FOR PORT READY

	MOV	DX,PORT
	ADD	DX,IDATA 	; SET INPUT DATA PORT
	IN	AL,DX		; READ IN IS
	MOV	IST,AL
	RET



; CKDTIN CHECKS FOR THE NECESSITY OF DATA FROM 
; THE CONTROLLER.  THEN CALLS THE APPROPRIATE
; ROUTINE.  REGISTER CONTENTS ARE NOT IMPORTANT,
; WITHIN REASON, UPON ENTRY AND EXIT.


CKDTIN:	
	MOV	AL,IST
	MOV	CL,2
	RCL	AL,CL    	; DATA BLOCK FOLLOWS ?
	JC	INDATA		; JIF YES
AHA:	RET

INDATA:	MOV	BX,DBUFER	; SET BUFFER TO DATA BUFFER
	MOV	DATBUF,BX
	CALL	READIT
	JMP	AHA



; READIT READS A DATA BLOCK FROM THE CONTROLLER
; PROCEDURES  CALLED FROM THIS ONE SHOULD SAVE 
; REGISTERS CONTENTS, AND RESTORE THEM UPON 
; RETURN.


READIT:	
	MOV	BX,DATBUF	; SET BX TO DATA BUFFER ADDRESS

	CALL	INPRT		; WAIT FOR PORT READY

	MOV	DX,PORT
	ADD	DX,IDATA 
	IN	AL,DX		; READ IN FIRST BYTE
	MOV	FORNOW,AL	; SAVE LSB BYTE

	CALL	INPRT

	IN	AL,DX		; READ IN SECOND BYTE MSB

	MOV	AH,AL		; PUT MSB IN AH
	MOV 	AL,FORNOW	; PLACE LSB IN AL

	MOV     CL,CA
	AND	CL,21		; CHECK FOR DETERMINE
	CMP	CL,21		;  RECORD LENGTH COMMAND
	JZ	DRL		; JIF SO

	MOV	WRDCNT,AX	; USE FOR STRING LENGTH
	MOV	SI,WRDAD
	MOV	ES:[SI],AX	; RESET BYTE COUNT IN
	MOV	CX,AX  		; C-PROGRAM 
	MOV	SI,0

NOK:	CALL	INPRT

	IN	AL,DX		; READ BYTE TO STORE 
	MOV	ES:[BX + SI],AL	; IN BUFFER
	INC	SI
	DEC	CX		; DEC COUNTER FOR DATA LENGTH
	JCXZ	OK		; JIF END OF DATA

	JMP	NOK		; CONTINUE IF NOT END OF DATA

DRL:	MOV	BX,DATBUF	; SET BX TO STRING ADDRESS
	MOV 	SI,0		; TO RETURN RECORD LENGTH
	MOV	ES:[BX + SI],AX
	MOV	WRDCNT,AX
	MOV	CTWBCT,AX

OK:	RET


IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF

; INPRT WAITS FOR INPUT DATA PORT TO BECOME
; READY. SAVES REGISTERS USED TO RETURN 
; THEM AS RECEIVED.


INPRT:	
	PUSH	AX		; SAVE REGISTERS USING
	PUSH	CX
	PUSH	DX

	MOV	DX,PORT
	ADD	DX,ISTAT 	; SET FOR STATUS PORT
KGO:	IN 	AL,DX		; READ STATUS
	MOV	CL,2
	RCR	AL,CL
	JC	GODAT		; JIF READY TO READ DATA FROM CONTROLLER
	JMP 	KGO		; LOOP IF STILL WAITING

; INPUT PORT READY 

GODAT:	POP 	DX
	POP	CX
	POP	AX
	RET


IF CPM86
EJECT
ENDIF
IF MSDOS
PAGE
ENDIF

; OTPRT WAITS FOR OUTPUT PORT READY 
; REGISTERS USED ARE SAVED
; AND RETURNED AS RECEIVED.


OTPRT:	
	PUSH	AX		; SAVE REGISTERS USED
	PUSH 	DX

	MOV	DX,PORT
	ADD	DX,ISTAT 
GLUG:	IN	AL,DX		; READ STATUS
	RCR	AL,1 
	JC	OTP		; JIF OUTPUT PORT READY
	JMP	GLUG

; OUTPUT PORT READY 

OTP:	POP	DX
	POP	AX
	RET

        NOP		; MANY NOPS WILL SAVE 
	NOP		; THIS PROGRAM FROM
        NOP		;  BEING EATEN BY 
	NOP		; BABBAGE FARIES
        NOP		; IN MASM AND LINK !??
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

IF MSDOS
PROG ENDS
ENDIF

   END
