          PAGE    61,132  ; (Ctrl-O) <--- Insert ASCII 15 for Condensed Print
          TITLE   SYSLOCK.ASM  (Creates SYSLOCK.SYS Device Driver)
;                         Version 1.1, 8/24/85
;   All Rights Reserved: J. C. Kilday Associates, Peaks Island, ME 04108
 
; SYSLOCK.SYS is a device driver for use with PC DOS & MS DOS releases 2.x and
; 3.x to implement a "BREAKproof" password security system for IBM PC's and
; compatibles.  When installed on an XT (or possibly another hard disk system),
; it provides the basis for absolute protection against unauthorized use of the
; PC and access to its hard disk data.
 
; If a simple, reversible hardware modification is made to an XT, use of the
; machine becomes impossible without entering the system password you have
; chosen.  The modification prevents the attempted boot operation from the
; floppy drive.  See the documentation provided with this program for more
; on this.
 
; This system is also useful for a measure of protection on floppy-based
; systems if installed on all boot/system diskettes.
 
; The companion program RELOCK.COM allows the user to disable the PC by typing
; RELOCK at the DOS prompt.  Normal use may be resumed by entering the requested
; password.
 
; After assembling SYSLOCK.ASM:
 
;             1) LINK SYSLOCK  (ignore "no STACK" error)
;             2) EXE2BIN SYSLOCK SYSLOCK.SYS
;             3) Enter DEVICE=SYSLOCK.SYS in CONFIG.SYS file
;             4) Copy SYSLOCK.SYS into the root directory of the boot disk
;             5) Reboot the system with Ctrl-Alt-Del
;             6) Respond to prompt with: password <ENTER>
 
; Note: The password matching is case-sensitive.  You must enter letters of
;       the same case used in defining the password.  If entering upper case
;       letters or shifted symbols after RELOCK has been invoked,  only the left
;       shift key is active.  The CTRL, ALT, and right shift keys are disabled
;       while RELOCK is awaiting password entry, so that certain resident
;       utilities (e.g., SideKick) cannot be used to bypass the system.
 
DEV_DRVR SEGMENT  PARA  PUBLIC 'CODE'
 
SLCK_DEVICE PROC FAR
          ASSUME CS:DEV_DRVR, DS:DEV_DRVR
 
BEGIN:
 
;                       D E V I C E    H E A D E R
 
NEXT_DEV  DD      -1                    ;Pointer to next device
ATTRIBUTE DW      8000H                 ;Character device
STRATEGY  DW      DEV_STRATEGY          ;Pointer to device strategy
INTERRUPT DW      DEV_INT               ;Pointer of device interrupt handler
DEV_NAME  DB      'SLCK_JCK'            ;8-byte device name
 
          PAGE
 
;                     P A S S W O R D    S T O R A G E
 
PW_LEN    EQU     4 ;<======================== INSERT PASSWORD LENGTH HERE
 
PW_AREA   DB      PW_LEN,'test';<============= INSERT PASSWORD HERE
 
          DB      15-PW_LEN DUP(' ') ;leaves space for 15 characters
                                     ; (allows password changes directly to
                                     ; object code using DEBUG, Norton
                                     ; Utilities, or other zapper.)
 
;                  O T H E R   S T O R A G E   A R E A S
 
KB_BUF_MAX DB     15                    ;Max length of local input buffer
KB_BUF_LEN DB     ?                     ;Number password characters keyed in
KB_BUF     DB     15 DUP(?)             ;Local keyboard input buffer
 
BREAK_SEG  DW     ?                     ;Store for segment  of old BREAK vector
BREAK_OFF  DW     ?                     ;Store for offset of old BREAK vector
 
TVEC_STORE DW     6 DUP (?)             ;Store for 3 time-related interrupt
                                        ; vectors 08H, 1AH, and 1CH
 
READ_CNT   DB     0                     ;Read control counter.
 
REQHDR_PTR LABEL DWORD
RH_PTR_OFF DW     ?                     ;Offset portion of Request Hdr pointer
RH_PTR_SEG DW     ?                     ;Segment portion of Request Hdr pointer
 
;                M E S S A G E   S T O R A G E   A R E A
 
MSG_1     DB      13,10                 ;CR,Linefeed
          DB      'Please enter system password: $'
MSG_2     DB      13,10
          DB      'Password accepted.',13,10,'$'
BEEP      DB      7,'$'
 
;                      D E V I C E   S T R A T E G Y
 
;Saves the pointer to the Request Header
 
DEV_STRATEGY PROC  FAR
          ASSUME  CS:DEV_DRVR
          MOV     CS:RH_PTR_OFF,BX      ;Save offset of Req Hdr
          MOV     CS:RH_PTR_SEG,ES      ;Save segment of Req Hdr
          RET                           ;Return to DOS
DEV_STRATEGY ENDP
 
;               P R I M A R Y    L O C A L    P R O C E D U R E
 
GET_PWRD  PROC NEAR
 
; This code prompts the user for the correct password
 
ASK:      LEA     DX, MSG_1             ;Point DX to "Enter Password" prompt
          MOV     AH,9                  ;Print message
          INT     21H
          MOV     CH,0                  ;Set CX = length of input buffer
          MOV     CL,KB_BUF_MAX
          MOV     DI,0                  ;Initialize the controlling index reg.
IN_LOOP:  MOV     AH,07                 ;Set up to get keyboard input w/o echo
          INT     21H                   ;Call DOS input handler
          CMP     AL,13                 ;Was <ENTER> pressed?
          JE      DONE                  ;Jump if yes
          MOV     KB_BUF[DI],AL         ;Put keyed character into buffer
          INC     DI                    ;Advance index reg to next buffer loc.
          LOOP    IN_LOOP               ;Loop back if buffer not full
 
DONE:     MOV     AX,DI                 ;Move number of keystrokes to
          MOV     KB_BUF_LEN,AL         ;  control field for testing
          MOV     AX,CS                 ;Set up ES for string comparison to come
          MOV     ES,AX
          LEA     SI,KB_BUF_LEN         ;Initialize index registers for the
          LEA     DI,PW_AREA            ;  string comparison
          MOV     CH,0                  ;Initialize CX to number of characters
          MOV     CL,[SI]               ; to be involved in string compare
          CMP     CL,[DI]               ;Is number of characters entered the
          JNE     ASK_AGAIN             ;  same as password length? Jump if no.
          INC     DI                    ;Step index regs to start char.-by-
          INC     SI                    ;  char. comparison against password
          REP     CMPSB                 ;Do the comparison
          JNE     ASK_AGAIN             ;Jump if they don't match
          LEA     DX,MSG_2              ;Point DX to "Password accepted" msg
          MOV     AH,9
          INT     21H                   ;Print message
          RET                           ;Return to calling routine
 
ASK_AGAIN:
          LEA     DX,BEEP               ;Point DX to the "BEEP" string
          MOV     AH,9
          INT     21H                   ;Beep
          JMP     ASK                   ;Go back and try again
GET_PWRD  ENDP
 
;             D E V I C E   I N T E R R U P T   H A N D L E R
 
;Processes the command indicated in the request header.
 
DEV_INT   PROC    FAR
 
          PUSH    DS                    ;Save everything in sight
          PUSH    ES
          PUSH    AX
          PUSH    BX
          PUSH    CX
          PUSH    DX
          PUSH    DI
          PUSH    SI
          PUSHF
          MOV     AX,CS                 ;Establish addressability of data
          MOV     DS,AX
          LES     BX,REQHDR_PTR         ;Set ES:BX = pointer to Req Hdr
          MOV     AL,ES:[BX+2]          ;Get command byte from Req Hdr
          CMP     AL,4                  ;Check for INPUT command
          JE      INPUT_CHAR            ;If yes, jump to dummy input routine
          CMP     AL,0                  ;Check for INITIALIZE command
          JE      INIT_FN               ;If yes, go do initialize functions
                                        ; otherwise fall thru to error exit
          OR      WORD PTR ES:[BX+3],8003H  ;Set Req Hdr status word=error,
                                            ;                unknown command.
          JMP     DO_POPS
NORMAL_EXIT:
          OR      WORD PTR ES:[BX+3],100H ;Set Req Hdr status word=done
DO_POPS:
          POPF                          ;Restore everything saved earlier
          POP     SI
          POP     DI
          POP     DX
          POP     CX
          POP     BX
          POP     AX
          POP     ES
          POP     DS
          RET                           ;Return to DOS
 
;The interrupt handler treats only 2 commands as valid commands: the read
;command which is implemented as a dummy operation only to re-enter the
;ask-for-password process from RELOCK.COM;  and the initialize command which
;consists of code which will be discarded after being used at driver
;installation time.
 
;The INPUT_CHAR routine is executed from RELOCK.COM which issues dummy
;requests to read a character from this device.  The first read request
;results in transfer of timer interrupt vectors as initialized at boot time.
;RELOCK.COM uses this information to temporarily "disconnect" resident
;utilities.  The second read request results in SYSLOCK.SYS asking for
;the password as done during initialization.
 
INPUT_CHAR:
 
          CMP     READ_CNT,0            ;Check for 1st of 2 read commands
                                        ; from RELOCK
          JNZ     PWRD_TST              ;Jump if 2nd read command
          XOR     READ_CNT,1            ;During 1st read set count to 1
          PUSH    ES                    ;Save ES for later use
          CLD                           ;Set forward string operations
          MOV     SI,OFFSET TVEC_STORE  ;Set index registers to control
          MOV     DI,WORD PTR ES:[BX+0EH]; move of time-related interrupt
                                        ;  vectors which were saved during
                                        ;  driver initilization
          MOV     AX,WORD PTR ES:[BX+10H] ;Point ES to RELOCK's buffer segment
          MOV     ES,AX
          MOV     CX,12                 ;Move 12 bytes (3 DWORD vectors)
          REP     MOVSB                 ;Move vectors to buffer in RELOCK.COM
          POP     ES                    ;Restore ES to point to request header
          MOV     WORD PTR ES:[BX+12H],12 ;Report 12 bytes input
          JMP     NORMAL_EXIT
 
PWRD_TST: PUSH    ES                    ;Save this before GET_PWRD destroys
          CALL    GET_PWRD              ;Perform the request for password, etc.
          POP     ES                    ;Restore ES
          MOV     READ_CNT,0            ;Clear read control counter
          MOV     WORD PTR ES:[BX+12H],1  ;Indicate 1 byte xferred (a lie, but
                                          ;  it makes DOS happy)
          JMP     NORMAL_EXIT           ;So as to return to RELOCK.COM
 
;The INIT_FN routine performs the initial installation functions, asks for
;password, and then informs the device driver installation portion of the
;operating system that all code beginning at INIT_FN is to be discarded.
 
INIT_FN:
          PUSH    ES                    ;Save this before it is lost
          CLI                           ;Disable interrupts
          CALL    NO_BREAK              ;Disable Ctrl-Break
          CALL    GET_VECS              ;Save time-related interrupt vectors
                                        ; 08H, 1AH, and 1CH for use by RELOCK
          STI                           ;Enable interrupts
          CALL    GET_PWRD              ;Perform request for password, etc.
          CLI                           ;Disable interrupts
          CALL    BREAK_ON              ;Restore Ctrl-Break operation
          STI                           ;Enable interrupts
          POP     ES                    ;Restore ES=segment of Req Hdr pointer
          MOV     WORD PTR ES:[BX+0EH],OFFSET INIT_FN-1 ;Inform DOS that the
                                        ; last byte to be retained as part of
                                        ; installed device driver is the one
                                        ; immediately preceding INIT_FN.
          MOV     WORD PTR ES:[BX+10H],CS ;And this identifies the segment
          JMP     NORMAL_EXIT           ;Go to finish housekeeping and
                                        ;  to return to DOS.
DEV_INT   ENDP
 
;            S E C O N D A R Y   L O C A L   P R O C E D U R E S
 
;         (These are discarded after device driver initialization.)
 
NO_BREAK  PROC    NEAR
 
;The following prevents Ctrl-Break from having any effect.
 
          MOV     AX,0                  ;Point ES to segment 0
          MOV     ES,AX
          MOV     AX,WORD PTR ES:[1BH*4] ;Save offset portion of present
          MOV     BREAK_OFF,AX          ;   Ctrl-Preak vector
          MOV     AX,WORD PTR ES:[1BH*4+2] ;Save segment portion
          MOV     BREAK_SEG,AX
          MOV     WORD PTR ES:[1BH*4],OFFSET DO_NOTHING ;Set up new vector to
          MOV     WORD PTR ES:[1BH*4+2],CS  ;point to IRET below.
          RET
 
DO_NOTHING:                             ; Break vector pointed here so
          IRET                          ; nothing happens on Ctrl-Break.
 
NO_BREAK  ENDP
 
; The following saves 3 timer interrupt vectors as setup during system boot.
 
GET_VECS  PROC    NEAR
          MOV     AX,WORD PTR ES:[08H*4]
          MOV     TVEC_STORE,AX
          MOV     AX,WORD PTR ES:[08H*4+2]
          MOV     TVEC_STORE[2],AX
          MOV     AX,WORD PTR ES:[1AH*4]
          MOV     TVEC_STORE[4],AX
          MOV     AX,WORD PTR ES:[1AH*4+2]
          MOV     TVEC_STORE[6],AX
          MOV     AX,WORD PTR ES:[1CH*4]
          MOV     TVEC_STORE[8],AX
          MOV     AX,WORD PTR ES:[1CH*4+2]
          MOV     TVEC_STORE[10],AX
          RET
GET_VECS  ENDP
 
BREAK_ON  PROC    NEAR
 
; The following restores the Ctrl-Break vector.
 
          MOV     AX,0                  ;Point ES to segment 0
          MOV     ES,AX
          MOV     AX,BREAK_OFF          ;Restore offset portion
          MOV     WORD PTR ES:[1BH*4],AX
          MOV     AX,BREAK_SEG          ;Restore segment portion
          MOV     WORD PTR ES:[1BH*4+2],AX
          RET
BREAK_ON  ENDP
 
SLCK_DEVICE  ENDP
 
DEV_DRVR  ENDS
 
          END     BEGIN
