    /*-------------------------------------*/
    /*-                                    */
    /*-           LOGO    v1.0              */
    /*-                                    */
    /*-  print file on HP Laser Jet        */
    /*-                                    */
    /*-------------------------------------*/

#include <dos.h>
#include <stdio.h>
/* #include <my.h> */

#define FF '\x0C'
#define ESC '\x1B'

extern   char *stpchr(), *malloc();

int _stack = 8140;

static int graphics = 0;

static leave(buf)
    char *buf;
         {
         if (graphics) pcvsvm(3);
         printf("\n%s\n\n",buf);
         return(0);
         }


main(argc, argv)
    int  argc;
    char *argv[];
         {
         FILE *fp, *out, *fopen();
         char file_name[30], out_name[30];
         char *p;
         int len, vec;

         if (argc != 2)
              {
              printf("\nERROR: in arguments\n");
              printf("\nLOGO usage:\n\nLOGO filename.ext\n\n");
              printf("output goes to filename.LGO\n\n");
              exit();
              }
         graphics = ((pcdevs() & '\x30') != '\x30');
         strcpy(file_name,argv[1]);
         len = strlen(file_name);
         len = strlen(file_name);
         strcpy(out_name,file_name);
         p=stpchr(out_name,'.');
         if (p != NULL) *p = '\0' ;
         strcat(out_name,".LGO");
         if ((fp = fopen(file_name, "r")) == NULL)
              {
              fprintf(stderr, "LOGO: can't open %s\n", file_name);
              exit(1);
              }
         if ((out = fopen(out_name, "w")) == NULL)
              {
              fprintf(stderr, "LOGO: can't open %s\n", out_name);
              fclose(fp);
              exit(1);
              }
         if (graphics) pcvsvm(6);
         build_logo();
         doit(fp,out,file_name);
         fclose(fp);
         leave("Copyright 1986, Whitfield Gregg");
         }

static int raz_line = 0;
static int max_dots = 0;

static char the_bit[8] = { '\x80', '\x40', '\x20', '\x10',
                           '\x08', '\x04', '\x02', '\x01'};
static char empty_line[] = {'\01', '\0', '\0'};

static  char *rasterize(fp)
    FILE *fp;
         {
         char ln[514];
         char bitbuf[65];
         int i,j,k, bbi, bitbuf_len, col;
         int ln_len;
         char *p, b;

         p = fgets(ln,512,fp);
         if (p==NULL) return(NULL);
         ln_len = strlen(ln);
         if (ln_len==0) return(empty_line);
         bitbuf_len = ln_len /8;
         if (ln_len % 8) bitbuf_len++;
         bitbuf[0] = bitbuf_len;
         if (max_dots<ln_len) max_dots=ln_len;
         bbi=1;                   /* index into bitbuf */
         b = '\0';                     /* zero byte holder */
         k = 0 ;                       /* zero bit counter */
         col = 0;
         for (p=ln;*p!='\0';p++)
              {
              if (*p > ' ')
                   {
                   b = b | the_bit[k];
                   if (graphics) pcvwd(raz_line,col,1);
                   }
              k++;
              col++;
              if (k == 8)
                   {
                   bitbuf[bbi++] = b ;
                   b = '\0';                /* zero byte holder */
                   k = 0;
                   }
              }
         raz_line++;
         bitbuf[bbi] = b ;
         p = malloc(bitbuf_len+6);
         movmem(bitbuf,p,bitbuf_len+4);
         return(p);
         }



static  char spaces[] = "                            ";
static  int page, ll;
static  char fname[30];

static char *logo[129];

static build_logo()
         {
         FILE *hdr;
         int i, rc;

         if ((hdr = fopen("LOGO.HDR", "r")) == NULL)
              {
              leave("LOGO: can't open LOGO.HDR");
              }
         for (i=0;i<128;i++)
              {
              logo[i] = rasterize(hdr);
              if (logo[i] == NULL) break;
              }
         fclose(hdr);
         }

static   int total_lines, total_pages;

static doit(fp,out,name)
    FILE *fp, *out;
    char *name;
         {
         int  cc;

         page = 0;
         while ((cc=fgetc(fp)) != EOF)
              {
              if (page==0) page_hdr(out);
              fputc(cc,out);
              if (cc==FF) page_hdr(out);
              }
         fputc(FF, out);
         }


static swipe (buf,out)
    char *buf;
    FILE *out;
         {
         int i, len;

         len = buf[0];
         fprintf(out,"%c*b%dW",ESC,len);
         for (i=1;i<=len;i++) fputc(buf[i],out);
         }


int page_hdr(out)
    FILE *out;
         {
         int i, col;

         page++;
         col = 79 - (max_dots / 30);
         fprintf(out,"%c&a%dC",ESC,col);   /* cursor to col */
         fprintf(out,"%c*t300R",ESC);  /* raster graphics resolution */
         fprintf(out,"%c*r1A",ESC);     /* start raster graphics */
         for (i=0;logo[i]!=NULL;i++)
              {
              swipe(logo[i],out);
              }
         fprintf(out,"%c*rB",ESC);      /* end raster graphics */
         fprintf(out,"%c&a0C",ESC);      /* set cursor column   */
         fprintf(out,"%c&a0R",ESC);      /* set cursor row      */
         }
