/* KEYVAL.C - when user presses a key, displays the numerical code generated */

#include <stdio.h>
#include <dos.h>

main()
{
  int  c;

  printf("KEYVAL - find code generated for a key  (press ESC to exit)\n");
  while ((c = kb()) != 27)
    printf("%d\n", c);
}


kb()
{
  register int c, scan_code;
  union REGS r;

  r.h.ah = 00;  		 /* Interrupt 16H service 0 */
  int86(0x16, &r, &r);  	 /*  fetches the keystroke. */
  if ((c = r.h.al) == 0)	 /* It's a special key, so  */
    c = r.h.ah | 0x80;  	 /*  turn on the high bit.  */

  /* This section tests if we pressed a <SHIFT> keypad key. */
  /* Among the codes not used (see keys.h) are 133-142 and  */
  /* 154-157. We map scan codes 71-83 into these keystrokes.*/
  else if ((scan_code = r.h.ah) >= 71 && scan_code <= 83)
    c = scan_code + ((scan_code <= 80) ? 62 : 73);
  else if (scan_code == 55)	     /* hit the <PrtSc> key */
    c = 157;
  return(c);	     /* returns int c (ascii value of key)  */
}
