#define PORTBASE 0x03F8		/* For COM1. 0x02F8 for com2	*/ 

comparm(baudrate, parity, stop, databits)

int baudrate;                   /* 110 through 9600                */
int parity;                     /* 0 = None, 1 = Odd, 2 = even     */
int stop;                       /* 1 or 2                          */
int databits;                   /* 5 through 8                     */
{
unsigned char parmbyte;
unsigned int divisor;
unsigned char lsb, msb;

/* First, calculate the baud rate divisor */

	divisor = 115200 / baudrate;
	msb = divisor >> 8;
	lsb = (divisor << 8) >> 8;

/*
* Enable access to the divisor latches by setting 
* The Divisor Latch Access Bit in the Line Control Register
*/

	outp(PORTBASE + 3, 128);

/* Set the Least Significant Byte */

	outp(PORTBASE, lsb);

/* Set the Most Significant Byte */

	outp(PORTBASE + 1, msb);

/* Start to calculate the parameter byte */

/* 
* First, the word length. This occupies bits 0 and 1 of the parameter byte
* from 0 0 for 5 bit words to 1 1 for 8 bit words
*/

	parmbyte = databits - 5;

/* Next the stop bits */

	parmbyte |= (stop - 1) << 2;

/* Now the Parity */

	if (parity) parmbyte |= 8;		/* Parity Enable	*/

	if (parity == 2) parmbyte |= 16;	/* Even 		*/

        outp(PORTBASE + 3, parmbyte);           /* Write it to UART     */   
}





/* Figure 16.6: Set Port Parameters, Direct Control Version */
