#include <stdio.h>

/*
STRUX -- convert a "structured" assembly-language file to straight code

V 1.0 --
  This version compiled under DeSmet v2.4
  
THIS PROGRAM IS PUBLIC DOMAIN
 and may be freely used, modified, and distributed.
 
 If you find it useful and would like to express your appreciation,
 DON'T send me a contribution!  Just support your local bulletin
 boards with courtesy, enthusiasm and good free software.
 That's what it's all about, after all!
 
 Davidson Corry
 4610 SW Lander
 Seattle, WA  98116
 206 / 935-0244
*/

#undef loop
#define loop for(;;)

#define IF 1
#define ELSEIF 2
#define ELSE 3
#define ENDIF 4
#define WHILE 5
#define BREAK 6
#define CNTNU 7
#define UNTIL 8

int errorcount = 0;
int lincount = 0;

int depth, typestack[20], targetstack[20], itargetstack[20], counter;

char *index();

char infilname[20], outfilname[20];

char buf[256], remark[256], opcode[256], test[256];

char tabs[256];

FILE *inf, *outf;

main(argc,argv)
int argc;
char *argv[];
	{

	if (argc<2)
		usage();

	strcpy(infilname,argv[1]);
	strcat(infilname,".A");
	if ( !(inf = fopen(infilname,"r")) )
		cantopen(infilname);
	strcpy(outfilname,argv[1]);
	strcat(outfilname,".ASM");
	if ( !(outf = fopen(outfilname,"w")) )
		cantopen(outfilname);

	while (fgets(buf,255,inf))
		{
		++lincount;
		if (!(lincount%20)) fprintf(stderr,"\r%d",lincount);
		striplabel();
		expand(buf);
		}
	fputs("\r             \r",stderr);
	fclose(inf);
	fclose(outf);
	exit(errorcount);
	}

expand(s)
char *s;
	{
	int ityp;

	ityp = itype(s);
	if (!ityp) { fputs(s,outf); return; }
	fprintf(outf,";%s",s);

	switch (ityp)
		{
	case IF:
		++depth; ++counter;
		typestack[depth] = IF;
		targetstack[depth] = counter;
		itargetstack[depth] = counter;
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_f%d\n",tabs,notjump(test),counter);
		break;
	case ELSEIF:
		if (!depth || typestack[depth] != IF)
			{
			bad(".ELSEIF w/o .IF");
			break;
			}
		fprintf(outf,"%sjmp\t_e%d\n_f%d:\n",tabs,itargetstack[depth],targetstack[depth]);
		targetstack[depth] = ++counter;
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_f%d\n",tabs,notjump(test),counter);
		break;
	case ELSE:
		if (!depth || typestack[depth] != IF)
			{
			bad(".ELSE w/o .IF");
			break;
			}
		fprintf(outf,"%sjmp\t_e%d\n_f%d:\n",tabs,itargetstack[depth],targetstack[depth]);
		targetstack[depth] = ++counter;
		break;
	case ENDIF:
		if (!depth || typestack[depth] != IF)
			{
			bad(".ENDIF w/o .IF");
			break;
			}
		fprintf(outf,"_f%d:\n_e%d:\n",targetstack[depth],itargetstack[depth]);
		--depth;
		break;
	case WHILE:
		++depth;
		++counter;
		targetstack[depth] = counter;
		typestack[depth] = WHILE;
		fprintf(outf,"_b%d:\n",counter);
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_f%d\n",tabs,notjump(test),counter);
		break;
	case BREAK:
		if (loopdepth() == -1)
			{
			bad(".BREAK w/ no .LOOP open");
			break;
			}
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_f%d\n",tabs,jump(test),targetstack[loopdepth()]);
		else
			fprintf(outf,"%sjmp\t_f%d\n",tabs,targetstack[loopdepth()]);
		break;
	case CNTNU:
		if (loopdepth() == -1)
			{
			bad(".CNTNU w/ no .LOOP open");
			break;
			}
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_b%d\n",tabs,jump(test),targetstack[loopdepth()]);
		else
			fprintf(outf,"%sjmp\t_b%d\n",tabs,targetstack[loopdepth()]);
		break;
	case UNTIL:
		if (depth==0 || typestack[depth]!=WHILE)
			{
			bad(".LEND w/ no .LOOP open");
			break;
			}
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_b%d\n",tabs,notjump(test),targetstack[depth]);
		else
			fprintf(outf,"%sjmp\t_b%d\n",tabs,targetstack[depth]);
		fprintf(outf,"_f%d:\n",targetstack[depth]);
		--depth;
		break;
	default:
		fputs(buf,outf);
		break;
		}
	}

usage()
	{
	fputs("STRUX [file]\n\trewrites [file].A with structures expanded",stderr);
	exit(0);
	}

leads(s,o)
char *s, *o;
	{
	for ( ; isspace(*s); ++s)
		;
	if (strncmp(s,o,strlen(o))==0 && isspace(*(s+strlen(o))) )
		return(TRUE);
	return(FALSE);
	}

itype(s)
char *s;
	{
	char *p, *q;
	int typ;

	for ( p=tabs ; isspace(*s); *p++ = *s++)
		;
	*p = '\0';
	if (leads(s,".IF"))
		typ = IF;
	else if (leads(s,".ELSEIF"))
		typ = ELSEIF;
	else if (leads(s,".ELSE"))
		typ = ELSE;
	else if (leads(s,".ENDIF"))
		typ = ENDIF;
	else if (leads(s,".WHILE") || leads(s,".REPEAT") || leads(s,".LOOP") )
		typ = WHILE;
	else if (leads(s,".BREAK"))
		typ = BREAK;
	else if (leads(s,".CNTNU"))
		typ = CNTNU;
	else if (leads(s,".UNTIL") || leads(s,".WEND") || leads(s,".LEND") )
		typ = UNTIL;
	else
		typ = NULL;

	if (typ)
		{
		opcode[0] = test[0] = remark[0] = '\0';
		/* break into opcode, argument, remark */
		for ( ; !isspace(*s); ++s)
			;
		for ( ; isspace(*s); ++s)
			;
		if (*s==';' || *s=='\n')
			{
			strcpy(test,"");
			strcpy(opcode,"");
			strcpy(remark,s);
			}
		else
			{
			if (*s=='<')
				{
				p = s+1;
				for ( s = p; *s && *s != '>'; ++s )
					{
					if (*s=='\'')
						s = index(s+1,'\'');
					else if (*s=='\"')
						s = index(s+1,'\"');
					}
				}
			else
				{
				p = s;
				for ( s = p; *s && *s != ','; ++s )
					{
					if (*s=='\'')
						s = index(s+1,'\'');
					else if (*s=='\"')
						s = index(s+1,'\"');
					}
				}
			for (q = opcode; p < s; *q++ = *p++)
				;
			*q = '\0';
			while ( *s && *s++ != ',')
				;
			for (p = s; isalpha(*s); ++s)
				;
			for (q = test; p < s; *q++ = *p++)
				;
			*q = '\0';
			strcpy(remark,s);
			}
		}
	return(typ);
	}

striplabel()
	{
	char *p;

	if (!isid(buf[0]))
		return;
	strcpy(remark,buf);
	for (p = remark+1; isid(*p) || isdigit(*p); ++p)
		;
	for ( ; *p==':'; ++p )
		;
	strcpy(buf,p);
	if (*(p-1)==':') strcpy(p,"\n"); else *p='\0';
	fputs(remark,outf);
	strcpy(remark,"");
	}

isid(k)
char k;
	{
	return(isalpha(k)||k=='_'||k=='?'||k=='$'||k=='@');
	}

jump(s)
char *s;
	{
        static char truejump[5];

        sprintf(truejump,"j%s",s);
        for (s = truejump; *s; ++s) *s = tolower(*s);
        return(truejump);
	}

notjump(s)
char *s;
	{
        static char truejump[5];
        
        if (strcmp(s,"PE")==0) return("jpo");
        if (strcmp(s,"PO")==0) return("jpe");
        if (*s=='N') sprintf(truejump,"j%s",s+1);
        else sprintf(truejump,"jn%s",s);
        for (s = truejump; *s; ++s) *s = tolower(*s);
        return(truejump);
	}

loopdepth()
	{
	int i;

	for (i = depth; i>0; --i)
		if (typestack[i] == WHILE)
			return(i);
	return(-1);
	}

bad(s)
char *s;
	{
	fprintf(stderr,"\r%d: %s\n",lincount,s);
	++errorcount;
	}

cantopen(s)
char *s;
	{
	fprintf(stderr,"Can't open %s",s);
	exit(1);
	}

