; TITLE	'INSTALL OR REMOVE AUTO BOOT SEQUENCE.  3/4/80'

;	WRITTEN BY JOHN MOORHEAD


;	THIS PROGRAM WILL INSTALL OR REMOVE AN AUTO BOOT
;	MESSAGE OR COMMAND FILE NAME TO/FROM THE USER
;	INPUT BUFFER AT LOCATION 80 HEX.  THIS MODIFICATION
;	IS PERMANANTLY STORED ON THE CURRENTLY LOGGED DISK.
;
;NAME:	AUTOBOOT.ASM
;
;	THIS PROGRAM WORKS WITH BOTH CP/M VERSIONS 1.4 AND 2.0.
;	IT LOADS THE FIRST 128 BYTES OF THE CP/M CCP MODULE
;	INTO RAM AT 80 HEX.  THIS IS ASSUMED TO BE ON TRACK
;	ZERO, SECTOR 2.  IF THE USER TYPES 'I' TO INSTALL THE
;	AUTO BOOT FILE NAME OR COMMAND, THE PROGRAM WILL PROMPT
;	THE USER FOR SAID ITEM.  THE PROGRAM WILL INSERT THAT
;	TEXT STRING INTO THE CCP CONSOLE BUFFER ALONG WITH THE
;	LENGTH.  IT THEN WRITES THIS MODIFIED SECTOR OF THE CCP
;	BACK TO THE DISK.  'REMOVE' WORKS THE SAME WAY, EXCEPT
;	THAT IT SETS THE LENGTH OF THE INPUT BUFFER STRING TO
;	ZERO AT HEX 987, AND WRITES 16 HEX 20'S (ASCII SPACE)
;	STARTING AT 988 HEX.  THIS IS THEN RE-WRITTEN OUT TO
;	THE DISK.
;
;	WHEN CP/M WARM BOOTS IT CHECKS THE CONSOLE BUFFER TO
;	SEE IF IT HAS ANYTHING IN IT.  IF IT DOES, CP/M READS
;	IT AND PERFORMS THE FUNCTION.  


	ORG 100H
BDOS	EQU	5

CR	EQU	0DH	;ASCII CARRIAGE RETURN


	JMP	START


;THE CBIOS JUMP TABLE IS MOVED HERE


BOOT:	DS	3
WBOOT:	DS	3
CONST:	DS	3
CONIN:	DS	3
CONOUT:	DS	3
LIST:	DS	3
PUNCH:	DS	3
READER:	DS	3
HOME:	DS	3
SELDSK:	DS	3
SETTRK:	DS	3
SETSEC:	DS	3
SETDMA:	DS	3
READ:	DS	3
WRITE:	DS	3
LISTST:	DS	3	;ABOVE 15 FOR CP/M 1.4; LAST 2 FOR
SECTRAN:DS	3	;CP/M 2.0 COMPATIBILITY.

START:	LXI	SP,STACK
	LHLD	1	;GET WARM BOOT ADDRESS
	DCX	H
	DCX	H
	DCX	H
	LXI	D,BOOT	;DESTINATION ADDRESS
	MVI	B,17*3	;NUMBER OF BYTES TO MOVE
	CALL	MOVE	;MOVE THE CBIOS JUMP TABLE 
	LXI	B,80H
	CALL	SETDMA	;SET DMA ADDRESS TO 80H
	MVI	C,0
	CALL	SETTRK	;SET TRACK TO 0
	MVI	C,2
	CALL	SETSEC	;SET SECTOR TO 2
	CALL	READ	;READ IN FIRST SECTOR OF CPM
QQ:	CALL	CRLF
	CALL	PRINT
	DB	' INSTALL OR REMOVE AUTO BOOT SEQUENCE ON',CR
	CALL	PRINT
	DB	' CURRENTLY LOGGED DISK? (I OR R)',CR
	CALL	CRLF
	CALL	PRINT
	DB	' NOTE - IT IS IMPOSSIBLE TO INSTALL A',CR
	CALL	PRINT
	DB	' SUBMIT COMMAND, AS THE SUBMIT PROGRAM',CR
	CALL	PRINT
	DB	' WILL LOOK AT THE BUFFER AND RE-SUBMIT',CR
	CALL	PRINT
	DB	' ITSELF AD-INFINITUM...',CR
	CALL	CRLF
	CALL	INPUT	;GET REPLY
	CPI	'I'
	JZ	INSTALL
	CPI	'R'
	JZ	REMOVE
	JMP	QQ


;CONSOLE INPUT ROUTINE

INPUT:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,1	;GET CONSOLE INPUT
	CALL	5
	CPI	60H
	JC	IN1
	SUI	20H	;CONVERT TO UPPER CASE
IN1:	POP	B
	POP	D
	POP	H
	RET

CRLF:	CALL	PRINT
	DB	CR
	RET


;PRINTS ASCII STRINGS POINTED TO BY TOP OF STACK
;TO CONSOLE.

PRINT:	XTHL		;GET STRING POINTER
	PUSH	PSW
	PUSH	B
PO1:	MOV	A,M
	INX	H
	CPI	'@'	;NO CR IF @ IS END OF STRING
	JZ	NOCR
	CALL	COUT
	CPI	CR	;CARRIAGE RET?
	JZ	THEEND
	JMP	PO1
THEEND:	CALL	PRINT
	DB	0AH,0,0,0,0,'@'
NOCR:	POP	B
	POP	PSW
	XTHL
	RET

;CONSOLE OUTPUT ROUTINE

COUT:	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	MVI	C,2	;WRITE CONSOLE
	CALL	5
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET


;GENERAL PURPOSE MEMORY TO MEMORY BLOCK MOVE ROUTINE
;HL POINT TO THE SOURCE,  DE POINT TO THE DESTINATION
;THE B REGISTER HAS THE COUNT.


MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET



;THIS ROUTINE GETS THE TEXT STRING FOR THE AUTO BOOT
;SEQUENCE AND THEN MOVES IT INTO THE CCP CONSOLE BUFFER.

INSTALL:	
	CALL	CRLF
	CALL	CRLF
	CALL	PRINT
	DB	' ENTER COMMAND STRING YOU WISH TO AUTO EXECUTE',CR
	CALL	PRINT
	DB	' EXACTLY AS DESIRED - NO BACKSPACES ALLOWED!',CR
	CALL	CRLF
	LXI	H,INSTL	;LOCATION OF ENTERED STRING
	MVI	B,0	;COUNT FOR MOVE ROUTINE
INST1:	CALL	INPUT
	CPI	CR
	JZ	INST2
	MOV	M,A
	INX	H
	INR	B
	JMP	INST1	;DIDN'T TYPE CR YET, SO GET MORE STUFF
INST2:	MVI	M,0	;WAS A CR, SO LAST BYTE IS A 00
	INR	B
	MOV	A,B
	STA	87H	;INDICATE LENGTH OF STRING
	LXI	D,88H
	LXI	H,INSTL	;MOVE TYPED TEXT STRING TO 88H
	CALL	MOVE
	CALL	WRITE	;WRITE SECTOR TO DISK
	CALL	CRLF
	CALL	PRINT
	DB	' CP/M AUTO BOOT SEQUENCE INSTALLED',CR
	JMP	0

;THIS ROUTINE CLEARS THE CCP CONSOLE BUFFER


REMOVE:	LXI	H,REMV
	LXI	D,87H
	MVI	B,11H
	CALL	MOVE
	CALL	WRITE
	CALL	CRLF
	CALL	PRINT
	DB	' CP/M AUTO BOOT SEQUENCE REMOVED',CR
	JMP	0

;THESE ARE THE STRINGS WHICH ARE PUT IN THE
;CCP CONSOLE BUFFER

INSTL:	DS	16

REMV:	DB	0,'                '




	DS	256
STACK:


	END	100H

