{===========================================================================
PROSET.PAS - SETS PROWRITER PRINTER CHARACTERISTICS
============================================================================
Peter Wanger - 4-March-1986
}
{$V-}

program PROSET;

type
   str = string[255];

var
   commands: string[255];

const
   esc: char = ^[;

{
-----------------------------------------------------------------------
}
procedure showmenu;

begin
   clrscr;
   writeln('Prowriter Printer Setup Menu');
   writeln;
   writeln('A. Pica Pitch (10 CPI)        I. Underlining ON');
   writeln('B. Elite Pitch (12 CPI)       J. Underlining OFF');
   writeln('C. Compressed (17 CPI)        K. Double-width');
   writeln('D. Proportional Pitch         L. Single-width');
   writeln('E. Boldface ON                M. Margin = 5');
   writeln('F. Boldface OFF               N. Margin = 0');
   writeln('G. Bi-directional             P. Form Feed');
   writeln('H. Uni-directional            T. Test Pattern');
   writeln;
   writeln('6. 6 lines per inch           8. 8 lines per inch');
   writeln;
   writeln('R. Reset to default values');
   writeln;
end; {showmenu}
{
-----------------------------------------------------------------------
}
procedure getcommands;

begin
   write ('   Select option(s): ');
   readln(commands);
end; {getcommands}
{
-----------------------------------------------------------------------
}
procedure stuffit(x,y:str);

begin
   write(lst,x);
   writeln(con,'   ',y);
end; {stuffit}

{
------------------------------------------------------------------------
}
procedure setprinter;

var
   i: integer;

const

   testpattern : string[80] =
      'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890 ';

   resetpattern : string[80] = 'AFGJLN6';

begin
   for i := 1 to length(commands) do
      commands[i] := upcase(commands[i]);

   while pos('R',commands) <> 0 do
      begin
      i := pos('R',commands);
      delete(commands,i,1);
      insert(resetpattern,commands,i);
      end;

   writeln;
   writeln('Printer settings:');
   writeln;
   for i := 1 to length(commands) do
      case commands[i] of
      'A': stuffit(esc + 'N','Pica Pitch');
      'B': stuffit(esc + 'E','Elite Pitch');
      'C': stuffit(esc + 'Q','Compressed Print');
      'D': stuffit(esc + 'P','Proportional Print');
      'E': stuffit(esc + '!','Boldface ON');
      'F': stuffit(esc + '"','Boldface OFF');
      'G': stuffit(esc + '<','Bi-directional');
      'H': stuffit(esc + '>','Uni-directional');
      'I': stuffit(esc + 'X','Underline ON');
      'J': stuffit(esc + 'Y','Underline OFF');
      'K': stuffit(chr(14),'Double-width');
      'L': stuffit(chr(15),'Single-width');
      'M': stuffit(esc + 'L005','Margin = 5');
      'N': stuffit(esc + 'L000','Margin = 0');
      'P': stuffit(chr(12),'Form Feed');
      'T': stuffit(testpattern + chr(13) + chr(10),'Test Pattern');
      '6': stuffit(esc + 'A','6 lines per inch');
      '8': stuffit(esc + 'B','8 lines per inch');
      end;

end; {setprinter}

{================================================================

MAIN LINE

----------------------------------------------------------------}

begin

   if paramcount > 0
      then commands := paramstr(1)
      else begin
         showmenu;
         getcommands;
         end;

   setprinter;

end. {program}                                                                                                     