#
# is.mak - make file for the IS batch file utility
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
#
# Function hierarchy of IS (not including MS C standard library functions)
#
#                                     IS (main())
#                                      |
#    *-----------------------*---------*----------*--------------------*
#    |                       |                    |                    | 
# IS_FUN                 IS_COND              IS_COMP              IS_ERROR   
#    |                                            | 
#    *-----------*-----------*-----------*        *-----*-----*-----*
#    |           |           |           |              |           |
# IS_SYS     IS_FILE     IS_INPUT     IS_DISK       DATE_CMP     NUM_CMP 
#                |
#             _STRF  
#
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

# ---  first, define some rules  ---

.c.obj:
        $(msc) $(copt) /c $**

.obj.exe:
        LINK @is.lnk

# ---  compile the source file(s)  ---

is.obj:       is.c 

is_fun.obj:   is_fun.c

is_cond.obj:  is_cond.c

is_comp.obj:  is_comp.c

is_error.obj: is_error.c

is_sys.obj:   is_sys.c

is_file.obj:  is_file.c 

is_input.obj: is_input.c

is_disk.obj:  is_disk.c

date_cmp.obj: date_cmp.c

num_cmp.obj:  num_cmp.c

_strf.obj:    _strf.c


# ---  link the object module(s)  ---

is.exe: is.obj is_fun.obj is_cond.obj is_comp.obj is_error.obj is_sys.obj \
        is_file.obj is_input.obj is_disk.obj \
        date_cmp.obj num_cmp.obj _strf.obj
       
# end

