/*
BYTE_MAGIC SOFTWARE                IS - Batch File Utility
9850 Meadowglen Lane #35
Houston, Tx.   77042
(713) 975-9033

Author:    Greg Messer
Date:      10-26-88
System:    Compiled with the Microsoft Optimizing C Compiler v5.00
           under MS-DOS v3.10 for IBM-PCs and compatibles.
Prep:      make is.mak

Purpose:   Provide conditional abilities within batch files
Syntax:    is function1 condition function2
Returns:   ERRORLEVEL 0 if expression is true, 1 if false
Comments:  
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "is.h"

int main(unsigned int argc, char *argv[], char *envp[])
{
   extern int is_fun(char *, char * *, char *);
   extern int is_cond(char *, char *);
   extern int is_comp(char *, char *, char *);
   extern int is_error(char *, char *, int);

   char ret_str1[129], ret_str2[129], cond[4];
   int ret;
   char drive[3], dir[40], ext[4];
   char pgm[9];

   /* get program name for error messages  */
   if(_osmajor < 3)
       strcpy(pgm, "IS\0");
   else
       _splitpath(argv[0], drive, dir, pgm, ext);

   /* 
   ** if not enough arguments, print usage message and exit
   ** otherwise process each function, validate condition, 
   ** do the comparison and return errorlevel to DOS
   */

   if(argc < 3)
   {
       printf("\nUsage:  %s function1 condition function2\n", pgm);
       ret = 10;                               /* bad number of args = 10  */
   }
   else
   {
       ret = is_fun(argv[1], envp, ret_str1);      /* return first string  */
       if(ret == OK)
       {
           ret = is_fun(argv[3], envp, ret_str2);  /* return second string */
           if(ret == OK)
           {
               ret = is_cond(argv[2], cond);       /* validate condition   */
               if(ret == OK)
               {
                   ret = is_comp(ret_str1, cond, ret_str2);    /* compare  */
               }
               else
                   ret = is_error(pgm, argv[2], 13);   /* bad cond. = 13   */
           }
           else
               ret = is_error(pgm, argv[3], 12);   /* bad 2nd fun. = 12    */
       }
       else
           ret = is_error(pgm, argv[1], 11);       /* bad 1st fun. = 11    */
   }
   exit(ret);                                      /* exit with ERRORLEVEL */
}

