program at_extended_memory_size;          { Copyright 1986 by Freelance, Inc. }

{-----------------------------------------------------------------------------}
{ The cassette interrupt ( 15 ) has a few surprises when you are running an   }
{ IBM AT.  One of these surprises is the ability to determine the size of the }
{ extended memory - not expanded memory.  Altogether there are twelve ( 12 )  }
{ such surprises.  You can open and close devices, check for SysReq key make  }
{ and break, support both the joystick and event waiting, block moves, even   }
{ a way to put the processor into the virtual mode.  IBM must be planning on  }
{ using some of these for something other than power-on self testing... What  }
{ do you think?  A complete list of these functions follows:                  }
{                                                                             }
{    1. Device Open                                                           }
{    2. Device Close                                                          }
{    3. Program Termination                                                   }
{    4. Event waiting - alarm clock type function                             }
{    5. Joystick Support                                                      }
{    6. System Request, SysReq, key press detection                           }
{    7. Wait a specified period of time before returning to user              }
{    8. Move a block of memory, 32k word limitation, to extended memory       }
{    9. Determine extended memory size                                        }
{   10. Switch the processor to virtual ( real ) mode                         }
{   11. Device busy loop                                                      }
{   12. Return the complete interrupt flag set                                }
{                                                                             }
{                                                                             }
{                                                                             }
{ This program was written by David G. Pardue, the SYSOP of the Bungalow      }
{ Billboard in Nashville, Tennessee.  You may contact me at (615) 385-9919.   }
{ Please feel free to leave messages about this program at the main menu. Do  }
{ not leave comments.  I never read comments.  You may also send monetary     }
{ donations in any amount, may I suggest $1, to this address:                 }
{                                                                             }
{                            David G. Pardue                                  }
{                            c/o Freelance, Inc                               }
{                            PO Box 23014                                     }
{                            Nashville, TN  37202                             }
{                                                                             }
{ Those sending $5.00 or more and a Stamped and Self Addressed Envelope will  }
{ receive in a matter of weeks a missive, hand carried to their door by a     }
{ representative of the Federal government, containing more information about }
{ the function numbers other than 88 hex.  88 hex is used in the program.     }
{                                                                             }
{ Please distribute the archive freely, but leave all credits and copyright   }
{ notices intact.  No matter if the code that follows is not in the strictest }
{ sense good Pascal - you didn't write it! Cannibalize, but do not Plagarize! }
{-----------------------------------------------------------------------------}

 type
      reg_pack = record
                       ax,bx,cx,dx,bp,si,di,ds,es,flags : integer
                 end;

 var
     registers               : reg_pack;
     extended_memory_size    : integer;


 begin
      with registers do
                       begin
                            ax := $8800;   { load the function number into ax }
                       end;

                           intr($15,registers);            { do the interrupt }

      with registers do
                       begin
                            extended_memory_size := ax;      { get the result }
                       end;

 write(extended_memory_size,' kilobytes of extended memory.');   { print it }

end.
