  { CALCSEM:  Calculator-specific semantics. }
  { Copyright (C) 1984 by QCAD Systems Inc., All Rights Reserved. }

  {*********************}
  procedure APPLY(PFLAG, PRODLEN: int; TSEMP: semrecp);
    { Apply customized for the calculator.  All operations are kept
      track of on the semantic stack. }
  begin
    case pflag of
      ASSIGN:   begin {Stmt -> <identifier> := Expr <eol>}
                  semstack[stackx-3]^.symp^.symt := real_variable;
                  semstack[stackx-3]^.symp^.rval
                    := semstack[stackx-1]^.rval;
                  write(semstack[stackx-3]^.symp^.sym, ':= ');
                  write_value(semstack[stackx-1]^.rval);
                  writeln
                end;
      DIVIDE,   {Term -> Term / Fact}
      MINUS,    {Expr -> Expr - Term}
      MPY,      {Term -> Term * Fact}
      PLUS:     {Expr -> Expr + Term}
                eval_binop(pflag, semstack[stackx-2], semstack[stackx],
                           tsemp);
      PRTVAL:   begin {Stmt -> Expr <eol>}
                  if semstack[stackx-1]^.semt = float then begin
                    { the value is good (assume that a message has
                      already been printed if it is not). }
                    write('= ');
                    write_value(semstack[stackx-1]^.rval);
                    writeln
                  end
                end;
      QUIT:     begin {Goal -> Stmts QUIT}
                  { this output could also have been generated in
                    the end_sem procedure. }
                  writeln('Quitting.');
                end;
      INTVAL:   begin {Primary -> <integer>}
                  { convert the integer to floating point }
                  tsemp^.semt := float;
                  tsemp^.rval := semstack[stackx]^.numval
                end;
      REALVAL:  begin {Primary -> <real>}
                end;
      PARENS:   {Primary -> ( Expr )}
                { Copy the result of the expression. }
                tsemp^ := semstack[stackx-1]^;
      UMINUS:   {Fact -> - Primary}
                eval_binop(uminus, semstack[stackx], nil, tsemp);
      VARIABLE: begin {Primary -> <identifier>}
                  if semstack[stackx]^.symp^.symt <> real_variable then
                     writeln('Undefined variable ',
                              semstack[stackx]^.symp^.sym)
                  else begin
                    tsemp^.semt := float;
                    tsemp^.rval := semstack[stackx]^.symp^.rval
                  end
                end;
    end { apply case }
  end;

