	Page	60,132
	Title	VIDBIOS: Access to video BIOS
	Subttl	Copyright (c) John Navas II, All Rights Reserved
;VIDBIOS is made available for personal, non-commercial use only.  You
;are granted a limited license to use VIDBIOS, and to copy it and
;distribute it, provided that no fee is charged for such copying and
;distribution, and that it is ONLY distributed in its original,
;unmodified state. */
	.Lall

	Name	VIDBIOS

; Language: MIcrosoft MASM 3.00 for Microsoft C 3.00 (small memory model)

	Comment	\
Provides access to the PC ROM BIOS video interrupt. \

;	usage:	void vidcpos( int, int );
;		void vidwrit( char * );
;		void vidattr( char, int );

VIDINT	equ	10h		; video BIOS interrupt

_TEXT	segment	byte public 'CODE'
	assume	cs:_TEXT

	public	_VIDCPOS	; POSITION CURSOR
_VIDCPOS	proc	near

x	equ	ss:byte ptr[bp+4]	; x coordinate
y	equ	ss:byte ptr[bp+6]	; y coordinate

	push	bp		; save registers
	mov	bp,sp

	mov	dl,x
	mov	dh,y
	xor	bh,bh		; page 0
	mov	ah,02h		; set cursor position
	int	VIDINT		; call bios

	pop	bp
	ret

_VIDCPOS	endp

	public	_VIDWRIT
_VIDWRIT	proc	near	; STRING DISPLAY (NOT TTY)

string	equ	ss:word ptr[bp+4]	; string pointer

	push	bp		; save registers
	mov	bp,sp
	push	si

	cld			; clear direction flag
	mov	si,[string]	; string address

	xor	bh,bh		; page 0
	mov	ah,03h		; get cursor position
	int	VIDINT		; call bios

loop:	lodsb			; get char
	or	al,al		; done?
	jz	exit		; nope

	xor	bh,bh		; page 0
	mov	cx,1		; number of times
	mov	ah,0Ah		; write char only
	int	VIDINT		; call bios

	inc	dl		; next column
	cmp	dl,80		; too far?
	jb	dinc		; no
	xor	dl,dl		; first column
	cmp	dh,24		; last row?
	jnb	dinc		; yes
	inc	dh		; next row
dinc:
	xor	bh,bh		; page 0
	mov	ah,02h		; set cursor position
	int	VIDINT		; call bios

	jmp	loop		; keep going

exit:	pop	si
	pop	bp
	ret

_VIDWRIT	endp

	public	_VIDATTR
_VIDATTR	proc	near	; SET ATTRIBUTES

attrib	equ	ss:word ptr[bp+4]	; attribute
count	equ	ss:word ptr[bp+6]	; count to set

	push	bp		; save registers
	mov	bp,sp
	push	si

	mov	bl,byte ptr [attrib]	; attribute
	mov	si,[count]	; number to do
	or	si,si		; any?
	jz	zonk		; no

	xor	bh,bh		; page 0
	mov	ah,03h		; get cursor position
	int	VIDINT		; call bios

whip:
	xor	bh,bh		; page 0
	mov	ah,08h		; read char & attr
	int	VIDINT		; call bios

	xor	bh,bh		; force page 0
	mov	cx,1		; number of times
	mov	ah,09h		; write char & attr (in bl)
	int	VIDINT		; call bios

	inc	dl		; next column
	cmp	dl,80		; too far?
	jb	cinc		; no
	xor	dl,dl		; first column
	cmp	dh,24		; last row?
	jnb	cinc		; yes
	inc	dh		; next row
cinc:
	xor	bh,bh		; page 0
	mov	ah,02h		; set cursor position
	int	VIDINT		; call bios

	dec	si		; any left
	jnz	whip		; yes

zonk:	pop	si
	pop	bp
	ret

_VIDATTR	endp

_TEXT	ends

	End

