/*
Ŀ
 Title   : jzwindow.h							     
 Purpose : Define structures, defs, and global variables for window system  
									     
	Written by Jack Zucker - 75766,1336    301-794-5950  on 1/15/85      

*/

/* misc window declarations */

struct	twindow
{
  int		*buf;		/* buffer of chars and attributes */
  char		row;		/* cursor row position		  */
  char		col;		/* cursor column position	  */
  unsigned char attr;		/* attribute (color) of window	  */
  unsigned
  char number;			/* window identifier byte	  */
  int		row1,
		col1,
		row2,
		col2;		/* global window coordinates	  */
  struct twindow *next; 	/* pointer to next window struct  */
};
#define TWINDOW struct twindow

#define BLACK 0
#define BLUE  1
#define GREEN 2
#define CYAN 3
#define RED 4
#define MAGENTA 5
#define BROWN 6
#define LIGHTGRAY 7
#define DARKGRAY 8
#define LIGHTBLUE 9
#define LIGHTGREEN 0x0A
#define LIGHTCYAN 0x0B
#define LIGHTRED 0x0C
#define LIGHTMAGENTA 0x0D
#define YELLOW 0x0E
#define WHITE 0x0F
#define BLINK 0x80

struct theader
{
  int		length; 	/* current length of a linked list */
  TWINDOW      *first;
  TWINDOW      *last;
} ;
#define THEADER struct theader

			/* convert row and column to absolute offset of screen */
#define SCROFS(_y,_x) (unsigned) (_y * 160 + (_x << 1))
			/* convert seperate foreground and background to attr  */
#define MKATTR(_b,_f) (unsigned char) (_b << 4 + _f)

			/* return a col position to center a given string */
#define CNTCOL(_s,_w) ((_w - strlen(_s)) >> 1)

#if LINT_ARGS
TWINDOW *jzopnwnd(),*jzappend(),*wsearch();
TWINDOW *jzcpywnd(TWINDOW *,int);
THEADER *jzgethdr();
void jzclrwnd(TWINDOW *,int);
#endif

