Comment *
Ŀ
doswrits.asm                                                                
Allows direct sector access from 'C' which is not possible using int86      
because this int leaves a word on the stack which would cause int86 to      
return to some unknown place.                                               
usage:                                                                      
char wbuf[512];          at lease 512 bytes for sector buffer               
int werror;                                                                 
                                                                            
werror = doswrits(0,0,1,wbuf);    writes to drive 'A',sector 0, 1 sector,   
                                  from wbuf                                 
                                                                            
                                                                            
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950                      

*
        assume cs:_text
_text   segment public byte 'code'
        public _doswrits

_doswrits   proc near

        push bp
        mov bp,sp
        push si                 ; save user's "C" register variables
        push di

        mov al,[bp+4]           ; drive number
        mov dx,[bp+6]           ; which sector to write
        mov cx,[bp+8]           ; amount of sectors
        mov bx,[bp+0Ah]         ; offset of buffer
        int 26h
        jc _doswritserror       ; if carry then error occurred
        mov ax,0                ; else return a zero
_doswritserror:
        popf                    ; int 25h pushes flags
        pop di                  ; restore user's "C" register variables
        pop si
        pop bp                  ; restore base pointer
        ret
_doswrits   endp
_text   ends
end
