/*
** is-file.c source modules for 'file' functions of IS
*/

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "is.h"

int is_file(char *fun, char *ret_str)
{
   extern char *_strftime(unsigned int, char *);
   extern char *_strfdate(unsigned int, char *);

   int ret = BAD;
   char *fbeg, *fend, *fn;         /* assorted pointers    */
   char filename[79];              /* d:\path\filename.ext buffer  */
   struct find_t fbuf;             /* struct returned by _dos_findfirst    */
   long fsize;
   unsigned int ftime, fdate;
   unsigned int search_attr = _A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_SUBDIR;

   fn = filename;

   /* all file functions require a filename, so. . .   */
   /* extract filename from fun    */
   if((fbeg = strchr(fun, '(')) != NULL)       /* if there's a left paren  */
   {
       if((fend = strrchr(fun, ')')) != NULL)  /* and a right paren        */
       {
           ++fbeg;                     /* copy what's inside to filename   */
           --fend;
           while(fbeg <= fend)
               *fn++ = *fbeg++;
           *fn = '\0';
           ret = OK;
       }
       else
           return(BAD);
   }
   else
       return(BAD);

   if(ret == OK)                           /* if there's a filename . . .  */
   {
       /* find first occurence of file, if any */
       ret = _dos_findfirst(filename, search_attr, &fbuf);

       if(ret != OK)
           return(BAD);            /* return 1 if not found,   */
       else                        /* or save data if found    */
       {
           ftime = fbuf.wr_time;
           fdate = fbuf.wr_date;
           fsize = fbuf.size;
                                                       /* do function. . . */
           if((strncmp(fun, "filesize", 8)) == 0)      /* is it filesize?  */
               ltoa(fsize, ret_str, 10);
           else if((strncmp(fun, "filetime", 8)) == 0) /* is it filetime?  */
               _strftime(ftime, ret_str);
           else if((strncmp(fun, "filedate", 8)) == 0) /* is it filedate?  */
               _strfdate(fdate, ret_str);
           else
               return(BAD);                /* none of the above, return 1  */
       }
       return(ret);
   }
}

