#include <stdio.h>
#include <signal.h>
#include <dos.h>

 char buf[BUFSIZ];
 int mode;
 union REGS r;

intr()
{
    r.x.ax=mode;
    int86(16, &r, &r);  /* reset mode */
    exit(0);
    return(0);
}

sine(angle)
 long angle;
{
 static int sintbl[] = {
       0,  174,  348,  523,  697,  871, 1045, 1218, 1391, 1564, 
    1736, 1908, 2079, 2249, 2419, 2588, 2756, 2923, 3090, 3255, 
    3420, 3583, 3746, 3907, 4067, 4226, 4383, 4539, 4694, 4848, 
    5000, 5150, 5299, 5446, 5591, 5735, 5877, 6018, 6156, 6293, 
    6427, 6560, 6691, 6819, 6946, 7071, 7193, 7313, 7431, 7547, 
    7660, 7771, 7880, 7986, 8090, 8191, 8290, 8386, 8480, 8571, 
    8660, 8746, 8829, 8910, 8987, 9063, 9135, 9205, 9271, 9335, 
    9396, 9455, 9510, 9563, 9612, 9659, 9702, 9743, 9781, 9816, 
    9848, 9876, 9902, 9925, 9945, 9961, 9975, 9986, 9993, 9998, 
    10000, 10000};
 int neg, result, *i;

    while(angle > 3600)
        angle -= 3600;
    while(angle < 0)
        angle += 3600;
    if (angle <= 900)
        neg=0;
    else
        if (angle <= 1800)
        {
            neg=0;
            angle = 1800-angle;
        } else
            if (angle <= 2700)
            {
                neg=1;
                angle -= 1800;
            } else
            {
                neg=1;
                angle = 3600-angle;
            }
    i = &sintbl[angle/10];
    result= *i+(angle%10)*(i[1] - *i)/10;
    if (neg)
        result = -result;
    return(result);
}

 void
dot(x, y)
{
    r.h.ah=12;
    r.h.al=1;
    r.x.cx=x;
    r.x.dx=y;
    int86(16, &r, &r);
}

 void
move(x, y)
{
    r.h.ah=2;
    r.h.bh=0;
    r.h.dh=y;
    r.h.dl=x;
    int86(16, &r, &r);
}

graph(l, m)
 long l;
{
 int x, y;
 long t;

    l=(l%m)*24-8;
    for(x=8 ; x <= 632 ; x++)
    {
        r.h.ah=11;
        int86(33, &r, &r);
        if (r.h.al)
            return(0);
        t=l+x;
        y=100-sine((3600L*t/m)/24L)/111;
        if (x == 8 || x == 632)
        {
            move(x == 8 ? 0 : 79, y/8);
            switch(m)
            {
            case 23:
                printf("P");
                break;
            case 28:
                printf("E");
                break;
            case 33:
                printf("I");
                break;
            }
        }
        dot(x, y);
    }
    return(1);
}

 int mon[] = { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

 long
ndays(d, m, y)
{
 long cnt;

    if (m < 1 || m > 12)
        m=1;
    cnt = d+(long)y*365L+y/4;
    if (m < 3 && (y%4) == 0)
        cnt--;
    while(--m)
        cnt += mon[m];
    return(cnt);
}

 void
main()
{
 int bd, bm, by, sd, sm, sy, show, c, incr, nshow, fin;
 long nd;

    r.h.ah=15;
    int86(16, &r, &r);  /* get mode */
    mode=r.h.al;
    signal(SIGINT, intr);
    r.h.ah=0x2a;
    int86(0x21, &r, &r);
    sd=bd=r.h.dl;
    sm=bm=r.h.dh;
    sy=by=r.x.cx-1900;
    for(;;)
    {
        r.x.ax=6;
        int86(16, &r, &r);  /* set mode = 6 */
        show=1;
        fin = -1;
        do
        {
            move(0, 0);
            printf("Birthdate ");
            if (show == 1)
                printf("   ");
            else
#ifdef USA
                printf("%02d ", bm);
#else
                printf("%02d ", bd);
#endif
            if (show == 2)
                printf("   ");
            else
#ifdef USA
                printf("%02d ", bd);
#else
                printf("%02d ", bm);
#endif
            if (show == 3)
                printf("   ");
            else
                printf("%02d ", by);
            printf("      Showdate ");
            if (show == 4)
                printf("   ");
            else
#ifdef USA
                printf("%02d ", sm);
#else
                printf("%02d ", sd);
#endif
            if (show == 5)
                printf("   ");
            else
#ifdef USA
                printf("%02d ", sd);
#else
                printf("%02d ", sm);
#endif
            if (show == 6)
                printf("   ");
            else
                printf("%02d ", sy);
            nshow = -show;
            if (kbhit() || fin == -1)
            {
                if (fin == -1)
                    c=0;
                else
                    if ((c=getch()) == 0)
                        c=getch()+256;
                incr=0;
                switch(c)
                {
                    case 0:
                        break;
                    case 13:
                        fin=1;
                        break;
                    case 27:
                        intr();
                        break;
                    case 327: /* home */
                        incr=100;
                        break;
                    case 328: /* up */
                        incr=1;
                        break;
                    case 329: /* pg up */
                        incr=10;
                        break;
                    case 331: /* left */
                        if (nshow < 0)
                            nshow = -nshow;
                        nshow = (nshow+4)%6 +1;
                        break;
                    case 333: /* right */
                        if (nshow < 0)
                            nshow = -nshow;
                        nshow = nshow%6 +1;
                        break;
                    case 335: /* end */
                        incr = -100;
                        break;
                    case 336: /* down */
                        incr = -1;
                        break;
                    case 337: /* pg dn */
                        incr = -10;
                        break;
                    default:
                        printf("\007");
                        break;
                }
                if (incr || fin == -1)
                {
                    switch(show)
                    {
#ifdef USA
                    case -2: case 2:
#else
                    case -1: case 1:
#endif
                        bd += incr;
                        if (bd <= 0)
                            bd=31;
                        if (bd >= 32)
                            bd=1;
                        break;
#ifdef USA
                    case -1: case 1:
#else
                    case -2: case 2:
#endif
                        bm += incr;
                        if (bm <= 0)
                            bm=12;
                        if (bm >= 13)
                            bm=1;
                        break;
                    case -3: case 3:
                        by += incr;
                        if (by < 0)
                            by=99;
                        if (by > 99)
                            by=0;
                        break;
#ifdef USA
                    case -5: case 5:
#else
                    case -4: case 4:
#endif
                        sd += incr;
                        if (sd <= 0)
                            sd=31;
                        if (sd >= 32)
                            sd=1;
                        break;
#ifdef USA
                    case -4: case 4:
#else
                    case -5: case 5:
#endif
                        sm += incr;
                        if (sm <= 0)
                            sm=12;
                        if (sm >= 13)
                            sm=1;
                        break;
                    case -6: case 6:
                        sy += incr;
                        if (sy < 0)
                            sy=99;
                        if (sy > 99)
                            sy=0;
                        break;
                    }
                    move(64, fin=0);
                    if ((nd=ndays(sd, sm, sy)-ndays(bd, bm, by)) < 0)
                        printf("%5ld day%s early ", -nd, nd == -1?"":"s");
                    else
                        if (nd == 0)
                            printf(" same day        ");
                        else
                            printf("%5ld day%s old   ", nd, nd == 1?"":"s");
                }
            } else
                c=0;
            show=nshow;
        } while(fin == 0 || show < 0);
        while(nd < 0)
            nd += 23L*28L*33L;
        move(0, 13);
        for(show=sd, c=8 ; c <= 632 ; c++)
        {
            dot(c, 100);
            if ((c-8)%24 == 0)
            {
                dot(c, 101);
                dot(c, 102);
                dot(c, 103);
                if (c != 632)
                    printf("%3d", show);
                if (++show > mon[sm])
                    show=1;
            }
        }
        if (graph(nd, 23) && graph(nd, 28))
                graph(nd, 33);
        if (getch() == 0)
            getch();
    }
}
