PROGRAM PhoneMem;

{ Ŀ
   Pinnacle Software's  Phone Memory Mnemonic Assistant      PHONEMEM     
  Ĵ
    C O P Y R I G H T  (C)  1986  BY   P I N N A C L E    S O F T W A R E  
    P.O. Box 163, Cartierville Station, Montreal, Quebec, Canada  H4K 2J5  
  Ĵ
    This program may be given to others, provided it is given in unalter-  
    ed form, including this notice, and that it is given absolutely free.  
   }

TYPE
  String2  = STRING[2];
  String80 = STRING[80];
VAR
  AfterPointer : INTEGER;
  Basic        : String80;
  Equiv        : String2;
  EquivAfter   : String2;
  EquivPointer : INTEGER;
  NumIn        : String80;
  PairFound    : BOOLEAN;
  PairPointer  : INTEGER;
  Pointer      : INTEGER;
  Reprint      : INTEGER;
  Test         : CHAR;
  TestAfter    : CHAR;
CONST
  NumNums   : String80 = '0123456789';
  Equivs    : ARRAY[0..9] OF String2 =
    ('NQ','LV','TZ','GW','XR','FC','DB','SJ','HK','MP');
  NumPairs  = 65;
  Pairs     : ARRAY[1..NumPairs] OF String2 =
    ('BB','CC','DD','FF','LL','MM','NN','PP','RR','SS','TT','ZZ',
     'BL','BR',
     'CH','CK','CL','CR','CT',
     'DR',
     'FR','FL','FT',
     'GR','GH','GL','GR',
     'KN',
     'LD','LK','LF',
     'MP',
     'NC','ND','NG','NK','NS','NT',
     'PH','PL','PR',
     'RB','RD','RG','RK','RL','RM','RN','RS','RT',
     'SC','SH','SK','SL','SM','SN','SP','SQ','ST','SW',
     'TH','TR','TW',
     'WH','WR');

PROCEDURE TextInverseOn;
BEGIN TEXTCOLOR(BLACK); TEXTBACKGROUND(LIGHTGRAY); END;

PROCEDURE TextInverseOff;
BEGIN TEXTCOLOR(CYAN); TEXTBACKGROUND(BLACK); END;

BEGIN
  CLRSCR;
  TextInverseOff;
  WRITELN;
  WRITE('Enter the number that you want to remember:  ');
  READLN(NumIn);
  WRITELN;
  {--- Delete non-numeric data ---}
  IF LENGTH(NumIn) > 0 THEN
  BEGIN
    Pointer := 1;
    REPEAT
      IF POS(NumIn[Pointer],NumNums) = 0
      THEN DELETE(NumIn,Pointer,1)
      ELSE Pointer := Pointer + 1;
    UNTIL Pointer > LENGTH(NumIn);
    IF LENGTH(NumIn) > 0
    THEN
    BEGIN
      WRITELN('The basic alternatives are as follows:');
      WRITELN;
      Basic := '';
      FOR Pointer := 1 TO LENGTH(NumIn) DO
      BEGIN
        Equiv := Equivs[POS(NumIn[Pointer],NumNums)-1];
        Basic := Basic + Equiv;
        WRITE(Equiv,' ');
      END;
      IF LENGTH(Basic) > 2 THEN
      BEGIN
        WRITELN; WRITELN;
        WRITELN('Letter pairs that typically occur in English...');
        WRITELN;
        PairFound := FALSE;
        FOR Pointer := 1 TO (LENGTH(Basic)-1 DIV 2) DO
        BEGIN
          {----- Look for candidate ---}
          Equiv      := Basic[Pointer*2-1] + Basic[Pointer*2];
          EquivAfter := Basic[Pointer*2+1] + Basic[Pointer*2+2];
          FOR PairPointer := 1 TO NumPairs DO
          BEGIN
            EquivPointer := 0;
            AfterPointer := 0;
            Test         := COPY(Pairs[PairPointer],1,1);
            TestAfter    := COPY(Pairs[PairPointer],2,1);
            IF Test      = Equiv[1]      THEN EquivPointer := 1;
            IF Test      = Equiv[2]      THEN EquivPointer := 2;
            IF TestAfter = EquivAfter[1] THEN AfterPointer := 1;
            IF TestAfter = EquivAfter[2] THEN AfterPointer := 2;
            IF (EquivPointer <> 0) AND (AfterPointer <> 0) THEN
            BEGIN
              PairFound := TRUE;
              FOR Reprint := 1 TO (LENGTH(Basic) DIV 2) DO
              BEGIN
                IF (Reprint = Pointer) OR (Reprint = Pointer+1) THEN
                BEGIN
                  IF Reprint = Pointer THEN
                  BEGIN
                    TextInverseOn;
                    WRITE(Test,' ');
                    TextInverseOff;
                  END
                  ELSE
                  BEGIN
                    TextInverseOn;
                    WRITE(TestAfter,' ');
                    TextInverseOff;
                  END;
                END   { Highlight this }
                ELSE WRITE(Basic[Reprint*2-1],Basic[Reprint*2]);
                WRITE(' ');
              END;  { Reprint basic equivalence with highlight }
              WRITE('    ');
              IF WHEREX + LENGTH(Basic) + (LENGTH(Basic) DIV 2) > 75
              THEN WRITELN;
            END;  { Found a pair }
          END;  { Step through pairs }
        END;  { Step through basic equivalence list }
        IF NOT PairFound THEN WRITELN('No pairs found.');
      END;  { Worth looking for pairs }
      WRITELN;
    END;  { There are digits to consider }
  END;  { Non-null input }
END.